/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.relational;

import java.text.MessageFormat;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;

public class DRIndexMaxColumns
extends DesignRule {
    private final String RULE_ID = "E097125D-1818-30D6-30AC-5A2018A3989C";
    private int maxColumns = 0;

    public DRIndexMaxColumns(int maxColumns) {
        this.setMaxColumns(maxColumns);
        this.setName(Messages.getString("DRIndexMaxColumns.IdentifyIndexesWithTooManyColumns"));
        this.setDescription(new StringBuffer(MessageFormat.format(Messages.getString("DRIndexMaxColumns.IndexesAboveColumnsNotAllowed"), this.getMaxColumns())));
    }

    public DRIndexMaxColumns() {
        this(64);
    }

    public void setMaxColumns(int max) {
        this.maxColumns = max;
    }

    public int getMaxColumns() {
        return this.maxColumns;
    }

    @Override
    public CheckResult doCheck(Object object) {
        Index index = (Index)object;
        if (index.size() > this.getMaxColumns()) {
            return CheckResult.createFailed(object, this, new StringBuffer(MessageFormat.format(Messages.getString("DRIndexMaxColumns.ColumnCountAllowed"), this.getMaxColumns(), index.size(), this.getContextString())).toString());
        }
        return CheckResult.createOk(object, this, new StringBuffer(MessageFormat.format(Messages.getString("DRIndexMaxColumns.MaximumNumberOfColumnsNotReached"), this.getMaxColumns(), index.size())).toString());
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "E097125D-1818-30D6-30AC-5A2018A3989C";
    }
}

