/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.logical;

import java.util.Iterator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.glossary.Glossary;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;
import oracle.dbtools.crest.util.options.namingstandards.NamingConstants;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;

public class DRAttributeNamingStandard
extends DesignRule
implements NamingConstants {
    private final String RULE_ID = "B1CCFFED-E720-B693-A9B6-109545989F45";
    private NamingStandardRule namingRule;

    public DRAttributeNamingStandard() {
        this.setName(Messages.getString("DRAttributeNamingStandard.IdentifyAttributesWithWrongNamingStandards"));
        this.setDescription(Messages.getString("DRAttributeNamingStandard.AttributesWithWrongNamingStandardsNotRecommended"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        Attribute attr = (Attribute)object;
        this.namingRule = attr.getDesign().getDesignLevelSettings().getNamingStandardRule();
        Iterator it = this.namingRule.getGlossaries().iterator();
        String errors = "";
        char logSep = this.namingRule.getLogicalSeparatorChar();
        boolean titleCaseSep = "Title Case".equalsIgnoreCase(this.namingRule.getLogicalSep());
        while (it.hasNext()) {
            Glossary glossary = (Glossary)it.next();
            String error = glossary.checkValidName(attr.getName(), this.namingRule.getAttributesList(), logSep, titleCaseSep, false, false, false);
            if (error == null) {
                return CheckResult.createOk(attr, this, Messages.getString("DRAttributeNamingStandard.AttributeNameIsInValidFormat"));
            }
            if (errors.length() == 0) {
                errors = error;
                continue;
            }
            errors = errors + ". " + error;
        }
        if ("".equals(errors)) {
            return CheckResult.createOk(attr, this, Messages.getString("DRAttributeNamingStandard.AttributeNameIsInValidFormat"));
        }
        return CheckResult.createWarning(attr, this, errors);
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "B1CCFFED-E720-B693-A9B6-109545989F45";
    }
}

