/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules;

import java.text.MessageFormat;
import java.util.ArrayList;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DRLibrary;
import oracle.dbtools.crest.model.designrules.DesignRule;
import oracle.dbtools.crest.util.GUID;
import oracle.dbtools.crest.util.logging.Logger;

public class DRCustomScript
extends DesignRule
implements Cloneable {
    public static final String BEFORE_CREATE = "Before Create";
    public static final String AFTER_CREATE = "After Create";
    public static final String END_OF_SCRIPT = "End Of Script";
    public static final String INSTEAD_OF_CREATE = "Instead Of Create";
    private final String CHECK_COMMENTS_VALIDATION_NAME = "Complex rule - check comments demo";
    private final String CHECK_COMMENTS_VALIDATION_TITLE = Messages.getString("DRCustomScript.CheckCommentsValidation");
    public static final String DDL_STATEMENTS_LIST_VARIABLE_NAME = "ddlStatementsList";
    public static final String DDL_RELATIONAL_MODEL_VARIABLE_NAME = "model";
    public static final String DDL_PHYSYCAL_MODEL_VARIABLE_NAME = "pModel";
    public static final String DDL_TABLE_VARIABLE_NAME = "table";
    public static final String DDL_TABLE_PROXY_VARIABLE_NAME = "tableProxy";
    public static final String TYPE_RELATIONAL = "relational";
    protected String name;
    protected String ruleId;
    protected String purpose;
    protected String object;
    protected String engineName;
    protected String script;
    protected String variable;
    protected DRLibrary library;
    protected String function;
    protected StorageDesign physicalModel;
    protected StorageObject physicalModelObject;
    protected DesignPart relationalModel;
    protected DesignObject relationalModelObject;
    protected String resultType;
    protected ScriptEngineManager scriptEngineManager;
    protected boolean hasEvalError = false;
    protected ScriptEngine engine;
    protected Compilable compilingEngine;
    public CompiledScript compiledScript;
    protected boolean eval = false;
    private static final Logger LOGGER = new Logger(DRCustomScript.class);

    public DRCustomScript(String name, String ruleId, String purp) {
        if (ruleId == null || ruleId.trim().length() == 0) {
            ruleId = new GUID().toString();
        }
        this.name = name;
        this.ruleId = ruleId;
        this.purpose = purp;
        this.setDescription(this.getName());
    }

    public DRCustomScript(String name, String ruleId, String purp, String object, String engine, String script, String variable, ScriptEngineManager scriptEngineManager, DRLibrary library, String function, StorageDesign storageDesign, StorageObject proxyObject, DesignPart relationalModel, DesignObject designObject) {
        this(name, ruleId, purp);
        this.object = object;
        this.engineName = engine;
        this.script = script;
        this.variable = variable;
        this.scriptEngineManager = scriptEngineManager;
        this.library = library;
        this.function = function;
        this.physicalModel = storageDesign;
        this.physicalModelObject = proxyObject;
        this.relationalModel = relationalModel;
        this.relationalModelObject = designObject;
    }

    @Override
    public void init() {
        this.hasEvalError = false;
        this.eval = false;
        this.compiledScript = null;
        this.engine = this.scriptEngineManager.getEngineByName(this.getEngineName());
    }

    @Override
    public CheckResult doCheck(Object object) {
        block15: {
            try {
                if (this.engine == null) {
                    this.engine = this.scriptEngineManager.getEngineByName(this.getEngineName());
                }
                if (this.engine == null) {
                    LOGGER.error("There is no such engine available " + this.getEngineName() + " for script " + this.getName());
                    return null;
                }
                this.engine.put(this.getVariable(), object);
                this.engine.put("SCRIPT_NAME", this.getName());
                if (object instanceof RelationalDesign) {
                    this.engine.put(DDL_RELATIONAL_MODEL_VARIABLE_NAME, this.getRelationalModel());
                    this.engine.put(DDL_TABLE_VARIABLE_NAME, this.getRelationalModelObject());
                    this.engine.put(DDL_PHYSYCAL_MODEL_VARIABLE_NAME, this.getPhysicalModel());
                    this.engine.put(DDL_TABLE_PROXY_VARIABLE_NAME, this.getPhysicalModelObject());
                    this.engine.put(DDL_STATEMENTS_LIST_VARIABLE_NAME, new ArrayList());
                }
                if (this.getLibrary() == null) {
                    if (this.engine instanceof Compilable) {
                        if (this.compiledScript == null) {
                            this.compilingEngine = (Compilable)((Object)this.engine);
                            this.compiledScript = this.compilingEngine.compile(this.getScript());
                        }
                        this.compiledScript.eval();
                    } else {
                        this.engine.eval(this.getScript());
                    }
                    break block15;
                }
                if (this.engine instanceof Compilable) {
                    if (this.compiledScript == null) {
                        this.compilingEngine = (Compilable)((Object)this.engine);
                        this.compiledScript = this.compilingEngine.compile(this.getLibrary().getScript());
                    }
                    if (this.engine instanceof Invocable) {
                        if (!this.eval) {
                            this.engine.eval(this.getLibrary().getScript());
                            this.eval = true;
                        }
                        Invocable invokeEngine = (Invocable)((Object)this.engine);
                        invokeEngine.invokeFunction(this.getFunction(), object);
                        break block15;
                    }
                    JOptionPane.showMessageDialog(null, MessageFormat.format(Messages.getString("DRCustomScript.EnginNotSupportingInvocable"), this.getEngineName()), Messages.getString("DRCustomScript.Error"), 0);
                    this.hasEvalError = true;
                    return null;
                }
                if (this.engine instanceof Invocable) {
                    this.engine.eval(this.getLibrary().getScript());
                    Invocable invokeEngine = (Invocable)((Object)this.engine);
                    invokeEngine.invokeFunction(this.getFunction(), object);
                    break block15;
                }
                JOptionPane.showMessageDialog(null, MessageFormat.format(Messages.getString("DRCustomScript.EnginNotSupportingInvocable"), this.getEngineName()), Messages.getString("DRCustomScript.Error"), 0);
                this.hasEvalError = true;
                return null;
            }
            catch (ScriptException ex) {
                JOptionPane.showMessageDialog(null, Messages.getString("DRCustomScript.EvaluateError") + "\n\nName     : " + this.getName() + "\n\nLine        : " + ex.getLineNumber() + "\nColumn   : " + ex.getColumnNumber() + "\nMessage : " + ex.getMessage(), Messages.getString("DRCustomScript.Error"), 0);
                this.hasEvalError = true;
                return null;
            }
            catch (NoSuchMethodException e) {
                JOptionPane.showMessageDialog(null, MessageFormat.format(Messages.getString("DRCustomScript.NoSuchMethod"), this.getFunction()), Messages.getString("DRCustomScript.Error"), 0);
                this.hasEvalError = true;
                return null;
            }
        }
        return null;
    }

    @Override
    public String getRuleId() {
        return this.ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    @Override
    public int getType() {
        if ("Error".equalsIgnoreCase(this.getResultType())) {
            return 0;
        }
        if ("Warning".equalsIgnoreCase(this.getResultType())) {
            return 1;
        }
        return 2;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public String getTitle() {
        if (this.name.equals("Complex rule - check comments demo")) {
            return this.CHECK_COMMENTS_VALIDATION_TITLE;
        }
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public String getObject() {
        return this.object;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public String getEngineName() {
        return this.engineName;
    }

    public void setEngineName(String engineName) {
        this.engineName = engineName;
    }

    public String getVariable() {
        return this.variable;
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }

    public DRLibrary getLibrary() {
        return this.library;
    }

    public void setLibrary(DRLibrary library) {
        this.library = library;
    }

    public String getFunction() {
        return this.function;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    public void setScriptEngineManager(ScriptEngineManager scriptEngineManager) {
        this.scriptEngineManager = scriptEngineManager;
    }

    public ScriptEngineManager getScriptEngineManager() {
        return this.scriptEngineManager;
    }

    public boolean hasEvalError() {
        return this.hasEvalError;
    }

    public String getResultType() {
        return this.resultType;
    }

    public void setResultType(String resultType) {
        this.resultType = resultType;
    }

    public ScriptEngine getEngine() {
        if (this.engine == null) {
            this.engine = this.scriptEngineManager.getEngineByName(this.getEngineName());
        }
        return this.engine;
    }

    public StorageDesign getPhysicalModel() {
        return this.physicalModel;
    }

    public void setPhysicalModel(StorageDesign physicalModel) {
        this.physicalModel = physicalModel;
    }

    public StorageObject getPhysicalModelObject() {
        return this.physicalModelObject;
    }

    public void setPhysicalModelObject(StorageObject physicalModelObject) {
        this.physicalModelObject = physicalModelObject;
    }

    public DesignPart getRelationalModel() {
        return this.relationalModel;
    }

    public void setRelationalModel(DesignPart relationalModel) {
        this.relationalModel = relationalModel;
    }

    public DesignObject getRelationalModelObject() {
        return this.relationalModelObject;
    }

    public void setRelationalModelObject(DesignObject relationalModelObject) {
        this.relationalModelObject = relationalModelObject;
    }

    public DRCustomScript copy() {
        return new DRCustomScript(this.name, this.ruleId, this.purpose, this.object, this.engineName, this.script, this.variable, this.scriptEngineManager, this.library, this.function, this.physicalModel, this.physicalModelObject, this.relationalModel, this.relationalModelObject);
    }

    public Object clone() throws CloneNotSupportedException {
        DRCustomScript s = (DRCustomScript)super.clone();
        return s;
    }
}

