/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.OwnerUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.UserGroupUDB;

public class PrivilegesUDB
extends StorageObject {
    protected SchemaUDB schema = null;
    protected OwnerUDB user = null;
    protected UserGroupUDB group = null;
    private String systemPrivileges = "";
    private PrivilegesSet systemPrivilegesSet = null;
    private static final String[] PRIVILEGES = new String[]{"ALTERIN", "CREATEIN", "DROPIN"};
    public static final List PRIVILEGESLIST = Arrays.asList(PRIVILEGES);
    private String grantOption = "NO";
    public static final String YES = "YES";
    public static final String NO = "NO";
    public static final String[] YES_NO_STATES = new String[]{"YES", "NO"};
    private static Set yesNoSet = null;
    public static final String TYPE_NAME = "Privileges";

    @Override
    public void showPropertyDialog() {
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "Priv";
    }

    private void addSystemPrivileges(String systemPrivileges) {
        if (!this.getSystemPrivilegesSet().contains(systemPrivileges)) {
            this.getSystemPrivilegesSet().add(systemPrivileges);
        }
    }

    private void recreateSystemPrivilegesSet(String privileges) {
        this.getSystemPrivilegesSet().clear();
        StringTokenizer st = new StringTokenizer(privileges, ",");
        this.systemPrivilegesSet = new PrivilegesSet();
        while (st.hasMoreTokens()) {
            String privilege = st.nextToken().trim();
            if (!this.checkPrivileges(privilege)) continue;
            this.getSystemPrivilegesSet().add(privilege);
        }
    }

    public void setSystemPrivileges(String privilege) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateSystemPrivilegesSet(privilege);
        } else if (this.checkPrivileges(privilege)) {
            this.addSystemPrivileges(privilege);
        }
        this.systemPrivileges = this.getSystemPrivilegesSet().toString();
        this.fireDataFieldChange();
    }

    public String getSystemPrivileges() {
        return this.systemPrivileges;
    }

    public PrivilegesSet getSystemPrivilegesSet() {
        if (this.systemPrivilegesSet == null) {
            this.systemPrivilegesSet = new PrivilegesSet();
        }
        return this.systemPrivilegesSet;
    }

    public static List getPrivilegesValues() {
        Collections.sort(PRIVILEGESLIST, new StringComparator());
        return PRIVILEGESLIST;
    }

    protected boolean checkPrivileges(String value) {
        return PRIVILEGESLIST.contains(value);
    }

    public void clear() {
        this.getSystemPrivilegesSet().removeAllElements();
        this.systemPrivileges = "";
    }

    public static String[] getYesNoChoices() {
        return YES_NO_STATES;
    }

    protected boolean checkYesNo(String value) {
        if (yesNoSet == null) {
            yesNoSet = new HashSet();
            yesNoSet.addAll(Arrays.asList(PrivilegesUDB.getYesNoChoices()));
        }
        return yesNoSet.contains(value);
    }

    public String getGrantOption() {
        return this.grantOption;
    }

    public void setGrantOption(String grantOption) {
        if (grantOption != null && grantOption.equals(this.grantOption)) {
            return;
        }
        if (this.checkYesNo(grantOption)) {
            this.grantOption = grantOption;
            this.fireDataFieldChange();
        }
    }

    public SchemaUDB getSchema() {
        return this.schema;
    }

    public void setSchema(SchemaUDB schema) {
        if (this.schema != schema) {
            this.schema = schema;
            this.fireDataFieldChange();
        }
    }

    public OwnerUDB getUser() {
        return this.user;
    }

    public void setUser(OwnerUDB user) {
        if (this.user != user) {
            this.user = user;
            this.setPAC_Element(user);
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
    }

    public UserGroupUDB getGroup() {
        return this.group;
    }

    public void setGroup(UserGroupUDB group) {
        if (this.group != group) {
            this.group = group;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        PrivilegesUDB priv = null;
        StorageObject stObject = (StorageObject)((StorageDesignUDB)targetDesign).getPrivilegesSet().getByName(this.getName());
        if (stObject != null) {
            if (this.isRawObject()) {
                priv = (PrivilegesUDB)stObject;
            }
        } else {
            priv = ((StorageDesignUDB)targetDesign).getPrivilegesSet().createPriv();
        }
        if (priv != null) {
            priv.setName(this.getName());
            priv.setSchema(this.getSchema());
            if (this.getUser() != null) {
                OwnerUDB owner = (OwnerUDB)((StorageDesignUDB)targetDesign).getOwnerSet().getByName(this.getUser().getName());
                if (owner == null) {
                    OwnerUDB newOwner = (OwnerUDB)((StorageDesignUDB)targetDesign).getOwnerSet().createElement(null);
                    newOwner.setName(this.getUser().getName());
                    newOwner.setRawObject(true);
                    priv.setUser(newOwner);
                } else {
                    priv.setUser(owner);
                }
            }
            if (this.getGroup() != null) {
                UserGroupUDB userGroup = (UserGroupUDB)((StorageDesignUDB)targetDesign).getUserGroupSet().getByName(this.getGroup().getName());
                if (userGroup == null) {
                    UserGroupUDB newGroup = ((StorageDesignUDB)targetDesign).getUserGroupSet().createUserGroup();
                    newGroup.setName(this.getGroup().getName());
                    newGroup.setRawObject(true);
                    priv.setGroup(newGroup);
                } else {
                    priv.setGroup(userGroup);
                }
            }
            priv.setGrantOption(this.getGrantOption());
            priv.recreateSystemPrivilegesSet(this.getSystemPrivilegesSet().toString());
            priv.setRawObject(false);
        }
    }

    static class StringComparator
    implements Comparator {
        StringComparator() {
        }

        public int compare(Object one, Object two) {
            return String.valueOf(one).compareTo(String.valueOf(two));
        }
    }

    public class PrivilegesSet
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }
}

