/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver.v2k12;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.StorageDesignSqlServerv2k12;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.UserSqlServerv2k12;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.RoleSqlServerv2k5;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k12.RolePropertyDialogSqlServerv2k12;

public class RoleSqlServerv2k12
extends RoleSqlServerv2k5 {
    private static final String[] PRIVILEGES = new String[]{"ALL", "CREATE DEFAULT", "CREATE FUNCTION", "CREATE PROCEDURE", "CREATE RULE", "CREATE TABLE", "CREATE VIEW"};
    public static final List PRIVILEGESLIST = Arrays.asList(PRIVILEGES);

    public static List getPrivilegesValues() {
        Collections.sort(PRIVILEGESLIST, new StringComparator());
        return PRIVILEGESLIST;
    }

    @Override
    protected boolean checkPrivileges(String value) {
        return PRIVILEGESLIST.contains(value);
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        RoleSqlServerv2k12 role = null;
        StorageObject stObject = (StorageObject)((StorageDesignSqlServerv2k12)targetDesign).getRoleSet().getByName(this.getName());
        if (stObject != null) {
            if (!this.isRawObject()) {
                role = (RoleSqlServerv2k12)stObject;
            }
        } else {
            role = (RoleSqlServerv2k12)((StorageDesignSqlServerv2k12)targetDesign).getRoleSet().createRole();
        }
        if (role != null) {
            role.setName(this.getName());
            role.setIsApplicationRole(this.getIsApplicationRole());
            role.setPassword(this.getPassword());
            role.setDefaultSchema(this.getDefaultSchema());
            if (this.getOwner() != null) {
                UserSqlServerv2k12 user = (UserSqlServerv2k12)((StorageDesignSqlServerv2k12)targetDesign).getUserSet().getByName(this.getOwner().getName());
                if (user == null) {
                    UserSqlServerv2k12 newUser = (UserSqlServerv2k12)((StorageDesignSqlServerv2k12)targetDesign).getUserSet().createUser();
                    newUser.setName(this.getOwner().getName());
                    newUser.setRawObject(true);
                    role.setOwner(newUser);
                } else {
                    role.setOwner(user);
                }
            }
            role.recreateUserSet(this.getUserSet().toString());
            role.recreateSystemPrivilegesSet(this.getPrivilegesSet().toString());
            role.setComment(this.getComment());
            role.setRawObject(false);
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            RolePropertyDialogSqlServerv2k12 dialog = new RolePropertyDialogSqlServerv2k12(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    static class StringComparator
    implements Comparator {
        StringComparator() {
        }

        public int compare(Object one, Object two) {
            return String.valueOf(one).compareTo(String.valueOf(two));
        }
    }
}

