/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import oracle.dbtools.crest.model.design.storage.sqlserver.AbstractStorageObjectSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.DataFilePropertyDialogSqlServer;

public class DataFileSqlServer
extends AbstractStorageObjectSqlServer {
    private static final String[] GROWTH_STATES = new String[]{"In KiloBytes", "In MegaBytes", "In GigaBytes", "In TeraBytes", "By Percent"};
    private static final String[] SIZE_IN_UNITS = new String[]{"In KiloBytes", "In MegaBytes", "In GigaBytes", "In TeraBytes"};
    private static final String[] SIZE_UNITS = new String[]{"KB", "MB", "GB", "TB"};
    private static Set growthSet = null;
    private static Set sizeSet = null;
    private String fileName = "";
    private int initialSize = 0;
    private int maxSize = 0;
    private String growthMethod = "In MegaBytes";
    private int growthValue = 0;
    private boolean isUnlimited = true;
    private String initialSizeInUnit = "In MegaBytes";
    private String maxSizeInUnit = "In MegaBytes";
    private DataBaseSqlServer dataBase = null;
    private FileGroupSqlServer filegroup = null;
    public static final String TYPE_NAME = "DataFile";

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            DataFilePropertyDialogSqlServer dialog = new DataFilePropertyDialogSqlServer(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "DF";
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
        this.fireDataFieldChange();
    }

    public int getInitialSize() {
        return this.initialSize;
    }

    public void setInitialSize(int initialSize) {
        this.initialSize = initialSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int value) {
        this.maxSize = value;
    }

    protected boolean checkGrowth(String value) {
        if (growthSet == null) {
            growthSet = new HashSet();
            growthSet.addAll(Arrays.asList(DataFileSqlServer.getGrowthChoices()));
        }
        return growthSet.contains(value);
    }

    public static String[] getGrowthChoices() {
        return GROWTH_STATES;
    }

    public void setGrowthMethod(String value) {
        if (this.checkGrowth(value)) {
            this.growthMethod = value;
            this.fireDataFieldChange();
        }
    }

    public String getGrowthMethod() {
        return this.growthMethod;
    }

    public int getGrowthValue() {
        return this.growthValue;
    }

    public void setGrowthValue(int growthValue) {
        this.growthValue = growthValue;
    }

    protected boolean checkSizeInUnit(String inUnit) {
        if (sizeSet == null) {
            sizeSet = new HashSet();
            sizeSet.addAll(Arrays.asList(DataFileSqlServer.getSizeInUnits()));
        }
        return sizeSet.contains(inUnit);
    }

    public static String[] getSizeInUnits() {
        return SIZE_IN_UNITS;
    }

    public String getInitialSizeInUnit() {
        return this.initialSizeInUnit;
    }

    public void setInitialSizeInUnit(String initialSizeInUnit) {
        if (this.checkSizeInUnit(initialSizeInUnit)) {
            this.initialSizeInUnit = initialSizeInUnit;
        }
    }

    public String getMaxSizeInUnit() {
        return this.maxSizeInUnit;
    }

    public void setMaxSizeInUnit(String maxSizeInUnit) {
        if (this.checkSizeInUnit(maxSizeInUnit)) {
            this.maxSizeInUnit = maxSizeInUnit;
        }
    }

    public String getSizeInUnitFromUnit(String unit) {
        for (int i = 0; i < SIZE_UNITS.length; ++i) {
            if (!SIZE_UNITS[i].equalsIgnoreCase(unit)) continue;
            return SIZE_IN_UNITS[i];
        }
        return "";
    }

    public String getSizeUnitFromInUnit(String inUnit) {
        for (int i = 0; i < SIZE_IN_UNITS.length; ++i) {
            if (!SIZE_IN_UNITS[i].equalsIgnoreCase(inUnit)) continue;
            return SIZE_UNITS[i];
        }
        return "";
    }

    public void setDataBase(DataBaseSqlServer dataBase) {
        this.dataBase = dataBase;
        if (dataBase != null) {
            this.filegroup = null;
            this.setPAC_Element(dataBase);
        }
        this.fireDataFieldChange();
    }

    public DataBaseSqlServer getDataBase() {
        return this.dataBase;
    }

    @Override
    public DataBaseSqlServer getDatabase() {
        return this.getDataBase();
    }

    public FileGroupSqlServer getFileGroup() {
        return this.filegroup;
    }

    public void setFileGroup(FileGroupSqlServer filegroup) {
        if (filegroup != null) {
            this.dataBase = null;
            this.filegroup = filegroup;
            this.setPAC_Element(filegroup.getPAC_Element());
            this.fireDataFieldChange();
        }
    }

    public boolean getIsUnlimited() {
        return this.isUnlimited;
    }

    public void setIsUnlimited(boolean isUnlimited) {
        this.isUnlimited = isUnlimited;
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("DATAFILE_ICON", 16);
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }
}

