/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v10g;

import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ClusterOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.LobStorageOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.RollbackSegmentOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxySetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UserOraclev10g;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v10g.SnapshotPropertyDialogOraclev10g;

public class SnapshotOraclev10g
extends SnapshotOracle {
    private String usingConstraint = USING_CONSTRAINT[0];
    private static final String[] USING_CONSTRAINT = new String[]{"ENFORCED", "TRUSTED"};

    public SnapshotOraclev10g(StorageDesign storage) {
        super(storage);
    }

    public String getUsingConstraint() {
        return this.usingConstraint;
    }

    public void setUsingConstraint(String value) {
        this.usingConstraint = value == null ? "" : value;
        this.fireDataFieldChange();
    }

    public static String[] getUsingConstraintStates() {
        return USING_CONSTRAINT;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            SnapshotPropertyDialogOraclev10g dialog = new SnapshotPropertyDialogOraclev10g(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public void copy(SnapshotOracle snapShot) {
        if (snapShot instanceof SnapshotOraclev10g) {
            this.copy(snapShot.getStorageDesign(), (SnapshotOraclev10g)snapShot);
        }
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        SnapshotOraclev10g snapShot = null;
        StorageObject stObject = (StorageObject)((StorageDesignOraclev10g)targetDesign).getSnapshotSet().getByName(this.getName());
        if (stObject != null) {
            if (!this.isRawObject()) {
                snapShot = (SnapshotOraclev10g)stObject;
            }
        } else {
            snapShot = (SnapshotOraclev10g)((StorageDesignOraclev10g)targetDesign).getSnapshotSet().createSnapshot();
        }
        this.copy(targetDesign, snapShot);
    }

    private void copy(StorageDesign targetDesign, SnapshotOraclev10g snapShot) {
        if (snapShot != null) {
            SegmentOracle sourceIndexSegment;
            snapShot.setName(this.getName());
            snapShot.setNameHasQuotes(this.getNameHasQuotes());
            snapShot.setAlias(this.getAlias());
            snapShot.setSubquery(this.getSubquery());
            if (this.getPartitionList() != null) {
                PartitionListOraclev10g partList = (PartitionListOraclev10g)((StorageDesignOraclev10g)targetDesign).getPartitionListSet().getByName(this.getPartitionList().getName());
                if (partList == null) {
                    PartitionListOraclev10g newList = (PartitionListOraclev10g)((StorageDesignOraclev10g)targetDesign).getPartitionListSet().createPartitionList();
                    newList.setName(this.getPartitionList().getName());
                    newList.setRawObject(true);
                    snapShot.setPartitionList(newList);
                } else {
                    snapShot.setPartitionList(partList);
                }
            }
            for (PartitionOraclev10g partition : this.getPartitions()) {
                PartitionOraclev10g part = (PartitionOraclev10g)((StorageDesignOraclev10g)targetDesign).getPartitionSet().getByName(partition.getName());
                if (part == null) {
                    PartitionOraclev10g newPart = (PartitionOraclev10g)((StorageDesignOraclev10g)targetDesign).getPartitionSet().createPartition();
                    newPart.setName(partition.getName());
                    newPart.setPartitionList(snapShot.getPartitionList());
                    newPart.setRawObject(true);
                    ((StorageDesignOraclev10g)targetDesign).getPartitionSet().add(newPart);
                    snapShot.addPartFromDesign(((StorageDesignOraclev10g)targetDesign).getPartitionSet());
                    continue;
                }
                part.setPartitionList(snapShot.getPartitionList());
                ((StorageDesignOraclev10g)targetDesign).getPartitionSet().add(part);
                snapShot.addPartFromDesign(((StorageDesignOraclev10g)targetDesign).getPartitionSet());
            }
            for (LobStorageOraclev10g lobStorage : this.getLobs()) {
                LobStorageOraclev10g targetLobStorage = (LobStorageOraclev10g)((StorageDesignOraclev10g)targetDesign).getLobStorageSet().getByName(lobStorage.getName());
                if (targetLobStorage == null) {
                    LobStorageOraclev10g newStorage = (LobStorageOraclev10g)((StorageDesignOraclev10g)targetDesign).getLobStorageSet().createLobStorage();
                    newStorage.setName(lobStorage.getName());
                    newStorage.setSnapshot(snapShot);
                    newStorage.setRawObject(true);
                    ((StorageDesignOraclev10g)targetDesign).getLobStorageSet().add(newStorage);
                    snapShot.getLobs().add(newStorage);
                    continue;
                }
                targetLobStorage.setSnapshot(snapShot);
                ((StorageDesignOraclev10g)targetDesign).getLobStorageSet().add(targetLobStorage);
                snapShot.getLobs().add(targetLobStorage);
            }
            if (this.getUser() != null) {
                UserOraclev10g user = (UserOraclev10g)((StorageDesignOraclev10g)targetDesign).getUserSet().getByName(this.getUser().getName());
                if (user == null) {
                    UserOraclev10g newUser = (UserOraclev10g)((StorageDesignOraclev10g)targetDesign).getUserSet().createUser();
                    newUser.setName(this.getUser().getName());
                    newUser.setRawObject(true);
                    snapShot.setUser(newUser);
                } else {
                    snapShot.setUser(user);
                }
            }
            if (this.getLobStorage() != null) {
                LobStorageOraclev10g targetLobs = (LobStorageOraclev10g)((StorageDesignOraclev10g)targetDesign).getLobStorageSet().getByName(this.getLobStorage().getName());
                if (targetLobs == null) {
                    LobStorageOraclev10g newLobs = (LobStorageOraclev10g)((StorageDesignOraclev10g)targetDesign).getLobStorageSet().createLobStorage();
                    newLobs.setName(this.getLobStorage().getName());
                    newLobs.setRawObject(true);
                    snapShot.setLobStorage(newLobs);
                } else {
                    snapShot.setLobStorage(targetLobs);
                }
            }
            snapShot.setPartitioned(this.getPartitioned());
            if (this.getCluster() != null) {
                ClusterOraclev10g cluster = (ClusterOraclev10g)((StorageDesignOraclev10g)targetDesign).getClusterSet().getByName(this.getCluster().getName());
                if (cluster == null) {
                    ClusterOraclev10g newCluster = (ClusterOraclev10g)((StorageDesignOraclev10g)targetDesign).getClusterSet().createCluster();
                    newCluster.setName(this.getCluster().getName());
                    newCluster.setRawObject(true);
                    snapShot.setCluster(newCluster);
                } else {
                    snapShot.setCluster(cluster);
                }
            }
            if (this.getTablespace() != null) {
                TableSpaceOraclev10g tableSpace = (TableSpaceOraclev10g)((StorageDesignOraclev10g)targetDesign).getTableSpaceSet().getByName(this.getTablespace().getName());
                if (tableSpace == null) {
                    TableSpaceOraclev10g newTableSpace = (TableSpaceOraclev10g)((StorageDesignOraclev10g)targetDesign).getTableSpaceSet().createTableSpace();
                    newTableSpace.setName(this.getTablespace().getName());
                    newTableSpace.setRawObject(true);
                    snapShot.setTablespace(newTableSpace);
                } else {
                    snapShot.setTablespace(tableSpace);
                }
            }
            snapShot.setLogging(this.getLogging());
            SegmentOracle sourceSegment = this.getSegment();
            if (sourceSegment != null) {
                SegmentOracle targetSegment = sourceSegment.getCopy(targetDesign);
                snapShot.setSegment(targetSegment);
            }
            snapShot.setParalelClause(this.getParalelClause());
            snapShot.setDegree(this.getDegree());
            snapShot.setBuild(this.getBuild());
            if (this.getOnPrebuildTable() != null) {
                TableProxyOraclev10g table = (TableProxyOraclev10g)((TableProxySetOraclev10g)((StorageDesignOraclev10g)targetDesign).getTableProxySet()).getByName(this.getOnPrebuildTable().getName());
                if (table == null) {
                    TableProxyOraclev10g newTable = (TableProxyOraclev10g)((TableProxySetOraclev10g)((StorageDesignOraclev10g)targetDesign).getTableProxySet()).createProxy(this.getOnPrebuildTable().getObject());
                    newTable.setName(this.getOnPrebuildTable().getName());
                    newTable.setRawObject(true);
                    snapShot.setOnPrebuildTable(newTable);
                } else {
                    snapShot.setOnPrebuildTable(table);
                }
            }
            snapShot.setReducedPrecision(this.getReducedPrecision());
            snapShot.setForUpdate(this.getForUpdate());
            snapShot.setQueryRewrite(this.getQueryRewrite());
            snapShot.setUseIndex(this.getUseIndex());
            if (this.getIndexTablespace() != null) {
                TableSpaceOraclev10g tableSpace = (TableSpaceOraclev10g)((StorageDesignOraclev10g)targetDesign).getTableSpaceSet().getByName(this.getIndexTablespace().getName());
                if (tableSpace == null) {
                    TableSpaceOraclev10g newTableSpace = (TableSpaceOraclev10g)((StorageDesignOraclev10g)targetDesign).getTableSpaceSet().createTableSpace();
                    newTableSpace.setName(this.getIndexTablespace().getName());
                    newTableSpace.setRawObject(true);
                    snapShot.setIndexTablespace(newTableSpace);
                } else {
                    snapShot.setIndexTablespace(tableSpace);
                }
            }
            if ((sourceIndexSegment = this.getIndexSegment()) != null) {
                SegmentOracle targetIndexSegment = sourceIndexSegment.getCopy(targetDesign);
                snapShot.setIndexSegment(targetIndexSegment);
            }
            snapShot.setCache(this.getCache());
            snapShot.setRefresh(this.getRefresh());
            snapShot.setRefreshType(this.getRefreshType());
            snapShot.setAction(this.getAction());
            snapShot.setStartDate(this.getStartDate());
            snapShot.setNextDate(this.getNextDate());
            snapShot.setWith(this.getWith());
            snapShot.setDefaultSegment(this.getDefaultSegment());
            snapShot.setSegmentType(this.getSegmentType());
            if (this.getRollbackSegment() != null) {
                RollbackSegmentOraclev10g rollBackSeg = (RollbackSegmentOraclev10g)((StorageDesignOraclev10g)targetDesign).getRollbackSegmentSet().getByName(this.getRollbackSegment().getName());
                if (rollBackSeg == null) {
                    RollbackSegmentOraclev10g newRollBackSeg = (RollbackSegmentOraclev10g)((StorageDesignOraclev10g)targetDesign).getRollbackSegmentSet().createRollbackSegment();
                    newRollBackSeg.setName(this.getRollbackSegment().getName());
                    newRollBackSeg.setRawObject(true);
                    snapShot.setRollbackSegment(newRollBackSeg);
                } else {
                    snapShot.setRollbackSegment(rollBackSeg);
                }
            }
            snapShot.setUsingConstraint(this.getUsingConstraint());
            snapShot.setComment(this.getComment());
            snapShot.setCommentInRdbms(this.getCommentInRdbms());
            snapShot.setRawObject(false);
        }
    }
}

