/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.AbstractPartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.swingui.editor.storage.db2.TSPartitionPropertyDialogDB2;

public class PartitionDB2
extends AbstractPartitionDB2 {
    protected TableSpaceDB2 tableSpace = null;
    private int partNumber = 1;
    private StorageTemplateDB2 storageTemplate = null;
    private boolean compress = false;
    public static final String TYPE_NAME = "Partition";

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "TSP";
    }

    public TableSpaceDB2 getTableSpace() {
        return this.tableSpace;
    }

    public void setTableSpace(TableSpaceDB2 tableSpace) {
        if (tableSpace != null) {
            this.tableSpace = tableSpace;
            this.setPAC_Element(tableSpace);
            this.fireDataFieldChange();
        }
    }

    public int getPartNumber() {
        return this.partNumber;
    }

    public void setPartNumber(int partNumber) {
        this.partNumber = partNumber;
        this.fireDataFieldChange();
    }

    public StorageTemplateDB2 getStorageTemplate() {
        return this.storageTemplate;
    }

    public void setStorageTemplate(StorageTemplateDB2 storageTemplate) {
        this.storageTemplate = storageTemplate;
        this.fireDataFieldChange();
    }

    public boolean isCompress() {
        return this.compress;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
        this.fireDataFieldChange();
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TSPartitionPropertyDialogDB2 dialog = new TSPartitionPropertyDialogDB2(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        PartitionDB2 partition = null;
        StorageObject stObject = (StorageObject)((AbstractStorageDesignDB2)targetDesign).getPartitionSet().getByName(this.getName());
        if (stObject != null) {
            if (!this.isRawObject()) {
                partition = (PartitionDB2)stObject;
            }
        } else {
            partition = ((AbstractStorageDesignDB2)targetDesign).getPartitionSet().createPartition();
        }
        if (partition != null) {
            partition.setName(this.getName());
            partition.setCompress(this.isCompress());
            if (this.getStorageTemplate() != null) {
                StorageTemplateDB2 targetTemplate = (StorageTemplateDB2)((AbstractStorageDesignDB2)targetDesign).getStorageTemplateSet().getByName(this.getStorageTemplate().getName());
                if (targetTemplate == null) {
                    StorageTemplateDB2 newTemplate = ((AbstractStorageDesignDB2)targetDesign).getStorageTemplateSet().createStorageTemplate();
                    newTemplate.setName(this.getStorageTemplate().getName());
                    newTemplate.setRawObject(true);
                    partition.setStorageTemplate(newTemplate);
                } else {
                    partition.setStorageTemplate(targetTemplate);
                }
            }
            partition.setComment(this.getComment());
            partition.setRawObject(false);
        }
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }
}

