/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIDObjectSet;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectPlaceHolder;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;

public class StorageObjectCollection
extends ModelIDObjectSet
implements ModelObjectSetListener {
    private static final StorageObject[] PROTO_ARRAY = new StorageObject[0];
    private StorageObjectSet set;
    Class parcl;
    private String setMethod;
    int allowedNumberOfElements = 99999;
    private boolean forbiddenCreateElement = false;
    private ModelObject logicalParent;

    public StorageObjectCollection() {
    }

    public StorageObjectCollection(StorageObjectSet set) {
        this.set = set;
        this.set.addSetListener(this);
    }

    @Override
    public Object[] getProtoTypeArray() {
        return PROTO_ARRAY;
    }

    @Override
    public ModelIDObject createElement(String id) {
        if (this.set != null) {
            StorageObject so = (StorageObject)this.set.createElement(id);
            so.setParent(this);
            if (this.getClassForParent() != null && this.getSetMethod() != null && this.getLogicalParent() != null) {
                Class<?> cl = so.getClass();
                try {
                    Method method = cl.getMethod(this.getSetMethod(), this.getClassForParent());
                    if (method != null) {
                        try {
                            method.invoke((Object)so, this.getLogicalParent());
                        }
                        catch (IllegalArgumentException e1) {
                        }
                        catch (IllegalAccessException e1) {
                        }
                        catch (InvocationTargetException e1) {}
                    }
                }
                catch (SecurityException e) {
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
            this.add(so);
            return so;
        }
        return null;
    }

    @Override
    public String getDefaultNamePrefix() {
        return "StorageObject";
    }

    @Override
    public boolean canCreateElement() {
        if (this.set != null) {
            return !this.isForbiddenCreateElement() && this.set.canCreateElement() && this.size() < this.getAllowedNumberOfElements();
        }
        return false;
    }

    public void removePlaceHolderFor(StorageObject object) {
        StorageObject[] ar = (StorageObject[])this.toArray();
        for (int i = 0; i < ar.length; ++i) {
            StorageObject so = ar[i];
            if (!(so instanceof StorageObjectPlaceHolder) || ((StorageObjectPlaceHolder)so).getStorageObject() != object) continue;
            this.remove(so);
            return;
        }
    }

    public boolean containsPlaceHolderFor(StorageObject object) {
        for (StorageObject so : this) {
            if (!(so instanceof StorageObjectPlaceHolder) || ((StorageObjectPlaceHolder)so).getStorageObject() != object) continue;
            return true;
        }
        return false;
    }

    public Class getClassForParent() {
        return this.parcl;
    }

    public void setClassForParent(Class parClass) {
        this.parcl = parClass;
    }

    public String getSetMethod() {
        return this.setMethod;
    }

    public void setSetMethod(String setMethod) {
        this.setMethod = setMethod;
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(0) && event.getAffected() instanceof StorageObject) {
            this.remove(event.getAffected());
        }
    }

    public int getAllowedNumberOfElements() {
        return this.allowedNumberOfElements;
    }

    public void setAllowedNumberOfElements(int allowedNumberOfElements) {
        this.allowedNumberOfElements = allowedNumberOfElements;
    }

    @Override
    public boolean remove(ModelObject object) {
        boolean result = super.remove(object);
        if (result && object instanceof StorageObject) {
            ((StorageObject)object).remove();
            return true;
        }
        return result;
    }

    public boolean justRemove(ModelObject object) {
        return super.remove(object);
    }

    public boolean isForbiddenCreateElement() {
        return this.forbiddenCreateElement;
    }

    public void setForbiddenCreateElement(boolean forbiddenCreateElement) {
        this.forbiddenCreateElement = forbiddenCreateElement;
    }

    public ModelObject getLogicalParent() {
        if (this.logicalParent != null) {
            return this.logicalParent;
        }
        return (ModelObject)this.getParent();
    }

    public void setLogicalParent(ModelObject logicalParent) {
        this.logicalParent = logicalParent;
    }

    @Override
    public void add(ModelObject object) {
        if (object instanceof StorageObjectPlaceHolder) {
            if (!this.containsPlaceHolderFor(((StorageObjectPlaceHolder)object).getStorageObject())) {
                super.add(object);
            }
        } else if (!this.contains(object)) {
            super.add(object);
        }
    }

    public void addWithoutCheck(ModelObject object) {
        super.add(object);
    }

    public StorageObjectSet getStorageObjectSet() {
        return this.set;
    }

    public void setStorageObjectSet(StorageObjectSet set) {
        this.set = set;
    }
}

