/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.editor.relational.FKArcPropertiesDialogEx;
import oracle.dbtools.crest.swingui.relational.TVFKContainer;

public class FKArc
extends ContainerObject
implements ObjectListener {
    private FKContainer table;
    private List fkeys;
    private int sizeIndex;
    private List fkIDs = new ArrayList();
    private boolean mandatory = false;
    private Column discriminatorColumn;
    private boolean reverse = false;
    public static final String TYPE_NAME = "FKArc";

    public FKArc(DesignPart designPart) {
        super(designPart);
        this.fkeys = new ArrayList();
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
        if (object instanceof FKIndexAssociation && event == ObjectChangeEvent.OBJECT_REMOVED) {
            this.removeFkey((FKIndexAssociation)object);
            if (this.fkeys.size() <= 1) {
                this.remove();
            }
        }
    }

    @Override
    public void remove() {
        Object[] fks = this.fkeys.toArray();
        for (int i = fks.length - 1; i >= 0; --i) {
            FKIndexAssociation fkey = (FKIndexAssociation)fks[i];
            this.removeFkey(fkey);
        }
        super.remove();
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            FKArcPropertiesDialogEx dialog = new FKArcPropertiesDialogEx(this.getDesign().getAppView(), this);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    public FKContainer getTable() {
        return this.table;
    }

    public void setTable(FKContainer table) {
        this.table = table;
        if (table != null && !table.arcExists(this)) {
            table.addArc(this);
        }
    }

    public List getFkeys() {
        if (this.fkIDs.size() > 0) {
            this.updateFKs();
        }
        return this.fkeys;
    }

    public boolean containsFKey(FKIndexAssociation fkey) {
        return this.fkeys.contains(fkey);
    }

    public void addFkey(FKIndexAssociation fkey) {
        if (!this.fkeys.contains(fkey)) {
            this.fkeys.add(fkey);
            fkey.addObjectListener(this);
            fkey.setArc(this);
        }
    }

    public void removeFkey(FKIndexAssociation fkey) {
        this.fkeys.remove(fkey);
        fkey.removeObjectListener(this);
        fkey.setArc(null);
    }

    public void clearFkeys() {
        this.fkeys.clear();
    }

    public int getSizeIndex() {
        return this.sizeIndex;
    }

    public void setSizeIndex(int sizeIndex) {
        this.sizeIndex = sizeIndex;
    }

    @Override
    protected void clearStructure() {
    }

    @Override
    public ContainedObject createContainedObject(String id) {
        return null;
    }

    @Override
    public DesignObjectSet getContainedSet() {
        return null;
    }

    @Override
    protected void updateStructure() {
    }

    public void addFKid(String id) {
        if (!this.fkIDs.contains(id)) {
            this.fkIDs.add(id);
        }
    }

    private void updateFKs() {
        for (int i = this.fkIDs.size() - 1; i >= 0; --i) {
            String id = (String)this.fkIDs.get(i);
            FKIndexAssociation fkey = (FKIndexAssociation)this.getDesign().getDesignObject(id);
            if (fkey == null) continue;
            this.addFkey(fkey);
            this.fkIDs.remove(i);
        }
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        if (this.mandatory != mandatory) {
            this.mandatory = mandatory;
        }
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "arc" + File.separatorChar + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public Column getDiscriminatorColumn() {
        return this.discriminatorColumn;
    }

    public void setDiscriminatorColumn(Column discriminatorColumn) {
        this.discriminatorColumn = discriminatorColumn;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }

    public void showArcInAllDPVs() {
        if (this.table != null) {
            for (TopView v : this.table.getAllTopViews()) {
                if (v == null || !(v instanceof TVFKContainer)) continue;
                ((TVFKContainer)v).addArcs();
            }
        }
    }

    @Override
    public void copy(DesignObject desObject) {
        this.copy(desObject, null, false);
    }

    public void copy(DesignObject desObject, Map copyMap) {
        this.copy(desObject, copyMap, false);
    }

    @Override
    public void copy(DesignObject desObject, Map copyMap, boolean remoteObject) {
        super.copy(desObject);
        if (desObject instanceof FKArc) {
            FKArc arc = (FKArc)desObject;
            arc.setMandatory(this.isMandatory());
            arc.setReverse(this.isReverse());
            FKArc.synchronizeForeignKeys(this, arc, copyMap, remoteObject);
            FKArc.synchronizeDiscriminatorColumn(this, arc, copyMap);
        }
    }

    public static void synchronizeDiscriminatorColumn(FKArc source, FKArc arc, Map copyMap) {
        if (!arc.isViewArc()) {
            FKContainer nt = arc.getTable();
            Column col = source.getDiscriminatorColumn();
            if (col != null && nt != null) {
                Column dcol = null;
                if (nt.isRemoteObject()) {
                    dcol = (Column)nt.getElementByRemoteObjectID(col.getObjectID());
                }
                if (dcol == null && copyMap != null) {
                    dcol = (Column)copyMap.get(col.getObjectID());
                }
                if (dcol == null) {
                    dcol = (Column)nt.getElementByID(col.getObjectID());
                }
                if (dcol == null) {
                    dcol = (Column)nt.getElementByName(col.getName());
                }
                if (dcol != null) {
                    arc.setDiscriminatorColumn(dcol);
                }
            }
        }
    }

    public static boolean isMatchingDiscriminatorColumn(FKArc source, FKArc arc, Map copyMap) {
        if (arc.isViewArc()) {
            return false;
        }
        FKContainer nt = arc.getTable();
        Column col = source.getDiscriminatorColumn();
        Column tcol = arc.getDiscriminatorColumn();
        Column dcol = null;
        if (col != null && tcol != null && nt != null) {
            if (nt.isRemoteObject()) {
                dcol = (Column)nt.getElementByRemoteObjectID(col.getObjectID());
            }
            if (dcol == null && copyMap != null) {
                dcol = (Column)copyMap.get(col.getObjectID());
            }
            if (dcol == null) {
                dcol = (Column)nt.getElementByID(col.getObjectID());
            }
            if (dcol == null) {
                dcol = (Column)nt.getElementByName(col.getName());
            }
            if (dcol != null && dcol == tcol) {
                return true;
            }
        }
        return col == null;
    }

    public static void synchronizeForeignKeys(FKArc source, FKArc arc, Map copyMap, boolean remoteObject) {
        if (arc.isRemoteObject() || remoteObject || copyMap != null) {
            Object[] oldFkeys = arc.getFkeys().toArray();
            ArrayList<FKIndexAssociation> newFkeys = new ArrayList<FKIndexAssociation>();
            for (FKIndexAssociation fk : source.getFkeys()) {
                FKIndexAssociation newfk = null;
                if (copyMap != null) {
                    newfk = (FKIndexAssociation)copyMap.get(fk.getObjectID());
                }
                if (newfk == null && (remoteObject || arc.isRemoteObject())) {
                    newfk = (FKIndexAssociation)((RelationalDesign)arc.getDesignPart()).getFKIndexAssociationSet().getObjectByRemoteObjectID(fk.getObjectID());
                }
                if (newfk == null) continue;
                arc.addFkey(newfk);
                newFkeys.add(newfk);
            }
            for (int i = 0; i < oldFkeys.length; ++i) {
                if (newFkeys.contains(oldFkeys[i])) continue;
                arc.removeFkey((FKIndexAssociation)oldFkeys[i]);
            }
        }
    }

    public static boolean isMatchingForeignKeys(FKArc source, FKArc arc, Map copyMap) {
        if (source.getFkeys().size() != arc.getFkeys().size()) {
            return false;
        }
        Object[] oldFkeys = arc.getFkeys().toArray();
        ArrayList<FKIndexAssociation> newFkeys = new ArrayList<FKIndexAssociation>();
        for (FKIndexAssociation fk : source.getFkeys()) {
            FKIndexAssociation newfk = null;
            if (copyMap != null) {
                newfk = (FKIndexAssociation)copyMap.get(fk.getObjectID());
            }
            if (newfk == null && arc.isRemoteObject()) {
                newfk = (FKIndexAssociation)((RelationalDesign)arc.getDesignPart()).getFKIndexAssociationSet().getObjectByRemoteObjectID(fk.getObjectID());
            }
            if (newfk == null && !arc.isRemoteObject() && (newfk = (FKIndexAssociation)((RelationalDesign)arc.getDesignPart()).getFKIndexAssociationSet().getObjectByID(fk.getObjectID())) == null) {
                newfk = (FKIndexAssociation)((RelationalDesign)arc.getDesignPart()).getFKIndexAssociationSet().getObjectByImportedID(fk.getObjectID());
            }
            if (newfk == null) continue;
            newFkeys.add(newfk);
        }
        if (oldFkeys.length != newFkeys.size()) {
            return false;
        }
        for (int i = 0; i < oldFkeys.length; ++i) {
            if (newFkeys.contains(oldFkeys[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object translateIdToObject(String propertyName, String id) {
        if ("fkeys".equalsIgnoreCase(propertyName)) {
            DesignObject fk = this.getDesign().getDesignObject(id);
            if (fk == null) {
                fk = ((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet().getObjectByRemoteObjectID(id);
            }
            if (fk != null) {
                return fk;
            }
        }
        return super.translateIdToObject(propertyName, id);
    }

    public boolean isViewArc() {
        return this.table != null && this.table instanceof TableView;
    }

    public void addToAllDPVs() {
        FKContainer ent = this.getTable();
        if (ent == null) {
            return;
        }
        Collection targetDPVs = ent.getAffectedDPVs();
        for (DesignPartView dpv : targetDPVs) {
            TVFKContainer tvent = (TVFKContainer)ent.getFirstViewForDPV(dpv);
            if (tvent == null) continue;
            tvent.addArc(this);
        }
    }

    public List<FKElement> getColumnsInArc() {
        if (this.isReverse() || this.getFkeys().size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<FKElement> list = new ArrayList<FKElement>();
        for (FKIndexAssociation fk : this.getFkeys()) {
            for (FKElement column : fk.getLocalFKIndex().getElementsCollection()) {
                list.add(column);
            }
        }
        return list;
    }
}

