/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import java.awt.Dialog;
import java.util.List;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.model.NameValidator;
import oracle.dbtools.crest.model.datatype.NativeDBType;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.xtdmapping.MappingCollector;
import oracle.dbtools.crest.model.xtdmapping.RMExtendedMap;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.editor.relational.TableViewPropertiesDialogEx;

public class ColumnView
extends AbstractViewElement {
    public ColumnView(DesignPart designPart) {
        super(designPart);
    }

    public ColumnView(DesignPart designPart, FKElement refColumn, FKIndexAssociation fkAssoc) {
        super(designPart, refColumn, fkAssoc);
    }

    @Override
    public String getObjectTypeName() {
        return "ColumnView";
    }

    @Override
    public String getIDPrefix() {
        return "CV";
    }

    @Override
    public Datatype getDataType() {
        NativeDBType nt;
        Datatype type;
        FKElement referencedColumn;
        if (!(this.getFKAssociationID() == null || "".equalsIgnoreCase(this.getFKAssociationID()) || this.getFKColumnID() == null || this.getFKColumnID().equalsIgnoreCase(this.getObjectID()) || this.isNested() || this.getContainer().isBST() || this.isReference() && this.getUse() == 3 || (referencedColumn = (FKElement)this.getReferencedColumn()) == null || referencedColumn.isOid())) {
            return referencedColumn.getDataType();
        }
        if (this.getReferencedColumn() != null) {
            return this.getReferencedColumn().getDataType();
        }
        if (this.getReferencedColumnView() != null && (type = this.getReferencedColumnView().getDataType()) != null && !"UNKNOWN".equalsIgnoreCase(type.getName())) {
            return type;
        }
        RDBMSType dbtype = this.getSelectedRDBMSType();
        String rdbmsName = this.getSelectedRDBMSType().toString();
        String colDatatype = this.removeBrackets(this.getDataTypeString());
        String usedDatatype = StandardDatatypeNames.getUsedDatatypeName(colDatatype);
        LogicalDatatype logicalDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(dbtype, usedDatatype);
        if (logicalDatatype == null && (nt = StandardDatatypeNames.getNativeDBType(dbtype, usedDatatype)) != null) {
            logicalDatatype = nt.getLogicalDatatype();
        }
        if (logicalDatatype == null) {
            logicalDatatype = this.getDesign().getLogicalDatatypeSet().getLogTypeByNativeType(colDatatype, dbtype.getName());
        }
        if (logicalDatatype == null) {
            return this.getDesign().getDomainSet().getDefaultDomain().getDataType();
        }
        TreeMap parameters = new TreeMap();
        return ContainedObjectWithDomain.getDataTypeWithDefaults(logicalDatatype, parameters, rdbmsName);
    }

    protected String removeBrackets(String input) {
        String result;
        int length = input.length();
        int ind = input.indexOf("(");
        if (ind > 0) {
            result = input.substring(0, ind);
            int close_ind = input.indexOf(")");
            if (close_ind > 0 && close_ind < length - 1) {
                String rest = input.substring(close_ind + 1, length);
                result = result.trim() + " " + this.removeBrackets(rest).trim();
            }
        } else {
            result = input;
        }
        return result.trim();
    }

    @Override
    public void copy(DesignObject desObject) {
        ColumnView columnView = (ColumnView)desObject;
        super.copy(columnView);
        columnView.setDesign(this.getDesign());
        columnView.setTableAlias(this.getTableAlias());
        columnView.setAlias(this.getAlias());
        columnView.setHeaderAlias(this.getHeaderAlias());
        columnView.setExpression(this.getExpression());
        columnView.setDataType(this.getDataTypeString());
        columnView.setReferencedColumn(this.getReferencedColumn());
        columnView.setReferencedColumnView(this.getReferencedColumnView());
        columnView.setTable(this.getTable());
        columnView.setScopeId(this.getScopeId());
        columnView.setReference(this.isReference());
        columnView.setStructuredType(this.getStructuredType());
        columnView.setFKAssociationID(this.getFKAssociationID());
        columnView.setFKColumnID(this.getFKColumnID());
        columnView.setNullsAllowed(this.getNullsAllowed());
        columnView.setReference(this.isReference());
        columnView.setUse(this.getUse());
        if (this.getUse() == 0) {
            columnView.setDomain(this.getDomain());
        } else if (this.getUse() == 1) {
            columnView.setLogicalDatatype(this.getLogicalDatatype());
            columnView.setDataTypeParameter("size", this.getSize());
            columnView.setDataTypeParameter("precision", this.getPrecision());
            columnView.setDataTypeParameter("scale", this.getScale());
        } else if (this.getUse() == 3) {
            columnView.setStructuredType(this.getStructuredType());
            List list = columnView.getPermittedSubTypes();
            list.clear();
            list.addAll(this.getPermittedSubTypes());
        } else if (this.getUse() == 4) {
            columnView.setCollectionType(this.getCollectionType());
        } else if (this.getUse() == 2) {
            columnView.setDistinctType(this.getDistinctType());
        }
        columnView.setPreviousColumn(this.isPreviousColumn());
        if (this.getDesignPart() == columnView.getDesignPart()) {
            columnView.setDependOnForeignKeyID(this.getDependOnForeignKeyID());
            columnView.setDependOnForeignKey(this.getDependOnForeignKey());
            columnView.setDependOnFK_AsMandatory(this.isDependOnFK_AsMandatory());
        }
    }

    @Override
    public void showPropertyDialog(Dialog owner) {
        if (this.getContainer() != null && !this.getContainer().isDialogVisible()) {
            TableViewPropertiesDialogEx dialog = owner == null ? new TableViewPropertiesDialogEx(this.getDesign().getAppView(), this.getContainer()) : new TableViewPropertiesDialogEx(owner, this.getDesign().getAppView(), this.getContainer());
            dialog.initProperties(this.getContainer());
            dialog.show();
        }
    }

    @Override
    public void showPropertyDialog() {
        this.showPropertyDialog(null);
    }

    public AttributeView getEngAttributeView() {
        XtdMapping mapping;
        AttributeView attr;
        MappingCollector mw = this.getRMExtendedMap().getOrCreateCollector(this);
        List list = mw.getMappingsForDesignPart(this.getDesign().getLogicalDesign().getObjectID());
        if (list.size() >= 1 && (attr = (AttributeView)(mapping = (XtdMapping)list.get(0)).getObjectMappedTo(this)) != null) {
            return attr;
        }
        return null;
    }

    @Override
    public RMExtendedMap getRMExtendedMap() {
        return ((RelationalDesign)this.getDesignPart()).getRMExtendedMap();
    }

    @Override
    public Attribute getEngAttribute() {
        DesignObject obj;
        XtdMapping mapping;
        Attribute attr;
        MappingCollector mw = this.getRMExtendedMap().getOrCreateCollector(this);
        List list = mw.getMappingsForDesignPart(this.getDesign().getLogicalDesign().getObjectID());
        if (list.size() == 1 && (attr = (Attribute)(mapping = (XtdMapping)list.get(0)).getObjectMappedTo(this)) != null) {
            return attr;
        }
        for (XtdMapping mapping2 : list) {
            if (mapping2.getInheritanceType() != 0 || (obj = mapping2.getObjectMappedTo(this)) == null || !(obj instanceof Attribute)) continue;
            return (Attribute)obj;
        }
        for (XtdMapping mapping2 : list) {
            if (mapping2.getInheritanceType() != 3 || (obj = mapping2.getObjectMappedTo(this)) == null || !(obj instanceof Attribute)) continue;
            return (Attribute)obj;
        }
        attr = null;
        attr = (Attribute)this.getGenerator();
        if (attr == null) {
            if (!"User generated".equalsIgnoreCase(this.getGeneratorID())) {
                attr = (Attribute)this.getDesign().getLogicalDesign().getAttributeSet().getObjectByID(this.getGeneratorID());
            }
            if (attr == null) {
                attr = (Attribute)this.getDesign().getLogicalDesign().getAttributeSet().getObjectGeneratedBy(this.getObjectID());
            }
        }
        return attr;
    }

    @Override
    public String getFormatedName(NameValidator sd, boolean quoted) {
        String presentationName = this.getPresentationName();
        if (presentationName.equals(this.getName())) {
            return super.getFormatedName(sd, quoted);
        }
        if (quoted || !sd.isValidName(presentationName)) {
            presentationName = "\"" + presentationName + "\"";
        }
        return presentationName;
    }

    public Column getFirstReferencedColumn() {
        ContainedObjectWithDomain referencedColumn = this.getReferencedColumn();
        if (referencedColumn == null) {
            referencedColumn = this.getReferencedColumnView();
        }
        if (referencedColumn instanceof Column) {
            return (Column)referencedColumn;
        }
        if (referencedColumn instanceof ColumnView) {
            Object col = null;
            ColumnView cv = (ColumnView)referencedColumn;
            while (col == null && cv != null) {
                FKElement refc = (FKElement)cv.getReferencedColumn();
                if (refc != null && refc instanceof Column) {
                    return (Column)refc;
                }
                if (refc instanceof ColumnView && refc != this) {
                    cv = (ColumnView)refc;
                    if (cv != referencedColumn) continue;
                    break;
                }
                cv = null;
            }
        }
        return null;
    }
}

