/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.multidimensional;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.fcp.SearchDockable;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatusHelper;
import oracle.dbtools.crest.fcp.vcs.TreePathHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNObjectHelper;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.DesignPartListener;
import oracle.dbtools.crest.model.design.ImageObject;
import oracle.dbtools.crest.model.design.ImageObjectSet;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.NoteSet;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.CubeSet;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.DimensionSet;
import oracle.dbtools.crest.model.design.multidimensional.EngineerFromOracle;
import oracle.dbtools.crest.model.design.multidimensional.EngineerToOracle;
import oracle.dbtools.crest.model.design.multidimensional.FactEntitiesJoin;
import oracle.dbtools.crest.model.design.multidimensional.FactEntitiesJoinSet;
import oracle.dbtools.crest.model.design.multidimensional.FromOracleModelSelector;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.HierarchySet;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.LevelSet;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.LinkSet;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.MeasureFolder;
import oracle.dbtools.crest.model.design.multidimensional.MeasureFolderCollection;
import oracle.dbtools.crest.model.design.multidimensional.MeasureFolderSet;
import oracle.dbtools.crest.model.design.multidimensional.MeasureSet;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesignSet;
import oracle.dbtools.crest.model.design.multidimensional.OracleModelSelector;
import oracle.dbtools.crest.model.design.multidimensional.RaggedHLink;
import oracle.dbtools.crest.model.design.multidimensional.RaggedHLinkSet;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.model.design.multidimensional.RollupLinkSet;
import oracle.dbtools.crest.model.design.multidimensional.SQLAccessToAW;
import oracle.dbtools.crest.model.design.multidimensional.SQLAccessToAWSet;
import oracle.dbtools.crest.model.design.multidimensional.SelectionCriteria;
import oracle.dbtools.crest.model.design.multidimensional.SelectionCriteriaSet;
import oracle.dbtools.crest.model.design.multidimensional.Slice;
import oracle.dbtools.crest.model.design.multidimensional.SliceSet;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.editor.multidimensional.MultidimensionalModelPropertiesDialog;
import oracle.dbtools.crest.swingui.multidimensional.AbstractMDTV;
import oracle.dbtools.crest.swingui.multidimensional.DPVCompactMultidimentional;
import oracle.dbtools.crest.swingui.multidimensional.DPVMultidimensional;
import oracle.dbtools.crest.swingui.multidimensional.TVLink;
import oracle.dbtools.crest.swingui.search.SearchPanel;
import oracle.dbtools.crest.swingui.search.SearchSet;
import oracle.dbtools.crest.swingui.wizards.reports.ReportConstants;

public class MultidimensionalDesign
extends DesignPart
implements ModelObjectSetListener,
ObjectListener,
DesignPartListener {
    public static final String OBJECT_TYPE_NAME = "Dimensional Model";
    public static final String OLD_OBJECT_TYPE_NAME = "Multidimensional Diagram";
    public static final String SEL_CRITERIA_SET_NAME = "Selection Criterias";
    public static final String LEVEL_SET_NAME = "Levels";
    public static final String ROLLUPLINK_SET_NAME = "RollupLinks";
    public static final String RAGGEDHLINK_SET_NAME = "Ragged Hierarchy Links";
    public static final String DIMENSION_SET_NAME = "Dimensions";
    public static final String MEASURE_SET_NAME = "Measures";
    public static final String SLICE_SET_NAME = "Slices";
    public static final String FE_JOINS_SET_NAME = "Fact Entities Joins";
    public static final String CUBE_SET_NAME = "Cubes";
    public static final String LINK_SET_NAME = "Links";
    public static final String HIERARCHY_SET_NAME = "Hierarchies";
    public static final String MEASUREFOLDER_SET_NAME = "MeasureFolders";
    public static final String SQLTOAW_SET_NAME = "SQLAccessToAWs";
    public static final String NOTE_SET_NAME = "Notes";
    public static final String DIAGRAM_SET_NAME = "Diagrams";
    private CubeSet cubeSet;
    private DimensionSet dimensionSet;
    private HierarchySet hierarchySet;
    private LevelSet levelSet;
    private MeasureSet measureSet;
    private LinkSet linkSet;
    private RaggedHLinkSet raggedHLinkSet;
    private RollupLinkSet rollupLinkSet;
    private SliceSet sliceSet;
    private SQLAccessToAWSet sqlAccessToAWSet;
    private NoteSet noteSet;
    private ImageObjectSet imageSet;
    private SelectionCriteriaSet scSet;
    private FactEntitiesJoinSet factEntitiesJoinSet;
    private MeasureFolderSet measureFolderSet;
    private MeasureFolderCollection measureFolderCollection;
    private DPVCompactMultidimentional compactDiagram;
    private DesignPartViewPlaceHolder compactDiagramPH;
    private DesignPart boundedModel;

    public MultidimensionalDesign(Design design) {
        this.setDesign(design);
        this.boundedModel = design.getLogicalDesign();
        this.boundedModel.addDesignPartListener(this);
    }

    @Override
    public Collection getAllTopLevelObjects() {
        ArrayList collection = new ArrayList();
        this.getCubeSet().addAllElementsTo(collection);
        this.getLevelSet().addAllElementsTo(collection);
        this.getDimensionSet().addAllElementsTo(collection);
        this.getLinkSet().addAllElementsTo(collection);
        this.getRaggedHLinkSet().addAllElementsTo(collection);
        this.getNoteSet().addAllElementsTo(collection);
        this.getImageObjectSet().addAllElementsTo(collection);
        this.getDiagramViewSet().addAllElementsTo(collection);
        return collection;
    }

    @Override
    public void clearAll() {
        this.getCubeSet().removeAll();
        this.getDimensionSet().removeAll();
        this.getHierarchySet().removeAll();
        this.getLevelSet().removeAll();
        this.getMeasureSet().removeAll();
        this.getLinkSet().removeAll();
        this.getRollupLinkSet().removeAll();
        this.getSliceSet().removeAll();
        this.getNoteSet().removeAll();
        this.getImageObjectSet().removeAll();
        this.getDiagramViewSet().removeAll();
        this.getSelectionCriteriaSet().removeAll();
        this.clearDocuments();
        this.clearResponsibleParties();
        this.setComment("");
        this.setNotes("");
        this.getMeasureFolderSet().removeAll();
        this.getMeasureFolderCollection().removeAll();
        this.setRepositoryOID(null);
        this.setRepositoryOVID(null);
    }

    @Override
    protected DesignPartView createDesignPartSubView(String name) {
        DPVCompactMultidimentional dpv = new DPVCompactMultidimentional(this.getDesign().getAppView(), this);
        dpv.setName(name);
        this.compactDiagramPH = new DesignPartViewPlaceHolder((DesignPart)this, dpv);
        this.compactDiagramPH.setParent(this.subViews);
        this.subViews.add(this.compactDiagramPH);
        return dpv;
    }

    public void createCompactDiagram() {
        if (this.compactDiagram == null) {
            this.compactDiagram = (DPVCompactMultidimentional)this.createDesignPartSubView(this.getName() + Messages.getString("MultidimensionalDesign.CompactDiagram"));
            this.compactDiagram.setDPVId(this.getDesign().getAppView().getIDGenerator().createNewID());
            this.compactDiagram.getTabbedPane().setName(this.getName() + Messages.getString("MultidimensionalDesign.CompactDiagram"));
            this.compactDiagram.getTabbedPane().add(this.compactDiagram);
        }
    }

    @Override
    public boolean setName(String name) {
        boolean result = super.setName(name);
        if (result) {
            if (this.compactDiagram == null) {
                this.createCompactDiagram();
            }
            this.compactDiagramPH.setName(name + Messages.getString("MultidimensionalDesign.CompactDiagram"));
        }
        return result;
    }

    public void showCompactDiagram(boolean show) {
        this.compactDiagramPH.setVisible(show);
        this.getCompactDiagram().setVisible(show);
    }

    public boolean isCompactDiagramVisible() {
        return this.compactDiagramPH.getVisible();
    }

    public DPVCompactMultidimentional getCompactDiagram() {
        if (this.compactDiagram == null) {
            this.createCompactDiagram();
        }
        return this.compactDiagram;
    }

    public DesignPartViewPlaceHolder getCompactDiagramPlaceHolder() {
        return this.compactDiagramPH;
    }

    @Override
    public DesignPartView getMainView() {
        if (this.mainView == null) {
            this.mainView = new DPVMultidimensional(this.getDesign().getAppView(), this);
            this.mainView.setDPVId(this.getDesign().getAppView().getIDGenerator().createNewID());
        }
        return this.mainView;
    }

    @Override
    public boolean isEmpty() {
        return this.getCubeSet().size() <= 0 && this.getDimensionSet().size() <= 0 && this.getHierarchySet().size() <= 0 && this.getLevelSet().size() <= 0 && this.getMeasureSet().size() <= 0 && this.getLinkSet().size() <= 0 && this.getRollupLinkSet().size() <= 0 && this.getSliceSet().size() <= 0 && this.getNoteSet().size() <= 0 && this.getImageObjectSet().size() <= 0 && this.getDiagramViewSet().size() <= 0 && this.getSelectionCriteriaSet().size() <= 0 && this.getMeasureFolderSet().size() <= 0;
    }

    @Override
    public String getObjectTypeName() {
        return OBJECT_TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "MDD";
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public CubeSet getCubeSet() {
        if (this.cubeSet == null) {
            this.cubeSet = new CubeSet(this);
            this.cubeSet.setDesign(this.getDesign());
            this.cubeSet.setName(Messages.getString("MultidimensionalDesign.Cubes"));
            this.cubeSet.setParent(this);
            this.cubeSet.addSetListener(this);
        }
        return this.cubeSet;
    }

    public DimensionSet getDimensionSet() {
        if (this.dimensionSet == null) {
            this.dimensionSet = new DimensionSet(this);
            this.dimensionSet.setDesign(this.getDesign());
            this.dimensionSet.setName(Messages.getString("MultidimensionalDesign.Dimensions"));
            this.dimensionSet.setParent(this);
            this.dimensionSet.addSetListener(this);
        }
        return this.dimensionSet;
    }

    public FactEntitiesJoinSet getFactEntitiesJoinSet() {
        if (this.factEntitiesJoinSet == null) {
            this.factEntitiesJoinSet = new FactEntitiesJoinSet(this);
            this.factEntitiesJoinSet.setDesign(this.getDesign());
            this.factEntitiesJoinSet.setName(Messages.getString("MultidimensionalDesign.JoinsFactEntities"));
            this.factEntitiesJoinSet.setParent(this);
            this.factEntitiesJoinSet.addSetListener(this);
        }
        return this.factEntitiesJoinSet;
    }

    public HierarchySet getHierarchySet() {
        if (this.hierarchySet == null) {
            this.hierarchySet = new HierarchySet(this);
            this.hierarchySet.setDesign(this.getDesign());
            this.hierarchySet.setName(Messages.getString("MultidimensionalDesign.Hierarchies"));
            this.hierarchySet.setParent(this);
            this.hierarchySet.addSetListener(this);
        }
        return this.hierarchySet;
    }

    public LevelSet getLevelSet() {
        if (this.levelSet == null) {
            this.levelSet = new LevelSet(this);
            this.levelSet.setDesign(this.getDesign());
            this.levelSet.setName(Messages.getString("MultidimensionalDesign.Levels"));
            this.levelSet.setParent(this);
            this.levelSet.addSetListener(this);
        }
        return this.levelSet;
    }

    public MeasureFolderSet getMeasureFolderSet() {
        if (this.measureFolderSet == null) {
            this.measureFolderSet = new MeasureFolderSet(this);
            this.measureFolderSet.setDesign(this.getDesign());
            this.measureFolderSet.setName(Messages.getString("MultidimensionalDesign.MeasureFolders"));
            this.measureFolderSet.setParent(this);
            this.measureFolderSet.addSetListener(this);
        }
        return this.measureFolderSet;
    }

    private MeasureFolderCollection getMeasureFolderCollection() {
        if (this.measureFolderCollection == null) {
            this.measureFolderCollection = new MeasureFolderCollection();
            this.measureFolderCollection.setDesign(this.getDesign());
            this.measureFolderCollection.setParent(this);
            this.measureFolderCollection.setName(Messages.getString("MultidimensionalDesign.MeasureFolders"));
        }
        return this.measureFolderCollection;
    }

    public MeasureSet getMeasureSet() {
        if (this.measureSet == null) {
            this.measureSet = new MeasureSet(this);
            this.measureSet.setDesign(this.getDesign());
            this.measureSet.setName(Messages.getString("MultidimensionalDesign.Measures"));
            this.measureSet.setParent(this);
            this.measureSet.addSetListener(this);
        }
        return this.measureSet;
    }

    @Override
    public ImageObjectSet getImageObjectSet() {
        if (this.imageSet == null) {
            this.imageSet = new ImageObjectSet(this);
            this.imageSet.setDesign(this.getDesign());
            this.imageSet.setName(Messages.getString("MultidimensionalDesign.Images"));
            this.imageSet.setParent(this);
            this.imageSet.addSetListener(this);
        }
        return this.imageSet;
    }

    @Override
    public NoteSet getNoteSet() {
        if (this.noteSet == null) {
            this.noteSet = new NoteSet(this);
            this.noteSet.setDesign(this.getDesign());
            this.noteSet.setName(Messages.getString("MultidimensionalDesign.Notes"));
            this.noteSet.setParent(this);
            this.noteSet.addSetListener(this);
        }
        return this.noteSet;
    }

    public RollupLinkSet getRollupLinkSet() {
        if (this.rollupLinkSet == null) {
            this.rollupLinkSet = new RollupLinkSet(this);
            this.rollupLinkSet.setDesign(this.getDesign());
            this.rollupLinkSet.setName(Messages.getString("MultidimensionalDesign.RollupLinks"));
            this.rollupLinkSet.setParent(this);
            this.rollupLinkSet.addSetListener(this);
        }
        return this.rollupLinkSet;
    }

    public LinkSet getLinkSet() {
        if (this.linkSet == null) {
            this.linkSet = new LinkSet(this);
            this.linkSet.setDesign(this.getDesign());
            this.linkSet.setName(Messages.getString("MultidimensionalDesign.Links"));
            this.linkSet.setParent(this);
            this.linkSet.addSetListener(this);
        }
        return this.linkSet;
    }

    public RaggedHLinkSet getRaggedHLinkSet() {
        if (this.raggedHLinkSet == null) {
            this.raggedHLinkSet = new RaggedHLinkSet(this);
            this.raggedHLinkSet.setDesign(this.getDesign());
            this.raggedHLinkSet.setName(Messages.getString("MultidimensionalDesign.RaggedHierarchyLinks"));
            this.raggedHLinkSet.setParent(this);
            this.raggedHLinkSet.addSetListener(this);
        }
        return this.raggedHLinkSet;
    }

    public SliceSet getSliceSet() {
        if (this.sliceSet == null) {
            this.sliceSet = new SliceSet(this);
            this.sliceSet.setDesign(this.getDesign());
            this.sliceSet.setName(Messages.getString("MultidimensionalDesign.Slices"));
            this.sliceSet.setParent(this);
            this.sliceSet.addSetListener(this);
        }
        return this.sliceSet;
    }

    public SQLAccessToAWSet getSQLAccessToAWSet() {
        if (this.sqlAccessToAWSet == null) {
            this.sqlAccessToAWSet = new SQLAccessToAWSet(this);
            this.sqlAccessToAWSet.setDesign(this.getDesign());
            this.sqlAccessToAWSet.setName(Messages.getString("MultidimensionalDesign.ViewDefinitionsForOracleAW"));
            this.sqlAccessToAWSet.setParent(this);
            this.sqlAccessToAWSet.addSetListener(this);
        }
        return this.sqlAccessToAWSet;
    }

    public SelectionCriteriaSet getSelectionCriteriaSet() {
        if (this.scSet == null) {
            this.scSet = new SelectionCriteriaSet(this);
            this.scSet.setDesign(this.getDesign());
            this.scSet.setName(Messages.getString("MultidimensionalDesign.SelectionCriterias"));
            this.scSet.setParent(this);
            this.scSet.addSetListener(this);
        }
        return this.scSet;
    }

    public Cube createCube() {
        return this.getCubeSet().createCube(null);
    }

    public Dimension createDimension() {
        return this.getDimensionSet().createDimension(null);
    }

    public Hierarchy createHierarchy() {
        return this.getHierarchySet().createHierarchy(null);
    }

    public FactEntitiesJoin createFactEntitiesJoin() {
        return this.getFactEntitiesJoinSet().createFactEntitiesJoin(null);
    }

    public Level createLevel() {
        return this.getLevelSet().createLevel(null);
    }

    public Measure createMeasure() {
        return this.getMeasureSet().createMeasure(null);
    }

    public RollupLink createRollupLink() {
        return this.getRollupLinkSet().createRollupLink(null);
    }

    public Link createLink() {
        return this.getLinkSet().createLink(null);
    }

    public RaggedHLink createRaggedHLink(Level childLevel, Level parentLevel) {
        return this.getRaggedHLinkSet().createRaggedHLink(null, childLevel, parentLevel);
    }

    public RaggedHLink createRaggedHLink() {
        return this.getRaggedHLinkSet().createRaggedHLink(null);
    }

    public Slice createSlice() {
        return this.getSliceSet().createSlice(null);
    }

    public SelectionCriteria createSelectionCriteria() {
        return this.getSelectionCriteriaSet().createSC(null);
    }

    public MeasureFolder createMeasureFolder() {
        return this.getMeasureFolderSet().createMeasureFolder(null);
    }

    public SQLAccessToAW createSQLAccessToAW() {
        return this.getSQLAccessToAWSet().createSQLAccessToAW(null);
    }

    @Override
    public Note createNote() {
        return this.getNoteSet().createNote(null);
    }

    @Override
    public Note recreateNote(String id) {
        return this.getNoteSet().createNote(id);
    }

    @Override
    public ImageObject createImage() {
        ImageObject image = this.getImageObjectSet().createImage(null);
        return image;
    }

    @Override
    public ImageObject recreateImage(String id) {
        return this.getImageObjectSet().createImage(id);
    }

    @Override
    public List getStorableSets() {
        ArrayList<DesignObjectSet> list = new ArrayList<DesignObjectSet>();
        list.add(this.getLevelSet());
        list.add(this.getRaggedHLinkSet());
        list.add(this.getDimensionSet());
        list.add(this.getSliceSet());
        list.add(this.getCubeSet());
        list.add(this.getRollupLinkSet());
        list.add(this.getHierarchySet());
        list.add(this.getMeasureFolderSet());
        list.add(this.getSQLAccessToAWSet());
        return list;
    }

    @Override
    public void sortCollections() {
        this.getCubeSet().sort();
        this.getDimensionSet().sort();
        this.getHierarchySet().sort();
        this.getLevelSet().sort();
        this.getMeasureSet().sort();
        this.getLinkSet().sort();
        this.getRollupLinkSet().sort();
        this.getSliceSet().sort();
        this.getSelectionCriteriaSet().sort();
        this.getMeasureFolderSet().sort();
    }

    @Override
    protected void fireChange(ObjectChangeEvent event) {
    }

    @Override
    public void changed(DesignObjectSet set, SetEvent event) {
        if (event == SetEvent.OBJECT_ADDED) {
            MeasureFolder mf;
            if (set instanceof MeasureFolderSet && (mf = (MeasureFolder)event.getAffected()).getParentFolder() == null) {
                mf.setParent(this.measureFolderCollection);
                this.measureFolderCollection.add(mf);
                mf.addObjectListener(this);
            }
            this.fireAdded(event.getAffected());
        } else if (event == SetEvent.OBJECT_REMOVED) {
            if (set instanceof MeasureFolderSet) {
                MeasureFolder mf = (MeasureFolder)event.getAffected();
                this.measureFolderCollection.remove(mf);
            }
            if (set instanceof CubeSet) {
                Cube cube = (Cube)event.getAffected();
                List measures = cube.getMeasures();
                Iterator it = measures.iterator();
                while (it.hasNext()) {
                    this.getMeasureSet().remove((DesignObject)it.next());
                }
                List slice = cube.getPrecalculatedSlices();
                Iterator sliceIterator = slice.iterator();
                while (sliceIterator.hasNext()) {
                    this.getSliceSet().remove((DesignObject)sliceIterator.next());
                }
            }
            this.fireRemoved(event.getAffected());
        }
    }

    @Override
    public int getNumberOfChildren() {
        if (this.isLoaded()) {
            return 8;
        }
        return 0;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.getCubeSet();
            }
            case 1: {
                return this.getLevelSet();
            }
            case 2: {
                return this.getDimensionSet();
            }
            case 3: {
                return this.getHierarchySet();
            }
            case 4: {
                return this.getMeasureFolderCollection();
            }
            case 5: {
                return this.getRollupLinkSet();
            }
            case 6: {
                return this.getRaggedHLinkSet();
            }
            case 7: {
                return this.getSliceSet();
            }
        }
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.getCubeSet()) {
            return 0;
        }
        if (child == this.getLevelSet()) {
            return 1;
        }
        if (child == this.getDimensionSet()) {
            return 2;
        }
        if (child == this.getHierarchySet()) {
            return 3;
        }
        if (child == this.getMeasureFolderCollection()) {
            return 4;
        }
        if (child == this.getRollupLinkSet()) {
            return 5;
        }
        if (child == this.getRaggedHLinkSet()) {
            return 6;
        }
        if (child == this.getSliceSet()) {
            return 7;
        }
        return -1;
    }

    @Override
    public void doAfterLoad() {
        this.getDesign().setMultidimensionalDesign(this);
        int pers = this.getDesign().getLoadedModelPersistence();
        if (pers != Design.PERS_MODEL_IN_ONE_FILE) {
            this.createFilesMap();
        }
        this.setLoaded(true);
        this.getMainDPVPlaceHolder().setDirty(false);
        this.getMainView().setDirty(false);
        this.getCompactDiagram().setDirty(false);
        this.setDirty(false);
        this.cleraDirtyForSubviews();
        this.setObjectListChanged(false);
        this.checkAndSetIDGenerator();
    }

    @Override
    public void load() {
        this.getDesign().setMultidimensionalDesign(this);
        XMLPersistenceManager pm = this.getDesign().getAppView().getPersistenceManager();
        AbstractXMLReader reader = pm.getDesignPartReader(this);
        if (reader != null) {
            reader.recreateDesign(this.getObjectID(), (DesignPart)this, false);
        }
        this.createFilesMap();
        this.setLoaded(true);
        this.getMainDPVPlaceHolder().setDirty(false);
        this.getMainView().setDirty(false);
        this.getCompactDiagram().setDirty(false);
        this.setDirty(false);
        this.checkAndSetIDGenerator();
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.getType() == 1) {
            if (event.getAffected() instanceof DesignObject) {
                DesignObject object = (DesignObject)event.getAffected();
                this.fireAdded(object);
            }
        } else if (event.getType() == 0 && event.getAffected() instanceof DesignObject) {
            DesignObject object = (DesignObject)event.getAffected();
            this.fireRemoved(object);
        }
    }

    public void processNewLink(Link link) {
        AbstractMDObject source = link.getSourceMDObject();
        AbstractMDObject target = link.getTargetMDObject();
        if (source instanceof Dimension && target instanceof Level) {
            this.makeNewHiearchies((Dimension)source, (Level)target, link);
        } else if (source instanceof Level && target instanceof Level) {
            this.makeAndUpdateHiearchies((Level)source, (Level)target, link);
        }
    }

    private void makeNewHiearchies(Dimension dimension, Level firstLevel, Link link) {
        ArrayList paths = new ArrayList();
        ArrayList resultLinks = new ArrayList();
        this.makePaths(firstLevel, new ArrayList(), new ArrayList(), paths, resultLinks);
        for (int i = 0; i < paths.size(); ++i) {
            List levels = (List)paths.get(i);
            List links = (List)resultLinks.get(i);
            Hierarchy hier = this.createHierarchy();
            hier.setDimension(dimension);
            hier.setLinkToDimension(link);
            for (int j = 0; j < levels.size(); ++j) {
                hier.addLevel((Level)levels.get(j));
                if (j >= links.size()) continue;
                hier.addLink(((Link)links.get(j)).getRollupLink());
            }
            dimension.addHierarchy(hier);
        }
    }

    private void makePaths(Level level, List inputLevels, List inputLinks, List paths, List resultLinks) {
        inputLevels.add(level);
        List links = level.getOutgoingLinks();
        for (Link link : links) {
            if (!(link.getTargetMDObject() instanceof Level)) continue;
            Level nextLevel = (Level)link.getTargetMDObject();
            ArrayList newLevels = new ArrayList();
            ArrayList<Link> newLinks = new ArrayList<Link>();
            newLevels.addAll(inputLevels);
            newLinks.addAll(inputLinks);
            newLinks.add(link);
            this.makePaths(nextLevel, newLevels, newLinks, paths, resultLinks);
        }
        if (links.size() == 0) {
            paths.add(inputLevels);
            resultLinks.add(inputLinks);
        }
    }

    public void removeAndUpdateHierarchies(Link deletedLink, AbstractMDObject source, AbstractMDObject target) {
        block5: {
            Hierarchy hier;
            RollupLink rlink;
            block6: {
                Hierarchy[] hiers = (Hierarchy[])this.getHierarchySet().toArray();
                for (int i = 0; i < hiers.length; ++i) {
                    if (hiers[i].getLinkToDimension() != deletedLink) continue;
                    hiers[i].remove();
                    hiers[i].getDimension().removeHierarchy(hiers[i]);
                }
                rlink = deletedLink.getRollupLink();
                if (!(target instanceof Level) || !(source instanceof Level)) break block5;
                Level targetLevel = (Level)target;
                List list = this.getHierarchiesContaining(targetLevel, rlink);
                List contLevel = this.getHierarchiesContaining((Level)source);
                if (contLevel.size() <= list.size()) break block6;
                for (Hierarchy hier2 : contLevel) {
                    if (list.contains(hier2)) {
                        hier2.remove();
                        hier2.getDimension().removeHierarchy(hier2);
                        continue;
                    }
                    hier2.removePartFromLink(deletedLink);
                }
                break block5;
            }
            List slist = this.getHierarchiesContaining((Level)source, rlink);
            for (int k = 0; k < slist.size(); ++k) {
                hier = (Hierarchy)slist.get(k);
                hier.removePartFromLink(deletedLink);
            }
            slist = this.getHierarchiesContaining((Level)source);
            List diflist = this.getHierarchiesWithDifferentPathTo((Level)source);
            if (diflist.size() >= slist.size()) break block5;
            for (int k = 0; k < slist.size(); ++k) {
                hier = (Hierarchy)slist.get(k);
                if (diflist.contains(hier)) continue;
                hier.remove();
                hier.getDimension().removeHierarchy(hier);
            }
        }
    }

    private void makeAndUpdateHiearchies(Level sourceLevel, Level targetLevel, Link link) {
        ArrayList paths = new ArrayList();
        ArrayList resultLinks = new ArrayList();
        this.makePaths(targetLevel, new ArrayList(), new ArrayList(), paths, resultLinks);
        List hiers = this.getHierarchiesWithDifferentPathTo(sourceLevel);
        Iterator it = hiers.iterator();
        while (it.hasNext()) {
            Hierarchy hier;
            Hierarchy sourceHier = hier = (Hierarchy)it.next();
            if (!hier.isLast(sourceLevel)) {
                hier = sourceHier.clonePartial(sourceLevel);
            }
            if (link.getRollupLink() == null) {
                link.addRollupLink();
            }
            hier.addLink(link.getRollupLink());
            for (int i = 0; i < paths.size(); ++i) {
                if (i > 0) {
                    hier = sourceHier.clonePartial(sourceLevel);
                    hier.addLink(link.getRollupLink());
                }
                List levels = (List)paths.get(i);
                List links = (List)resultLinks.get(i);
                for (int j = 0; j < levels.size(); ++j) {
                    hier.addLevel((Level)levels.get(j));
                    if (j >= links.size()) continue;
                    hier.addLink(((Link)links.get(j)).getRollupLink());
                }
            }
        }
    }

    private List getHierarchiesContaining(Level level, RollupLink link) {
        ArrayList<Hierarchy> list = new ArrayList<Hierarchy>();
        Iterator it = this.getHierarchySet().iterator();
        while (it.hasNext()) {
            Hierarchy hier = (Hierarchy)it.next();
            if (!hier.contains(level) || !hier.contains(link)) continue;
            list.add(hier);
        }
        return list;
    }

    private List getHierarchiesContaining(Level level) {
        ArrayList<Hierarchy> list = new ArrayList<Hierarchy>();
        Iterator it = this.getHierarchySet().iterator();
        while (it.hasNext()) {
            Hierarchy hier = (Hierarchy)it.next();
            if (!hier.contains(level)) continue;
            list.add(hier);
        }
        return list;
    }

    public Hierarchy getHierarchyDefinedByLevels(List list) {
        Iterator it = this.getHierarchySet().iterator();
        while (it.hasNext()) {
            Hierarchy hier = (Hierarchy)it.next();
            if (!hier.isEqualToLevelList(list)) continue;
            return hier;
        }
        return null;
    }

    public Hierarchy getFirstHierarchyDefinedByLinkToDimension(Link link) {
        Iterator it = this.getHierarchySet().iterator();
        while (it.hasNext()) {
            Hierarchy hier = (Hierarchy)it.next();
            if (hier.getLinkToDimension() != link) continue;
            return hier;
        }
        return null;
    }

    private List getHierarchiesWithDifferentPathTo(Level level) {
        ArrayList<Hierarchy> list = new ArrayList<Hierarchy>();
        for (Hierarchy hier : this.getHierarchiesContaining(level)) {
            if (!hier.hasDifferentPathToLevel(level, list)) continue;
            list.add(hier);
        }
        return list;
    }

    public void normalizeHierarchies() {
        Iterator it = this.getDimensionSet().iterator();
        while (it.hasNext()) {
            Dimension dimension = (Dimension)it.next();
            Level level = this.findLowestLevel(dimension);
            if (level == null) continue;
            this.reconnectFirstLevels(dimension, level);
        }
    }

    private Level findLowestLevel(Dimension dimension) {
        Level level;
        Iterator it = dimension.getHierarchies().iterator();
        ContainerObject ent = null;
        while (it.hasNext()) {
            Hierarchy hier = (Hierarchy)it.next();
            level = (Level)hier.getLevels().get(0);
            if (level.getLevelEntity() == null) continue;
            ent = level.getLevelEntity();
            break;
        }
        if (ent != null) {
            for (Hierarchy hier : dimension.getHierarchies()) {
                level = (Level)hier.getLevels().get(0);
                if (!(ent instanceof ContainerWithKeyObject) || ((ContainerWithKeyObject)ent).getPK() == null || !level.getLevelKey().equals(((ContainerWithKeyObject)ent).getPK().getElementsCollection())) continue;
                return level;
            }
        }
        return null;
    }

    private void reconnectFirstLevels(Dimension dimension, Level lowestLevel) {
        int count = dimension.getHierarchies().size();
        Object[] hiers = dimension.getHierarchies().toArray();
        for (int i = count - 1; i > -1; --i) {
            int last;
            Link link;
            Hierarchy hier = (Hierarchy)hiers[i];
            String hname = hier.getName();
            Level firstLevel = (Level)hier.getLevels().get(0);
            if (firstLevel == lowestLevel || (link = dimension.getFirstLinkToTarget(firstLevel)) == null) continue;
            link.remove();
            AbstractMDTV tv1 = (AbstractMDTV)lowestLevel.getTopView();
            AbstractMDTV tv2 = (AbstractMDTV)firstLevel.getTopView();
            if (tv1 != null && tv2 != null) {
                link = this.createLink();
                link.setSourceTV(tv1);
                link.setTargetTV(tv2);
                ((TVLink)link.getTopView()).addConnection();
            }
            if ((last = dimension.getHierarchies().size() - 1) <= -1) continue;
            Hierarchy lastHier = (Hierarchy)dimension.getHierarchies().getElement(last);
            lastHier.setName(hname);
        }
    }

    public void engineerToOracleSD() {
        OracleModelSelector oms;
        boolean res;
        RelationalDesign phdes = null;
        StorageDesignOracle sdOra = null;
        if ((phdes == null || sdOra == null) && (res = (oms = new OracleModelSelector(this.getAppView(), this)).showDialog())) {
            phdes = oms.getPhysicalDesign();
            sdOra = (StorageDesignOracle)oms.getStorageDesign();
        }
        if (phdes != null && sdOra != null) {
            EngineerToOracle eng = new EngineerToOracle(this, phdes, sdOra);
            eng.engineer();
        }
    }

    public void engineerFromOracleSD() {
        FromOracleModelSelector oms;
        boolean res;
        RelationalDesign phdes = null;
        StorageDesignOracle sdOra = null;
        int minDimensions = 3;
        if ((phdes == null || sdOra == null) && (res = (oms = new FromOracleModelSelector(this.getAppView(), this)).showDialog())) {
            phdes = oms.getPhysicalDesign();
            sdOra = (StorageDesignOracle)oms.getStorageDesign();
            minDimensions = oms.getMinDimensions();
            if (phdes != null && sdOra != null) {
                EngineerFromOracle eng = new EngineerFromOracle(this, phdes, sdOra, minDimensions, oms.isUseFactTablesOnly(), oms.getSearchMethod());
                eng.engineer();
                ((DPVMultidimensional)this.getMainView()).rearrangeDiagram(true);
                this.getCompactDiagram().generateDiagram();
            }
        }
    }

    public void clearUnusedObjects() {
        int i;
        for (i = this.getSliceSet().size() - 1; i >= 0; --i) {
            Slice slice = (Slice)this.getSliceSet().getElement(i);
            if (slice.getCube() != null) continue;
            slice.remove();
        }
        for (i = this.getMeasureSet().size() - 1; i >= 0; --i) {
            Measure measure = (Measure)this.getMeasureSet().getElement(i);
            if (measure.getCube() != null) continue;
            measure.remove();
        }
        this.removeInvalidLinks();
    }

    public Cube getCubeOnEntity(ContainerObject entity) {
        Iterator it = this.getCubeSet().iterator();
        while (it.hasNext()) {
            Cube cube = (Cube)it.next();
            if (cube.getFactEntity() != entity) continue;
            return cube;
        }
        return null;
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
        MeasureFolder mf;
        if (object instanceof MeasureFolder && (mf = (MeasureFolder)object).getParentFolder() != null) {
            this.measureFolderCollection.remove(mf);
        }
    }

    @Override
    public void objectAdded(DesignPart designPart, DesignObject object) {
    }

    @Override
    public void objectRemoved(DesignPart designPart, DesignObject object) {
        if (object instanceof ContainedObject) {
            AbstractMDObject link;
            ContainedObject dobj = (ContainedObject)object;
            Iterator it = this.getLevelSet().iterator();
            while (it.hasNext()) {
                Level level = (Level)it.next();
                level.attributeIsDeleted(dobj);
            }
            it = this.getCubeSet().iterator();
            while (it.hasNext()) {
                Cube cube = (Cube)it.next();
                cube.attributeIsDeleted(dobj);
            }
            it = this.getLinkSet().iterator();
            while (it.hasNext()) {
                link = (Link)it.next();
                ((Link)link).attributeIsDeleted(dobj);
            }
            it = this.getRaggedHLinkSet().iterator();
            while (it.hasNext()) {
                link = (RaggedHLink)it.next();
                ((RaggedHLink)link).attributeIsDeleted(dobj);
            }
            this.getMainView().getWorkSpace().repaint();
        } else if (object instanceof ContainerObject && !(object instanceof KeyObject)) {
            ContainerObject dobj = (ContainerObject)object;
            Iterator it = this.getLevelSet().iterator();
            while (it.hasNext()) {
                Level level = (Level)it.next();
                level.entityIsDeleted(dobj);
            }
            it = this.getCubeSet().iterator();
            while (it.hasNext()) {
                Cube cube = (Cube)it.next();
                cube.entityIsDeleted(dobj);
            }
        }
        this.getMainView().getWorkSpace().repaint();
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            MultidimensionalModelPropertiesDialog dialog = new MultidimensionalModelPropertiesDialog(this.getDesign().getAppView(), this);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    @Override
    protected List createTypeOrder() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("SelectionCriteria");
        list.add("Level");
        list.add("RaggedHLink");
        list.add("Dimension");
        list.add("Measure");
        list.add("Slice");
        list.add("FactEntitiesJoin");
        list.add("Cube");
        list.add("RollupLink");
        list.add("Link");
        list.add("Hierarchy");
        list.add("MeasureFolder");
        list.add("SQLAccessToAW");
        list.add("Note");
        list.add("MainView");
        list.add("SubView");
        return list;
    }

    @Override
    public String getStoragePath() {
        String designPath = this.getDesign().getStoragePath();
        if (designPath != null && designPath.length() > 0) {
            try {
                return new File(designPath, "multidimensional" + File.separatorChar + this.getObjectID()).getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getStorageName() {
        String designPath = this.getDesign().getStoragePath();
        if (designPath != null && designPath.length() > 0) {
            try {
                return new File(designPath, "multidimensional" + File.separatorChar + this.getObjectID() + ".xml").getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public StorableObject createObject(String objectType, String objectID, String name) {
        DesignObject object = null;
        if ("SelectionCriteria".equalsIgnoreCase(objectType)) {
            object = this.getSelectionCriteriaSet().createSC(objectID);
        } else if ("Level".equalsIgnoreCase(objectType)) {
            object = this.getLevelSet().createLevel(objectID);
        } else if ("RollupLink".equalsIgnoreCase(objectType)) {
            object = this.getRollupLinkSet().createRollupLink(objectID);
        } else if ("RaggedHLink".equalsIgnoreCase(objectType)) {
            object = this.getRaggedHLinkSet().createRaggedHLink(objectID);
        } else if ("Dimension".equalsIgnoreCase(objectType)) {
            object = this.getDimensionSet().createDimension(objectID);
        } else if ("Measure".equalsIgnoreCase(objectType)) {
            object = this.getMeasureSet().createMeasure(objectID);
        } else if ("Slice".equalsIgnoreCase(objectType)) {
            object = this.getSliceSet().createSlice(objectID);
        } else if ("FactEntitiesJoin".equalsIgnoreCase(objectType)) {
            object = this.getFactEntitiesJoinSet().createFactEntitiesJoin(objectID);
        } else if ("Cube".equalsIgnoreCase(objectType)) {
            object = this.getCubeSet().createCube(objectID);
        } else if ("Link".equalsIgnoreCase(objectType)) {
            object = this.getLinkSet().createLink(objectID);
        } else if ("Hierarchy".equalsIgnoreCase(objectType)) {
            object = this.getHierarchySet().createHierarchy(objectID);
        } else if ("MeasureFolder".equalsIgnoreCase(objectType)) {
            object = this.getMeasureFolderSet().createMeasureFolder(objectID);
        } else if ("SQLAccessToAW".equalsIgnoreCase(objectType)) {
            object = this.getSQLAccessToAWSet().createSQLAccessToAW(objectID);
        } else if ("Note".equalsIgnoreCase(objectType)) {
            object = this.getNoteSet().createNote(objectID);
        } else if ("Image".equalsIgnoreCase(objectType)) {
            object = this.getImageObjectSet().createImage(objectID);
        }
        if (object != null && name != null && name.length() > 0) {
            object.setName(name);
        }
        return object;
    }

    @Override
    public Map getFolderToTypeMap() {
        if (this.f2tMap == null) {
            this.f2tMap = new LinkedHashMap();
            this.f2tMap.put("level", "Level");
            this.f2tMap.put("rhlink", "RaggedHLink");
            this.f2tMap.put("dimension", "Dimension");
            this.f2tMap.put("slice", "Slice");
            this.f2tMap.put("cube", "Cube");
            this.f2tMap.put("rolluplink", "RollupLink");
            this.f2tMap.put("hierarchy", "Hierarchy");
            this.f2tMap.put("measurefolder", "MeasureFolder");
            this.f2tMap.put("sqltoaw", "SQLAccessToAW");
            this.f2tMap.put("note", "Note");
            this.f2tMap.put("image", "Image");
        }
        return this.f2tMap;
    }

    public static void initObjectDetails(Design design, File file, String path, StorableObjectStatusHelper sosHelper, String storableObjectID) {
        Map<String, SVNObjectHelper> svnOHMap = design.getSVNObjectHelperMap();
        sosHelper.treePath.add(new TreePathHelper(Design.getMultidimensionalDesignSetName(), file.getParentFile().getParentFile(), MultidimensionalDesignSet.class));
        if (sosHelper.designPart != null) {
            sosHelper.treePath.add(new TreePathHelper(sosHelper.designPart.getName(), file.getParentFile(), MultidimensionalDesign.class));
        } else {
            SVNObjectHelper parentSVNOH;
            SVNObjectHelper svnOH = svnOHMap.get(storableObjectID);
            if (svnOH != null && (parentSVNOH = svnOHMap.get(svnOH.parentID)) != null) {
                sosHelper.treePath.add(new TreePathHelper(parentSVNOH.propName, new File(parentSVNOH.fileName), MultidimensionalDesign.class));
            }
        }
        if ("selcriteria".equalsIgnoreCase(path)) {
            sosHelper.objectClass = SelectionCriteria.class;
            sosHelper.objectType = "SelectionCriteria";
            sosHelper.treePath.add(new TreePathHelper(SEL_CRITERIA_SET_NAME, file.getParentFile(), SelectionCriteriaSet.class));
            if (sosHelper.designPart != null) {
                sosHelper.objectSet = ((MultidimensionalDesign)sosHelper.designPart).getSelectionCriteriaSet();
                sosHelper.storableObject = ((MultidimensionalDesign)sosHelper.designPart).getSelectionCriteriaSet().getObjectByID(storableObjectID);
            }
        } else if ("level".equalsIgnoreCase(path)) {
            sosHelper.objectClass = Level.class;
            sosHelper.objectType = "Level";
            sosHelper.treePath.add(new TreePathHelper(LEVEL_SET_NAME, file.getParentFile(), LevelSet.class));
            if (sosHelper.designPart != null) {
                sosHelper.objectSet = ((MultidimensionalDesign)sosHelper.designPart).getLevelSet();
                sosHelper.storableObject = ((MultidimensionalDesign)sosHelper.designPart).getLevelSet().getObjectByID(storableObjectID);
            }
        } else if ("rolluplink".equalsIgnoreCase(path)) {
            sosHelper.objectClass = RollupLink.class;
            sosHelper.objectType = "RollupLink";
            sosHelper.treePath.add(new TreePathHelper(ROLLUPLINK_SET_NAME, file.getParentFile(), RollupLinkSet.class));
            if (sosHelper.designPart != null) {
                sosHelper.objectSet = ((MultidimensionalDesign)sosHelper.designPart).getRollupLinkSet();
                sosHelper.storableObject = ((MultidimensionalDesign)sosHelper.designPart).getRollupLinkSet().getObjectByID(storableObjectID);
            }
        } else if ("rhlink".equalsIgnoreCase(path)) {
            sosHelper.objectClass = RaggedHLink.class;
            sosHelper.objectType = "RaggedHLink";
            sosHelper.treePath.add(new TreePathHelper(RAGGEDHLINK_SET_NAME, file.getParentFile(), RaggedHLinkSet.class));
            if (sosHelper.designPart != null) {
                sosHelper.objectSet = ((MultidimensionalDesign)sosHelper.designPart).getRaggedHLinkSet();
                sosHelper.storableObject = ((MultidimensionalDesign)sosHelper.designPart).getRaggedHLinkSet().getObjectByID(storableObjectID);
            }
        } else if ("dimension".equalsIgnoreCase(path)) {
            sosHelper.objectClass = Dimension.class;
            sosHelper.objectType = "Dimension";
            sosHelper.treePath.add(new TreePathHelper(DIMENSION_SET_NAME, file.getParentFile(), DimensionSet.class));
            if (sosHelper.designPart != null) {
                sosHelper.objectSet = ((MultidimensionalDesign)sosHelper.designPart).getDimensionSet();
                sosHelper.storableObject = ((MultidimensionalDesign)sosHelper.designPart).getDimensionSet().getObjectByID(storableObjectID);
            }
        } else if ("measure".equalsIgnoreCase(path)) {
            sosHelper.objectClass = Measure.class;
            sosHelper.objectType = "Measure";
            sosHelper.treePath.add(new TreePathHelper(MEASURE_SET_NAME, file.getParentFile(), MeasureSet.class));
            if (sosHelper.designPart != null) {
                sosHelper.objectSet = ((MultidimensionalDesign)sosHelper.designPart).getMeasureSet();
                sosHelper.storableObject = ((MultidimensionalDesign)sosHelper.designPart).getMeasureSet().getObjectByID(storableObjectID);
            }
        } else if ("slice".equalsIgnoreCase(path)) {
            sosHelper.objectClass = Slice.class;
            sosHelper.objectType = "Slice";
            sosHelper.treePath.add(new TreePathHelper(SLICE_SET_NAME, file.getParentFile(), SliceSet.class));
            if (sosHelper.designPart != null) {
                sosHelper.objectSet = ((MultidimensionalDesign)sosHelper.designPart).getSliceSet();
                sosHelper.storableObject = ((MultidimensionalDesign)sosHelper.designPart).getSliceSet().getObjectByID(storableObjectID);
            }
        } else if ("fejoins".equalsIgnoreCase(path)) {
            sosHelper.objectClass = FactEntitiesJoin.class;
            sosHelper.objectType = "FactEntitiesJoin";
            sosHelper.treePath.add(new TreePathHelper(FE_JOINS_SET_NAME, file.getParentFile(), FactEntitiesJoinSet.class));
            if (sosHelper.designPart != null) {
                sosHelper.objectSet = ((MultidimensionalDesign)sosHelper.designPart).getFactEntitiesJoinSet();
                sosHelper.storableObject = ((MultidimensionalDesign)sosHelper.designPart).getFactEntitiesJoinSet().getObjectByID(storableObjectID);
            }
        } else if ("cube".equalsIgnoreCase(path)) {
            sosHelper.objectClass = Cube.class;
            sosHelper.objectType = "Cube";
            sosHelper.treePath.add(new TreePathHelper(CUBE_SET_NAME, file.getParentFile(), CubeSet.class));
            if (sosHelper.designPart != null) {
                sosHelper.objectSet = ((MultidimensionalDesign)sosHelper.designPart).getCubeSet();
                sosHelper.storableObject = ((MultidimensionalDesign)sosHelper.designPart).getCubeSet().getObjectByID(storableObjectID);
            }
        } else if ("link".equalsIgnoreCase(path)) {
            sosHelper.objectClass = Link.class;
            sosHelper.objectType = "Link";
            sosHelper.treePath.add(new TreePathHelper(LINK_SET_NAME, file.getParentFile(), LinkSet.class));
            if (sosHelper.designPart != null) {
                sosHelper.objectSet = ((MultidimensionalDesign)sosHelper.designPart).getLinkSet();
                sosHelper.storableObject = ((MultidimensionalDesign)sosHelper.designPart).getLinkSet().getObjectByID(storableObjectID);
            }
        } else if ("hierarchy".equalsIgnoreCase(path)) {
            sosHelper.objectClass = Hierarchy.class;
            sosHelper.objectType = "Hierarchy";
            sosHelper.treePath.add(new TreePathHelper(HIERARCHY_SET_NAME, file.getParentFile(), HierarchySet.class));
            if (sosHelper.designPart != null) {
                sosHelper.objectSet = ((MultidimensionalDesign)sosHelper.designPart).getHierarchySet();
                sosHelper.storableObject = ((MultidimensionalDesign)sosHelper.designPart).getHierarchySet().getObjectByID(storableObjectID);
            }
        } else if ("measurefolder".equalsIgnoreCase(path)) {
            sosHelper.objectClass = MeasureFolder.class;
            sosHelper.objectType = "MeasureFolder";
            sosHelper.treePath.add(new TreePathHelper(MEASUREFOLDER_SET_NAME, file.getParentFile(), MeasureFolderSet.class));
            if (sosHelper.designPart != null) {
                sosHelper.objectSet = ((MultidimensionalDesign)sosHelper.designPart).getMeasureFolderSet();
                sosHelper.storableObject = ((MultidimensionalDesign)sosHelper.designPart).getMeasureFolderSet().getObjectByID(storableObjectID);
            }
        } else if ("sqltoaw".equalsIgnoreCase(path)) {
            sosHelper.objectClass = SQLAccessToAW.class;
            sosHelper.objectType = "SQLAccessToAW";
            sosHelper.treePath.add(new TreePathHelper(SQLTOAW_SET_NAME, file.getParentFile(), SQLAccessToAWSet.class));
            if (sosHelper.designPart != null) {
                sosHelper.objectSet = ((MultidimensionalDesign)sosHelper.designPart).getSQLAccessToAWSet();
                sosHelper.storableObject = ((MultidimensionalDesign)sosHelper.designPart).getSQLAccessToAWSet().getObjectByID(storableObjectID);
            }
        } else if ("note".equalsIgnoreCase(path)) {
            sosHelper.objectClass = Note.class;
            sosHelper.objectType = "Note";
            sosHelper.treePath.add(new TreePathHelper(NOTE_SET_NAME, file.getParentFile(), NoteSet.class));
            if (sosHelper.designPart != null) {
                sosHelper.objectSet = ((MultidimensionalDesign)sosHelper.designPart).getNoteSet();
                sosHelper.storableObject = ((MultidimensionalDesign)sosHelper.designPart).getNoteSet().getObjectByID(storableObjectID);
            }
        } else if ("subviews".equalsIgnoreCase(path)) {
            sosHelper.objectClass = DPVMultidimensional.class;
            sosHelper.treePath.add(new TreePathHelper(DIAGRAM_SET_NAME, file.getParentFile(), DPVMultidimensional.class));
            if (sosHelper.designPart != null) {
                MultidimensionalDesign model = (MultidimensionalDesign)sosHelper.designPart;
                sosHelper.storableObject = model.getMainView().getDPVId().equals(storableObjectID) ? model.getMainView() : model.getSubViewByID(storableObjectID);
            }
        }
    }

    public void removeInvalidLinks() {
        Object[] links = this.getRollupLinkSet().toArray();
        for (int i = 0; i < links.length; ++i) {
            RollupLink link = (RollupLink)links[i];
            if (link.getChildLevel() == null && link.getParentLevel() == null) {
                link.remove();
                continue;
            }
            if (link.getLink() != null) continue;
            link.remove();
        }
    }

    @Override
    public void doAfterExternalLoad() {
        this.doAfterLoad();
        if (this.getMainView() != null) {
            this.getMainView().getWorkSpace().updateSettings();
        }
        this.clearUnusedObjects();
        this.sortCollections();
    }

    @Override
    public List<Object> getObjectsWithMeasurements() {
        ArrayList<Object> objects = new ArrayList<Object>();
        Iterator it = this.getCubeSet().iterator();
        while (it.hasNext()) {
            Cube cube = (Cube)it.next();
            if (cube.getMeasurements().size() <= 0) continue;
            objects.add(cube);
        }
        it = this.getDimensionSet().iterator();
        while (it.hasNext()) {
            Dimension dimension = (Dimension)it.next();
            if (dimension.getMeasurements().size() <= 0) continue;
            objects.add(dimension);
        }
        it = this.getHierarchySet().iterator();
        while (it.hasNext()) {
            Hierarchy hierarchy = (Hierarchy)it.next();
            if (hierarchy.getMeasurements().size() <= 0) continue;
            objects.add(hierarchy);
        }
        it = this.getLevelSet().iterator();
        while (it.hasNext()) {
            Level level = (Level)it.next();
            if (level.getMeasurements().size() <= 0) continue;
            objects.add(level);
        }
        it = this.getLinkSet().iterator();
        while (it.hasNext()) {
            Link link = (Link)it.next();
            if (link.getMeasurements().size() <= 0) continue;
            objects.add(link);
        }
        it = this.getRaggedHLinkSet().iterator();
        while (it.hasNext()) {
            RaggedHLink raggedHLink = (RaggedHLink)it.next();
            if (raggedHLink.getMeasurements().size() <= 0) continue;
            objects.add(raggedHLink);
        }
        it = this.getRollupLinkSet().iterator();
        while (it.hasNext()) {
            RollupLink rollupLink = (RollupLink)it.next();
            if (rollupLink.getMeasurements().size() <= 0) continue;
            objects.add(rollupLink);
        }
        it = this.getSliceSet().iterator();
        while (it.hasNext()) {
            Slice slice = (Slice)it.next();
            if (slice.getMeasurements().size() <= 0) continue;
            objects.add(slice);
        }
        it = this.getSQLAccessToAWSet().iterator();
        while (it.hasNext()) {
            SQLAccessToAW sqlAccessToAW = (SQLAccessToAW)it.next();
            if (sqlAccessToAW.getMeasurements().size() <= 0) continue;
            objects.add(sqlAccessToAW);
        }
        it = this.getNoteSet().iterator();
        while (it.hasNext()) {
            Note note = (Note)it.next();
            if (note.getMeasurements().size() <= 0) continue;
            objects.add(note);
        }
        it = this.getSelectionCriteriaSet().iterator();
        while (it.hasNext()) {
            SelectionCriteria selectionCriteria = (SelectionCriteria)it.next();
            if (selectionCriteria.getMeasurements().size() <= 0) continue;
            objects.add(selectionCriteria);
        }
        it = this.getFactEntitiesJoinSet().iterator();
        while (it.hasNext()) {
            FactEntitiesJoin factEntitiesJoin = (FactEntitiesJoin)it.next();
            if (factEntitiesJoin.getMeasurements().size() <= 0) continue;
            objects.add(factEntitiesJoin);
        }
        it = this.getMeasureFolderSet().iterator();
        while (it.hasNext()) {
            MeasureFolder measureFolder = (MeasureFolder)it.next();
            if (measureFolder.getMeasurements().size() <= 0) continue;
            objects.add(measureFolder);
        }
        return objects;
    }

    @Override
    public ArrayList<SearchDockable> getAllSearchDockables() {
        if (this.allSearchDockables == null) {
            this.allSearchDockables = new ArrayList();
        }
        return this.allSearchDockables;
    }

    @Override
    public void addSearchDockable(SearchDockable sd) {
        this.getAllSearchDockables().add(sd);
    }

    @Override
    public SearchDockable getLastNonPinnedSearchDockable() {
        SearchDockable lastOne = null;
        int currentSeq = 0;
        for (SearchDockable sd : this.getAllSearchDockables()) {
            if (((SearchPanel)sd.getGUI()).isPinned() || sd.getViewSequence() < currentSeq) continue;
            lastOne = sd;
        }
        return lastOne;
    }

    @Override
    public int getSearchDockableIdSequence() {
        int currentSeq = 0;
        for (SearchDockable sd : this.getAllSearchDockables()) {
            if (sd.getViewSequence() <= currentSeq) continue;
            currentSeq = sd.getViewSequence();
        }
        return currentSeq + 1;
    }

    @Override
    public void closeAllSearchDockables() {
        for (SearchDockable sd : this.getAllSearchDockables()) {
            sd.closeView(sd);
        }
        this.getAllSearchDockables().clear();
    }

    @Override
    public List getSearchableSets() {
        ArrayList<SearchSet> sets = new ArrayList<SearchSet>();
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(Cube.class), Cube.class, this, this.getCubeSet()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(Level.class), Level.class, this, this.getLevelSet()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(Dimension.class), Dimension.class, this, this.getDimensionSet()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(Hierarchy.class), Hierarchy.class, this, this.getHierarchySet()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(RollupLink.class), RollupLink.class, this, this.getRollupLinkSet()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(Slice.class), Slice.class, this, this.getSliceSet()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(Measure.class), Measure.class, this, this.getMeasureSet()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(MeasureFolder.class), MeasureFolder.class, this, this.getMeasureFolderSet()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(RaggedHLink.class), RaggedHLink.class, this, this.getRaggedHLinkSet()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(SelectionCriteria.class), SelectionCriteria.class, this, this.getSelectionCriteriaSet()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(SQLAccessToAW.class), SQLAccessToAW.class, this, this.getSQLAccessToAWSet()));
        return sets;
    }

    public void fixLabels() {
        Iterator it = this.getLinkSet().iterator();
        while (it.hasNext()) {
            Link link = (Link)it.next();
            for (TVLink tv : link.getAllViews()) {
                Label label = tv.getLabel(1);
                RollupLink rl = link.getRollupLink();
                if (label == null || rl == null || !rl.isRolePlaying()) continue;
                label.setText(rl.getName());
                tv.displayLabels();
            }
        }
    }

    public DesignPart getBoundModel() {
        return this.boundedModel;
    }

    public void setBoundModel(DesignPart boundedModel) {
        if (boundedModel != this.boundedModel && !this.isEmpty()) {
            throw new RuntimeException("Dimensional model is not empty, cannot change the bound model");
        }
        if (this.boundedModel != null) {
            this.boundedModel.removeDesignPartListener(this);
        }
        this.boundedModel = boundedModel;
        if (this.boundedModel != null) {
            this.boundedModel.addDesignPartListener(this);
        }
    }

    public List getEntities() {
        ArrayList list = new ArrayList();
        if (this.boundedModel != null) {
            if (this.boundedModel instanceof LogicalDesign) {
                ((LogicalDesign)this.boundedModel).getEntitySet().addAllElementsTo(list);
            } else if (this.boundedModel instanceof RelationalDesign) {
                ((RelationalDesign)this.boundedModel).getTableSet().addAllElementsTo(list);
            }
        }
        return list;
    }

    public List getViews() {
        ArrayList list = new ArrayList();
        if (this.boundedModel != null) {
            if (this.boundedModel instanceof LogicalDesign) {
                ((LogicalDesign)this.boundedModel).getEntityViewSet().addAllElementsTo(list);
            } else if (this.boundedModel instanceof RelationalDesign) {
                ((RelationalDesign)this.boundedModel).getTableViewSet().addAllElementsTo(list);
            }
        }
        return list;
    }

    public List getAttributes() {
        ArrayList list = new ArrayList();
        if (this.boundedModel != null) {
            if (this.boundedModel instanceof LogicalDesign) {
                ((LogicalDesign)this.boundedModel).getAttributeSet().addAllElementsTo(list);
            } else if (this.boundedModel instanceof RelationalDesign) {
                ((RelationalDesign)this.boundedModel).getColumnSet().addAllElementsTo(list);
            }
        }
        return list;
    }

    public List getAttributeViews() {
        ArrayList list = new ArrayList();
        if (this.boundedModel != null) {
            if (this.boundedModel instanceof LogicalDesign) {
                ((LogicalDesign)this.boundedModel).getAttributeViewSet().addAllElementsTo(list);
            } else if (this.boundedModel instanceof RelationalDesign) {
                ((RelationalDesign)this.boundedModel).getColumnViewSet().addAllElementsTo(list);
            }
        }
        return list;
    }

    public List getAllColntainers() {
        ArrayList list = new ArrayList();
        if (this.boundedModel != null) {
            if (this.boundedModel instanceof LogicalDesign) {
                ((LogicalDesign)this.boundedModel).getEntitySet().addAllElementsTo(list);
                ((LogicalDesign)this.boundedModel).getEntityViewSet().addAllElementsTo(list);
            } else if (this.boundedModel instanceof RelationalDesign) {
                ((RelationalDesign)this.boundedModel).getTableSet().addAllElementsTo(list);
                ((RelationalDesign)this.boundedModel).getTableViewSet().addAllElementsTo(list);
            }
        }
        return list;
    }

    public List getAllContained() {
        ArrayList list = new ArrayList();
        if (this.boundedModel != null) {
            if (this.boundedModel instanceof LogicalDesign) {
                ((LogicalDesign)this.boundedModel).getAttributeSet().addAllElementsTo(list);
                ((LogicalDesign)this.boundedModel).getAttributeViewSet().addAllElementsTo(list);
            } else if (this.boundedModel instanceof RelationalDesign) {
                ((RelationalDesign)this.boundedModel).getColumnSet().addAllElementsTo(list);
                ((RelationalDesign)this.boundedModel).getColumnViewSet().addAllElementsTo(list);
            }
        }
        return list;
    }

    public DesignObjectSet getEntitySet() {
        if (this.boundedModel != null) {
            if (this.boundedModel instanceof LogicalDesign) {
                return ((LogicalDesign)this.boundedModel).getEntitySet();
            }
            if (this.boundedModel instanceof RelationalDesign) {
                ((RelationalDesign)this.boundedModel).getTableSet();
            }
        }
        return null;
    }

    @Override
    public Object translateIdToObject(String propertyName, String id) {
        if ("boundModel".equalsIgnoreCase(propertyName)) {
            if (this.getDesign().getLogicalDesign().getObjectID().equals(id)) {
                return this.getDesign().getLogicalDesign();
            }
            return this.getDesign().getRelationalDesigns().getObjectByID(id);
        }
        return super.translateIdToObject(propertyName, id);
    }
}

