/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.multidimensional;

import java.awt.Dialog;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.FactEntitiesJoin;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.model.design.multidimensional.Slice;
import oracle.dbtools.crest.swingui.editor.multidimensional.CubePropertiesDialogEx;

public class Cube
extends AbstractMDObject
implements EditableFonts {
    private ContainerObject factEntity;
    private final List measures = new ArrayList();
    private boolean virtual = true;
    private boolean partitioned = true;
    private String partitioningDescription = "";
    private Slice fullCubeMaterialization;
    private final List precalculatedSlices = new ArrayList();
    private final List factEntities = new ArrayList();
    private final List joins = new ArrayList();
    private Dimension partDimension;
    private Hierarchy partHierarchy;
    private Level partLevel;
    private final List dimensionsOrderList = new ArrayList();
    private List<RollupLink> dimensioinsUsage;
    private boolean useGlobalComposites;
    private boolean compressedComposites;
    private String hierarchyID;
    private final List sqlDefinitions = new ArrayList();
    private List editableFonts = new ArrayList();
    public static final String TYPE_NAME = "Cube";

    public Cube(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            CubePropertiesDialogEx dialog = new CubePropertiesDialogEx(this.getDesign().getAppView(), this);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    @Override
    public void showPropertyDialog(Dialog owner) {
        if (!this.isDialogVisible()) {
            CubePropertiesDialogEx dialog = owner == null ? new CubePropertiesDialogEx(this.getDesign().getAppView(), this) : new CubePropertiesDialogEx(owner, this.getDesign().getAppView(), this);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    public ContainerObject getFactEntity() {
        if (this.factEntity != null && this.factEntities.contains(this.factEntity)) {
            return this.factEntity;
        }
        if (this.factEntities.size() > 0) {
            return (ContainerObject)this.factEntities.get(0);
        }
        return null;
    }

    public void setFactEntity(ContainerObject factEntity) {
        this.factEntity = factEntity;
        if (factEntity != null) {
            if (factEntity instanceof ContainerWithKeyObject) {
                ((ContainerWithKeyObject)factEntity).setTypeID("1");
            }
            factEntity.setDirty(true);
            if (!this.factEntities.contains(factEntity)) {
                this.factEntities.add(factEntity);
            }
        }
    }

    public Slice getFullCubeMaterialization() {
        return this.fullCubeMaterialization;
    }

    public void setFullCubeMaterialization(Slice fullCubeMaterialization) {
        this.fullCubeMaterialization = fullCubeMaterialization;
    }

    public boolean isPartitioned() {
        return this.partitioned;
    }

    public void setPartitioned(boolean partitioned) {
        this.partitioned = partitioned;
    }

    public String getPartitioningDescription() {
        return this.partitioningDescription;
    }

    public void setPartitioningDescription(String partitioningDescription) {
        this.partitioningDescription = partitioningDescription;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public void setVirtual(boolean virtual) {
        this.virtual = virtual;
    }

    public List getDimensions() {
        if (this.dimensionsOrderList.size() > 0) {
            for (int i = 0; i < this.dimensionsOrderList.size(); ++i) {
                Dimension dim = (Dimension)this.dimensionsOrderList.get(i);
                this.moveToIndex(dim, i);
            }
            this.dimensionsOrderList.clear();
        }
        ArrayList<Dimension> list = new ArrayList<Dimension>();
        Link.Connection[] links = this.getAllLinks();
        for (int i = 0; i < links.length; ++i) {
            Dimension dim;
            Link.Connection connection = links[i];
            if (!(connection.getLink().getTargetMDObject() instanceof Dimension) || list.indexOf(dim = (Dimension)connection.getLink().getTargetMDObject()) != -1) continue;
            list.add(dim);
        }
        return list;
    }

    public void addDimension(Dimension dim) {
        this.dimensionsOrderList.add(dim);
    }

    public void removeDimension(Dimension dim) {
        this.dimensionsOrderList.remove(dim);
    }

    public void moveDimensionToIndex(Dimension dim, int index) {
        if (this.dimensionsOrderList.contains(dim) && this.dimensionsOrderList.size() > index && index >= 0) {
            this.dimensionsOrderList.remove(dim);
            this.dimensionsOrderList.add(index, dim);
        }
    }

    public RollupLink getRollUpLink(Dimension dim) {
        Link.Connection[] links = this.getAllLinks();
        for (int i = 0; i < links.length; ++i) {
            Link.Connection connection = links[i];
            if (!(connection.getLink().getTargetMDObject() instanceof Dimension) || connection.getLink().getTargetMDObject() != dim) continue;
            return connection.getLink().getRollupLink();
        }
        return null;
    }

    public List<RollupLink> getRollUpLinks(Dimension dim) {
        ArrayList<RollupLink> list = new ArrayList<RollupLink>();
        Link.Connection[] links = this.getAllLinks();
        for (int i = 0; i < links.length; ++i) {
            Link.Connection connection = links[i];
            if (!(connection.getLink().getTargetMDObject() instanceof Dimension) || connection.getLink().getTargetMDObject() != dim) continue;
            list.add(connection.getLink().getRollupLink());
        }
        return list;
    }

    public void moveToIndex(Dimension dim, int index) {
        Link.Connection[] links = this.getAllLinks();
        for (int i = 0; i < links.length; ++i) {
            Link.Connection connection = links[i];
            if (!(connection.getLink().getTargetMDObject() instanceof Dimension) || connection.getLink().getTargetMDObject() != dim) continue;
            if (index < links.length) {
                this.moveToIndex(connection, index);
                continue;
            }
            this.moveToIndex(connection, links.length - 1);
        }
    }

    public List getMeasures() {
        return this.measures;
    }

    public Measure getMeasureByName(String name) {
        for (Measure meas : this.measures) {
            if (!meas.getName().equalsIgnoreCase(name)) continue;
            return meas;
        }
        return null;
    }

    public void addMeasure(Measure measure) {
        this.measures.add(measure);
        measure.setCube(this);
    }

    public void removeMeasure(Measure measure) {
        this.measures.remove(measure);
        measure.setCube(null);
        measure.remove();
    }

    public List getPrecalculatedSlices() {
        return this.precalculatedSlices;
    }

    public void addPrecalculatedSlice(Slice slice) {
        slice.setCube(this);
        this.precalculatedSlices.add(slice);
    }

    public void removePrecalculatedSlice(Slice slice) {
        this.precalculatedSlices.remove(slice);
        slice.remove();
    }

    public List getAllJoinAttributes() {
        ArrayList list = new ArrayList();
        List links = this.getOutgoingLinks();
        for (Link link : links) {
            list.addAll(link.getRollupLink().getChildToParentAttributes());
        }
        return list;
    }

    public Measure getMeasureForAttribute(ContainedObject attribute) {
        for (Measure measure : this.getMeasures()) {
            if (measure.getMeasureFact() != attribute) continue;
            return measure;
        }
        return null;
    }

    public List getFactEntities() {
        return this.factEntities;
    }

    public void addFactEntity(ContainerObject entity) {
        if (!this.factEntities.contains(entity) && entity != null) {
            this.factEntities.add(entity);
            if (entity instanceof ContainerWithKeyObject) {
                ((ContainerWithKeyObject)entity).setTypeID("1");
            }
        }
    }

    public List getJoins() {
        return this.joins;
    }

    public void addFactEntitiesJoin(FactEntitiesJoin join) {
        if (join != null) {
            join.setCube(this);
            this.joins.add(join);
        }
    }

    public Dimension getPartDimension() {
        return this.partDimension;
    }

    public void setPartDimension(Dimension partDimension) {
        this.partDimension = partDimension;
    }

    public Hierarchy getPartHierarchy() {
        if (this.partHierarchy == null && this.hierarchyID != null) {
            this.partHierarchy = (Hierarchy)((MultidimensionalDesign)this.getDesignPart()).getHierarchySet().getObjectByID(this.hierarchyID);
        }
        return this.partHierarchy;
    }

    public void setPartHierarchy(Hierarchy partHierarchy) {
        this.partHierarchy = partHierarchy;
    }

    public Level getPartLevel() {
        return this.partLevel;
    }

    public void setPartLevel(Level partLevel) {
        this.partLevel = partLevel;
    }

    public List getDimensionsOrderList() {
        return this.dimensionsOrderList;
    }

    public boolean isUseGlobalComposites() {
        return this.useGlobalComposites;
    }

    public void setUseGlobalComposites(boolean useGlobalComposites) {
        this.useGlobalComposites = useGlobalComposites;
    }

    public boolean isCompressedComposites() {
        return this.compressedComposites;
    }

    public void setCompressedComposites(boolean compressedComposites) {
        this.compressedComposites = compressedComposites;
    }

    public void setPartHierarchyID(String hierarchyID) {
        this.hierarchyID = hierarchyID;
    }

    public boolean hasRolePlayingDimensions() {
        for (Dimension dim : this.getDimensions()) {
            if (this.getAllRollupLinksToTarget(dim).size() <= 1) continue;
            return true;
        }
        return false;
    }

    public List getSQLDefinitions() {
        return this.sqlDefinitions;
    }

    public void attributeIsDeleted(ContainedObject attr) {
        for (Link link : this.getOutgoingLinks()) {
            RollupLink rl = link.getRollupLink();
            if (rl == null) continue;
            rl.getChildToParentAttributes().remove(attr);
        }
        for (Measure meas : this.getMeasures()) {
            if (meas.isFormula() || meas.getMeasureFact() != attr) continue;
            meas.setMeasureFact(null);
        }
        for (FactEntitiesJoin fj : this.getJoins()) {
            ContainedObject attribute;
            int i;
            List list = fj.getRightAttributes();
            for (i = 0; i < list.size(); ++i) {
                attribute = (ContainedObject)list.get(i);
                if (attribute != attr) continue;
                list.remove(i);
                list.add(i, null);
            }
            list = fj.getLeftAttributes();
            for (i = 0; i < list.size(); ++i) {
                attribute = (ContainedObject)list.get(i);
                if (attribute != attr) continue;
                list.remove(i);
                list.add(i, null);
            }
            Object[] left = fj.getLeftAttributes().toArray();
            Object[] right = fj.getRightAttributes().toArray();
            fj.getLeftAttributes().clear();
            fj.getRightAttributes().clear();
            for (int i2 = 0; i2 < left.length; ++i2) {
                if (left[i2] == null || right[i2] == null) continue;
                fj.getLeftAttributes().add(left[i2]);
                fj.getRightAttributes().add(right[i2]);
            }
        }
    }

    public void entityIsDeleted(ContainerObject ent) {
        if (this.getFactEntity() == ent) {
            this.setFactEntity(null);
        }
        this.getFactEntities().remove(ent);
        Object[] joins = this.getJoins().toArray();
        this.getJoins().clear();
        for (int i = 0; i < joins.length; ++i) {
            FactEntitiesJoin fj = (FactEntitiesJoin)joins[i];
            if (fj.getLeftEntity() != ent && fj.getRightEntity() != ent) {
                this.getJoins().add(fj);
                continue;
            }
            fj.remove();
        }
    }

    @Override
    public String getFCObjectType() {
        return TYPE_NAME;
    }

    public List getEditableFonts() {
        return this.editableFonts;
    }

    public FontObject getFontObject(String type) {
        for (FontObject next : this.editableFonts) {
            if (!type.equalsIgnoreCase(next.getType())) continue;
            return next;
        }
        return null;
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "cube" + File.separatorChar + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public Measure createAndAddMeasure() {
        Measure measure = ((MultidimensionalDesign)this.getDesignPart()).createMeasure();
        measure.setCube(this);
        this.addMeasure(measure);
        return measure;
    }

    public Slice createAndAddSlice() {
        Slice slice = ((MultidimensionalDesign)this.getDesignPart()).createSlice();
        this.addPrecalculatedSlice(slice);
        return slice;
    }

    public FactEntitiesJoin createAndAddFactEntitiesJoin() {
        FactEntitiesJoin fej = ((MultidimensionalDesign)this.getDesignPart()).createFactEntitiesJoin();
        this.addFactEntitiesJoin(fej);
        return fej;
    }

    public List<RollupLink> getRollupLinks() {
        ArrayList<RollupLink> list = new ArrayList<RollupLink>();
        for (Link link : this.getOutgoingLinks()) {
            if (!(link.getTargetMDObject() instanceof Dimension) || link.getRollupLink() == null) continue;
            list.add(link.getRollupLink());
        }
        return list;
    }

    public List<RollupLink> getDimensioinsUsage() {
        if (this.dimensioinsUsage == null) {
            this.dimensioinsUsage = new ArrayList<RollupLink>();
        }
        this.dimensioinsUsage.clear();
        for (Dimension dim : this.getDimensions()) {
            List<RollupLink> list = this.getRollUpLinks(dim);
            if (list.size() <= 0) continue;
            this.dimensioinsUsage.addAll(list);
        }
        return this.dimensioinsUsage;
    }
}

