/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle;

import java.util.List;
import oracle.dbtools.crest.model.design.PropertyNames;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.ddl.AbstractCSSBOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDropTriggerOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.TriggerOracleComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TriggerOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.swingui.compare.ddl.CDDLFileMaker;

public class CSSBTriggerOracle
extends AbstractCSSBOracle {
    private StorageDesignOracle storageDesign;
    private boolean forceCreate = false;

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        CompareObjectSelection sTriggerSel = (CompareObjectSelection)object;
        TriggerOracleComparator propsComparator = (TriggerOracleComparator)sTriggerSel.getPropertiesComparator();
        TriggerOracle sourceTrigger = (TriggerOracle)sTriggerSel.getObject();
        this.storageDesign = (StorageDesignOracle)sourceTrigger.getStorageDesign();
        boolean needCreate = false;
        if (this.forceCreate || sTriggerSel.canBeCreate()) {
            needCreate = true;
        } else {
            boolean needDrop = false;
            List propsList = propsComparator.getPropertiesList();
            for (EngPropertyHolder ph : propsList) {
                if (!ph.isModified() || !ph.isSelected() || ph.isFiltered() || ph.getName().equals(PropertyNames.COMMENT)) continue;
                if (ph.getName().equals(PropertyNames.NAME)) {
                    needDrop = true;
                    needCreate = true;
                    continue;
                }
                if (ph.getName().equals(PropertyNames.USER_NAME)) {
                    if (!this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) continue;
                    needDrop = true;
                    needCreate = true;
                    continue;
                }
                needCreate = true;
            }
            if (needDrop) {
                CSSBDropTriggerOracle cssbDropTrigger = new CSSBDropTriggerOracle();
                cssbDropTrigger.doAppend(oldbuffer, object, prettyPrint);
            }
        }
        if (needCreate) {
            String actions = propsComparator.getChoosedPropertyValue(TriggerOracleComparator.ACTION);
            if (!actions.trim().equalsIgnoreCase("")) {
                this.appendComment(oldbuffer, propsComparator.getTriggerForProperty(PropertyNames.COMMENT));
                StringBuffer buffer = new StringBuffer();
                this.appendCreateOrReplace(buffer);
                CSSBTriggerOracle.appendStringWithSpace(buffer, "TRIGGER");
                this.appendTriggerName(buffer, propsComparator);
                String advancedComment = buffer.toString();
                this.appendTriggeringTime(buffer, propsComparator, prettyPrint);
                this.appendDMLEvent(buffer, sTriggerSel, propsComparator);
                this.appendReferencingClause(buffer, propsComparator, prettyPrint);
                this.appendCrossEditionClause(buffer, propsComparator, prettyPrint);
                String triggerState = propsComparator.getTriggerForProperty(TriggerOracleComparator.STATE).getState();
                if (!"".equals(triggerState) && this.storageDesign instanceof StorageDesignOraclev11g) {
                    CSSBTriggerOracle.appendNewLine(buffer, prettyPrint, 1);
                    CSSBTriggerOracle.appendStringWithSpace(buffer, triggerState);
                }
                this.appendCondition(buffer, propsComparator, prettyPrint);
                this.appendTriggeredAction(buffer, propsComparator, prettyPrint);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                if (CDDLFileMaker.getddlAdvancedGenenerator() == null) {
                    CSSBTriggerOracle.appendNewLine(oldbuffer, prettyPrint, 0);
                    CSSBTriggerOracle.appendString(oldbuffer, '/');
                }
                CSSBTriggerOracle.appendNewLine(oldbuffer, prettyPrint, 0);
                CSSBTriggerOracle.appendNewLine(oldbuffer, prettyPrint, 0);
                CDDLFileMaker.incrementCreateTrigger();
                if (!"".equals(triggerState) && !(this.storageDesign instanceof StorageDesignOraclev11g)) {
                    buffer = new StringBuffer();
                    CSSBTriggerOracle.appendStringWithSpace(buffer, "ALTER");
                    CSSBTriggerOracle.appendStringWithSpace(buffer, "TRIGGER");
                    this.appendTriggerName(buffer, propsComparator);
                    advancedComment = buffer.toString();
                    CSSBTriggerOracle.appendStringWithSpace(buffer, triggerState);
                    this.appendToBuffer(oldbuffer, buffer, advancedComment);
                    CSSBTriggerOracle.appendNewLine(oldbuffer, prettyPrint, 0);
                    this.appendLineFinisher(buffer, prettyPrint);
                    this.appendToBuffer(oldbuffer, buffer, advancedComment);
                    CSSBTriggerOracle.appendNewLine(oldbuffer, prettyPrint, 0);
                    CDDLFileMaker.incrementAlterTrigger();
                }
            } else {
                CSSBTriggerOracle.appendStringWithSpace(oldbuffer, "--error invalid trigger: without action - " + this.storageDesign.getFormatedLongNameDDL(sourceTrigger));
                CSSBTriggerOracle.appendNewLine(oldbuffer, prettyPrint, 0);
                CDDLFileMaker.incrementErrors();
            }
        }
    }

    private void appendTriggerName(StringBuffer buffer, TriggerOracleComparator propsComparator) {
        UserOracle user;
        if (this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL() && (user = propsComparator.getTriggerForProperty(PropertyNames.USER_NAME).getUser()) != null) {
            CSSBTriggerOracle.appendString(buffer, this.storageDesign.getFormatedName(user));
            CSSBTriggerOracle.appendString(buffer, '.');
        }
        CSSBTriggerOracle.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(propsComparator.getTriggerForProperty(PropertyNames.NAME)));
    }

    private void appendTriggeringTime(StringBuffer buffer, TriggerOracleComparator propsComparator, boolean prettyPrint) {
        String triggerTime = propsComparator.getChoosedPropertyValue(TriggerOracleComparator.TRIGGERING_TIME);
        if (triggerTime.equals("COMPOUND")) {
            triggerTime = "FOR";
        }
        CSSBTriggerOracle.appendNewLine(buffer, prettyPrint, 1);
        CSSBTriggerOracle.appendStringWithSpace(buffer, triggerTime);
    }

    private void appendDMLEvent(StringBuffer buffer, CompareObjectSelection triggerSel, TriggerOracleComparator propsComparator) {
        TriggerOracle triggerForActions = propsComparator.getTriggerForProperty(TriggerOracleComparator.ACTION);
        for (int i = 0; i < triggerForActions.getActionSet().size(); ++i) {
            TriggerOracle triggerForColumnIDs;
            if (i > 0) {
                CSSBTriggerOracle.appendStringWithSpace(buffer, "OR");
            }
            String action = triggerForActions.getActionSet().elementAt(i).toString();
            CSSBTriggerOracle.appendStringWithSpace(buffer, action);
            if (!action.equals(Trigger.ACTION_TYPES[1]) || (triggerForColumnIDs = propsComparator.getTriggerForProperty(TriggerOracleComparator.UPDATE_COLUMNS)).getColumns().equalsIgnoreCase("")) continue;
            StorageDesignOracle relevantStorageDesign = (StorageDesignOracle)triggerForColumnIDs.getStorageDesign();
            CSSBTriggerOracle.appendStringWithSpace(buffer, "OF");
            CSSBTriggerOracle.appendStringWithSpace(buffer, relevantStorageDesign.getFormatedColumnNamesFromIDs(triggerForColumnIDs.getColumns()));
        }
        CSSBTriggerOracle.appendStringWithSpace(buffer, "ON");
        CSSBTriggerOracle.appendStringWithSpace(buffer, this.getTableOrViewName(triggerSel));
    }

    private void appendReferencingClause(StringBuffer buffer, TriggerOracleComparator propsComparator, boolean prettyPrint) {
        String triggerTime;
        TriggerOracle triggerForScope;
        String refNewAs = propsComparator.getChoosedPropertyValue(TriggerOracleComparator.REF_NEW_AS);
        String refOldAs = propsComparator.getChoosedPropertyValue(TriggerOracleComparator.REF_OLD_AS);
        String refParentAs = propsComparator.getChoosedPropertyValue(TriggerOracleComparator.REF_PARENT_AS);
        if (refNewAs != null && refNewAs.length() > 0 || refOldAs != null && refOldAs.length() > 0 || refParentAs != null && refParentAs.length() > 0) {
            CSSBTriggerOracle.appendStringWithSpace(buffer, "REFERENCING");
            if (refNewAs.length() > 0) {
                CSSBTriggerOracle.appendNewLine(buffer, prettyPrint, 1);
                CSSBTriggerOracle.appendStringWithSpace(buffer, "NEW");
                CSSBTriggerOracle.appendStringWithSpace(buffer, "AS");
                CSSBTriggerOracle.appendStringWithSpace(buffer, refNewAs);
            }
            if (refOldAs.length() > 0) {
                CSSBTriggerOracle.appendNewLine(buffer, prettyPrint, 1);
                CSSBTriggerOracle.appendStringWithSpace(buffer, "OLD");
                CSSBTriggerOracle.appendStringWithSpace(buffer, "AS");
                CSSBTriggerOracle.appendStringWithSpace(buffer, refOldAs);
            }
            if (refParentAs.length() > 0) {
                CSSBTriggerOracle.appendNewLine(buffer, prettyPrint, 1);
                CSSBTriggerOracle.appendStringWithSpace(buffer, "PARENT");
                CSSBTriggerOracle.appendStringWithSpace(buffer, "AS");
                CSSBTriggerOracle.appendStringWithSpace(buffer, refParentAs);
            }
        }
        if ((triggerForScope = propsComparator.getTriggerForProperty(TriggerOracleComparator.SCOPE)).isScopeForEachRow() && !(triggerTime = propsComparator.getChoosedPropertyValue(TriggerOracleComparator.TRIGGERING_TIME)).equals("COMPOUND")) {
            CSSBTriggerOracle.appendNewLine(buffer, prettyPrint, 1);
            CSSBTriggerOracle.appendStringWithSpace(buffer, triggerForScope.getScope());
        }
    }

    private void appendCrossEditionClause(StringBuffer buffer, TriggerOracleComparator propsComparator, boolean prettyPrint) {
        String crossEdition = propsComparator.getChoosedPropertyValue(TriggerOracleComparator.CROSS_EDITION);
        if ((crossEdition.equals("FORWARD") || crossEdition.equals("REVERSE")) && this.storageDesign instanceof StorageDesignOraclev11g) {
            CSSBTriggerOracle.appendNewLine(buffer, prettyPrint, 1);
            CSSBTriggerOracle.appendStringWithSpace(buffer, crossEdition);
            CSSBTriggerOracle.appendStringWithSpace(buffer, "CROSSEDITION");
        }
    }

    private void appendCondition(StringBuffer buffer, TriggerOracleComparator propsComparator, boolean prettyPrint) {
        String condition = propsComparator.getChoosedPropertyValue(TriggerOracleComparator.CONDITION);
        if (condition.length() > 0) {
            CSSBTriggerOracle.appendNewLine(buffer, prettyPrint, 1);
            CSSBTriggerOracle.appendStringWithSpace(buffer, "WHEN");
            CSSBTriggerOracle.appendStringWithSpace(buffer, '(');
            CSSBTriggerOracle.appendStringWithSpace(buffer, condition);
            CSSBTriggerOracle.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendTriggeredAction(StringBuffer buffer, TriggerOracleComparator propsComparator, boolean prettyPrint) {
        CSSBTriggerOracle.appendNewLine(buffer, prettyPrint, 0);
        String body = propsComparator.getChoosedPropertyValue(TriggerOracleComparator.BODY).trim();
        if (body.length() == 0) {
            CSSBTriggerOracle.appendStringWithSpace(buffer, "-- Empty body");
        } else {
            CSSBTriggerOracle.appendStringWithSpace(buffer, body);
            if (!body.endsWith(";")) {
                CSSBTriggerOracle.appendString(buffer, ';');
            }
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).getObject() instanceof TriggerOracle;
    }

    protected String getTableOrViewName(CompareObjectSelection triggerSel) {
        CompareObjectSelection tableSel = triggerSel.getTableNode();
        if (tableSel != null) {
            return this.getFormattedTableName(tableSel, this.storageDesign);
        }
        return "";
    }

    public void forceAppendTrigger(StringBuffer oldbuffer, CompareObjectSelection trgSel, boolean prettyPrint) {
        boolean generate = trgSel.canBeCreate() ? trgSel.isSelected() : (trgSel.canBeDrop() ? !trgSel.isSelected() : true);
        if (generate) {
            this.forceCreate = true;
            this.doAppend(oldbuffer, trgSel, prettyPrint);
        }
    }
}

