/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.ddl.AbstractCSSBOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBCreateTable;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionLobItemOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionLobItemSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LobStorageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ListPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionListOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PermissionsOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SnapshotOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxyOraclev9i;
import oracle.dbtools.crest.swingui.compare.ddl.CDDLFileMaker;

public class CSSBSnapshot
extends AbstractCSSBOracle {
    private StorageDesignOraclev9i storageDesign;
    private CSSBCreateTable cssbCreateTable;

    public CSSBSnapshot(CSSBCreateTable cssbCreateTable) {
        this.cssbCreateTable = cssbCreateTable;
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        CompareObjectSelection snapSel = (CompareObjectSelection)object;
        if (snapSel.canBeCreate() || snapSel.isDDLModified() || snapSel.hasDDLModifiedChildren()) {
            StringBuffer buffer = new StringBuffer();
            String advancedComment = "";
            SnapshotOraclev9i snapshot = (SnapshotOraclev9i)snapSel.getObject();
            this.storageDesign = (StorageDesignOraclev9i)snapshot.getStorageDesign();
            this.appendComment(oldbuffer, snapshot);
            if (!snapSel.canBeCreate()) {
                StringBuffer dropbuffer = new StringBuffer();
                CSSBSnapshot.appendStringWithSpace(dropbuffer, "DROP");
                CSSBSnapshot.appendStringWithSpace(dropbuffer, "MATERIALIZED");
                CSSBSnapshot.appendStringWithSpace(dropbuffer, "VIEW");
                CSSBSnapshot.appendStringWithSpace(dropbuffer, this.storageDesign.getFormatedLongNameDDL(snapshot));
                this.appendToBuffer(oldbuffer, dropbuffer, dropbuffer.toString());
                CSSBSnapshot.appendNewLine(dropbuffer, prettyPrint, 0);
                this.appendLineFinisher(dropbuffer, prettyPrint);
                this.appendToBuffer(oldbuffer, dropbuffer, dropbuffer.toString());
            }
            this.appendCreateSnapshot(buffer, snapshot);
            advancedComment = buffer.toString();
            if (snapshot.getImplementedTable() != null || snapshot.getOnPrebuildTable() == null) {
                if (snapshot.getCluster() != null) {
                    this.appendCreateCluster(oldbuffer, snapshot, prettyPrint);
                    this.appendCluster(buffer, snapshot, prettyPrint);
                } else {
                    this.appendSegment(buffer, snapshot, prettyPrint);
                }
                TableProxyOracle tableProxy = snapshot.getImplementedTable();
                if (tableProxy != null && this.cssbCreateTable != null) {
                    this.cssbCreateTable.appendPartitionList(buffer, (TableProxyOraclev9i)tableProxy, prettyPrint);
                } else {
                    this.appendPartitioning(buffer, snapshot, prettyPrint);
                }
                this.appendParallelClause(buffer, snapshot, prettyPrint);
                if (!snapshot.getBuild().equals("IMMEDIATE")) {
                    CSSBSnapshot.appendStringWithSpace(buffer, "BUILD");
                    CSSBSnapshot.appendStringWithSpace(buffer, snapshot.getBuild());
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    CSSBSnapshot.appendStringWithSpace(buffer, "BUILD");
                    CSSBSnapshot.appendStringWithSpace(buffer, "IMMEDIATE");
                }
            } else {
                this.appendPrebuild(buffer, snapshot, prettyPrint);
            }
            this.appendUsingIndex(buffer, snapshot, prettyPrint);
            this.appendRefreshClause(buffer, snapshot, prettyPrint);
            this.appendForUpdate(buffer, snapshot, prettyPrint);
            this.appendQueryRewrite(buffer, snapshot, prettyPrint);
            this.appendSubquery(buffer, snapshot, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CSSBSnapshot.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CDDLFileMaker.incrementCreateSnapshot();
            CSSBSnapshot.appendNewLine(oldbuffer, prettyPrint, 0);
            if (snapshot.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                this.appendCommentOn(oldbuffer, snapshot, prettyPrint);
            }
            this.appendPermissions(oldbuffer, snapshot, prettyPrint);
        }
    }

    private void appendCreateSnapshot(StringBuffer buffer, SnapshotOraclev9i snapshot) {
        this.appendCreate(buffer);
        CSSBSnapshot.appendStringWithSpace(buffer, "MATERIALIZED");
        CSSBSnapshot.appendStringWithSpace(buffer, "VIEW");
        CSSBSnapshot.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(snapshot));
    }

    private void appendSegment(StringBuffer buffer, SnapshotOraclev9i snapshot, boolean prettyPrint) {
        SegmentOracle segment = snapshot.getSegment();
        if (segment == null && snapshot.getImplementedTable() != null) {
            segment = snapshot.getImplementedTable().getSegment();
        }
        this.appendPhysicalAttributes(buffer, segment, false, prettyPrint);
        this.appendTableSpace(buffer, snapshot, prettyPrint);
        for (LobStorageOracle lob : snapshot.getLobsCollection()) {
            this.appendLobStorage(buffer, lob, prettyPrint);
        }
        this.appendAttributes(buffer, snapshot, prettyPrint);
    }

    private void appendParallelClause(StringBuffer buffer, SnapshotOraclev9i snapshot, boolean prettyPrint) {
        if ("YES".equalsIgnoreCase(snapshot.getParalelClause())) {
            CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
            CSSBSnapshot.appendStringWithSpace(buffer, "PARALLEL");
            if (snapshot.getDegree() > 0) {
                this.appendStringWithSpace(buffer, snapshot.getDegree());
            }
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
            CSSBSnapshot.appendStringWithSpace(buffer, "NOPARALLEL");
        }
    }

    private void appendPrebuild(StringBuffer buffer, SnapshotOraclev9i snapshot, boolean prettyPrint) {
        if (snapshot.getImplementedTable() != null || snapshot.getOnPrebuildTable() == null) {
            if (!snapshot.getBuild().equals("IMMEDIATE")) {
                CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
                CSSBSnapshot.appendStringWithSpace(buffer, "BUILD");
                CSSBSnapshot.appendStringWithSpace(buffer, snapshot.getBuild());
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
                CSSBSnapshot.appendStringWithSpace(buffer, "BUILD");
                CSSBSnapshot.appendStringWithSpace(buffer, "IMMEDIATE");
            }
        } else {
            CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
            CSSBSnapshot.appendStringWithSpace(buffer, "ON");
            CSSBSnapshot.appendStringWithSpace(buffer, "PREBUILT");
            CSSBSnapshot.appendStringWithSpace(buffer, "TABLE");
            if ("YES".equalsIgnoreCase(snapshot.getReducedPrecision())) {
                CSSBSnapshot.appendStringWithSpace(buffer, "WITH REDUCED PRECISION");
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBSnapshot.appendStringWithSpace(buffer, "WITHOUT REDUCED PRECISION");
            }
        }
    }

    private void appendUsingIndex(StringBuffer buffer, SnapshotOraclev9i snapshot, boolean prettyPrint) {
        if (snapshot.getUseIndex().equals("YES")) {
            CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
            CSSBSnapshot.appendStringWithSpace(buffer, "USING");
            CSSBSnapshot.appendStringWithSpace(buffer, "INDEX");
            if (snapshot.getIndexTablespace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                CSSBSnapshot.appendStringWithSpace(buffer, "TABLESPACE");
                CSSBSnapshot.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(snapshot.getIndexTablespace()));
            }
            if (snapshot.getIndexSegment() != null) {
                this.appendPhysicalAttributes(buffer, snapshot.getIndexSegment(), true, prettyPrint);
            }
        } else if (snapshot.getUseIndex().equals("NO")) {
            CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
            CSSBSnapshot.appendStringWithSpace(buffer, "USING");
            CSSBSnapshot.appendStringWithSpace(buffer, "NO");
            CSSBSnapshot.appendStringWithSpace(buffer, "INDEX");
        }
    }

    private void appendRefreshClause(StringBuffer buffer, SnapshotOraclev9i snapshot, boolean prettyPrint) {
        if ("NEVER".equalsIgnoreCase(snapshot.getRefresh())) {
            CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
            CSSBSnapshot.appendStringWithSpace(buffer, "NEVER");
            CSSBSnapshot.appendStringWithSpace(buffer, "REFRESH");
        } else if ("YES".equals(snapshot.getRefresh())) {
            CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
            CSSBSnapshot.appendStringWithSpace(buffer, "REFRESH");
            CSSBSnapshot.appendStringWithSpace(buffer, snapshot.getRefreshType());
            if (!"".equalsIgnoreCase(snapshot.getAction())) {
                CSSBSnapshot.appendStringWithSpace(buffer, snapshot.getAction());
            } else if (!"".equalsIgnoreCase(snapshot.getStartDate()) || !"".equalsIgnoreCase(snapshot.getNextDate())) {
                if (!"".equalsIgnoreCase(snapshot.getStartDate())) {
                    CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
                    CSSBSnapshot.appendStringWithSpace(buffer, "START WITH");
                    CSSBSnapshot.appendStringWithSpace(buffer, snapshot.getStartDate());
                }
                if (!"".equalsIgnoreCase(snapshot.getNextDate())) {
                    CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
                    CSSBSnapshot.appendStringWithSpace(buffer, "NEXT");
                    CSSBSnapshot.appendStringWithSpace(buffer, snapshot.getNextDate());
                }
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBSnapshot.appendStringWithSpace(buffer, "ON DEMAND");
            }
            if (!snapshot.getWith().equalsIgnoreCase("")) {
                CSSBSnapshot.appendStringWithSpace(buffer, "WITH");
                CSSBSnapshot.appendStringWithSpace(buffer, snapshot.getWith());
            }
            if ("YES".equalsIgnoreCase(snapshot.getDefaultSegment())) {
                CSSBSnapshot.appendStringWithSpace(buffer, "USING");
                CSSBSnapshot.appendStringWithSpace(buffer, "DEFAULT");
                if (!"LOCAL".equalsIgnoreCase(snapshot.getSegmentType())) {
                    CSSBSnapshot.appendStringWithSpace(buffer, snapshot.getSegmentType());
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    CSSBSnapshot.appendStringWithSpace(buffer, "LOCAL");
                }
                CSSBSnapshot.appendStringWithSpace(buffer, "ROLLBACK");
                CSSBSnapshot.appendStringWithSpace(buffer, "SEGMENT");
            } else if (snapshot.getRollbackSegment() != null) {
                CSSBSnapshot.appendStringWithSpace(buffer, "USING");
                if (!"LOCAL".equalsIgnoreCase(snapshot.getSegmentType())) {
                    CSSBSnapshot.appendStringWithSpace(buffer, snapshot.getSegmentType());
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    CSSBSnapshot.appendStringWithSpace(buffer, "LOCAL");
                }
                CSSBSnapshot.appendStringWithSpace(buffer, "ROLLBACK");
                CSSBSnapshot.appendStringWithSpace(buffer, "SEGMENT");
                CSSBSnapshot.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(snapshot.getRollbackSegment()));
            }
        }
    }

    private void appendForUpdate(StringBuffer buffer, SnapshotOraclev9i snapshot, boolean prettyPrint) {
        if ("YES".equalsIgnoreCase(snapshot.getForUpdate())) {
            CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
            CSSBSnapshot.appendStringWithSpace(buffer, "FOR");
            CSSBSnapshot.appendStringWithSpace(buffer, "UPDATE");
        }
    }

    private void appendQueryRewrite(StringBuffer buffer, SnapshotOraclev9i snapshot, boolean prettyPrint) {
        if ("ENABLE".equalsIgnoreCase(snapshot.getQueryRewrite())) {
            CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
            CSSBSnapshot.appendStringWithSpace(buffer, "ENABLE");
            CSSBSnapshot.appendStringWithSpace(buffer, "QUERY REWRITE");
        }
    }

    private void appendSubquery(StringBuffer buffer, SnapshotOraclev9i snapshot, boolean prettyPrint) {
        CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
        CSSBSnapshot.appendStringWithSpace(buffer, "AS");
        CSSBSnapshot.appendStringWithSpace(buffer, snapshot.getSubquery());
    }

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).getObject() instanceof SnapshotOraclev9i;
    }

    private void appendLobStorage(StringBuffer buffer, LobStorageOracle lobStorage, boolean prettyPrint) {
        if (lobStorage != null) {
            CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
            CSSBSnapshot.appendStringWithSpace(buffer, "LOB");
            CSSBSnapshot.appendStringWithSpace(buffer, '(');
            CSSBSnapshot.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobStorage.getColumn()));
            CSSBSnapshot.appendStringWithSpace(buffer, ')');
            CSSBSnapshot.appendStringWithSpace(buffer, "STORE AS");
            if (!lobStorage.getLobSegmentName().equalsIgnoreCase("")) {
                CSSBSnapshot.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobStorage.getLobSegmentName()));
            }
            CSSBSnapshot.appendNewLine(buffer, prettyPrint, 2);
            CSSBSnapshot.appendStringWithSpace(buffer, '(');
            CSSBSnapshot.appendNewLine(buffer, prettyPrint, 2);
            if (lobStorage.getTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                CSSBSnapshot.appendStringWithSpace(buffer, "TABLESPACE");
                CSSBSnapshot.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobStorage.getTableSpace()));
                CSSBSnapshot.appendNewLine(buffer, prettyPrint, 2);
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
                CSSBSnapshot.appendStringWithSpace(buffer, "STORAGE");
                CSSBSnapshot.appendStringWithSpace(buffer, '(');
                boolean props = false;
                if (lobStorage.getSCInitialExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
                    CSSBSnapshot.appendNewLine(buffer, prettyPrint, 3);
                    CSSBSnapshot.appendStringWithSpace(buffer, "INITIAL");
                    this.appendStringWithSpace(buffer, lobStorage.getSCInitialExtent());
                    props = true;
                }
                if (lobStorage.getSCNextExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeNextExtentInDDL()) {
                    CSSBSnapshot.appendNewLine(buffer, prettyPrint, 3);
                    CSSBSnapshot.appendStringWithSpace(buffer, "NEXT");
                    this.appendStringWithSpace(buffer, lobStorage.getSCNextExtent());
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
                    CSSBSnapshot.appendNewLine(buffer, prettyPrint, 3);
                    CSSBSnapshot.appendStringWithSpace(buffer, "PCTINCREASE");
                    this.appendStringWithSpace(buffer, lobStorage.getSCPctIncrease());
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
                    CSSBSnapshot.appendNewLine(buffer, prettyPrint, 3);
                    CSSBSnapshot.appendStringWithSpace(buffer, "MINEXTENTS");
                    this.appendStringWithSpace(buffer, lobStorage.getSCMinExtents());
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
                    CSSBSnapshot.appendNewLine(buffer, prettyPrint, 3);
                    CSSBSnapshot.appendStringWithSpace(buffer, "MAXEXTENTS");
                    CSSBSnapshot.appendStringWithSpace(buffer, lobStorage.getSCMaxExtents());
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeFreeListsInDDL()) {
                    CSSBSnapshot.appendNewLine(buffer, prettyPrint, 3);
                    CSSBSnapshot.appendStringWithSpace(buffer, "FREELISTS");
                    this.appendStringWithSpace(buffer, lobStorage.getSCFreeLists());
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeFreeListGroupsInDDL() && lobStorage.getSCFreelistGroups() > 1) {
                    CSSBSnapshot.appendNewLine(buffer, prettyPrint, 3);
                    CSSBSnapshot.appendStringWithSpace(buffer, "FREELIST");
                    CSSBSnapshot.appendStringWithSpace(buffer, "GROUPS");
                    this.appendStringWithSpace(buffer, lobStorage.getSCFreelistGroups());
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeBufferPoolInDDL()) {
                    CSSBSnapshot.appendNewLine(buffer, prettyPrint, 3);
                    CSSBSnapshot.appendStringWithSpace(buffer, "BUFFER_POOL");
                    CSSBSnapshot.appendStringWithSpace(buffer, lobStorage.getSCBufferPool());
                    props = true;
                }
                if (props) {
                    CSSBSnapshot.appendNewLine(buffer, prettyPrint, 2);
                    CSSBSnapshot.appendStringWithSpace(buffer, ')');
                } else {
                    buffer = buffer.replace(buffer.lastIndexOf("STORAGE ("), buffer.length(), "");
                }
                CSSBSnapshot.appendNewLine(buffer, prettyPrint, 2);
            }
            if (lobStorage.getChunk() > 0) {
                CSSBSnapshot.appendStringWithSpace(buffer, "CHUNK");
                this.appendStringWithSpace(buffer, lobStorage.getChunk());
                CSSBSnapshot.appendNewLine(buffer, prettyPrint, 2);
            }
            if (lobStorage.getOldVersions().equalsIgnoreCase("RETENTION")) {
                CSSBSnapshot.appendStringWithSpace(buffer, "RETENTION");
            } else {
                CSSBSnapshot.appendStringWithSpace(buffer, "PCTVERSION");
                this.appendStringWithSpace(buffer, lobStorage.getPCTVersion());
            }
            if (lobStorage.getFreepools() > 0 && lobStorage.getSCFreelistGroups() <= 1) {
                CSSBSnapshot.appendNewLine(buffer, prettyPrint, 2);
                CSSBSnapshot.appendStringWithSpace(buffer, "FREEPOOLS");
                this.appendStringWithSpace(buffer, lobStorage.getFreepools());
            }
            CSSBSnapshot.appendNewLine(buffer, prettyPrint, 2);
            if ("ENABLE".equalsIgnoreCase(lobStorage.getStorageInRow())) {
                CSSBSnapshot.appendStringWithSpace(buffer, "ENABLE");
            } else {
                CSSBSnapshot.appendStringWithSpace(buffer, "DISABLE");
            }
            CSSBSnapshot.appendStringWithSpace(buffer, "STORAGE IN ROW");
            CSSBSnapshot.appendNewLine(buffer, prettyPrint, 2);
            CSSBSnapshot.appendStringWithSpace(buffer, lobStorage.getCache());
            if (!"CACHE".equalsIgnoreCase(lobStorage.getCache()) && this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                if ("YES".equalsIgnoreCase(lobStorage.getLogging())) {
                    CSSBSnapshot.appendStringWithSpace(buffer, "LOGGING");
                } else if ("NO".equalsIgnoreCase(lobStorage.getLogging())) {
                    CSSBSnapshot.appendStringWithSpace(buffer, "NOLOGGING");
                }
            }
            CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
            CSSBSnapshot.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendTableSpace(StringBuffer buffer, SnapshotOraclev9i snapshot, boolean prettyPrint) {
        TableSpaceOracle tableSpace;
        if (this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL() && (tableSpace = snapshot.getTablespace()) != null && !"[NONE]".equalsIgnoreCase(tableSpace.getName())) {
            CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
            CSSBSnapshot.appendStringWithSpace(buffer, "TABLESPACE");
            CSSBSnapshot.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableSpace));
        }
    }

    private void appendAttributes(StringBuffer buffer, SnapshotOraclev9i snapshot, boolean prettyPrint) {
        if (this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
            if ("YES".equalsIgnoreCase(snapshot.getLogging())) {
                CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
                CSSBSnapshot.appendStringWithSpace(buffer, "LOGGING");
            } else if ("NO".equalsIgnoreCase(snapshot.getLogging())) {
                CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
                CSSBSnapshot.appendStringWithSpace(buffer, "NOLOGGING");
            }
        }
        if ("YES".equalsIgnoreCase(snapshot.getCache())) {
            CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
            CSSBSnapshot.appendStringWithSpace(buffer, "CACHE");
        } else if ("NO".equalsIgnoreCase(snapshot.getCache()) || this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
            CSSBSnapshot.appendStringWithSpace(buffer, "NOCACHE");
        }
    }

    private void appendCluster(StringBuffer buffer, SnapshotOraclev9i snapshot, boolean prettyPrint) {
        ClusterOracle cluster = snapshot.getCluster();
        if (cluster != null) {
            CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
            CSSBSnapshot.appendStringWithSpace(buffer, "CLUSTER");
            CSSBSnapshot.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(cluster));
            if (!"".equalsIgnoreCase(snapshot.getClusterColumns())) {
                CSSBSnapshot.appendStringWithSpace(buffer, '(');
                CSSBSnapshot.appendStringWithSpace(buffer, this.storageDesign.getFormattedNameList(snapshot.getClusterColumns()));
                CSSBSnapshot.appendStringWithSpace(buffer, ')');
            }
        }
    }

    private void appendCreateCluster(StringBuffer oldbuffer, SnapshotOraclev9i snapshot, boolean prettyPrint) {
        ClusterOracle cluster = snapshot.getCluster();
        if (cluster != null) {
            TableSpaceOracle tableSpace;
            StringBuffer buffer = new StringBuffer();
            CSSBSnapshot.appendStringWithSpace(buffer, "CREATE");
            CSSBSnapshot.appendStringWithSpace(buffer, "CLUSTER");
            CSSBSnapshot.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(cluster));
            this.appendPhysicalAttributes(buffer, cluster.getSegment(), false, prettyPrint);
            if (this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL() && (tableSpace = cluster.getTableSpace()) != null && !"[NONE]".equalsIgnoreCase(tableSpace.getName())) {
                CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
                CSSBSnapshot.appendStringWithSpace(buffer, "TABLESPACE");
                CSSBSnapshot.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableSpace));
            }
            this.appendToBuffer(oldbuffer, buffer, buffer.toString());
            CSSBSnapshot.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, buffer.toString());
        }
    }

    private void appendPhysicalAttributes(StringBuffer buffer, SegmentOracle segment, boolean usingIndex, boolean prettyPrint) {
        if (segment != null && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            if (!usingIndex) {
                if (this.storageDesign.getAppView().getSettings().isIncludePctFreeInDDL()) {
                    CSSBSnapshot.appendNewLine(buffer, prettyPrint, 2);
                    CSSBSnapshot.appendStringWithSpace(buffer, "PCTFREE");
                    this.appendStringWithSpace(buffer, segment.getPCTFree());
                }
                if (this.storageDesign.getAppView().getSettings().isIncludePctUsedInDDL()) {
                    CSSBSnapshot.appendNewLine(buffer, prettyPrint, 2);
                    CSSBSnapshot.appendStringWithSpace(buffer, "PCTUSED");
                    this.appendStringWithSpace(buffer, segment.getPCTUsed());
                }
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeInitransInDDL()) {
                if (segment.getInitrans() > 1) {
                    CSSBSnapshot.appendNewLine(buffer, prettyPrint, 2);
                    CSSBSnapshot.appendStringWithSpace(buffer, "INITRANS");
                    this.appendStringWithSpace(buffer, segment.getInitrans());
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    CSSBSnapshot.appendNewLine(buffer, prettyPrint, 2);
                    CSSBSnapshot.appendStringWithSpace(buffer, "INITRANS");
                    CSSBSnapshot.appendStringWithSpace(buffer, "1");
                }
                if (segment.getMaxTrans() > 1) {
                    CSSBSnapshot.appendNewLine(buffer, prettyPrint, 2);
                    CSSBSnapshot.appendStringWithSpace(buffer, "MAXTRANS");
                    this.appendStringWithSpace(buffer, segment.getMaxTrans());
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    CSSBSnapshot.appendNewLine(buffer, prettyPrint, 2);
                    CSSBSnapshot.appendStringWithSpace(buffer, "MAXTRANS");
                    CSSBSnapshot.appendStringWithSpace(buffer, "255");
                }
            }
            CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
            CSSBSnapshot.appendStringWithSpace(buffer, "STORAGE");
            CSSBSnapshot.appendStringWithSpace(buffer, '(');
            CSSBSnapshot.appendNewLine(buffer, prettyPrint, 2);
            boolean props = false;
            if (segment.getSCInitialExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
                CSSBSnapshot.appendStringWithSpace(buffer, "INITIAL");
                this.appendStringWithSpace(buffer, segment.getSCInitialExtent());
                CSSBSnapshot.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (segment.getSCNextExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeNextExtentInDDL()) {
                CSSBSnapshot.appendStringWithSpace(buffer, "NEXT");
                this.appendStringWithSpace(buffer, segment.getSCNextExtent());
                CSSBSnapshot.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
                CSSBSnapshot.appendStringWithSpace(buffer, "PCTINCREASE");
                this.appendStringWithSpace(buffer, segment.getSCPctIncrease());
                CSSBSnapshot.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
                CSSBSnapshot.appendStringWithSpace(buffer, "MINEXTENTS");
                this.appendStringWithSpace(buffer, segment.getSCMinExtents());
                CSSBSnapshot.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
                CSSBSnapshot.appendStringWithSpace(buffer, "MAXEXTENTS");
                CSSBSnapshot.appendStringWithSpace(buffer, segment.getSCMaxExtents());
                CSSBSnapshot.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeFreeListsInDDL()) {
                CSSBSnapshot.appendStringWithSpace(buffer, "FREELISTS");
                this.appendStringWithSpace(buffer, segment.getSCFreeLists());
                CSSBSnapshot.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeFreeListGroupsInDDL()) {
                CSSBSnapshot.appendStringWithSpace(buffer, "FREELIST");
                CSSBSnapshot.appendStringWithSpace(buffer, "GROUPS");
                this.appendStringWithSpace(buffer, segment.getSCFreelistGroups());
                CSSBSnapshot.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeBufferPoolInDDL()) {
                CSSBSnapshot.appendStringWithSpace(buffer, "BUFFER_POOL");
                CSSBSnapshot.appendStringWithSpace(buffer, segment.getSCBufferPool());
                props = true;
            }
            if (props) {
                CSSBSnapshot.appendStringWithSpace(buffer, ')');
            } else {
                buffer = buffer.replace(buffer.lastIndexOf("STORAGE ("), buffer.length(), "");
            }
        }
    }

    private void appendPartitioning(StringBuffer buffer, SnapshotOraclev9i snapshot, boolean prettyPrint) {
        PartitionListOraclev9i partitionList = (PartitionListOraclev9i)snapshot.getPartitionList();
        if (partitionList != null) {
            String partitionType = partitionList.getPartitionType();
            CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
            if ("RANGE".equalsIgnoreCase(partitionType)) {
                CSSBSnapshot.appendStringWithSpace(buffer, "PARTITION BY RANGE");
                CSSBSnapshot.appendStringWithSpace(buffer, '(');
                CSSBSnapshot.appendStringWithSpace(buffer, this.storageDesign.getFormattedNameList(snapshot.getColumns()));
                CSSBSnapshot.appendStringWithSpace(buffer, ')');
                this.appendPartitions(buffer, partitionList, false, prettyPrint);
            } else if ("COMPOSITE BY HASH".equalsIgnoreCase(partitionType)) {
                CSSBSnapshot.appendStringWithSpace(buffer, "PARTITION BY RANGE");
                CSSBSnapshot.appendStringWithSpace(buffer, '(');
                CSSBSnapshot.appendStringWithSpace(buffer, this.storageDesign.getFormattedNameList(snapshot.getColumns()));
                CSSBSnapshot.appendStringWithSpace(buffer, ')');
                CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
                CSSBSnapshot.appendStringWithSpace(buffer, "SUBPARTITION");
                CSSBSnapshot.appendStringWithSpace(buffer, "BY");
                CSSBSnapshot.appendStringWithSpace(buffer, "HASH");
                CSSBSnapshot.appendStringWithSpace(buffer, '(');
                CSSBSnapshot.appendStringWithSpace(buffer, this.storageDesign.getFormattedNameList(snapshot.getSubPartColumns()));
                CSSBSnapshot.appendStringWithSpace(buffer, ')');
                if ("NO".equals(partitionList.getUseSubpartStorageTemplate())) {
                    if (partitionList.getSubPartitionsQuantity() > 1 || !"".equals(partitionList.getSubPartitionsTableSpaces())) {
                        CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
                        CSSBSnapshot.appendStringWithSpace(buffer, "SUBPARTITIONS");
                        this.appendStringWithSpace(buffer, partitionList.getSubPartitionsQuantity());
                        if (!"".equals(partitionList.getSubPartitionsTableSpaces())) {
                            CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
                            CSSBSnapshot.appendStringWithSpace(buffer, "STORE IN");
                            CSSBSnapshot.appendStringWithSpace(buffer, '(');
                            CSSBSnapshot.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partitionList.getSubPartitionsTableSpaces()));
                            CSSBSnapshot.appendStringWithSpace(buffer, ')');
                        }
                    } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
                        CSSBSnapshot.appendStringWithSpace(buffer, "SUBPARTITIONS");
                        CSSBSnapshot.appendStringWithSpace(buffer, "1");
                    }
                }
                this.appendPartitions(buffer, partitionList, true, prettyPrint);
            } else if ("COMPOSITE BY LIST".equalsIgnoreCase(partitionType)) {
                CSSBSnapshot.appendStringWithSpace(buffer, "PARTITION BY RANGE");
                CSSBSnapshot.appendStringWithSpace(buffer, '(');
                CSSBSnapshot.appendStringWithSpace(buffer, this.storageDesign.getFormattedNameList(snapshot.getColumns()));
                CSSBSnapshot.appendStringWithSpace(buffer, ')');
                CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
                CSSBSnapshot.appendStringWithSpace(buffer, "SUBPARTITION");
                CSSBSnapshot.appendStringWithSpace(buffer, "BY");
                CSSBSnapshot.appendStringWithSpace(buffer, "LIST");
                CSSBSnapshot.appendStringWithSpace(buffer, '(');
                CSSBSnapshot.appendStringWithSpace(buffer, this.storageDesign.getFormattedNameList(snapshot.getSubPartColumns()));
                CSSBSnapshot.appendStringWithSpace(buffer, ')');
                this.appendPartitions(buffer, partitionList, true, prettyPrint);
            } else if ("HASH BY QUANTITY".equalsIgnoreCase(partitionType)) {
                CSSBSnapshot.appendStringWithSpace(buffer, "PARTITION");
                CSSBSnapshot.appendStringWithSpace(buffer, "BY");
                CSSBSnapshot.appendStringWithSpace(buffer, "HASH");
                CSSBSnapshot.appendStringWithSpace(buffer, '(');
                CSSBSnapshot.appendStringWithSpace(buffer, this.storageDesign.getFormattedNameList(snapshot.getColumns()));
                CSSBSnapshot.appendStringWithSpace(buffer, ')');
                CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
                CSSBSnapshot.appendStringWithSpace(buffer, "PARTITIONS");
                this.appendStringWithSpace(buffer, partitionList.getHashPQuantity());
                if (!"".equals(partitionList.getHashPTableSpaces())) {
                    CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
                    CSSBSnapshot.appendStringWithSpace(buffer, "STORE IN");
                    CSSBSnapshot.appendStringWithSpace(buffer, '(');
                    CSSBSnapshot.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partitionList.getHashPTableSpaces()));
                    CSSBSnapshot.appendStringWithSpace(buffer, ')');
                }
                if (!"".equals(partitionList.getIOTOverflowHashPTS())) {
                    CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
                    CSSBSnapshot.appendStringWithSpace(buffer, "OVERFLOW");
                    CSSBSnapshot.appendStringWithSpace(buffer, "STORE IN");
                    CSSBSnapshot.appendStringWithSpace(buffer, '(');
                    CSSBSnapshot.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partitionList.getIOTOverflowHashPTS()));
                    CSSBSnapshot.appendStringWithSpace(buffer, ')');
                }
            } else if ("HASH BY LIST OF PARTITIONS".equalsIgnoreCase(partitionType)) {
                CSSBSnapshot.appendStringWithSpace(buffer, "PARTITION");
                CSSBSnapshot.appendStringWithSpace(buffer, "BY");
                CSSBSnapshot.appendStringWithSpace(buffer, "HASH");
                CSSBSnapshot.appendStringWithSpace(buffer, '(');
                CSSBSnapshot.appendStringWithSpace(buffer, this.storageDesign.getFormattedNameList(snapshot.getColumns()));
                CSSBSnapshot.appendStringWithSpace(buffer, ')');
                this.appendHashPartitions(buffer, partitionList, prettyPrint);
            } else if ("LIST".equalsIgnoreCase(partitionType)) {
                CSSBSnapshot.appendStringWithSpace(buffer, "PARTITION");
                CSSBSnapshot.appendStringWithSpace(buffer, "BY");
                CSSBSnapshot.appendStringWithSpace(buffer, "LIST");
                CSSBSnapshot.appendStringWithSpace(buffer, '(');
                CSSBSnapshot.appendStringWithSpace(buffer, this.storageDesign.getFormattedNameList(snapshot.getColumns()));
                CSSBSnapshot.appendStringWithSpace(buffer, ')');
                this.appendListPartitions(buffer, snapshot, prettyPrint);
            }
        }
    }

    private void appendListPartitions(StringBuffer buffer, SnapshotOraclev9i snapshot, boolean prettyPrint) {
        Iterator it = snapshot.getPartitions().iterator();
        boolean first = true;
        while (it.hasNext()) {
            ListPartitionOraclev9i partition = (ListPartitionOraclev9i)it.next();
            if (first) {
                CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
                CSSBSnapshot.appendStringWithSpace(buffer, '(');
                CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
                first = false;
            } else {
                CSSBSnapshot.appendStringWithSpace(buffer, ',');
                CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
            }
            CSSBSnapshot.appendStringWithSpace(buffer, "PARTITION");
            if (!partition.getName().toUpperCase().startsWith("SYS_")) {
                CSSBSnapshot.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partition));
            }
            CSSBSnapshot.appendStringWithSpace(buffer, "VALUES");
            CSSBSnapshot.appendStringWithSpace(buffer, '(');
            if (!"".equalsIgnoreCase(partition.getColumns())) {
                CSSBSnapshot.appendStringWithSpace(buffer, partition.getColumns());
            } else {
                CSSBSnapshot.appendStringWithSpace(buffer, "DEFAULT");
            }
            CSSBSnapshot.appendStringWithSpace(buffer, ')');
            if (partition.getDataSegmentCompression().equalsIgnoreCase("NO")) {
                CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
                CSSBSnapshot.appendStringWithSpace(buffer, "NOCOMPRESS");
            } else if (partition.getDataSegmentCompression().equalsIgnoreCase("YES")) {
                CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
                CSSBSnapshot.appendStringWithSpace(buffer, "COMPRESS");
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
                CSSBSnapshot.appendStringWithSpace(buffer, "NOCOMPRESS");
            }
            if (partition.getSegment() == null) {
                if (partition.getTablespace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                    CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
                    CSSBSnapshot.appendStringWithSpace(buffer, "TABLESPACE");
                    CSSBSnapshot.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partition.getTablespace()));
                }
                if (this.storageDesign.isOpen() && this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                    if (partition.getLogging().equalsIgnoreCase("YES")) {
                        CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
                        CSSBSnapshot.appendStringWithSpace(buffer, "LOGGING");
                    } else if (partition.getLogging().equalsIgnoreCase("NO")) {
                        CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
                        CSSBSnapshot.appendStringWithSpace(buffer, "NOLOGGING");
                    }
                }
            }
            for (LobStorageOracle lob : partition.getLobStorages()) {
                this.appendLobStorage(buffer, lob, prettyPrint);
            }
        }
        if (!first) {
            CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
            CSSBSnapshot.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendPartitions(StringBuffer buffer, PartitionListOracle partitionList, boolean composite, boolean prettyPrint) {
        StorageObjectCollection partitions = partitionList.getSnapshot().getPartitionsCollection();
        if (partitions.size() > 0) {
            Object[] partitionsList = partitions.toArray();
            Arrays.sort(partitionsList, new PossitionComparator());
            ArrayList<Object> sortedList = new ArrayList<Object>();
            for (int i = 0; i < partitionsList.length; ++i) {
                sortedList.add(partitionsList[i]);
            }
            Iterator setIt = sortedList.iterator();
            boolean first = true;
            while (setIt.hasNext()) {
                Object partitionObj = setIt.next();
                if (!(partitionObj instanceof PartitionOracle)) continue;
                PartitionOracle partition = (PartitionOracle)partitionObj;
                if (first) {
                    CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
                    CSSBSnapshot.appendStringWithSpace(buffer, '(');
                    first = false;
                } else {
                    CSSBSnapshot.appendStringWithSpace(buffer, ',');
                }
                CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
                CSSBSnapshot.appendStringWithSpace(buffer, "PARTITION");
                if (!partition.getName().toUpperCase().startsWith("SYS_")) {
                    CSSBSnapshot.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partition));
                }
                CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
                CSSBSnapshot.appendStringWithSpace(buffer, "VALUES LESS THAN");
                CSSBSnapshot.appendStringWithSpace(buffer, '(');
                CSSBSnapshot.appendStringWithSpace(buffer, partition.getValueList());
                CSSBSnapshot.appendStringWithSpace(buffer, ')');
                this.appendPhysicalAttributes(buffer, partition.getSegment(), false, prettyPrint);
                for (LobStorageOracle lob : partition.getLobs()) {
                    this.appendLobStorage(buffer, lob, prettyPrint);
                }
                if (!composite || this.appendHashSubPartitions(buffer, partition, prettyPrint) || partition.getSubPartitionsQuantity() <= 0) continue;
                CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
                CSSBSnapshot.appendStringWithSpace(buffer, "SUBPARTITIONS");
                this.appendStringWithSpace(buffer, partition.getSubPartitionsQuantity());
                if ("".equalsIgnoreCase(partition.getSubPartitionsTableSpaces())) continue;
                CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
                CSSBSnapshot.appendStringWithSpace(buffer, "STORE IN");
                CSSBSnapshot.appendStringWithSpace(buffer, '(');
                CSSBSnapshot.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partition.getSubPartitionsTableSpaces()));
                CSSBSnapshot.appendStringWithSpace(buffer, ')');
            }
            if (!first) {
                CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
                CSSBSnapshot.appendStringWithSpace(buffer, ')');
            }
        }
    }

    private boolean appendHashSubPartitions(StringBuffer buffer, PartitionOracle partition, boolean prettyPrint) {
        boolean result = false;
        HashPartitionSetOracle hashPartitionSet = ((StorageDesignOracle)partition.getStorageDesign()).getHashPartitionSet();
        Iterator setIt = hashPartitionSet.iterator();
        boolean first = true;
        while (setIt.hasNext()) {
            HashPartitionOracle hashPartition = (HashPartitionOracle)setIt.next();
            if (hashPartition.getSubPartitionOf() != partition) continue;
            if (first) {
                CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
                CSSBSnapshot.appendStringWithSpace(buffer, '(');
                first = false;
                result = true;
            } else {
                this.appendComma(buffer);
                CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
            }
            CSSBSnapshot.appendStringWithSpace(buffer, "SUBPARTITION");
            if (!hashPartition.getName().toUpperCase().startsWith("SYS_")) {
                CSSBSnapshot.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(hashPartition));
            }
            if (hashPartition.getTableSpace() == null || !this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) continue;
            CSSBSnapshot.appendStringWithSpace(buffer, "TABLESPACE");
            CSSBSnapshot.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(hashPartition.getTableSpace()));
            for (HashPartitionLobItemOracle lobStorage : hashPartition.getLobItems()) {
                CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
                CSSBSnapshot.appendStringWithSpace(buffer, "LOB");
                CSSBSnapshot.appendStringWithSpace(buffer, '(');
                this.appendStringWithSpace(buffer, lobStorage);
                CSSBSnapshot.appendStringWithSpace(buffer, ')');
                if (lobStorage.getTableSpace() == null || !this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) continue;
                CSSBSnapshot.appendStringWithSpace(buffer, "STORE AS");
                CSSBSnapshot.appendStringWithSpace(buffer, '(');
                CSSBSnapshot.appendStringWithSpace(buffer, "TABLESPACE");
                CSSBSnapshot.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobStorage.getTableSpace()));
                CSSBSnapshot.appendStringWithSpace(buffer, ')');
            }
        }
        if (!first) {
            CSSBSnapshot.appendStringWithSpace(buffer, ')');
        }
        return result;
    }

    private boolean appendHashPartitions(StringBuffer buffer, PartitionListOracle partitionList, boolean prettyPrint) {
        boolean result = false;
        SnapshotOracle snapshot = partitionList.getSnapshot();
        Iterator it = snapshot.getPartitions().iterator();
        boolean first = true;
        while (it.hasNext()) {
            HashPartitionOracle hashPartition = (HashPartitionOracle)it.next();
            if (first) {
                CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
                CSSBSnapshot.appendStringWithSpace(buffer, '(');
                CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
                first = false;
                result = true;
            } else {
                this.appendComma(buffer);
                CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
            }
            CSSBSnapshot.appendStringWithSpace(buffer, "PARTITION");
            if (!hashPartition.getName().toUpperCase().startsWith("SYS_")) {
                CSSBSnapshot.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(hashPartition));
            }
            if (hashPartition.getTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                CSSBSnapshot.appendStringWithSpace(buffer, "TABLESPACE");
                CSSBSnapshot.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(hashPartition.getTableSpace()));
            }
            this.appendHashPLobItems(buffer, hashPartition, prettyPrint);
        }
        if (!first) {
            CSSBSnapshot.appendNewLine(buffer, prettyPrint, 1);
            CSSBSnapshot.appendStringWithSpace(buffer, ')');
        }
        return result;
    }

    private void appendHashPLobItems(StringBuffer buffer, HashPartitionOracle hashPartition, boolean prettyPrint) {
        HashPartitionLobItemSetOracle hashPLobItemSet = ((StorageDesignOracle)hashPartition.getStorageDesign()).getHashPartitionLobItemSet();
        for (HashPartitionLobItemOracle hashPLobItem : hashPLobItemSet) {
            if (hashPLobItem.getHashPartition() == null || !hashPLobItem.getHashPartition().toString().equalsIgnoreCase(hashPartition.toString())) continue;
            CSSBSnapshot.appendNewLine(buffer, prettyPrint, 2);
            this.appendLobPartitioningStorage(buffer, hashPLobItem, hashPLobItem.getLobColumn(), "", hashPLobItem.getTableSpace(), prettyPrint);
        }
    }

    private void appendLobPartitioningStorage(StringBuffer buffer, StorageObject lobObject, Object column, String lobSegName, TableSpaceOracle tableSpace, boolean prettyPrint) {
        CSSBSnapshot.appendStringWithSpace(buffer, "LOB");
        CSSBSnapshot.appendStringWithSpace(buffer, '(');
        if (column instanceof ColumnProxy) {
            CSSBSnapshot.appendStringWithSpace(buffer, this.storageDesign.getFormatedName((ColumnProxy)column));
        } else {
            String columnName = "";
            if (column != null) {
                columnName = column.toString();
            }
            if (columnName.length() > 0) {
                CSSBSnapshot.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnName));
            } else {
                CSSBSnapshot.appendNewLine(buffer, prettyPrint, 0);
                buffer.append("--  ERROR: Lob ");
                buffer.append(lobObject.getName());
                buffer.append(" has no Column specified");
                CDDLFileMaker.incrementErrors();
            }
        }
        CSSBSnapshot.appendStringWithSpace(buffer, ')');
        CSSBSnapshot.appendStringWithSpace(buffer, "STORE AS");
        if (!lobSegName.equalsIgnoreCase("")) {
            CSSBSnapshot.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobSegName));
        } else if (tableSpace == null) {
            CSSBSnapshot.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobObject));
        }
        if (tableSpace != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
            CSSBSnapshot.appendStringWithSpace(buffer, '(');
            CSSBSnapshot.appendStringWithSpace(buffer, "TABLESPACE");
            CSSBSnapshot.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableSpace));
            CSSBSnapshot.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendPermissions(StringBuffer oldbuffer, SnapshotOraclev9i snapshot, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        PermissionsSetOracle permissionsSet = ((StorageDesignOracle)snapshot.getStorageDesign()).getPermissionsSet();
        for (PermissionsOraclev9i permissions : permissionsSet) {
            if (permissions.getSnapshot() == null || !permissions.getSnapshot().equals(snapshot)) continue;
            if (!permissions.getPrivileges().equalsIgnoreCase("")) {
                CSSBSnapshot.appendNewLine(oldbuffer, prettyPrint, 0);
                CSSBSnapshot.appendNewLine(oldbuffer, prettyPrint, 0);
                this.appendComment(oldbuffer, permissions);
                CSSBSnapshot.appendStringWithSpace(buffer, "GRANT");
                CSSBSnapshot.appendStringWithSpace(buffer, permissions.getPrivileges());
                this.appendObject(buffer, permissions);
                this.appendTo(buffer, permissions, this.storageDesign);
                advancedComment = buffer.toString();
                this.appendHierrarchyOption(buffer, permissions);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                CSSBSnapshot.appendNewLine(buffer, prettyPrint, 0);
                buffer.append(';');
                CSSBSnapshot.appendNewLine(buffer, prettyPrint, 0);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
            }
            if (permissions.getPrivilegesWithGrantOption().equalsIgnoreCase("")) continue;
            CSSBSnapshot.appendNewLine(oldbuffer, prettyPrint, 0);
            CSSBSnapshot.appendNewLine(oldbuffer, prettyPrint, 0);
            this.appendComment(oldbuffer, permissions);
            CSSBSnapshot.appendStringWithSpace(buffer, "GRANT");
            CSSBSnapshot.appendStringWithSpace(buffer, permissions.getPrivilegesWithGrantOption());
            this.appendObject(buffer, permissions);
            this.appendTo(buffer, permissions, this.storageDesign);
            advancedComment = buffer.toString();
            this.appendHierrarchyOption(buffer, permissions);
            this.appendGrantOption(buffer, permissions);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CSSBSnapshot.appendNewLine(buffer, prettyPrint, 0);
            buffer.append(';');
            CSSBSnapshot.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
        }
    }

    private void appendObject(StringBuffer buffer, PermissionsOraclev9i permissions) {
        buffer.append(NEWLINE);
        CSSBSnapshot.appendStringWithSpace(buffer, "ON");
        CSSBSnapshot.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(permissions.getSnapshot()));
    }

    private void appendGrantOption(StringBuffer buffer, PermissionsOraclev9i permissions) {
        if (permissions.getRole() == null) {
            CSSBSnapshot.appendStringWithSpace(buffer, "WITH GRANT OPTION");
        }
    }

    private void appendHierrarchyOption(StringBuffer buffer, PermissionsOraclev9i permissions) {
        if ("YES".equalsIgnoreCase(permissions.getHierarchyOption())) {
            buffer.append(NEWLINE);
            CSSBSnapshot.appendStringWithSpace(buffer, "WITH HIERARCHY OPTION");
        }
    }

    static class PossitionComparator
    implements Comparator {
        PossitionComparator() {
        }

        public int compare(Object one, Object two) {
            if (((PartitionOracle)one).getPosition() > ((PartitionOracle)two).getPosition()) {
                return 1;
            }
            if (((PartitionOracle)one).getPosition() < ((PartitionOracle)two).getPosition()) {
                return -1;
            }
            return 0;
        }
    }
}

