/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model;

import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.MDUser;
import oracle.dbtools.crest.model.MDUserFactory;
import oracle.dbtools.crest.swingui.ApplicationView;

public class ObjectChange {
    private MDUser user = MDUserFactory.getInstance().getCurrentUser();
    private long timeStamp = System.currentTimeMillis();
    private String timeString;

    public void setTime(long timeStamp) {
        this.timeStamp = timeStamp;
        this.timeString = null;
    }

    public void setTimeNow() {
        if (!ApplicationView.loading) {
            this.timeStamp = System.currentTimeMillis();
        }
    }

    public long getTime() {
        if (this.timeString != null) {
            this.timeStamp = MDConfiguration.stringToTime(this.timeString);
        }
        return this.timeStamp;
    }

    public String getTimeString() {
        if (this.timeString == null) {
            this.timeString = MDConfiguration.timeToString(this.getTime(), "UTC");
        }
        return this.timeString;
    }

    public String getTimeString(String zone) {
        if (this.timeString != null && "UTC".equals(zone)) {
            return this.timeString;
        }
        return MDConfiguration.timeToString(this.getTime(), zone);
    }

    public boolean setTimeString(String value) {
        this.timeString = value;
        return true;
    }

    public void setUser(MDUser user) {
        this.user = user;
    }

    public MDUser getUser() {
        return this.user;
    }
}

