/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var.process;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.imports.var.process.RHPOSynonyms;
import oracle.dbtools.crest.imports.var.process.RHProcessModelEvents;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Event;
import oracle.dbtools.crest.util.logging.Logger;

public class RHClockEvent
extends RowHandler {
    public static final String OBJECT_TYPE = "CLOCK_EVENT";
    private static final Logger LOGGER = new Logger(RHClockEvent.class);

    public RHClockEvent(Design design, Fields constants, List allSelectedLines, Map allCreatedObjects, List allForeignKeyLines, List allPrimaryKeyLines, Map allReferences, List allColumnLines, List commentLines) {
        super(design, constants, allSelectedLines, allCreatedObjects, allForeignKeyLines, allPrimaryKeyLines, allReferences, allColumnLines, commentLines);
    }

    @Override
    public void read(VarFileLine line) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.addSelectedLine(line);
        } else {
            this.nextRead(line);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(OBJECT_TYPE);
        return list;
    }

    @Override
    public void handle(VarFileLine line, boolean hasMapping) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.createEvent(line);
        } else {
            this.nextHandler(line, hasMapping);
        }
    }

    private void createEvent(VarFileLine line) {
        block26: {
            try {
                DesignObject event;
                String eventID;
                block27: {
                    int value;
                    DataFlowDesign diagram;
                    eventID = this.getField(line, "general_id");
                    String eventName = this.getField(line, "EVENT_NAME");
                    String diagramID = this.getDiagramID(eventID);
                    event = null;
                    if (!"".equalsIgnoreCase(diagramID) && (diagram = (DataFlowDesign)this.getAllCreatedObjects().get(diagramID)) != null) {
                        event = diagram.getProcessModel().createEvent(1);
                    }
                    if (event == null) break block26;
                    event.setName(eventName);
                    String comment = this.getComment(line);
                    event.setComment(comment);
                    ((AbstractProcessObject)event).setSynonym(this.getSynonym(line));
                    event.setNotes(this.getNotes(line, "NOTE_CLOCK_EVENT_ID"));
                    String onDay = this.getField(line, "CLOCK_EVENT_ON_DAY");
                    if (!"0".equalsIgnoreCase(onDay)) {
                        ((Event)event).setOnDay(false);
                        String frequency = this.getField(line, "CLOCK_EVENT_FREQUENCY");
                        try {
                            value = Integer.parseInt(frequency);
                            ((Event)event).setFrequency(value);
                        }
                        catch (NumberFormatException e) {
                            LOGGER.error("Error in RHClockEvent.createEvent()", e);
                        }
                    }
                    String dayOfWeek = this.getField(line, "CLOCK_EVENT_DAY_OF_WEEK");
                    try {
                        value = Integer.parseInt(dayOfWeek);
                        ((Event)event).setDayOfWeek(Event.DAYS_OF_WEEK[value]);
                    }
                    catch (NumberFormatException e) {
                        LOGGER.error("Error in RHClockEvent.createEvent()", e);
                    }
                    String dayOfMonth = this.getField(line, "CLOCK_EVENT_DAY_OF_MONTH");
                    try {
                        int value2 = Integer.parseInt(dayOfMonth);
                        ((Event)event).setDayOfMonth(value2);
                    }
                    catch (NumberFormatException e) {
                        LOGGER.error("Error in RHClockEvent.createEvent()", e);
                    }
                    String month = this.getField(line, "CLOCK_EVENT_MONTH");
                    try {
                        int value3 = Integer.parseInt(month);
                        ((Event)event).setMonths(Event.MONTHS[value3]);
                    }
                    catch (NumberFormatException e) {
                        LOGGER.error("Error in RHClockEvent.createEvent()", e);
                    }
                    String quarter = this.getField(line, "CLOCK_EVENT_QUARTER");
                    try {
                        int value4 = Integer.parseInt(quarter);
                        ((Event)event).setQuarter(value4);
                    }
                    catch (NumberFormatException e) {
                        LOGGER.error("Error in RHClockEvent.createEvent()", e);
                    }
                    String fiscal = this.getField(line, "CLOCK_EVENT_FISCAL");
                    if (!"0".equalsIgnoreCase(fiscal)) {
                        ((Event)event).setFiscal(false);
                    }
                    String year = this.getField(line, "CLOCK_EVENT_YEAR");
                    try {
                        int value5 = Integer.parseInt(year);
                        ((Event)event).setYear(value5);
                    }
                    catch (NumberFormatException e) {
                        LOGGER.error("Error in RHClockEvent.createEvent()", e);
                    }
                    String timesWhenRun = this.getField(line, "CLOCK_EVENT_TIMES_WHEN_RUN");
                    try {
                        int value6 = Integer.parseInt(timesWhenRun);
                        ((Event)event).setTimesWhenRun(value6 + 1);
                        if (value6 != 3) break block27;
                        String atTime = this.getField(line, "CLOCK_EVENT_AT_TIME");
                        if (!"0".equalsIgnoreCase(atTime)) {
                            ((Event)event).setAtTime(true);
                            String timeFreq = this.getField(line, "CLOCK_EVENT_TIME_FREQUENCY");
                            try {
                                int tf = Integer.parseInt(timeFreq);
                                ((Event)event).setTimeFreq(tf);
                            }
                            catch (NumberFormatException e) {
                                LOGGER.error("Error in RHClockEvent.createEvent()", e);
                            }
                        }
                        String hourStr = this.getField(line, "CLOCK_EVENT_HOUR");
                        try {
                            int hour = Integer.parseInt(hourStr);
                            ((Event)event).setHour(hour);
                        }
                        catch (NumberFormatException e) {
                            LOGGER.error("Error in RHClockEvent.createEvent()", e);
                        }
                        String minStr = this.getField(line, "CLOCK_EVENT_MINUTE");
                        try {
                            int min = Integer.parseInt(minStr);
                            ((Event)event).setMinute(min);
                        }
                        catch (NumberFormatException e) {
                            LOGGER.error("Error in RHClockEvent.createEvent()", e);
                        }
                    }
                    catch (NumberFormatException e) {
                        LOGGER.error("Error in RHClockEvent.createEvent()", e);
                    }
                }
                this.addCreatedObject(eventID, event);
                this.removeSelectedLine(line);
            }
            catch (Exception e) {
                LOGGER.error("Error in RHClockEvent.createEvent()", e);
            }
        }
    }

    private String getComment(VarFileLine line) {
        String comment = null;
        String textID = this.getField(line, "EVENT_TEXT_ID");
        if (!"0".equalsIgnoreCase(textID)) {
            VarFileLine commentLine = this.getCommentLine(textID, "ANLTEXT");
            if (commentLine != null) {
                comment = this.getField(commentLine, "TEXT_COMMENT_2");
                this.removeSelectedLine(commentLine);
            }
        } else {
            comment = "";
        }
        return comment;
    }

    private String getDiagramID(String eventID) {
        List pmEvents = this.getSpecificRowHandler(RHProcessModelEvents.class).getOwnLines();
        for (VarFileLine line : pmEvents) {
            if (!line.getType().equalsIgnoreCase("PROCESS_MODELCLOCK") || !eventID.equalsIgnoreCase(this.getField(line, "DESTINATION_OBJECT_ID"))) continue;
            String diagramID = this.getField(line, "general_id");
            return diagramID;
        }
        return "";
    }

    private String getSynonym(VarFileLine line) {
        StringBuffer synonym = new StringBuffer("");
        String id = this.getField(line, "general_id");
        for (VarFileLine selectedLine : this.getSpecificRowHandler(RHPOSynonyms.class).getOwnLines()) {
            VarFileLine synonymLine;
            String synID;
            String lineID;
            if (!selectedLine.getType().equalsIgnoreCase("CLOCK_EVENTSYNONYM") || !id.equalsIgnoreCase(lineID = this.getField(selectedLine, "general_id")) || "0".equalsIgnoreCase(synID = this.getField(selectedLine, "SYNONYM_ID")) || (synonymLine = this.getCommentLine(synID, "SYNONYM_OBJECT")) == null) continue;
            if (synonym.length() > 0) {
                synonym.append(',');
            }
            synonym.append(this.getField(synonymLine, "SYNONYM_OBJ_NAME"));
        }
        return synonym.toString();
    }
}

