/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.udb;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.udb.MOHDatatypeUDB;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.MethodParam;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.storage.udb.MethodParamProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.StructuredTypeProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.MethodProxyUDBv81;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHTypeUDB
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "TYPE";
    private static final Logger LOGGER = new Logger(MOHTypeUDB.class);

    public MOHTypeUDB(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        Iterator it = this.getDesign().getDataTypesDesign().getStructuredTypeSet().iterator();
        StructuredType type = null;
        StorageDesignUDB storage = (StorageDesignUDB)this.getStorageDesign();
        while (it.hasNext()) {
            type = (StructuredType)it.next();
            StructuredTypeProxyUDB proxy = (StructuredTypeProxyUDB)storage.getStructuredTypeProxySet().getProxy(type.getObjectID());
            this.initAttributes(sqlConnection, type, proxy);
            this.initMethods(sqlConnection, type, proxy);
            this.initHierarchyType(sqlConnection, type, proxy);
        }
    }

    private void initAttributes(Connection sqlConnection, StructuredType type, StructuredTypeProxyUDB proxy) throws Exception {
        if (proxy.getSchema() != null) {
            String username = proxy.getSchema().getName();
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("select ");
                buffer.append("ATTR_NAME,ATTR_TYPENAME, ");
                buffer.append("LENGTH, SCALE,TARGET_TYPENAME ");
                buffer.append("from syscat.attributes ");
                buffer.append("where ");
                buffer.append("typeschema = '").append(username).append('\'');
                buffer.append(" and typename = '").append(proxy.getName()).append('\'');
                buffer.append(" and typeschema = source_typeschema");
                buffer.append(" and typename = source_typename");
                buffer.append(" order by ordinal");
                rs = statement.executeQuery(buffer.toString());
            }
            catch (SQLException e) {
                LOGGER.error("MOHTypeUDB.initAttributes():", e);
            }
            if (rs != null) {
                while (rs.next()) {
                    String attrName = rs.getString(1);
                    String typeName = rs.getString(2);
                    int lenght = rs.getInt(3);
                    int scale = rs.getInt(4);
                    String refType = rs.getString(5);
                    TypeElement element = new TypeElement(type.getDesignPart(), type);
                    element.setName(attrName);
                    element.setDesign(type.getDesign());
                    type.add(element);
                    if (typeName != null && !typeName.equalsIgnoreCase("REFERENCE")) {
                        String usedDatatype = StandardDatatypeNames.getUsedDatatypeName(typeName);
                        LogicalDatatype logicalDT = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), usedDatatype);
                        if (logicalDT != null && !usedDatatype.equalsIgnoreCase("UNKNOWN")) {
                            element.setType(logicalDT);
                            if (MOHDatatypeUDB.hasSize(typeName)) {
                                element.setSize(Integer.toString(lenght));
                            } else {
                                if (MOHDatatypeUDB.hasPrecision(typeName)) {
                                    element.setPrecision(lenght);
                                }
                                if (MOHDatatypeUDB.hasScale(typeName)) {
                                    element.setScale(scale);
                                }
                            }
                        } else {
                            StructuredType st = (StructuredType)element.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(typeName);
                            if (st != null) {
                                element.setType(st);
                            } else {
                                DistinctType ct = (DistinctType)element.getDesign().getDataTypesDesign().getDistinctTypeSet().getByName(typeName);
                                if (ct != null) {
                                    element.setType(ct);
                                }
                            }
                        }
                        element.updateReference();
                        continue;
                    }
                    StructuredType st = (StructuredType)element.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(refType);
                    if (st == null) continue;
                    element.setType(st);
                    element.setReference(true);
                    element.updateReference();
                }
                rs.close();
            }
            statement.close();
        }
    }

    private void initMethods(Connection sqlConnection, StructuredType type, StructuredTypeProxyUDB proxy) throws Exception {
        if (proxy.getSchema() != null) {
            String username = proxy.getSchema().getName();
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("select ");
                buffer.append("f.funcname,f.specificname,f.language,f.contains_sql, ");
                buffer.append("f.nullcall,f.parm_style,f.scratchpad,f.fenced,f.final_call, ");
                buffer.append("f.parallelizable,f.dbinfo,f.body,f.remarks,d.typename ");
                buffer.append("from syscat.FUNCTIONS f,syscat.datatypes d ");
                buffer.append("where ");
                buffer.append("method = 'Y' and ");
                buffer.append("effect not in ('MU','OB','CN') and ");
                buffer.append("subject_typeschema  = '").append(username).append('\'');
                buffer.append(" and subject_typename  = '").append(proxy.getName()).append('\'');
                buffer.append(" and  f.return_type = d.typeid");
                rs = statement.executeQuery(buffer.toString());
            }
            catch (SQLException e) {
                LOGGER.error("MOHTypeUDB.initMethods():", e);
            }
            if (rs != null) {
                while (rs.next()) {
                    String name = rs.getString(1);
                    String specificName = rs.getString(2);
                    String language = rs.getString(3);
                    String containsSql = rs.getString(4);
                    String nullCall = rs.getString(5);
                    String paramStyle = rs.getString(6);
                    String scratchpad = rs.getString(7);
                    String fenced = rs.getString(8);
                    String finalCall = rs.getString(9);
                    String parallelizable = rs.getString(10);
                    String dbInfo = rs.getString(11);
                    String sqlBody = rs.getString(12);
                    String comment = rs.getString(13);
                    String returnType = rs.getString(14);
                    Method m = new Method(type.getDesignPart(), type);
                    m.setName(name);
                    m.setDesign(type.getDesign());
                    type.addMethod(m);
                    MethodProxyUDBv81 methodProxy = (MethodProxyUDBv81)proxy.getStorageDesign().getMethodProxySet().getByName(name);
                    if (methodProxy != null) {
                        methodProxy.setSpecificName(specificName);
                        methodProxy.setLanguage(language.trim());
                        if (containsSql.equalsIgnoreCase("CONTAINS SQL")) {
                            methodProxy.setSqlStatementType("CONTAINS SQL");
                        }
                        if ("N".equalsIgnoreCase(nullCall)) {
                            methodProxy.setNullParametersTreatment("RETURNS NULL ON NULL INPUT");
                        }
                        if (paramStyle.equalsIgnoreCase("DB2SQL")) {
                            methodProxy.setExt_R_ParameterStyle("DB2SQL");
                        }
                        if ("Y".equalsIgnoreCase(scratchpad)) {
                            methodProxy.setExt_R_Scratchpad("YES");
                        } else if ("N".equalsIgnoreCase("NO")) {
                            methodProxy.setExt_R_Scratchpad("NO");
                        }
                        if ("N".equalsIgnoreCase(fenced)) {
                            methodProxy.setExt_R_Safeness("NOT FENCED");
                        }
                        if ("Y".equalsIgnoreCase(finalCall)) {
                            methodProxy.setExt_R_FinalCall("YES");
                        }
                        if ("N".equalsIgnoreCase(parallelizable)) {
                            methodProxy.setExt_R_ParallelInvocation("DISALLOW");
                        }
                        if ("Y".equalsIgnoreCase(dbInfo)) {
                            methodProxy.setExt_R_DBInfo("YES");
                        }
                        methodProxy.setSqlMethodBody(sqlBody);
                        methodProxy.setComment(comment);
                    }
                    this.initMethodParam(sqlConnection, m, methodProxy, username);
                    this.initAdditionalMethodParams(sqlConnection, methodProxy, username);
                    this.initMethodResult(m, returnType);
                }
                rs.close();
            }
            statement.close();
        }
    }

    private void initMethodParam(Connection sqlConnection, Method method, MethodProxyUDBv81 methodProxy, String username) throws SQLException {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("select ");
            buffer.append("funcname,as_locator,typename ");
            buffer.append("from syscat.funcparms ");
            buffer.append("where ");
            buffer.append("funcschema = '").append(username).append('\'');
            buffer.append(" and funcname = '").append(methodProxy.getName()).append('\'');
            buffer.append(" and parmname<>'SELF' and rowtype ='P' ");
            buffer.append("order by ordinal");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHTypeUDB.initMethodParam():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                MethodParamProxyUDB paramProxy;
                String name = rs.getString(1);
                String asLocator = rs.getString(2);
                String typeName = rs.getString(3);
                MethodParam param = this.createParam(method, name);
                this.initDataType(param, typeName);
                method.addParameter(param);
                if (!"Y".equalsIgnoreCase(asLocator) || (paramProxy = (MethodParamProxyUDB)methodProxy.getStorageDesign().getMethodParamProxySet().getByName(name)) == null) continue;
                paramProxy.setAsLocator(true);
            }
        }
    }

    private void initAdditionalMethodParams(Connection sqlConnection, MethodProxyUDBv81 methodProxy, String username) throws SQLException {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("select ");
            buffer.append("deterministic ");
            buffer.append("from syscat.procedures ");
            buffer.append("where ");
            buffer.append("procschema = '").append(username).append('\'');
            buffer.append(" and procname = '").append(methodProxy.getName()).append('\'');
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHTypeUDB.initAdditionalMethodParams():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String deterministic = rs.getString(1);
                if (!"Y".equalsIgnoreCase(deterministic)) continue;
                methodProxy.setDeterministic("YES");
            }
        }
    }

    private void initMethodResult(Method m, String returnType) {
        if (returnType != null && !returnType.equals("")) {
            MethodParam param = this.createParam(m, returnType);
            this.initDataType(param, returnType);
            m.setReturnValue(param);
        }
    }

    private MethodParam createParam(Method m, String name) {
        MethodParam param = new MethodParam(m.getDesignPart());
        param.setName(name);
        param.setDesign(m.getDesign());
        return param;
    }

    private void initDataType(MethodParam param, String typeName) {
        String usedDatatype = StandardDatatypeNames.getUsedDatatypeName(typeName);
        LogicalDatatype logicalDT = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), usedDatatype);
        if (logicalDT != null && !usedDatatype.equalsIgnoreCase("UNKNOWN")) {
            param.setType(logicalDT);
        } else {
            StructuredType st = (StructuredType)param.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(typeName);
            if (st != null) {
                param.setType(st);
            }
        }
    }

    private void initHierarchyType(Connection sqlConnection, StructuredType type, StructuredTypeProxyUDB proxy) throws SQLException {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("select ");
            buffer.append("sub_schema,sub_name,super_schema,super_name, ");
            buffer.append("root_schema,root_name ");
            buffer.append("from syscat.HIERARCHIES ");
            buffer.append("where ");
            buffer.append(" root_schema =  '").append(proxy.getSchema()).append('\'');
            buffer.append("  and metatype = 'R'");
            buffer.append(" and sub_name = '").append(proxy.getName()).append("'");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHTypeUDB.initHierarchyType():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String superName = rs.getString(4);
                StructuredType superType = (StructuredType)this.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(superName);
                if (superType == null) continue;
                type.setParentType(superType, false);
            }
            rs.close();
        }
        statement.close();
    }
}

