/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.udb;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.StoredProcedureUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHProcedureUDB
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "PROCEDURE";
    private static final Logger LOGGER = new Logger(MOHProcedureUDB.class);

    public MOHProcedureUDB(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObject dbo = (DBObject)selectedObjects.get(i);
            String name = dbo.getName();
            String schemaName = dbo.getSchema();
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            StoredProcedureUDB proc = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT PROCNAME,SPECIFICNAME,DEFINER, ");
                buffer.append("TEXT_BODY_OFFSET,TEXT definition,REMARKS comment ");
                buffer.append("from syscat.PROCEDURES ");
                buffer.append("WHERE  procschema = '");
                buffer.append(schemaName).append("'");
                buffer.append(" AND PROCNAME ='");
                buffer.append(name).append("'");
                buffer.append(" and SPECIFICNAME = '").append(dbo.getSpecificName()).append("'");
                rs = statement.executeQuery(buffer.toString());
            }
            catch (SQLException e) {
                LOGGER.error("MOHProcedureUDB.generate():", e);
            }
            if (rs != null) {
                while (rs.next()) {
                    StorageDesignUDB storage;
                    StorageDesign storageDesign = this.getStorageDesign();
                    if (storageDesign == null || !(storageDesign instanceof StorageDesignUDB) || (proc = (StoredProcedureUDB)(storage = (StorageDesignUDB)storageDesign).getStoredProcedureSet().getByName(name)) != null && (proc.getSchema() == null || !proc.getSchema().getName().equalsIgnoreCase(schemaName) || proc.getSpecificName().equalsIgnoreCase(dbo.getSpecificName()))) continue;
                    String specificName = rs.getString(2);
                    String body = rs.getString(5);
                    String comment = rs.getString(6);
                    proc = storage.getStoredProcedureSet().createStoredProcedure();
                    proc.setName(name);
                    proc.setBody(body);
                    proc.setSpecificName(specificName);
                    this.stampModelObject(proc, dbo);
                    SchemaUDB schema = (SchemaUDB)storage.getSchemaSet().getByName(schemaName);
                    if (schema != null) {
                        proc.setSchema(schema);
                        proc.setOwner(schema.getOwner());
                    }
                    proc.setCommentInRDBMS(comment);
                }
                rs.close();
            }
            statement.close();
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        for (DBObject dboNext : schemas) {
            if (!dboNext.isSelected()) continue;
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT PROCNAME,SPECIFICNAME, ");
                buffer.append("TEXT_BODY_OFFSET,TEXT definition,REMARKS comment ");
                buffer.append("from syscat.PROCEDURES ");
                buffer.append("WHERE  procschema = '");
                buffer.append(dboNext.getName()).append("'");
                rs = statement.executeQuery(buffer.toString());
            }
            catch (SQLException e) {
                LOGGER.error("MOHProcedureUDB.extract(): " + e.getMessage());
            }
            if (rs != null) {
                while (rs.next()) {
                    String procname = rs.getString(1);
                    String specificName = rs.getString(2);
                    DBObject dboTable = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), procname, OBJECT_TYPE, dboNext.getName(), specificName);
                    list.add(dboTable);
                }
                rs.close();
            }
            statement.close();
        }
        return list;
    }
}

