/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.db2;

import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.datatype.NotStandartDataTypeNames;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.DomainSet;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.LogicalDatatypeFactory;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.DistinctTypeDB2;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateDistinctTypeDB2
extends DDLStatementHandler {
    private DistinctTypeDB2 type;
    private static final String TYPE = "TYPE";
    private static final String ZERO = "0";
    private static final Logger LOGGER = new Logger(SHCreateDistinctTypeDB2.class);

    public SHCreateDistinctTypeDB2(Design design) {
        super(design);
    }

    public SHCreateDistinctTypeDB2(Design design, LogicalDatatypeFactory factoryLogical) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateDistinctTypeDB2.clearCR(line);
        if (Token.startsWithString(statement, "create distinct type")) {
            try {
                this.parseDistinctType(statement.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                this.importLog.addFailedStatement(SHCreateDistinctTypeDB2.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    public void parseDistinctType(String statement) {
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        AbstractStorageDesignDB2 storageDesign = (AbstractStorageDesignDB2)this.design.getStorageDesign(site);
        if (storageDesign != null) {
            this.type = storageDesign.getDistinctTypeSet().createDistinctType();
            if (this.type != null) {
                String name = Token.getTokenAfter(statement, TYPE).trim();
                this.type.setName(name);
                this.design.getRelationalDesign().stampModelObjectDDL(this.type);
                String buildinType = Token.getStringAfter(statement, "AS").trim();
                DomainSet domains = storageDesign.getDesign().getDomainSet();
                Domain dom = (Domain)domains.getByName(name);
                if (dom != null) {
                    if (dom.getDataType().toString().equalsIgnoreCase(buildinType)) {
                        this.type.setDomain(name);
                        this.type.setImplementedDomain(dom);
                    } else {
                        LOGGER.error("Type of domain " + name + " is not " + buildinType);
                        this.importLog.addError("Type of domain " + name + " is not " + buildinType);
                    }
                } else {
                    this.createOneDomain(name, buildinType);
                    dom = (Domain)domains.getByName(name);
                    this.type.setImplementedDomain(dom);
                    this.type.setDomain(name);
                }
                NotStandartDataTypeNames.addNotStandartDataType(name);
                NotStandartDataTypeNames.addNotStandartSynonym(name, buildinType);
            }
        }
    }

    private void createOneDomain(String domainName, String buildinType) {
        String typeForCheck = buildinType;
        int bracketPosition = typeForCheck.indexOf(40);
        if (bracketPosition > -1) {
            typeForCheck = typeForCheck.substring(0, bracketPosition).trim();
        }
        if (this.checkBuildinDatatype(typeForCheck)) {
            Map elements = this.parseBuildinDatatype(buildinType);
            String datatype = (String)elements.get("datatype");
            String[] parameters = new String[]{(String)elements.get("scale"), (String)elements.get("precision"), (String)elements.get("size")};
            if (datatype != null) {
                String usedDatatype = StandardDatatypeNames.getUsedDatatypeName(datatype);
                LogicalDatatype logicalDT = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), usedDatatype);
                DomainSet domSet = this.design.getDomainSet();
                Domain newDomain = domSet.createDomain();
                newDomain.setName(domainName);
                this.design.getRelationalDesign().stampModelObjectDDL(newDomain);
                if (logicalDT != null) {
                    newDomain.setLogicalDatatype(logicalDT);
                } else {
                    LogicalDatatype newLogicDT = this.design.getLogicalDatatypeSet().createLogicalDatatype(null);
                    this.design.getRelationalDesign().stampModelObjectDDL(newLogicDT);
                    newDomain.setLogicalDatatype(newLogicDT);
                }
                newDomain.setFileName(this.design.getFileName());
                newDomain.setDataTypeParameter("size", parameters[2]);
                newDomain.setDataTypeParameter("scale", parameters[1]);
                newDomain.setDataTypeParameter("precision", parameters[0]);
            }
        }
    }

    protected boolean checkBuildinDatatype(String buildinType) {
        String[] names = StandardDatatypeNames.getAllPossibleDatatypes("DB2/390 7");
        for (int number = 0; number < names.length; ++number) {
            if (!names[number].equalsIgnoreCase(buildinType)) continue;
            return true;
        }
        return false;
    }

    private Map parseBuildinDatatype(String buildinType) {
        String datatype;
        HashMap<String, String> mapElementsColumn = new HashMap<String, String>();
        String beforeBracket = buildinType;
        int bracketPosition = buildinType.indexOf(40);
        if (bracketPosition > -1) {
            beforeBracket = buildinType.substring(0, bracketPosition).trim();
        }
        if ((datatype = StandardDatatypeNames.getUsedDatatypeName(beforeBracket)) != null) {
            String params = Token.cutTokenFromFront(buildinType, beforeBracket);
            mapElementsColumn.put("datatype", datatype);
            if (!params.equalsIgnoreCase("")) {
                boolean hasBrackets = Token.hasCloseAndOpenBrackets(params);
                if (hasBrackets) {
                    hasBrackets = Token.getValBeforeBrackets(params).trim().equalsIgnoreCase("");
                }
                if (hasBrackets) {
                    String parameters = Token.getValBetweenBrackets(params, 1);
                    int positionComma = parameters.indexOf(",");
                    if (positionComma != -1) {
                        mapElementsColumn.put("size", ZERO);
                        mapElementsColumn.put("precision", parameters.substring(0, positionComma).trim());
                        mapElementsColumn.put("scale", parameters.substring(positionComma + 1).trim());
                    } else if (datatype.equals("DECIMAL")) {
                        mapElementsColumn.put("size", ZERO);
                        mapElementsColumn.put("scale", ZERO);
                        mapElementsColumn.put("precision", parameters.trim());
                    } else {
                        mapElementsColumn.put("scale", ZERO);
                        mapElementsColumn.put("precision", ZERO);
                        mapElementsColumn.put("size", parameters.trim());
                    }
                }
            }
        } else {
            LOGGER.error("datatype " + buildinType + " is unknown!");
            this.importLog.addError("Datatype " + buildinType + " is unknown");
        }
        return mapElementsColumn;
    }
}

