/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn.commands;

import java.io.File;
import oracle.dbtools.crest.fcp.vcs.VCSClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNHistoryWindow;
import oracle.dbtools.crest.fcp.vcs.svn.SVNStorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNVersionHistoryCommand;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.swingui.ApplicationView;

public class SVNDesignHistoryCommand
extends SVNVersionHistoryCommand {
    public static String COMMAND_ID = "oracle.jdeveloper.subversion.oracle.jdeveloper.vcs.action.HISTORY" + SVNDesignHistoryCommand.class.getName();

    @Override
    public boolean isAvailable() {
        Design design;
        if (this.context != null && (design = VCSClientHelper.getSelectionDesign(this.context.getView())) != null && design.isVersioned()) {
            return true;
        }
        return ApplicationView.getInstance().getCurrentDesign().isVersioned();
    }

    @Override
    protected void init(SVNHistoryWindow svnHistoryWindow) {
        Design design = null;
        if (this.context != null) {
            design = VCSClientHelper.getSelectionDesign(this.context.getView());
        }
        if (design == null) {
            design = ApplicationView.getInstance().getCurrentDesign();
        }
        svnHistoryWindow.setDesign(design);
        svnHistoryWindow.setStorableObjectStatus(new SVNStorableObjectStatus(design));
        svnHistoryWindow.setFilePaths(new File[]{new File(design.getStorageName()), new File(design.getStoragePath())});
    }
}

