/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn.commands;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.crest.fcp.DataModelerAddin;
import oracle.dbtools.crest.fcp.vcs.ChangeListTreePanel;
import oracle.dbtools.crest.fcp.vcs.IChangeListPanel;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.VersioningTreeNode;
import oracle.dbtools.crest.fcp.vcs.svn.SVNChangeListWindow;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNOutgoingChangesChangeList;
import oracle.dbtools.crest.fcp.vcs.svn.commands.DMSVNOperationCommit;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.util.Extension;
import oracle.ide.Context;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Locatable;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSActionInfo;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdeveloper.vcs.vop.VersionOperationSelectTablePanel;
import oracle.jdevimpl.vcs.xspi.ALMCommitContext;
import oracle.jdevimpl.vcs.xspi.XVCSCommandState;
import oracle.jdevimpl.vcs.xspi.XVCSComponents;

public class SVNCommitCommand
extends DMSVNOperationCommit {
    public static final String COMMAND_ID = Extension.isDataModeler() ? "oracle.jdeveloper.subversion.commit" : SVNCommitCommand.class.getName();
    private static final IdeAction ACTION = DataModelerAddin.overrideAction("oracle.jdeveloper.subversion.commit", SVNCommitCommand.class.getName());
    private static final SVNClientHelper SVN_CLIENT_HELPER = SVNClientHelper.getInstance();
    protected VersionOperationSelectTablePanel versionOperationPanel = null;

    public SVNCommitCommand() {
        super(COMMAND_ID);
        this.setProfile(VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.subversion"));
    }

    public static IdeAction getAction() {
        return ACTION;
    }

    protected VCSActionInfo getActionInfo() {
        return this.getProfile().getActionInfo("oracle.jdeveloper.subversion.commit");
    }

    protected boolean isSilent(Context context, VCSProfile profile) {
        return true;
    }

    public boolean isAvailableImpl() {
        ArrayList<VersioningTreeNode> treeNodesForCommit = new ArrayList<VersioningTreeNode>();
        ChangeListTreePanel outgoingChangesPanel = (ChangeListTreePanel)SVNChangeListWindow.getSVNOutgoingChangesChangeList().getPanel();
        if (outgoingChangesPanel.getTree().getSelectionCount() > 0) {
            outgoingChangesPanel.getSelectedFilePaths(treeNodesForCommit, true, true);
            if (treeNodesForCommit.size() == 1 && ((VersioningTreeNode)treeNodesForCommit.get(0)).getStorableObjectStatus().isMissing()) {
                return false;
            }
        }
        return SVN_CLIENT_HELPER.actionsEnabled(SVNChangeListWindow.getSVNOutgoingChangesChangeList(), null, false, false, false, true, true, false, false, false);
    }

    public boolean isAvailable() {
        ArrayList<VersioningTreeNode> treeNodesForCommit = new ArrayList<VersioningTreeNode>();
        SVNOutgoingChangesChangeList outgoingChangesChangeList = SVNChangeListWindow.getSVNOutgoingChangesChangeList();
        this.collectTreeNodes(outgoingChangesChangeList, treeNodesForCommit);
        this.removeMissingAndDeletedDependantNodes(treeNodesForCommit);
        if (treeNodesForCommit.size() > 0) {
            for (int i = 0; i < treeNodesForCommit.size(); ++i) {
                StorableObjectStatus storableObjectStatus = ((VersioningTreeNode)treeNodesForCommit.get(i)).getStorableObjectStatus();
                if (storableObjectStatus.getTextStatus().compareTo("C") != 0) continue;
                return false;
            }
            return true;
        }
        return super.isAvailable();
    }

    protected int doitImpl(VCSProfile vcsProfile) throws Exception {
        if (this.context.getView().getId().equals("FileNavigatorWindow.Files")) {
            return super.doitImpl(vcsProfile);
        }
        SVNOutgoingChangesChangeList outgoingChangesChangeList = SVNChangeListWindow.getSVNOutgoingChangesChangeList();
        ArrayList<VersioningTreeNode> treeNodesForCommit = new ArrayList<VersioningTreeNode>();
        XVCSCommandState state = new XVCSCommandState();
        this.collectTreeNodes(outgoingChangesChangeList, treeNodesForCommit);
        this.removeMissingAndDeletedDependantNodes(treeNodesForCommit);
        Locatable[] nodesForCommit = treeNodesForCommit.toArray(new Locatable[0]);
        state.setLocatables(nodesForCommit);
        boolean res = super.invokeCommand(vcsProfile, (CommandState)state);
        if (res) {
            outgoingChangesChangeList.refresh();
        }
        for (int i = 0; i < treeNodesForCommit.size(); ++i) {
            StorableObject storableObject;
            VersioningTreeNode versioningTreeNode = (VersioningTreeNode)treeNodesForCommit.get(i);
            if (versioningTreeNode.getStorableObjectStatus() == null || (storableObject = versioningTreeNode.getStorableObject()) == null || !(storableObject instanceof ModelIDObject)) continue;
            ((ModelIDObject)storableObject).updateSVNStorableObjectStatus();
        }
        return 0;
    }

    protected void collectTreeNodes(SVNOutgoingChangesChangeList changeList, List<VersioningTreeNode> treeNodes) {
        IChangeListPanel pan = changeList.getPanel();
        if (pan instanceof ChangeListTreePanel) {
            ChangeListTreePanel tpan = (ChangeListTreePanel)pan;
            if (tpan.getSelectedNode() == null) {
                tpan.getAllFilePathsForCommit(treeNodes, true, true);
            } else {
                pan.getSelectedFilePaths(treeNodes, true, true);
            }
        } else {
            pan.getSelectedFilePaths(treeNodes, true, true);
        }
    }

    protected void removeMissingAndDeletedDependantNodes(List<VersioningTreeNode> nodes) {
        for (int i = nodes.size() - 1; i >= 0; --i) {
            VersioningTreeNode node = nodes.get(i);
            StorableObjectStatus storableObjectStatus = node.getStorableObjectStatus();
            if ((!storableObjectStatus.isDeleted() || node.getDependingOn() == null) && !storableObjectStatus.isMissing()) continue;
            nodes.remove(i);
        }
    }

    @Override
    protected void invokeCommit(VCSProfile profile, CommandState state, Map options, IndeterminateProgressMonitor progress) throws Exception {
        if (this.versionOperationPanel != null) {
            state.setLocatables(this.versionOperationPanel.getSelectedLocatables());
        }
        Locatable[] locatables = state.getLocatables();
        ArrayList<File> filePaths = new ArrayList<File>(locatables.length);
        for (Locatable locatable : locatables) {
            File dependantFilePath;
            VersioningTreeNode versioningTreeNode = (VersioningTreeNode)locatable;
            this.findNotAddedParents(versioningTreeNode, filePaths);
            if (!this.isFilePathAdded(filePaths, versioningTreeNode.getFilePath())) {
                filePaths.add(versioningTreeNode.getFilePath());
            }
            if ((dependantFilePath = versioningTreeNode.getDependantFilePath()) == null || this.isFilePathAdded(filePaths, dependantFilePath)) continue;
            filePaths.add(dependantFilePath);
        }
        Collections.sort(filePaths);
        SVN_CLIENT_HELPER.doCommit(filePaths.toArray(new File[0]), (String)options.get("setting_comments"), false, options.get("oracle.jdeveloper.subversion.KEEP_LOCKS") == null ? false : (Boolean)options.get("OPTION_KEEP_LOCKS"));
    }

    @Override
    protected JEWTDialog createOperationDialog(Collection nodes, VCSOptionsCustomizer customizer, CommandState commandState) {
        this.versionOperationPanel = SVN_CLIENT_HELPER.createVersionOperationTablePanel((List)nodes);
        this.setSVNVersionOperationPanel(VCSComponents.createSelectFileListerComponent((Collection)nodes));
        return XVCSComponents.createCommitOperationDialog((Component)VCSWindowUtils.getCurrentWindow(), (String)this.getDialogTitle(), (String)this.getDialogHint(), (Component)this.versionOperationPanel, (VCSOptionsCustomizer)customizer, (String)this.getHelpTopicId(), (ALMCommitContext)((XVCSCommandState)commandState).getALMCommitContext());
    }

    public void findNotAddedParents(VersioningTreeNode versioningTreeNode, List<File> notAddedParentFilePaths) {
        StorableObjectStatus storableObjectStatus = versioningTreeNode.getStorableObjectStatus();
        if (storableObjectStatus != null && "A".equals(storableObjectStatus.getTextStatus())) {
            this.findNotAddedParents(versioningTreeNode.getFilePath(), notAddedParentFilePaths);
        }
    }

    public void findNotAddedParents(File filePath, List<File> filePaths) {
        File parentFilePath = filePath.getParentFile();
        if (SVN_CLIENT_HELPER.isVersioned(parentFilePath) && SVN_CLIENT_HELPER.getLastChangedRevision(parentFilePath) <= 0L) {
            if (!this.isFilePathAdded(filePaths, parentFilePath)) {
                filePaths.add(parentFilePath);
            }
            this.findNotAddedParents(parentFilePath, filePaths);
        }
    }

    private boolean isFilePathAdded(List<File> filePaths, File dependantFilePath) {
        for (File listFile : filePaths) {
            if (!listFile.getAbsolutePath().equalsIgnoreCase(dependantFilePath.getAbsolutePath())) continue;
            return true;
        }
        return false;
    }
}

