/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.dbtools.crest.fcp.preferences.AbstractPP;
import oracle.dbtools.crest.fcp.preferences.ModelRelationalPreferences;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.util.Messages;
import oracle.ide.panels.TraversableContext;

final class ModelRelationalPP
extends AbstractPP {
    private JRadioButton rbDeleteFKcolumns;
    private JRadioButton rbNotDeleteFKcolumns;
    private JRadioButton rbAskBeforeDelete;
    private JComboBox defaultFKRule;
    private JCheckBox chbColumnsReorder;
    private JCheckBox chbSyncRemoteObjectsOnLoad;
    private JCheckBox chbUseSourceConnection;
    private JCheckBox chbUseSourceSchema;
    private JCheckBox chbUseSourceObject;
    private JCheckBox chbSyncWholeSchema;
    private final List modelArray = new ArrayList();
    private ButtonGroup group;
    private JTextField tfLogicalDatatype;
    private JTextField tfLogicalDatatypePrecision;
    private JComboBox cbDomain;

    public ModelRelationalPP() {
        this.setHelpID("MODEL_RELATIONAL_PREFS_PANEL");
        JPanel pnTop = new JPanel(new GridBagLayout());
        pnTop.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.DeleteFKColumnsStrategy")));
        this.group = new ButtonGroup();
        this.rbDeleteFKcolumns = new JRadioButton(Messages.getString("OptionsDialog.DeleteGenerateFKColumns"));
        this.addItem(pnTop, this.rbDeleteFKcolumns, 0, 0, 1, 1, 17, 1, 100);
        this.group.add(this.rbDeleteFKcolumns);
        this.modelArray.add(this.rbDeleteFKcolumns.getModel());
        this.rbNotDeleteFKcolumns = new JRadioButton(Messages.getString("OptionsDialog.DoNotDeleteGenerateFKColumns"));
        this.addItem(pnTop, this.rbNotDeleteFKcolumns, 0, 1, 1, 1, 17, 1, 100);
        this.group.add(this.rbNotDeleteFKcolumns);
        this.modelArray.add(this.rbNotDeleteFKcolumns.getModel());
        this.rbAskBeforeDelete = new JRadioButton(Messages.getString("OptionsDialog.AskBeforeDelete"));
        this.addItem(pnTop, this.rbAskBeforeDelete, 0, 2, 1, 1, 17, 1, 100);
        this.group.add(this.rbAskBeforeDelete);
        this.modelArray.add(this.rbAskBeforeDelete.getModel());
        JPanel jpanel2 = new JPanel(new GridLayout(3, 1));
        JPanel jpanel = new JPanel(new FlowLayout(0));
        JLabel label = new JLabel(Messages.getString("OptionsDialog.DefaultForeignKeyDeleteRule"));
        jpanel.add(label);
        this.defaultFKRule = new JComboBox<String>(FKIndexAssociation.DELETE_RULES);
        jpanel.add(this.defaultFKRule);
        this.setBG(this.defaultFKRule);
        jpanel2.add(jpanel);
        this.chbColumnsReorder = new JCheckBox(Messages.getString("OptionsDialog.AllowChangInColumnOrder"));
        jpanel2.add(this.chbColumnsReorder);
        this.chbSyncRemoteObjectsOnLoad = new JCheckBox(Messages.getString("OptionsDialog.SyncRemoteObjectsOnLoad"));
        jpanel2.add(this.chbSyncRemoteObjectsOnLoad);
        JPanel sKeyDTPanel = new JPanel(new GridLayout(3, 1));
        sKeyDTPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ModelRelationallPP.SurrColumnDataType")));
        JLabel lLogicalDatatype = new JLabel(Messages.getString("ModelRelationallPP.LDT"));
        lLogicalDatatype.setPreferredSize(new Dimension(110, 20));
        this.tfLogicalDatatype = new JTextField("NUMERIC");
        this.tfLogicalDatatype.setPreferredSize(new Dimension(60, 20));
        this.tfLogicalDatatype.setEnabled(false);
        JLabel lLogicalDatatypePrecision = new JLabel(Messages.getString("ModelRelationallPP.Precision"));
        lLogicalDatatypePrecision.setPreferredSize(new Dimension(110, 20));
        this.tfLogicalDatatypePrecision = new JTextField();
        this.tfLogicalDatatypePrecision.setPreferredSize(new Dimension(40, 20));
        JLabel lDomain = new JLabel(Messages.getString("ModelRelationallPP.Scale"));
        lDomain.setPreferredSize(new Dimension(110, 20));
        this.cbDomain = new JComboBox();
        this.cbDomain.addItem(" ");
        Iterator allDomainsIt = this.getCurrentDesign().getDomainSet().iterator();
        while (allDomainsIt.hasNext()) {
            this.cbDomain.addItem(allDomainsIt.next());
        }
        this.cbDomain.setSelectedIndex(0);
        this.cbDomain.setPreferredSize(new Dimension(120, 20));
        JPanel jp1 = new JPanel(new FlowLayout(0));
        jp1.add(lLogicalDatatype);
        jp1.add(this.tfLogicalDatatype);
        sKeyDTPanel.add(jp1);
        JPanel jp2 = new JPanel(new FlowLayout(0));
        jp2.add(lLogicalDatatypePrecision);
        jp2.add(this.tfLogicalDatatypePrecision);
        sKeyDTPanel.add(jp2);
        JPanel jp3 = new JPanel(new FlowLayout(0));
        jp3.add(lDomain);
        jp3.add(this.cbDomain);
        sKeyDTPanel.add(jp3);
        JPanel syncDBPanel = new JPanel(new GridLayout(4, 1));
        syncDBPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ModelRelationallPP.DBSync")));
        this.chbUseSourceConnection = new JCheckBox(Messages.getString("ModelRelationallPP.UseSrcConnection"));
        syncDBPanel.add(this.chbUseSourceConnection);
        this.chbUseSourceSchema = new JCheckBox(Messages.getString("ModelRelationallPP.UseSrcSchema"));
        syncDBPanel.add(this.chbUseSourceSchema);
        this.chbUseSourceObject = new JCheckBox(Messages.getString("ModelRelationallPP.UseSrcObject"));
        syncDBPanel.add(this.chbUseSourceObject);
        this.chbSyncWholeSchema = new JCheckBox(Messages.getString("ModelRelationallPP.SyncWholeSchema"));
        syncDBPanel.add(this.chbSyncWholeSchema);
        this.add(pnTop, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, -1));
        this.add(jpanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, -1));
        this.add(sKeyDTPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, -1));
        this.add(syncDBPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 0, -1));
    }

    public void onEntry(TraversableContext tc) {
        this.defaultFKRule.setSelectedItem(settings.getDefaultFKDeleteRule());
        this.group.setSelected((ButtonModel)this.modelArray.get(settings.getDeleteFKColumnStrategy()), true);
        this.chbColumnsReorder.setSelected(settings.isDefaultAllowColumnsReorder());
        this.chbSyncRemoteObjectsOnLoad.setSelected(settings.isSyncRemoteObjectsOnLoad());
        this.tfLogicalDatatypePrecision.setText(settings.getSurrogateKeyLDTPrecision());
        this.cbDomain.setSelectedItem(settings.getSurrogateKeyDomain());
        this.chbUseSourceConnection.setSelected(settings.isUseDBSyncSourceConnection());
        this.chbUseSourceSchema.setSelected(settings.isUseDBSyncSourceSchema());
        this.chbUseSourceObject.setSelected(settings.isUseDBSyncSourceObject());
        this.chbSyncWholeSchema.setSelected(settings.isSyncWholeSchema());
    }

    public void onExit(TraversableContext tc) {
        settings.setDefaultFKDeleteRule((String)this.defaultFKRule.getSelectedItem());
        settings.setDeleteFKColumnStrategy(this.modelArray.indexOf(this.group.getSelection()));
        settings.setDefaultAllowColumnsReorder(this.chbColumnsReorder.isSelected());
        settings.setSyncRemoteObjectsOnLoad(this.chbSyncRemoteObjectsOnLoad.isSelected());
        settings.setSurrogateKeyLDTPrecision(this.tfLogicalDatatypePrecision.getText());
        if (this.cbDomain.getSelectedItem() instanceof Domain) {
            settings.setSurrogateKeyDomain(((Domain)this.cbDomain.getSelectedItem()).getObjectID());
        } else {
            settings.setSurrogateKeyDomain(" ");
        }
        settings.setUseDBSyncSourceConnection(this.chbUseSourceConnection.isSelected());
        settings.setUseDBSyncSourceSchema(this.chbUseSourceSchema.isSelected());
        settings.setUseDBSyncSourceObject(this.chbUseSourceObject.isSelected());
        settings.setSyncWholeSchema(this.chbSyncWholeSchema.isSelected());
        ModelRelationalPreferences preferences = this.getModelRelationalPreferences(tc);
        preferences.setDefaultFKDeleteRule((String)this.defaultFKRule.getSelectedItem());
        preferences.setDeleteFKColumnStrategy(this.modelArray.indexOf(this.group.getSelection()));
        preferences.setAllowColumnsReorder(this.chbColumnsReorder.isSelected());
        preferences.setSyncRemoteObjectsOnLoad(this.chbSyncRemoteObjectsOnLoad.isSelected());
        preferences.setSurrogateKeyLDTPrecision(this.tfLogicalDatatypePrecision.getText());
        if (this.cbDomain.getSelectedItem() instanceof Domain) {
            preferences.setSurrogateKeyDomain((Domain)this.cbDomain.getSelectedItem());
        } else {
            preferences.setSurrogateKeyDomain(" ");
        }
        preferences.setUseDBSyncSourceConnection(this.chbUseSourceConnection.isSelected());
        preferences.setUseDBSyncSourceSchema(this.chbUseSourceSchema.isSelected());
        preferences.setUseDBSyncSourceObject(this.chbUseSourceObject.isSelected());
        preferences.setSyncWholeSchema(this.chbSyncWholeSchema.isSelected());
    }

    private ModelRelationalPreferences getModelRelationalPreferences(TraversableContext tc) {
        return ModelRelationalPreferences.getInstance(tc.getPropertyStorage());
    }
}

