/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.process.ExternalData;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.process.RecordStructure;

public class RSRecordStructures
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<RecordStructure> list = new ArrayList<RecordStructure>(1000);
        int count = 0;
        ArrayList<RecordStructure> rsCollection = new ArrayList<RecordStructure>();
        String query = "INSERT INTO DMRS_RECORD_STRUCTURES (Record_Structure_ID, Record_Structure_OVID, Record_Structure_Name, Model_ID, Model_OVID, Model_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        ProcessModel processModel = design.getProcessModel();
        Iterator it = processModel.getRecordStructureSet().iterator();
        while (it.hasNext()) {
            RecordStructure rec2 = (RecordStructure)it.next();
            String recOVID = RSRecordStructures.getOrCreateOVID(map, rec2.getObjectID());
            rsCollection.add(rec2);
            stmt.setString(1, rec2.getObjectID());
            stmt.setString(2, recOVID);
            stmt.setString(3, rec2.getName());
            stmt.setString(4, processModel.getObjectID());
            stmt.setString(5, (String)map.get(processModel.getObjectID()));
            stmt.setString(6, processModel.getName());
            stmt.setString(7, (String)map.get(design.getObjectID()));
            stmt.addBatch();
            list.add(rec2);
            if (++count != 1000) continue;
            count = 0;
            stmt.executeBatch();
            for (RecordStructure rec2 : list) {
                RSObjectNotes.export(map, connection, rec2);
                RSComments.export(map, connection, rec2);
                RSDynamicProperties.export(design, map, connection, rec2);
            }
            list.clear();
        }
        RSRecordStructures.exportRelationships(map, connection, rsCollection, design);
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
            for (RecordStructure rec : list) {
                RSObjectNotes.export(map, connection, rec);
                RSComments.export(map, connection, rec);
                RSDynamicProperties.export(design, map, connection, rec);
            }
            list.clear();
        }
        stmt.close();
        stmt = null;
    }

    private static void exportRelationships(Map map, Connection connection, List structures, Design design) throws Exception {
        int count = 0;
        String dataQuery = "INSERT INTO DMRS_RECORD_STRUCT_EXT_DATAS (Record_Structure_ID, Record_Structure_OVID, Record_Structure_Name, External_Data_ID, External_Data_OVID, External_Data_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement dataStmt = connection.prepareStatement(dataQuery);
        for (RecordStructure rec : structures) {
            for (ExternalData data : rec.getExtDatas()) {
                String dataOVID = (String)map.get(data.getObjectID());
                dataStmt.setString(1, rec.getObjectID());
                dataStmt.setString(2, (String)map.get(rec.getObjectID()));
                dataStmt.setString(3, rec.getName());
                dataStmt.setString(4, data.getObjectID());
                dataStmt.setString(5, dataOVID);
                dataStmt.setString(6, data.getName());
                dataStmt.setString(7, (String)map.get(design.getObjectID()));
                dataStmt.addBatch();
                if (++count != 1000) continue;
                count = 0;
                dataStmt.executeBatch();
            }
        }
        if (count > 0) {
            count = 0;
            dataStmt.executeBatch();
        }
        dataStmt.close();
        dataStmt = null;
    }
}

