/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.util.GUID;

public class RSDesign
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection, String comments) throws Exception {
        String ovid = new GUID().toString();
        map.put(design.getObjectID(), ovid);
        String query = "INSERT INTO DMRS_Designs (Design_ID, Design_OVID, Design_Name, Date_Published, Published_By, Persistence_Version, Version_Comments) VALUES (?, ?, ?, sysdate, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        stmt.setString(1, design.getObjectID());
        stmt.setString(2, ovid);
        stmt.setString(3, design.getName());
        stmt.setString(4, System.getProperty("user.name"));
        stmt.setFloat(5, 1.6f);
        stmt.setString(6, comments);
        stmt.executeUpdate();
        stmt.close();
        stmt = null;
        RSObjectNotes.export(map, connection, design);
        RSComments.export(map, connection, design);
    }
}

