/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v81;

import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.v81.InstanceUDBv81;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBInstanceUDBv81
extends AbstractSSBUDB {
    public static final String AUTHENTICATION_TYPE = "-a";
    public static final String PORT_NAME = "-p";
    public static final String TYPE = "-s";
    public static final String WORD_WIDTH = "-w";
    public static final String FENCED_ID = "-u";
    public static final String USER_NAME = "-u";
    public static final String PROFILE_PATH = "-p";
    public static final String CLUSTER_NAME = "-c";
    public static final String HOST_NAME = "-h";
    public static final String PORT_RANGE = "-r";
    public static final String CREATE_INSTANCE = "DB2ICRT";
    private StorageDesign storageDesign;

    @Override
    public boolean canHandle(Object object) {
        return object instanceof InstanceUDBv81 && ((InstanceUDBv81)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        InstanceUDBv81 instance = (InstanceUDBv81)object;
        this.storageDesign = instance.getStorageDesign();
        if (instance.getOperatingSystem().equalsIgnoreCase("Windows Based")) {
            this.appendForWindowsBasedSystems(buffer, instance, prettyPrint);
        }
        if (instance.getOperatingSystem().equalsIgnoreCase("OS/2 Based")) {
            this.appendForWindowsBasedSystems(buffer, instance, prettyPrint);
        }
        if (instance.getOperatingSystem().equalsIgnoreCase("Unix Based")) {
            this.appendForUnixBasedSystems(buffer, instance, prettyPrint);
        }
    }

    protected void appendForWindowsBasedSystems(StringBuffer buffer, InstanceUDBv81 instance, boolean prettyPrint) {
        this.appendCreate(buffer);
        this.appendType(buffer, instance, prettyPrint);
        this.appendUserName(buffer, instance, prettyPrint);
        this.appendProfilePath(buffer, instance, prettyPrint);
        this.appendClusterName(buffer, instance, prettyPrint);
        this.appendHostName(buffer, instance, prettyPrint);
        this.appendPortRange(buffer, instance, prettyPrint);
        SSBInstanceUDBv81.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(instance.getName()));
        SSBInstanceUDBv81.appendNewLine(buffer, prettyPrint, 0);
        this.appendLineFinisher(buffer, prettyPrint);
        DDLFileMaker.incrementCreateInstance();
    }

    protected void appendForUnixBasedSystems(StringBuffer buffer, InstanceUDBv81 instance, boolean prettyPrint) {
        this.appendCreate(buffer);
        this.appendAuthenticationType(buffer, instance, prettyPrint);
        this.appendPortName(buffer, instance, prettyPrint);
        this.appendType(buffer, instance, prettyPrint);
        this.appendWordWidth(buffer, instance, prettyPrint);
        this.appendFencedId(buffer, instance, prettyPrint);
        SSBInstanceUDBv81.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(instance.getName()));
        SSBInstanceUDBv81.appendNewLine(buffer, prettyPrint, 0);
        this.appendLineFinisher(buffer, prettyPrint);
    }

    protected void appendAuthenticationType(StringBuffer buffer, InstanceUDBv81 instance, boolean prettyPrint) {
        if (!instance.getAuthenticationType().equalsIgnoreCase("")) {
            SSBInstanceUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBInstanceUDBv81.appendStringWithSpace(buffer, AUTHENTICATION_TYPE);
            SSBInstanceUDBv81.appendStringWithSpace(buffer, instance.getAuthenticationType());
        }
    }

    protected void appendPortName(StringBuffer buffer, InstanceUDBv81 instance, boolean prettyPrint) {
        if (!instance.getPortName().equalsIgnoreCase("")) {
            SSBInstanceUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBInstanceUDBv81.appendStringWithSpace(buffer, "-p");
            SSBInstanceUDBv81.appendStringWithSpace(buffer, instance.getPortName());
        }
    }

    protected void appendType(StringBuffer buffer, InstanceUDBv81 instance, boolean prettyPrint) {
        if (!instance.getType().equalsIgnoreCase("")) {
            SSBInstanceUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBInstanceUDBv81.appendStringWithSpace(buffer, TYPE);
            SSBInstanceUDBv81.appendStringWithSpace(buffer, instance.getType());
        }
    }

    protected void appendWordWidth(StringBuffer buffer, InstanceUDBv81 instance, boolean prettyPrint) {
        if (instance.getWordWidth() > 0) {
            SSBInstanceUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBInstanceUDBv81.appendStringWithSpace(buffer, WORD_WIDTH);
            this.appendStringWithSpace(buffer, instance.getWordWidth());
        }
    }

    protected void appendFencedId(StringBuffer buffer, InstanceUDBv81 instance, boolean prettyPrint) {
        if (!instance.getFencedId().equalsIgnoreCase("")) {
            SSBInstanceUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBInstanceUDBv81.appendStringWithSpace(buffer, "-u");
            SSBInstanceUDBv81.appendStringWithSpace(buffer, instance.getFencedId());
        }
    }

    protected void appendUserName(StringBuffer buffer, InstanceUDBv81 instance, boolean prettyPrint) {
        if (!instance.getUserName().equalsIgnoreCase("")) {
            SSBInstanceUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBInstanceUDBv81.appendStringWithSpace(buffer, "-u");
            SSBInstanceUDBv81.appendString(buffer, instance.getUserName());
            this.appendComma(buffer);
            SSBInstanceUDBv81.appendStringWithSpace(buffer, instance.getPassword());
        }
    }

    protected void appendProfilePath(StringBuffer buffer, InstanceUDBv81 instance, boolean prettyPrint) {
        if (!instance.getProfilePath().equalsIgnoreCase("")) {
            SSBInstanceUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBInstanceUDBv81.appendStringWithSpace(buffer, "-p");
            SSBInstanceUDBv81.appendStringWithSpace(buffer, instance.getProfilePath());
        }
    }

    protected void appendClusterName(StringBuffer buffer, InstanceUDBv81 instance, boolean prettyPrint) {
        if (!instance.getClusterName().equalsIgnoreCase("")) {
            SSBInstanceUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBInstanceUDBv81.appendStringWithSpace(buffer, CLUSTER_NAME);
            SSBInstanceUDBv81.appendStringWithSpace(buffer, instance.getClusterName());
        }
    }

    protected void appendHostName(StringBuffer buffer, InstanceUDBv81 instance, boolean prettyPrint) {
        if (!instance.getHostName().equalsIgnoreCase("")) {
            SSBInstanceUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBInstanceUDBv81.appendStringWithSpace(buffer, HOST_NAME);
            SSBInstanceUDBv81.appendStringWithSpace(buffer, instance.getHostName());
        }
    }

    protected void appendPortRange(StringBuffer buffer, InstanceUDBv81 instance, boolean prettyPrint) {
        if (!instance.getPortRange().equalsIgnoreCase("")) {
            SSBInstanceUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBInstanceUDBv81.appendStringWithSpace(buffer, PORT_RANGE);
            SSBInstanceUDBv81.appendStringWithSpace(buffer, instance.getPortRange());
        }
    }
}

