/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v81;

import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.AliasUDBv81;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBAliasUDBv81
extends AbstractSSBUDB {
    private StorageDesignUDB storageDesign;

    @Override
    public boolean canHandle(Object object) {
        return object instanceof AliasUDBv81 && ((AliasUDBv81)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        AliasUDBv81 alias = (AliasUDBv81)object;
        this.storageDesign = (StorageDesignUDB)this.getStorageDesign(object);
        this.appendComment(buffer, alias);
        this.appendCreate(buffer, alias);
        this.appendReferencedObject(buffer, alias, prettyPrint);
        SSBAliasUDBv81.appendNewLine(buffer, prettyPrint, 0);
        this.appendLineFinisher(buffer, prettyPrint);
        DDLFileMaker.incrementCreateAlias();
        if (alias.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
            this.appendCommentOn(buffer, alias, prettyPrint);
        }
    }

    private void appendCommentOn(StringBuffer buffer, AliasUDBv81 alias, boolean prettyPrint) {
        SSBAliasUDBv81.appendNewLine(buffer, prettyPrint, 0);
        SSBAliasUDBv81.appendStringWithSpace(buffer, "COMMENT ON");
        SSBAliasUDBv81.appendStringWithSpace(buffer, "ALIAS");
        SSBAliasUDBv81.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(alias.getLongNameDDL()));
        SSBAliasUDBv81.appendStringWithSpace(buffer, "IS");
        SSBAliasUDBv81.appendString(buffer, '\'');
        SSBAliasUDBv81.appendString(buffer, alias.getCommentInRDBMS());
        SSBAliasUDBv81.appendStringWithSpace(buffer, '\'');
        SSBAliasUDBv81.appendNewLine(buffer, prettyPrint, 0);
        this.appendLineFinisher(buffer, prettyPrint);
    }

    protected void appendCreate(StringBuffer buffer, AliasUDBv81 alias) {
        this.appendCreate(buffer);
        SSBAliasUDBv81.appendStringWithSpace(buffer, "ALIAS");
        SSBAliasUDBv81.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(alias.getLongNameDDL()));
    }

    protected void appendReferencedObject(StringBuffer buffer, AliasUDBv81 alias, boolean prettyPrint) {
        if (alias.getReferencedObject() != null) {
            SSBAliasUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBAliasUDBv81.appendStringWithSpace(buffer, "FOR");
            SSBAliasUDBv81.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(alias.getReferencedObject().getLongNameDDL()));
        }
    }
}

