/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb;

import oracle.dbtools.crest.exports.ddl.AbstractSSBDB2;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.udb.FKProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBDropFKUDB
extends AbstractSSBDB2 {
    @Override
    public boolean canHandle(Object object) {
        FKIndexAssociation fk;
        return object instanceof Index && ((Index)object).isFK() ? (fk = ((Index)object).getFKAssociation()).isDropEnabled() && !fk.shouldBeDroppedIndirectly() : object instanceof FKProxyUDB && ((FKProxyUDB)object).isDropEnabled() && !((FKProxyUDB)object).shouldBeDroppedIndirectly();
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        FKProxyUDB indp;
        if (object == null) {
            return;
        }
        if (object instanceof Index) {
            FKIndexAssociation fkassociation = ((Index)object).getFKAssociation();
            if (fkassociation.getRemoteTable() instanceof Table) {
                StorageDesignUDB storageDesign = (StorageDesignUDB)this.getStorageDesign(object);
                SSBDropFKUDB.appendStringWithSpace(buffer, "ALTER");
                SSBDropFKUDB.appendStringWithSpace(buffer, "TABLE");
                SSBDropFKUDB.appendStringWithSpace(buffer, storageDesign.getFormatedName(fkassociation.getTable().getName()));
                SSBDropFKUDB.appendNewLine(buffer, prettyPrint, 1);
                this.appendDrop(buffer);
                SSBDropFKUDB.appendStringWithSpace(buffer, "FOREIGN KEY");
                SSBDropFKUDB.appendStringWithSpace(buffer, storageDesign.getFormatedName(fkassociation.getName()));
                SSBDropFKUDB.appendNewLine(buffer, prettyPrint, 0);
                this.appendLineFinisher(buffer, prettyPrint);
                DDLFileMaker.incrementAlterTable();
            }
        } else if (object instanceof FKProxyUDB && (indp = (FKProxyUDB)object).getFKTable() instanceof Table) {
            StorageDesignUDB storageDesign = (StorageDesignUDB)this.getStorageDesign(object);
            SSBDropFKUDB.appendStringWithSpace(buffer, "ALTER");
            SSBDropFKUDB.appendStringWithSpace(buffer, "TABLE");
            SSBDropFKUDB.appendStringWithSpace(buffer, storageDesign.getFormatedName(indp.getTableProxy().getLongNameDDL()));
            SSBDropFKUDB.appendNewLine(buffer, prettyPrint, 1);
            this.appendDrop(buffer);
            SSBDropFKUDB.appendStringWithSpace(buffer, "FOREIGN KEY");
            SSBDropFKUDB.appendStringWithSpace(buffer, storageDesign.getFormatedName(indp.getLongNameDDL()));
            SSBDropFKUDB.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            DDLFileMaker.incrementAlterTable();
        }
    }
}

