/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver.v2k5;

import java.util.Iterator;
import java.util.StringTokenizer;
import oracle.dbtools.crest.exports.ddl.sqlserver.AbstractSSBSqlServer;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.IndexOnViewSqlServerv2k5;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBIndexOnViewSqlServerv2k5
extends AbstractSSBSqlServer {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        IndexOnViewSqlServerv2k5 index = (IndexOnViewSqlServerv2k5)object;
        this.storageDesign = index.getStorageDesign();
        this.appendComment(buffer, index);
        TableView tv = (TableView)index.getView().getObject();
        if (tv.getColumns().length > 0) {
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, "CREATE");
            this.appendUnique(buffer, index);
            this.appendClustered(buffer, index);
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, "INDEX");
            SSBIndexOnViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(index.getName()));
            this.appendView(buffer, index, prettyPrint);
            this.appendOptions(buffer, index, prettyPrint);
            this.appendFilegroup(buffer, index, prettyPrint);
            SSBIndexOnViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, "GO");
            SSBIndexOnViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            DDLFileMaker.incrementCreateIndexOnView();
            if (index.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                this.appendIndexOnViewComment(buffer, index, prettyPrint);
            }
            this.appendExtProperties(buffer, index, prettyPrint);
        } else {
            SSBIndexOnViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBIndexOnViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            buffer.append("-- Index ").append(index.getName()).append(" on View ").append(index.getView().getName()).append(" not created in ddl");
            DDLFileMaker.incrementErrors();
            SSBIndexOnViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
        }
    }

    protected void appendIndexOnViewComment(StringBuffer buffer, IndexOnViewSqlServerv2k5 index, boolean prettyPrint) {
        String comment = index.getCommentInRDBMS();
        if (comment != null && !comment.trim().equalsIgnoreCase("")) {
            SSBIndexOnViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBIndexOnViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBIndexOnViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, "EXEC");
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, "sp_addextendedproperty");
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, "'MS_Description'");
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, ',');
            SSBIndexOnViewSqlServerv2k5.appendString(buffer, '\'');
            SSBIndexOnViewSqlServerv2k5.appendString(buffer, comment);
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, '\'');
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, ',');
            if (index != null && index.getView().getSchema() != null) {
                SSBIndexOnViewSqlServerv2k5.appendString(buffer, '\'');
                SSBIndexOnViewSqlServerv2k5.appendString(buffer, "SCHEMA");
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, ',');
                SSBIndexOnViewSqlServerv2k5.appendString(buffer, '\'');
                SSBIndexOnViewSqlServerv2k5.appendString(buffer, index.getView().getSchema().getName());
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, ',');
            } else if (index != null && index.getView().getUser() != null) {
                SSBIndexOnViewSqlServerv2k5.appendString(buffer, '\'');
                SSBIndexOnViewSqlServerv2k5.appendString(buffer, "USER");
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, ',');
                SSBIndexOnViewSqlServerv2k5.appendString(buffer, '\'');
                SSBIndexOnViewSqlServerv2k5.appendString(buffer, index.getView().getUser().getName());
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, ',');
            } else {
                SSBIndexOnViewSqlServerv2k5.appendString(buffer, '\'');
                SSBIndexOnViewSqlServerv2k5.appendString(buffer, "USER");
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, ',');
                SSBIndexOnViewSqlServerv2k5.appendString(buffer, '\'');
                SSBIndexOnViewSqlServerv2k5.appendString(buffer, "dbo");
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, ',');
            }
            SSBIndexOnViewSqlServerv2k5.appendString(buffer, '\'');
            SSBIndexOnViewSqlServerv2k5.appendString(buffer, "VIEW");
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, '\'');
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, ',');
            SSBIndexOnViewSqlServerv2k5.appendString(buffer, '\'');
            SSBIndexOnViewSqlServerv2k5.appendString(buffer, index.getLongNameDDL());
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, '\'');
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, ',');
            SSBIndexOnViewSqlServerv2k5.appendString(buffer, '\'');
            SSBIndexOnViewSqlServerv2k5.appendString(buffer, "INDEX");
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, '\'');
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, ',');
            SSBIndexOnViewSqlServerv2k5.appendString(buffer, '\'');
            SSBIndexOnViewSqlServerv2k5.appendString(buffer, index.getName());
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, '\'');
            SSBIndexOnViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBIndexOnViewSqlServerv2k5.appendString(buffer, "GO");
            SSBIndexOnViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
        }
    }

    private void appendUnique(StringBuffer buffer, IndexOnViewSqlServerv2k5 index) {
        if (index.getUnique().equalsIgnoreCase("YES")) {
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, "UNIQUE");
        }
    }

    private void appendClustered(StringBuffer buffer, IndexOnViewSqlServerv2k5 index) {
        if (index.getClustered().equalsIgnoreCase("YES")) {
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, "CLUSTERED");
        } else {
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, "NONCLUSTERED");
        }
    }

    private void appendView(StringBuffer buffer, IndexOnViewSqlServerv2k5 index, boolean prettyPrint) {
        SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, "ON");
        SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(index.getView().getName()));
        SSBIndexOnViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
        SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, '(');
        SSBIndexOnViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
        TableView tv = (TableView)index.getView().getObject();
        Iterator it = index.getColSet().iterator();
        boolean first = true;
        while (it.hasNext()) {
            String sort;
            String cname = (String)it.next();
            ContainedObject obj = tv.getElementByName(cname);
            if (obj == null) continue;
            if (!first) {
                this.appendComma(buffer);
                SSBIndexOnViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            }
            first = false;
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(((ModelObject)obj).getName()));
            if (!it.hasNext() || "ASC".equalsIgnoreCase((sort = (String)it.next()).trim())) continue;
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, sort);
        }
        SSBIndexOnViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
        SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, ')');
    }

    private void appendOptions(StringBuffer buffer, IndexOnViewSqlServerv2k5 index, boolean prettyPrint) {
        if ((index.getFillFactor() > 0 || index.getIgnoreDupKey().equalsIgnoreCase("YES") || index.getRecomputeStatistics().equalsIgnoreCase("OFF") || index.getSortInTempDB().equalsIgnoreCase("YES")) && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBIndexOnViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, "WITH");
            SSBIndexOnViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, '(');
            SSBIndexOnViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexOnViewSqlServerv2k5.appendSpace(buffer);
            boolean writeComma = false;
            if (index.getFillFactor() > 0) {
                if (index.getPadIndex().equalsIgnoreCase("YES")) {
                    SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, "PAD_INDEX");
                    this.appendComma(buffer);
                }
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, "FILLFACTOR");
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, '=');
                this.appendStringWithSpace(buffer, index.getFillFactor());
                writeComma = true;
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                if (index.getPadIndex().equalsIgnoreCase("YES")) {
                    SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, "PAD_INDEX");
                    this.appendComma(buffer);
                } else {
                    SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, "PAD_INDEX");
                    SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, '=');
                    SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, "OFF");
                    this.appendComma(buffer);
                }
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, "FILLFACTOR");
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, '=');
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, "0");
                writeComma = true;
            }
            if (index.getIgnoreDupKey().equalsIgnoreCase("YES") || this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                if (writeComma) {
                    this.appendComma(buffer);
                }
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, "IGNORE_DUP_KEY");
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, '=');
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, index.getIgnoreDupKey().equalsIgnoreCase("YES") ? ON : OFF);
                writeComma = true;
            }
            if (index.getRecomputeStatistics().equalsIgnoreCase("OFF") || this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                if (writeComma) {
                    this.appendComma(buffer);
                }
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, "STATISTICS_NORECOMPUTE");
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, '=');
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, index.getRecomputeStatistics().equalsIgnoreCase("OFF") ? ON : OFF);
                writeComma = true;
            }
            if (index.getSortInTempDB().equalsIgnoreCase("YES") || this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                if (writeComma) {
                    this.appendComma(buffer);
                }
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, "SORT_IN_TEMPDB");
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, '=');
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, index.getSortInTempDB().equalsIgnoreCase("YES") ? ON : OFF);
                writeComma = true;
            }
            if (index.getAllowRowLocks().equalsIgnoreCase("OFF") || this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                if (writeComma) {
                    this.appendComma(buffer);
                }
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, "ALLOW_ROW_LOCKS");
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, '=');
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, index.getAllowRowLocks());
                writeComma = true;
            }
            if (index.getAllowPageLocks().equalsIgnoreCase("OFF") || this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                if (writeComma) {
                    this.appendComma(buffer);
                }
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, "ALLOW_PAGE_LOCKS");
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, '=');
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, index.getAllowPageLocks());
                writeComma = true;
            }
            if (index.getMaxdop() > 0 || this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                if (writeComma) {
                    this.appendComma(buffer);
                }
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, "MAXDOP");
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, '=');
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, Integer.toString(index.getMaxdop()));
                writeComma = true;
            }
            if (index.getOnlineChoise().equalsIgnoreCase("ON") || this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                if (writeComma) {
                    this.appendComma(buffer);
                }
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, "ONLINE");
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, '=');
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, index.getOnlineChoise());
                writeComma = true;
            }
            if (index.getDropExisting().equalsIgnoreCase("ON") || this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                if (writeComma) {
                    this.appendComma(buffer);
                }
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, "DROP_EXISTING");
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, '=');
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, index.getDropExisting());
            }
            SSBIndexOnViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexOnViewSqlServerv2k5.appendString(buffer, ')');
        }
    }

    private void appendFilegroup(StringBuffer buffer, IndexOnViewSqlServerv2k5 index, boolean prettyPrint) {
        if (index.getFilegroup() != null && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBIndexOnViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, "ON");
            SSBIndexOnViewSqlServerv2k5.appendString(buffer, '\'');
            SSBIndexOnViewSqlServerv2k5.appendString(buffer, index.getFilegroup().getName());
            SSBIndexOnViewSqlServerv2k5.appendString(buffer, '\'');
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBIndexOnViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, "ON");
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, "\"default\"");
        }
    }

    private void appendExtProperties(StringBuffer buffer, IndexOnViewSqlServerv2k5 index, boolean prettyPrint) {
        if (!(index.getProps().trim().equalsIgnoreCase("") || index.getView().getSchema() == null && index.getView().getUser() == null)) {
            StringTokenizer st = new StringTokenizer(index.getProps().trim(), ",");
            while (st.hasMoreTokens()) {
                String name = st.nextToken();
                String value = st.nextToken();
                SSBIndexOnViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, "EXEC");
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, "sp_addextendedproperty");
                SSBIndexOnViewSqlServerv2k5.appendString(buffer, '\'');
                SSBIndexOnViewSqlServerv2k5.appendString(buffer, name.trim());
                SSBIndexOnViewSqlServerv2k5.appendString(buffer, '\'');
                this.appendComma(buffer);
                SSBIndexOnViewSqlServerv2k5.appendString(buffer, '\'');
                SSBIndexOnViewSqlServerv2k5.appendString(buffer, value.trim());
                SSBIndexOnViewSqlServerv2k5.appendString(buffer, '\'');
                this.appendComma(buffer);
                SSBIndexOnViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                if (index.getView().getSchema() != null) {
                    SSBIndexOnViewSqlServerv2k5.appendString(buffer, '\'');
                    SSBIndexOnViewSqlServerv2k5.appendString(buffer, "SCHEMA");
                    SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                    this.appendComma(buffer);
                    SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(index.getView().getSchema().getName()));
                    this.appendComma(buffer);
                } else {
                    SSBIndexOnViewSqlServerv2k5.appendString(buffer, '\'');
                    SSBIndexOnViewSqlServerv2k5.appendString(buffer, "USER");
                    SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                    this.appendComma(buffer);
                    SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(index.getView().getUser().getName()));
                    this.appendComma(buffer);
                }
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, "'Schema-bound View'");
                this.appendComma(buffer);
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(index.getView().getName()));
                this.appendComma(buffer);
                SSBIndexOnViewSqlServerv2k5.appendString(buffer, '\'');
                SSBIndexOnViewSqlServerv2k5.appendString(buffer, "INDEX");
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                this.appendComma(buffer);
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(index.getName()));
                SSBIndexOnViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                SSBIndexOnViewSqlServerv2k5.appendString(buffer, "GO");
                SSBIndexOnViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            }
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof IndexOnViewSqlServerv2k5 && ((IndexOnViewSqlServerv2k5)object).getView().getDataBase() != null && !((IndexOnViewSqlServerv2k5)object).getView().getDataBase().isNullInstance() && ((IndexOnViewSqlServerv2k5)object).isMarkedGenerate();
    }
}

