/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v9i;

import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ClusterIndexOraclev9i;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBClusterIndexOraclev9i
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        ClusterIndexOraclev9i clusterIndex = (ClusterIndexOraclev9i)object;
        this.storageDesign = clusterIndex.getStorageDesign();
        this.appendComment(oldbuffer, clusterIndex);
        SSBClusterIndexOraclev9i.appendStringWithSpace(buffer, "CREATE");
        SSBClusterIndexOraclev9i.appendStringWithSpace(buffer, "INDEX");
        SSBClusterIndexOraclev9i.appendStringWithSpace(buffer, clusterIndex.getStorageDesign().getFormatedLongNameDDL(clusterIndex));
        advancedComment = buffer.toString();
        this.appendCluster(buffer, clusterIndex, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        SSBClusterIndexOraclev9i.appendNewLine(buffer, prettyPrint, 0);
        this.appendLineFinisher(buffer, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        DDLFileMaker.incrementCreateIndex();
    }

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof ClusterIndexOraclev9i) {
            ClusterOracle cluster = ((ClusterIndexOraclev9i)object).getCluster();
            return cluster != null && cluster.isMarkedGenerate();
        }
        return false;
    }

    private void appendCluster(StringBuffer buffer, ClusterIndexOraclev9i clusterIndex, boolean prettyPrint) {
        if (clusterIndex.getCluster() != null) {
            SSBClusterIndexOraclev9i.appendStringWithSpace(buffer, "ON");
            SSBClusterIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBClusterIndexOraclev9i.appendStringWithSpace(buffer, "CLUSTER");
            SSBClusterIndexOraclev9i.appendStringWithSpace(buffer, clusterIndex.getStorageDesign().getFormatedLongNameDDL(clusterIndex.getCluster()));
            this.appendIndexAttributes(buffer, clusterIndex, prettyPrint);
        }
    }

    private void appendIndexAttributes(StringBuffer buffer, ClusterIndexOraclev9i clusterIndex, boolean prettyPrint) {
        if (clusterIndex.getTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
            SSBClusterIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBClusterIndexOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
            SSBClusterIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(clusterIndex.getTableSpace()));
        }
        this.appendSegment(buffer, clusterIndex.getSegment(), prettyPrint);
        if ("YES".equalsIgnoreCase(clusterIndex.getOnline())) {
            SSBClusterIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBClusterIndexOraclev9i.appendStringWithSpace(buffer, "ONLINE");
        }
        if (this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
            if ("YES".equalsIgnoreCase(clusterIndex.getLogging())) {
                SSBClusterIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBClusterIndexOraclev9i.appendStringWithSpace(buffer, "LOGGING");
            } else if ("NO".equalsIgnoreCase(clusterIndex.getLogging())) {
                SSBClusterIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBClusterIndexOraclev9i.appendStringWithSpace(buffer, "NOLOGGING");
            }
        }
        if ("YES".equalsIgnoreCase(clusterIndex.getComputeStatistics())) {
            SSBClusterIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBClusterIndexOraclev9i.appendStringWithSpace(buffer, "COMPUTE STATISTICS");
        }
        SSBClusterIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        if (clusterIndex.getCompress() > 0) {
            SSBClusterIndexOraclev9i.appendStringWithSpace(buffer, "COMPRESS");
            this.appendStringWithSpace(buffer, clusterIndex.getCompress());
        } else {
            SSBClusterIndexOraclev9i.appendStringWithSpace(buffer, "NOCOMPRESS");
        }
        if ("YES".equalsIgnoreCase(clusterIndex.getReverse())) {
            SSBClusterIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBClusterIndexOraclev9i.appendStringWithSpace(buffer, "SORT");
            }
            SSBClusterIndexOraclev9i.appendStringWithSpace(buffer, "REVERSE");
        }
        SSBClusterIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        if ("YES".equalsIgnoreCase(clusterIndex.getParallel())) {
            SSBClusterIndexOraclev9i.appendStringWithSpace(buffer, "PARALLEL");
            if (!"".equalsIgnoreCase(clusterIndex.getDegree())) {
                SSBClusterIndexOraclev9i.appendStringWithSpace(buffer, clusterIndex.getDegree());
            }
        } else {
            SSBClusterIndexOraclev9i.appendStringWithSpace(buffer, "NOPARALLEL");
        }
    }

    private void appendSegment(StringBuffer buffer, SegmentOracle segment, boolean prettyPrint) {
        if (segment != null && segment.isMarkedGenerate() && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            if (this.storageDesign.getAppView().getSettings().isIncludePctFreeInDDL()) {
                SSBClusterIndexOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                SSBClusterIndexOraclev9i.appendStringWithSpace(buffer, "PCTFREE");
                this.appendStringWithSpace(buffer, segment.getPCTFree());
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeInitransInDDL()) {
                if (segment.getInitrans() > 2) {
                    SSBClusterIndexOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    SSBClusterIndexOraclev9i.appendStringWithSpace(buffer, "INITRANS");
                    this.appendStringWithSpace(buffer, segment.getInitrans());
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    SSBClusterIndexOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    SSBClusterIndexOraclev9i.appendStringWithSpace(buffer, "INITRANS");
                    SSBClusterIndexOraclev9i.appendStringWithSpace(buffer, "2");
                }
                if (segment.getMaxTrans() > 2) {
                    SSBClusterIndexOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    SSBClusterIndexOraclev9i.appendStringWithSpace(buffer, "MAXTRANS");
                    this.appendStringWithSpace(buffer, segment.getMaxTrans());
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    SSBClusterIndexOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    SSBClusterIndexOraclev9i.appendStringWithSpace(buffer, "MAXTRANS");
                    SSBClusterIndexOraclev9i.appendStringWithSpace(buffer, "255");
                }
            }
            SSBClusterIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBClusterIndexOraclev9i.appendStringWithSpace(buffer, "STORAGE");
            SSBClusterIndexOraclev9i.appendStringWithSpace(buffer, '(');
            SSBClusterIndexOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            boolean props = false;
            if (segment.getSCInitialExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
                SSBClusterIndexOraclev9i.appendStringWithSpace(buffer, "INITIAL");
                this.appendStringWithSpace(buffer, segment.getSCInitialExtent());
                SSBClusterIndexOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (segment.getSCNextExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeNextExtentInDDL()) {
                SSBClusterIndexOraclev9i.appendStringWithSpace(buffer, "NEXT");
                this.appendStringWithSpace(buffer, segment.getSCNextExtent());
                SSBClusterIndexOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
                SSBClusterIndexOraclev9i.appendStringWithSpace(buffer, "PCTINCREASE");
                this.appendStringWithSpace(buffer, segment.getSCPctIncrease());
                SSBClusterIndexOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
                SSBClusterIndexOraclev9i.appendStringWithSpace(buffer, "MINEXTENTS");
                this.appendStringWithSpace(buffer, segment.getSCMinExtents());
                SSBClusterIndexOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
                SSBClusterIndexOraclev9i.appendStringWithSpace(buffer, "MAXEXTENTS");
                SSBClusterIndexOraclev9i.appendStringWithSpace(buffer, segment.getSCMaxExtents());
                SSBClusterIndexOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeFreeListsInDDL()) {
                SSBClusterIndexOraclev9i.appendStringWithSpace(buffer, "FREELISTS");
                this.appendStringWithSpace(buffer, segment.getSCFreeLists());
                SSBClusterIndexOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeFreeListGroupsInDDL()) {
                SSBClusterIndexOraclev9i.appendStringWithSpace(buffer, "FREELIST");
                SSBClusterIndexOraclev9i.appendStringWithSpace(buffer, "GROUPS");
                this.appendStringWithSpace(buffer, segment.getSCFreelistGroups());
                SSBClusterIndexOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeBufferPoolInDDL()) {
                SSBClusterIndexOraclev9i.appendStringWithSpace(buffer, "BUFFER_POOL");
                SSBClusterIndexOraclev9i.appendStringWithSpace(buffer, segment.getSCBufferPool());
                props = true;
            }
            if (props) {
                SSBClusterIndexOraclev9i.appendStringWithSpace(buffer, ')');
            } else {
                buffer = buffer.replace(buffer.lastIndexOf("STORAGE ("), buffer.length(), "");
            }
        }
    }
}

