/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TriggerOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;
import oracle.dbtools.crest.util.options.Settings;
import oracle.dbtools.crest.util.string.StringUtilities;

public class SSBAutoIncrementColumnOracle
extends AbstractSSBOracle {
    private static final int MAX_OBJECT_LENGTH = 30;
    public static final String TRIGGER_SUFFIX = "TRG";
    private static final String SEQUENCE_SUFFIX = "SEQ";
    private StorageDesignOracle storageDesign;
    private static Set genSequenceSet = new HashSet();

    public static void clearGenSequenceSet() {
        genSequenceSet.clear();
    }

    public SSBAutoIncrementColumnOracle(StorageDesignOracle storageDesign) {
        this.storageDesign = storageDesign;
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof TableProxyOracle || object instanceof Table;
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        if (object instanceof TableProxyOracle && ((TableProxyOracle)object).isMarkedGenerate() || object instanceof Table && ((Table)object).isMarkedGenerate()) {
            Table table = object instanceof Table ? (Table)object : (Table)((TableProxyOracle)object).getObject();
            for (Column column : table.getElementsAndNestedElementsCollection()) {
                if (!column.isAutoIncrementColumn()) continue;
                this.appendAutoIncrementSequenceAndTrigger(buffer, column, prettyPrint);
            }
        }
    }

    public void appendAutoIncrementSequenceAndTrigger(StringBuffer buffer, Column column, boolean prettyPrint) {
        this.appendAutoIncrementSequenceAndTrigger(buffer, column, prettyPrint, true);
    }

    public void appendAutoIncrementSequenceAndTrigger(StringBuffer buffer, Column column, boolean prettyPrint, boolean tableCreated) {
        boolean genTrigger = true;
        ColumnProxyOracle columnProxy = (ColumnProxyOracle)this.storageDesign.getColumnProxySet().getProxy(column.getObjectID());
        if (columnProxy != null) {
            String autoIncDDL = columnProxy.getDDLTypeForAutoIncCol();
            if (autoIncDDL.equalsIgnoreCase("NONE")) {
                return;
            }
            if (autoIncDDL.equalsIgnoreCase("TRIGGER") && !tableCreated) {
                return;
            }
            if (autoIncDDL.equalsIgnoreCase("DEFAULT_CLAUSE")) {
                if (tableCreated) {
                    return;
                }
                genTrigger = false;
            }
            if (autoIncDDL.equalsIgnoreCase("IDENTITY_CLAUSE")) {
                String dt;
                if (!tableCreated) {
                    return;
                }
                if (column.isIdentityColumn() && (dt = column.getDatatypeString(this.storageDesign.getRDBMSType().getName())).toUpperCase(Locale.ROOT).indexOf("CHAR") <= -1) {
                    return;
                }
            }
        }
        String sequenceName = this.generateSequenceName(buffer, column, prettyPrint);
        if (column.isAutoIncrementGenerateTrigger() && genTrigger) {
            TriggerOracle existingTrigger = null;
            String triggerName = column.getAutoIncrementTriggerName();
            if (StringUtilities.isNotEmpty(triggerName)) {
                TableProxyOracle tableProxy;
                int indexOfDot = triggerName.indexOf(46);
                if (indexOfDot > -1) {
                    triggerName = triggerName.substring(indexOfDot + 1);
                }
                if ((tableProxy = (TableProxyOracle)this.storageDesign.getTableProxySet().getProxy(column.getTable().getObjectID())) != null) {
                    for (TriggerOracle tableTrigger : tableProxy.getTriggers()) {
                        if (!tableTrigger.getName().equalsIgnoreCase(triggerName)) continue;
                        existingTrigger = tableTrigger;
                        break;
                    }
                }
            }
            if (existingTrigger == null) {
                int dotIndex;
                Settings settings = this.storageDesign.getAppView().getSettings();
                triggerName = column.getAutoIncrementTriggerName();
                triggerName = this.generateAutoIncrementObjectName(triggerName, settings.getDefaultOracleTriggerName(), TRIGGER_SUFFIX, column);
                if (!settings.isIncludeSchemaInDDL() && (dotIndex = triggerName.indexOf(46)) > -1) {
                    triggerName = triggerName.substring(dotIndex + 1);
                }
                this.appendAutoIncrementTrigger(triggerName, sequenceName, column, buffer, prettyPrint);
            }
        }
    }

    public String generateSequenceName(StringBuffer buffer, Column column, boolean prettyPrint) {
        Settings settings = this.storageDesign.getAppView().getSettings();
        String sequenceName = column.getAutoIncrementSequenceName();
        if (sequenceName != null) {
            sequenceName = sequenceName.trim();
        }
        String seqLongName = this.generateAutoIncrementObjectName(sequenceName, settings.getDefaultOracleSequenceName(), SEQUENCE_SUFFIX, column);
        String userName = "";
        int dotIndex = seqLongName.indexOf(46);
        if (dotIndex == -1) {
            sequenceName = seqLongName;
        } else {
            sequenceName = seqLongName.substring(dotIndex + 1);
            userName = seqLongName.substring(0, dotIndex);
        }
        SequenceOracle sequence = (SequenceOracle)this.storageDesign.getSequenceSet().getByUserSchemaAndName(userName, sequenceName);
        if (sequence != null) {
            return this.storageDesign.getFormatedLongNameDDL(sequence);
        }
        if (!settings.isIncludeSchemaInDDL()) {
            seqLongName = sequenceName;
        }
        if (buffer != null && !genSequenceSet.contains(seqLongName)) {
            this.appendAutoIncrementSequence(seqLongName, column, buffer, prettyPrint);
            genSequenceSet.add(seqLongName);
        }
        return this.storageDesign.getFormatedName(seqLongName);
    }

    public String generateAutoIncrementObjectName(String objectName, String objectNameTemplate, String suffix, Column column) {
        String result;
        String schema = "";
        Table table = (Table)column.getParent();
        ColumnProxyOracle columnProxy = (ColumnProxyOracle)this.storageDesign.getColumnProxySet().getProxy(column.getObjectID());
        TableProxyOracle tableProxy = (TableProxyOracle)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        if (tableProxy == null || columnProxy == null) {
            schema = table.getSchema();
        } else {
            UserOracle autoIncUser = columnProxy.getAutoIncrementUser();
            if (autoIncUser != null) {
                schema = autoIncUser.getName();
            } else {
                String tableLongName = tableProxy.getLongName();
                int dotIndex = tableLongName.indexOf(46);
                if (dotIndex > -1) {
                    schema = tableLongName.substring(0, dotIndex);
                }
            }
        }
        if (StringUtilities.isNotEmpty(objectName)) {
            int dotIndex = objectName.indexOf(46);
            if (dotIndex > -1) {
                schema = objectName.substring(0, dotIndex);
                result = objectName.substring(dotIndex + 1);
            } else {
                result = objectName;
            }
        } else {
            String columnAbbr;
            String columnName;
            String tableName;
            if (tableProxy == null || columnProxy == null) {
                tableName = table.getName();
                columnName = column.getShortName();
            } else {
                tableName = tableProxy.getName();
                columnName = column.getParentObject() != null ? column.getShortName() : columnProxy.getName();
            }
            String tableAbbr = table.getAbbreviation();
            if (StringUtilities.isEmpty(tableAbbr)) {
                tableAbbr = tableName;
            }
            if (StringUtilities.isEmpty(columnAbbr = column.getAbbreviation())) {
                columnAbbr = columnName;
            }
            if (StringUtilities.isNotEmpty(objectNameTemplate)) {
                result = objectNameTemplate.replaceAll("\\{table\\}", tableName).replaceAll("\\{table abbr\\}", tableAbbr).replaceAll("\\{column\\}", columnName).replaceAll("\\{column abbr\\}", columnAbbr);
            } else {
                result = tableAbbr + '_' + columnAbbr;
                if (result.length() + suffix.length() + 1 <= 30) {
                    result = result + '_' + suffix;
                }
            }
        }
        result = this.getStringWithMaxLength(result, 30);
        if (!schema.isEmpty()) {
            result = schema + '.' + result;
        }
        return result;
    }

    private void appendAutoIncrementSequence(String sequenceName, Column column, StringBuffer oldbuffer, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String autoIncrementStartWith = column.getAutoIncrementStartWith();
        Integer autoIncrementIncrementBy = column.getAutoIncrementIncrementBy();
        String autoIncrementMaxValue = column.getAutoIncrementMaxValue();
        String autoIncrementMinValue = column.getAutoIncrementMinValue();
        Integer autoIncrementCache = column.getAutoIncrementCache();
        SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "CREATE");
        SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "SEQUENCE");
        SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(sequenceName));
        String advancedComment = buffer.toString();
        if (autoIncrementStartWith != null && !"".equals(autoIncrementStartWith)) {
            SSBAutoIncrementColumnOracle.appendNewLine(buffer, prettyPrint, 0);
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "START");
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "WITH");
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, autoIncrementStartWith);
        }
        if (autoIncrementIncrementBy != null && autoIncrementIncrementBy != 1) {
            SSBAutoIncrementColumnOracle.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "INCREMENT");
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "BY");
            this.appendStringWithSpace(buffer, autoIncrementIncrementBy);
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBAutoIncrementColumnOracle.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "INCREMENT");
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "BY");
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "1");
        }
        if (autoIncrementMinValue != null) {
            SSBAutoIncrementColumnOracle.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "MINVALUE");
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, autoIncrementMinValue);
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBAutoIncrementColumnOracle.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "NOMINVALUE");
        }
        if (autoIncrementMaxValue != null) {
            SSBAutoIncrementColumnOracle.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "MAXVALUE");
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, autoIncrementMaxValue);
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBAutoIncrementColumnOracle.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "NOMAXVALUE");
        }
        if (column.isAutoIncrementCycle()) {
            SSBAutoIncrementColumnOracle.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "CYCLE");
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBAutoIncrementColumnOracle.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "NOCYCLE");
        }
        if (column.isAutoIncrementDisableCache()) {
            SSBAutoIncrementColumnOracle.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "NOCACHE");
        } else if (autoIncrementCache != null) {
            SSBAutoIncrementColumnOracle.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "CACHE");
            this.appendStringWithSpace(buffer, autoIncrementCache);
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBAutoIncrementColumnOracle.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "CACHE");
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "20");
        }
        if (column.isAutoIncrementOrder()) {
            SSBAutoIncrementColumnOracle.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "ORDER");
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBAutoIncrementColumnOracle.appendNewLine(buffer, prettyPrint, 1);
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "NOORDER");
        }
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        this.appendLineFinisher(buffer, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        SSBAutoIncrementColumnOracle.appendNewLine(oldbuffer, prettyPrint, 0);
        DDLFileMaker.incrementCreateSequence();
    }

    public void appendAutoIncrementTrigger(String triggerName, String sequenceName, Column column, StringBuffer oldbuffer, boolean prettyPrint) {
        ColumnProxyOracle columnProxy;
        Table table = (Table)column.getParent();
        TableProxyOracle tableProxy = (TableProxyOracle)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        if (tableProxy != null && (columnProxy = (ColumnProxyOracle)tableProxy.getColumnProxy(column.getObjectID())) != null) {
            StringBuffer buffer = new StringBuffer();
            String tableLongName = this.storageDesign.getFormatedLongNameDDL(tableProxy);
            String columnName = this.storageDesign.getFormatedName(columnProxy);
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "CREATE");
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "OR");
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "REPLACE");
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "TRIGGER");
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(triggerName));
            String advancedComment = buffer.toString();
            SSBAutoIncrementColumnOracle.appendNewLine(buffer, prettyPrint, 0);
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "BEFORE INSERT ON " + tableLongName);
            SSBAutoIncrementColumnOracle.appendNewLine(buffer, prettyPrint, 0);
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "FOR EACH ROW");
            SSBAutoIncrementColumnOracle.appendNewLine(buffer, prettyPrint, 0);
            if (!column.isAutoIncrementGenerateAlways()) {
                SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "WHEN (NEW." + columnName + " IS NULL)");
                SSBAutoIncrementColumnOracle.appendNewLine(buffer, prettyPrint, 0);
            }
            SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "BEGIN");
            SSBAutoIncrementColumnOracle.appendNewLine(buffer, prettyPrint, 1);
            if (this.storageDesign instanceof StorageDesignOraclev11g) {
                SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, ":NEW." + columnName);
                SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, ":=");
                SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, sequenceName + ".NEXTVAL;");
            } else {
                SSBAutoIncrementColumnOracle.appendStringWithSpace(buffer, "SELECT " + sequenceName + ".NEXTVAL INTO :NEW." + columnName + " FROM DUAL;");
            }
            SSBAutoIncrementColumnOracle.appendNewLine(buffer, prettyPrint, 0);
            SSBAutoIncrementColumnOracle.appendString(buffer, "END");
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            this.appendLineFinisherWithSlash(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            DDLFileMaker.incrementCreateTrigger();
        }
    }
}

