/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.db2.v80;

import oracle.dbtools.crest.exports.ddl.AbstractSSBDB2;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.FKProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.v80.FKProxyDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBFKeyDB2v80
extends AbstractSSBDB2 {
    private StorageDesignDB2v80 storageDesign;

    private StorageObject getOwner(FKContainer table) {
        TableProxyDB2 tableProxy = null;
        tableProxy = (TableProxyDB2)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        if (tableProxy != null && tableProxy.getOwner() != null && !tableProxy.getOwner().getName().equalsIgnoreCase("[Implicit]")) {
            return tableProxy.getOwner();
        }
        return null;
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        FKProxyDB2 fkproxy;
        if (object instanceof FKIndexAssociation) {
            FKIndexAssociation fk = (FKIndexAssociation)object;
            RelationalDesign rd = (RelationalDesign)fk.getDesignPart();
            this.storageDesign = (StorageDesignDB2v80)rd.getStorageDesign(rd.getSelectedRDBMSSite());
            fkproxy = (FKProxyDB2)this.storageDesign.getFKProxySet().getProxy(fk.getObjectID());
            if (fkproxy == null && (fkproxy = (FKProxyDB2)this.storageDesign.getFKProxySet().getProxy(fk.getLocalFKIndex().getObjectID())) == null) {
                return;
            }
        } else {
            fkproxy = (FKProxyDB2)object;
            this.storageDesign = (StorageDesignDB2v80)fkproxy.getStorageDesign();
        }
        if (fkproxy.getRemoteTable() instanceof Table) {
            if (fkproxy.getColumnProxies().length > 0) {
                this.appendBeforeAlterScript(buffer, prettyPrint, fkproxy.getTable());
                SSBFKeyDB2v80.appendStringWithSpace(buffer, "ALTER");
                SSBFKeyDB2v80.appendStringWithSpace(buffer, "TABLE");
                StorageObject owner = this.getOwner(fkproxy.getTable());
                if (owner != null && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
                    SSBFKeyDB2v80.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(owner.getName()) + '.' + this.storageDesign.getFormatedName(fkproxy.getTable().getName()));
                } else {
                    SSBFKeyDB2v80.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(fkproxy.getTable().getName()));
                }
                SSBFKeyDB2v80.appendNewLine(buffer, prettyPrint, 1);
                SSBFKeyDB2v80.appendStringWithSpace(buffer, "ADD");
                SSBFKeyDB2v80.appendStringWithSpace(buffer, "CONSTRAINT");
                SSBFKeyDB2v80.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(fkproxy.getName()));
                SSBFKeyDB2v80.appendStringWithSpace(buffer, "FOREIGN KEY");
                this.appendColumns(buffer, fkproxy, prettyPrint);
                this.appendReferences(buffer, fkproxy, prettyPrint);
                this.appendOnDelete(buffer, fkproxy, prettyPrint);
                this.appendEnforced(buffer, fkproxy, prettyPrint);
                SSBFKeyDB2v80.appendNewLine(buffer, prettyPrint, 0);
                this.appendLineFinisher(buffer, prettyPrint);
                SSBFKeyDB2v80.appendNewLine(buffer, prettyPrint, 0);
                DDLFileMaker.incrementAlterTable();
                this.appendAfterAlterScript(buffer, prettyPrint, fkproxy.getTable());
            } else {
                SSBFKeyDB2v80.appendNewLine(buffer, prettyPrint, 0);
                buffer.append("-- Error - Foreign Key ");
                buffer.append(this.storageDesign.getFormatedName(fkproxy.getTableName()) + "." + this.storageDesign.getFormatedName(fkproxy.getName()));
                buffer.append(" has no columns");
                SSBFKeyDB2v80.appendNewLine(buffer, prettyPrint, 0);
                DDLFileMaker.incrementErrors();
            }
        }
    }

    private void appendColumns(StringBuffer buffer, FKProxyDB2 fk, boolean prettyPrint) {
        ColumnProxy[] columns = fk.getColumnProxies();
        if (columns.length > 0) {
            SSBFKeyDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBFKeyDB2v80.appendStringWithSpace(buffer, '(');
            SSBFKeyDB2v80.appendNewLine(buffer, prettyPrint, 1);
            for (int i = 0; i < columns.length; ++i) {
                SSBFKeyDB2v80.appendString(buffer, ' ');
                SSBFKeyDB2v80.appendString(buffer, this.storageDesign.getFormatedName(columns[i].getName()));
                if (i != columns.length - 1) {
                    this.appendComma(buffer);
                }
                SSBFKeyDB2v80.appendNewLine(buffer, prettyPrint, 1);
            }
            SSBFKeyDB2v80.appendStringWithSpace(buffer, ')');
            SSBFKeyDB2v80.appendNewLine(buffer, prettyPrint, 1);
        }
    }

    private void appendReferences(StringBuffer buffer, FKProxyDB2 fk, boolean prettyPrint) {
        SSBFKeyDB2v80.appendStringWithSpace(buffer, "REFERENCES");
        StorageObject owner = this.getOwner(fk.getRemoteTable());
        if (owner != null && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
            SSBFKeyDB2v80.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(owner.getName()) + '.' + this.storageDesign.getFormatedName(fk.getRemoteTable().getName()));
        } else {
            SSBFKeyDB2v80.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(fk.getRemoteTable().getName()));
        }
        ContainedObject[] columns = fk.getRefColumns();
        SSBFKeyDB2v80.appendNewLine(buffer, prettyPrint, 1);
        SSBFKeyDB2v80.appendStringWithSpace(buffer, '(');
        SSBFKeyDB2v80.appendNewLine(buffer, prettyPrint, 1);
        for (int i = 0; i < columns.length; ++i) {
            SSBFKeyDB2v80.appendString(buffer, ' ');
            SSBFKeyDB2v80.appendString(buffer, this.storageDesign.getFormatedName(columns[i].getName()));
            if (i != columns.length - 1) {
                this.appendComma(buffer);
            }
            SSBFKeyDB2v80.appendNewLine(buffer, prettyPrint, 1);
        }
        SSBFKeyDB2v80.appendStringWithSpace(buffer, ')');
    }

    private void appendOnDelete(StringBuffer buffer, FKProxyDB2 fk, boolean prettyPrint) {
        FKIndexAssociation foreignKey = ((Index)fk.getObject()).getFKAssociation();
        String onDelete = foreignKey.getDeleteRule();
        if (onDelete.equalsIgnoreCase("SET DEFAULT")) {
            onDelete = foreignKey.isMandatory() ? "RESTRICT" : "SET NULL";
        }
        SSBFKeyDB2v80.appendNewLine(buffer, prettyPrint, 1);
        SSBFKeyDB2v80.appendStringWithSpace(buffer, "ON");
        SSBFKeyDB2v80.appendStringWithSpace(buffer, "DELETE");
        SSBFKeyDB2v80.appendStringWithSpace(buffer, onDelete);
    }

    private void appendEnforced(StringBuffer buffer, FKProxyDB2 fk, boolean prettyPrint) {
        if (fk.getEnforced().equalsIgnoreCase("NO")) {
            SSBFKeyDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBFKeyDB2v80.appendStringWithSpace(buffer, "NOT");
            SSBFKeyDB2v80.appendStringWithSpace(buffer, "ENFORCED");
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBFKeyDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBFKeyDB2v80.appendStringWithSpace(buffer, "ENFORCED");
        }
    }

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof RelationalObjectProxy && !((RelationalObjectProxy)object).getStorageDesign().isOpen()) {
            if (object instanceof FKProxyDB2v80) {
                return ((RelationalObjectProxy)object).getObject().isMarkedGenerate();
            }
        } else if (object instanceof FKIndexAssociation) {
            return ((FKIndexAssociation)object).isMarkedGenerate();
        }
        return object instanceof FKProxyDB2v80 && ((FKProxyDB2v80)object).isMarkedGenerate();
    }
}

