/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.db2.v70;

import java.util.List;
import oracle.dbtools.crest.exports.ddl.AbstractSSBDB2;
import oracle.dbtools.crest.exports.ddl.db2.v70.SSBIndexDB2v70;
import oracle.dbtools.crest.exports.ddl.oracle.SSBArcFK_CheckConstr;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.ColumnIdentityDB2;
import oracle.dbtools.crest.model.design.storage.db2.ColumnProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.DistinctTypeDB2;
import oracle.dbtools.crest.model.design.storage.db2.InstanceDescriptorColumnDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.v70.ColumnProxyDB2v70;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.model.design.storage.db2.v70.TableProxyDB2v70;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBTableDB2v70
extends AbstractSSBDB2 {
    private SSBIndexDB2v70 ssbIndex = new SSBIndexDB2v70();
    private AbstractStorageDesignDB2 storageDesign;
    private SSBArcFK_CheckConstr arcConstrHandler;

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof Table && ((Table)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof TableProxy;
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        Table table = null;
        TableProxyDB2 tableProxy = null;
        if (object == null) {
            return;
        }
        if (object instanceof Table) {
            table = (Table)object;
            this.storageDesign = (AbstractStorageDesignDB2)this.getStorageDesign(table);
            tableProxy = (TableProxyDB2)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        } else if (object instanceof TableProxyDB2) {
            tableProxy = (TableProxyDB2)object;
            table = (Table)tableProxy.getObject();
            this.storageDesign = (AbstractStorageDesignDB2)this.getStorageDesign(tableProxy);
        }
        if (tableProxy != null && !tableProxy.isMarkedGenerate()) {
            this.appendIndexes(buffer, tableProxy, prettyPrint);
            return;
        }
        if (table != null && table.getElementsCollection().size() > 0) {
            String tableName;
            if (tableProxy != null) {
                this.appendSetCurrentRules(buffer, tableProxy, prettyPrint);
            }
            if (tableProxy != null && tableProxy.isCommentChanged()) {
                this.appendComment(buffer, tableProxy);
            } else {
                this.appendComment(buffer, table);
            }
            if (tableProxy != null && tableProxy.getName().length() > tableProxy.getMaxNameLength()) {
                SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 0);
                SSBTableDB2v70.appendStringWithSpace(buffer, "--  ERROR: Table name length exceeds maximum allowed length(" + tableProxy.getMaxNameLength() + ")");
                SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 0);
                DDLFileMaker.incrementErrors();
            }
            this.appendBeforeCreateScript(buffer, prettyPrint, table);
            this.appendCreate(buffer);
            if (tableProxy == null) {
                SSBTableDB2v70.appendStringWithSpace(buffer, "TABLE");
                tableName = this.storageDesign.getFormatedName(table.getLongNameDDL());
                SSBTableDB2v70.appendStringWithSpace(buffer, tableName);
                this.appendElementList(buffer, table, null, prettyPrint);
            } else {
                SSBTableDB2v70.appendStringWithSpace(buffer, "TABLE");
                tableName = this.storageDesign.getFormatedName(tableProxy.getLongNameDDL());
                SSBTableDB2v70.appendStringWithSpace(buffer, tableName);
                this.appendElementList(buffer, table, tableProxy, prettyPrint);
                this.appendInDb(buffer, tableProxy, prettyPrint);
                this.appendEditProc(buffer, tableProxy, prettyPrint);
                this.appendValidProc(buffer, tableProxy, prettyPrint);
                this.appendAudit(buffer, tableProxy, prettyPrint);
                this.appendObid(buffer, tableProxy, prettyPrint);
                this.appendDataCapture(buffer, tableProxy, prettyPrint);
                this.appendWithRestrict(buffer, tableProxy, prettyPrint);
                this.appendCcid(buffer, tableProxy, prettyPrint);
            }
            SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            DDLFileMaker.incrementCreateTable();
            this.appendAfterCreateScript(buffer, prettyPrint, table);
            if (tableProxy != null) {
                this.appendLabelOn(buffer, tableProxy, prettyPrint);
                ColumnProxy[] columns = tableProxy.getColumnProxies();
                for (int i = 0; i < columns.length; ++i) {
                    this.appendLabelOnColumn(buffer, (ColumnProxyDB2v70)columns[i], prettyPrint);
                }
            }
            this.appendColumnCheckConstraints(buffer, tableProxy, prettyPrint);
            SSBTableDB2v70.appendExistenceDependencyConstraints(buffer, tableProxy, prettyPrint, this, String.valueOf(DB2_UDB_STATEMENT_TERMINATION_CHAR), 18);
            SSBTableDB2v70.appendOptionalFKCheckConstraints(buffer, tableProxy, prettyPrint, this, String.valueOf(';'), 30);
            if (this.getArcConstrHandler() != null) {
                this.getArcConstrHandler().appendArcConstraints(buffer, tableProxy, prettyPrint);
            }
            if (table.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                this.appendTableCommentOn(buffer, table, tableProxy, prettyPrint);
            }
            if (tableProxy != null) {
                this.appendIndexes(buffer, tableProxy, prettyPrint);
            }
        } else if (table != null) {
            SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 0);
            buffer.append("-- Error - Table ");
            buffer.append(this.storageDesign.getFormatedName(table.getName()));
            buffer.append(" has no columns");
            SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 0);
            DDLFileMaker.incrementErrors();
        }
    }

    private void appendIndexes(StringBuffer buffer, TableProxyDB2 tableProxy, boolean prettyPrint) {
        for (Object object : tableProxy.getIndexes()) {
            if (!this.ssbIndex.canHandle(object)) continue;
            this.ssbIndex.doAppend(buffer, object, prettyPrint);
        }
        this.appendIndexesForConstraints(buffer, (Table)tableProxy.getObject(), tableProxy);
    }

    private void appendSetCurrentRules(StringBuffer buffer, TableProxyDB2 tableProxy, boolean prettyPrint) {
        boolean hasAUXTable = this.hasAUXTables(tableProxy);
        SSBTableDB2v70.appendStringWithSpace(buffer, "SET CURRENT RULES");
        SSBTableDB2v70.appendStringWithSpace(buffer, '=');
        SSBTableDB2v70.appendString(buffer, '\'');
        SSBTableDB2v70.appendString(buffer, hasAUXTable ? CR_DB2 : CR_STD);
        SSBTableDB2v70.appendStringWithSpace(buffer, '\'');
        this.appendLineFinisher(buffer, prettyPrint);
    }

    private void appendElementList(StringBuffer buffer, Table table, TableProxyDB2 tableProxy, boolean prettyPrint) {
        List columns = table.getAllNestedElements();
        Column column = null;
        ColumnProxyDB2 columnProxy = null;
        Object[] instCols = null;
        if (tableProxy != null) {
            instCols = tableProxy.getInstDescriptorCols().toArray();
        }
        SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 1);
        if (columns.size() == 0 && (instCols == null || instCols.length == 0)) {
            SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 1);
            SSBTableDB2v70.appendStringWithSpace(buffer, "-- No columns");
            SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 1);
        } else {
            for (int i = 0; i < columns.size(); ++i) {
                if (i == 0) {
                    SSBTableDB2v70.appendStringWithSpace(buffer, '(');
                } else {
                    this.appendComma(buffer);
                }
                SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 1);
                column = (Column)columns.get(i);
                if (tableProxy == null) continue;
                columnProxy = (ColumnProxyDB2)tableProxy.getColumnProxy(column.getObjectID());
                if (columnProxy.getName().length() > columnProxy.getMaxNameLength()) {
                    SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 0);
                    SSBTableDB2v70.appendStringWithSpace(buffer, "--  ERROR: Column name length exceeds maximum allowed length(" + columnProxy.getMaxNameLength() + ")");
                    SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 0);
                    DDLFileMaker.incrementErrors();
                }
                if (columnProxy.isCommentChanged() && !"".equalsIgnoreCase(columnProxy.getComment())) {
                    this.appendComment(buffer, columnProxy);
                } else if (!"".equalsIgnoreCase(columnProxy.getObject().getComment())) {
                    this.appendComment(buffer, columnProxy.getObject());
                }
                this.appendColumnDefinition(buffer, columnProxy, prettyPrint);
            }
            InstanceDescriptorColumnDB2 instCol = null;
            for (int i = 0; i < instCols.length; ++i) {
                instCol = (InstanceDescriptorColumnDB2)instCols[i];
                if (columns.size() == 0 && i == 0) {
                    SSBTableDB2v70.appendString(buffer, '(');
                } else {
                    buffer.append(", ");
                }
                SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 1);
                SSBTableDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(instCol.getName()));
                SSBTableDB2v70.appendStringWithSpace(buffer, instCol.getDataType());
            }
            this.appendTableConstraintsDefinition(buffer, table, prettyPrint);
            SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 1);
            SSBTableDB2v70.appendStringWithSpace(buffer, ')');
        }
    }

    protected void appendColumnDefinition(StringBuffer buffer, ColumnProxyDB2 columnProxy, boolean prettyPrint) {
        SSBTableDB2v70.appendString(buffer, ' ');
        SSBTableDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy.getName()));
        DistinctTypeDB2 distType = columnProxy.getDistinctType();
        if (distType != null) {
            this.appendStringWithSpace(buffer, distType);
        } else {
            String datatype = columnProxy.getDatatypeString();
            SSBTableDB2v70.appendStringWithSpace(buffer, datatype);
            if (datatype.equalsIgnoreCase("unknown")) {
                SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 0);
                SSBTableDB2v70.appendStringWithSpace(buffer, "--  ERROR: Datatype UNKNOWN is not allowed");
                SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 5);
                DDLFileMaker.incrementErrors();
            }
        }
        this.appendBitDataDefinition(buffer, columnProxy);
        this.appendNotNullDefinition(buffer, columnProxy);
        this.appendWithDefaultDefinition(buffer, columnProxy);
        this.appendIdentityDefinition(buffer, columnProxy, prettyPrint);
        this.appendColumnConstraints(buffer, columnProxy.getColumn(), columnProxy);
        this.appendFieldProcDefinition(buffer, columnProxy);
    }

    protected void appendLabelOnColumn(StringBuffer buffer, ColumnProxyDB2 columnProxy, boolean prettyPrint) {
        if (!columnProxy.getLabel().equalsIgnoreCase("")) {
            SSBTableDB2v70.appendStringWithSpace(buffer, "LABEL");
            SSBTableDB2v70.appendStringWithSpace(buffer, "ON");
            SSBTableDB2v70.appendStringWithSpace(buffer, "COLUMN");
            SSBTableDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy.getLongName()));
            SSBTableDB2v70.appendStringWithSpace(buffer, "IS");
            SSBTableDB2v70.appendStringWithSpace(buffer, "'" + columnProxy.getLabel() + "'");
            this.appendLineFinisher(buffer, prettyPrint);
        }
    }

    protected void appendBitDataDefinition(StringBuffer buffer, ColumnProxyDB2 columnProxy) {
        String bitdata = columnProxy.getBitData();
        if (!"".equalsIgnoreCase(bitdata)) {
            SSBTableDB2v70.appendStringWithSpace(buffer, "FOR");
            SSBTableDB2v70.appendStringWithSpace(buffer, bitdata);
            SSBTableDB2v70.appendStringWithSpace(buffer, "DATA");
        }
    }

    protected void appendNotNullDefinition(StringBuffer buffer, ColumnProxyDB2 columnProxy) {
        if (!columnProxy.getColumn().getNullsAllowed()) {
            SSBTableDB2v70.appendStringWithSpace(buffer, "NOT NULL");
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBTableDB2v70.appendStringWithSpace(buffer, "NULL");
        }
    }

    private void appendWithDefaultDefinition(StringBuffer buffer, ColumnProxyDB2 columnProxy) {
        String defaultConstant = columnProxy.getDefaultValueConstant();
        boolean isSDOpen = columnProxy.getStorageDesign().isOpen();
        String defaultValue = "";
        Column column = columnProxy.getColumn();
        boolean isDefault = columnProxy.getDefault();
        if (!isSDOpen) {
            defaultValue = column.getDefaultValue();
            isDefault = column.getUsesDefaultValue();
        } else {
            defaultValue = columnProxy.getDefaultValue();
        }
        if (isDefault) {
            SSBTableDB2v70.appendStringWithSpace(buffer, "WITH");
            SSBTableDB2v70.appendStringWithSpace(buffer, "DEFAULT");
            if (!"".equalsIgnoreCase(defaultValue)) {
                if (defaultValue.equalsIgnoreCase(ColumnProxyDB2.getDefaultValueChoices()[1])) {
                    if (!"".equalsIgnoreCase(defaultConstant)) {
                        String dt = columnProxy.getColumn().getDatatypeString("DB2/390 7");
                        String df = this.addQuotesToDefault(dt, defaultConstant);
                        SSBTableDB2v70.appendStringWithSpace(buffer, df);
                    }
                } else if (defaultValue.equalsIgnoreCase(ColumnProxyDB2.getDefaultValueChoices()[4])) {
                    SSBTableDB2v70.appendStringWithSpace(buffer, defaultConstant);
                } else {
                    String dt = columnProxy.getColumn().getDatatypeString("DB2/390 7");
                    String df = this.addQuotesToDefault(dt, defaultValue);
                    SSBTableDB2v70.appendStringWithSpace(buffer, df);
                }
            }
        }
    }

    protected void appendIdentityDefinition(StringBuffer buffer, ColumnProxyDB2 columnProxy, boolean prettyPrint) {
        ColumnIdentityDB2 identity;
        Column column = columnProxy.getColumn();
        if (column.isIdentityColumn() && columnProxy.isUseIdentity() && (identity = columnProxy.getColumnIdentity()) != null) {
            SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 1);
            SSBTableDB2v70.appendStringWithSpace(buffer, "GENERATED");
            SSBTableDB2v70.appendStringWithSpace(buffer, identity.getGenerate());
            SSBTableDB2v70.appendStringWithSpace(buffer, "AS");
            SSBTableDB2v70.appendStringWithSpace(buffer, "IDENTITY");
            SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 2);
            SSBTableDB2v70.appendStringWithSpace(buffer, '(');
            SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 2);
            SSBTableDB2v70.appendStringWithSpace(buffer, "START");
            SSBTableDB2v70.appendStringWithSpace(buffer, "WITH");
            SSBTableDB2v70.appendStringWithSpace(buffer, identity.getStartWith());
            this.appendComma(buffer);
            SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 2);
            SSBTableDB2v70.appendStringWithSpace(buffer, "INCREMENT");
            SSBTableDB2v70.appendStringWithSpace(buffer, "BY");
            this.appendStringWithSpace(buffer, identity.getIncrementBy());
            this.appendComma(buffer);
            SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 2);
            if (identity.getCache() == 0) {
                SSBTableDB2v70.appendStringWithSpace(buffer, "NO");
                SSBTableDB2v70.appendStringWithSpace(buffer, "CACHE");
            } else {
                SSBTableDB2v70.appendStringWithSpace(buffer, "CACHE");
                this.appendStringWithSpace(buffer, identity.getCache());
            }
            this.appendComma(buffer);
            SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 2);
            if (identity.isCycle()) {
                SSBTableDB2v70.appendStringWithSpace(buffer, "CYCLE");
            } else {
                SSBTableDB2v70.appendStringWithSpace(buffer, "NO");
                SSBTableDB2v70.appendStringWithSpace(buffer, "CYCLE");
            }
            if (!"".equalsIgnoreCase(identity.getMaxValue().trim())) {
                this.appendComma(buffer);
                SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 2);
                SSBTableDB2v70.appendStringWithSpace(buffer, "MAXVALUE");
                SSBTableDB2v70.appendStringWithSpace(buffer, identity.getMaxValue());
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                this.appendComma(buffer);
                SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 2);
                SSBTableDB2v70.appendStringWithSpace(buffer, "NO");
                SSBTableDB2v70.appendStringWithSpace(buffer, "MAXVALUE");
            }
            if (!"".equalsIgnoreCase(identity.getMinValue().trim())) {
                this.appendComma(buffer);
                SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 2);
                SSBTableDB2v70.appendStringWithSpace(buffer, "MINVALUE");
                SSBTableDB2v70.appendStringWithSpace(buffer, identity.getMinValue());
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                this.appendComma(buffer);
                SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 2);
                SSBTableDB2v70.appendStringWithSpace(buffer, "NO");
                SSBTableDB2v70.appendStringWithSpace(buffer, "MINVALUE");
            }
            SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 2);
            SSBTableDB2v70.appendStringWithSpace(buffer, ')');
        }
    }

    protected void appendFieldProcDefinition(StringBuffer buffer, ColumnProxyDB2 columnProxy) {
        String program;
        if (!(columnProxy.getDefault() || (program = columnProxy.getProgram()) == null || program.trim().equals("") || program.trim().equalsIgnoreCase("NULL"))) {
            SSBTableDB2v70.appendStringWithSpace(buffer, "FIELDPROC");
            SSBTableDB2v70.appendStringWithSpace(buffer, program);
            String constant = columnProxy.getConstant();
            if (constant != null && !constant.trim().equals("") && !constant.trim().equalsIgnoreCase("NULL")) {
                SSBTableDB2v70.appendStringWithSpace(buffer, '(');
                SSBTableDB2v70.appendStringWithSpace(buffer, constant);
                SSBTableDB2v70.appendStringWithSpace(buffer, ')');
            }
        }
    }

    private void appendColumnConstraints(StringBuffer buffer, Column column, ColumnProxyDB2 columnProxy) {
        String text;
        if (column.hasConstraintsDefinedForDDL() && !"".equals(text = column.getConstraintsText(this.storageDesign.getFormatedName(columnProxy.getName())))) {
            String cname = column.getConstraintName();
            if (column.getDesign().getAppView().getSettings().isGenerateInlineColumnCC()) {
                if (!cname.equals("") && cname.length() <= 18) {
                    SSBTableDB2v70.appendStringWithSpace(buffer, "CONSTRAINT");
                    SSBTableDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(cname));
                }
                SSBTableDB2v70.appendStringWithSpace(buffer, "CHECK");
                SSBTableDB2v70.appendStringWithSpace(buffer, '(');
                SSBTableDB2v70.appendStringWithSpace(buffer, text);
                SSBTableDB2v70.appendStringWithSpace(buffer, ')');
            }
        }
    }

    private void appendPKDefinition(StringBuffer buffer, Table table, TableProxyDB2 tableProxy, boolean prettyPrint) {
        Index[] indexes;
        int i;
        KeyObject pk = table.getPK();
        if (pk != null && pk.isMarkedGenerate()) {
            Column[] columns = (Column[])pk.getElements();
            if (columns.length > 0) {
                SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 1);
                if (tableProxy != null) {
                    SSBTableDB2v70.appendStringWithSpace(buffer, "ALTER");
                    SSBTableDB2v70.appendStringWithSpace(buffer, "TABLE");
                    SSBTableDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
                    SSBTableDB2v70.appendStringWithSpace(buffer, "ADD");
                    SSBTableDB2v70.appendStringWithSpace(buffer, "CONSTRAINT");
                    SSBTableDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(pk.getName()));
                    SSBTableDB2v70.appendStringWithSpace(buffer, "PRIMARY KEY");
                    SSBTableDB2v70.appendString(buffer, '(');
                    for (i = 0; i < columns.length; ++i) {
                        if (i != 0) {
                            this.appendComma(buffer);
                        }
                        SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 1);
                        SSBTableDB2v70.appendString(buffer, " " + this.storageDesign.getFormatedName(columns[i].getName()));
                    }
                    SSBTableDB2v70.appendString(buffer, ')');
                    SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 0);
                    this.appendLineFinisher(buffer, prettyPrint);
                    SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 0);
                    DDLFileMaker.incrementAlterTable();
                }
            } else {
                SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 0);
                buffer.append("-- Error - Primary Key ");
                buffer.append(this.storageDesign.getFormatedName(pk.getName()));
                buffer.append(" has no columns");
                DDLFileMaker.incrementErrors();
            }
        }
        if ((indexes = (Index[])table.getKeys()).length > 0) {
            for (i = 0; i < indexes.length; ++i) {
                Column[] indexColumns;
                Index index = indexes[i];
                if (!index.getIndexState().equalsIgnoreCase("Unique Constraint") || !index.isMarkedGenerate() || (indexColumns = (Column[])index.getElements()).length <= 0) continue;
                SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 1);
                SSBTableDB2v70.appendStringWithSpace(buffer, "ALTER");
                SSBTableDB2v70.appendStringWithSpace(buffer, "TABLE");
                SSBTableDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
                SSBTableDB2v70.appendStringWithSpace(buffer, "ADD");
                SSBTableDB2v70.appendStringWithSpace(buffer, "CONSTRAINT");
                SSBTableDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(index.getName()));
                SSBTableDB2v70.appendStringWithSpace(buffer, "UNIQUE");
                SSBTableDB2v70.appendString(buffer, '(');
                for (int j = 0; j < indexColumns.length; ++j) {
                    if (j != 0) {
                        this.appendComma(buffer);
                    }
                    buffer.append(this.storageDesign.getFormatedName(indexColumns[j].getName()));
                }
                SSBTableDB2v70.appendString(buffer, ')');
                SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 0);
                this.appendLineFinisher(buffer, prettyPrint);
                SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 0);
                DDLFileMaker.incrementAlterTable();
            }
        }
    }

    private void appendTableConstraintsDefinition(StringBuffer buffer, Table table, boolean prettyPrint) {
        if (table.getDesign().getAppView().getSettings().isGenerateInlineColumnCC()) {
            for (TableLevelConstraint constraint : table.getCheckConstraints()) {
                this.appendComma(buffer);
                SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 1);
                SSBTableDB2v70.appendString(buffer, ' ');
                SSBTableDB2v70.appendStringWithSpace(buffer, "CONSTRAINT");
                SSBTableDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(constraint.getName()));
                SSBTableDB2v70.appendStringWithSpace(buffer, "CHECK");
                SSBTableDB2v70.appendString(buffer, '(');
                SSBTableDB2v70.appendString(buffer, constraint.getRule());
                SSBTableDB2v70.appendString(buffer, ')');
            }
        }
    }

    private void appendInDb(StringBuffer buffer, TableProxyDB2 tableProxy, boolean prettyPrint) {
        DataBaseDB2 database = tableProxy.getDataBase();
        TableSpaceDB2 tableSpace = tableProxy.getTableSpace();
        if (tableSpace != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
            SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 1);
            SSBTableDB2v70.appendStringWithSpace(buffer, "IN");
            if (database != null && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
                SSBTableDB2v70.appendString(buffer, this.storageDesign.getFormatedName(database.getLongNameDDL()));
                SSBTableDB2v70.appendString(buffer, '.');
            }
            SSBTableDB2v70.appendString(buffer, this.storageDesign.getFormatedName(tableSpace.getLongNameDDL()));
        } else if (this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            if (database != null) {
                SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 1);
                SSBTableDB2v70.appendStringWithSpace(buffer, "IN");
                SSBTableDB2v70.appendString(buffer, this.storageDesign.getFormatedName(database.getLongNameDDL()));
            } else if (database == null && this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 1);
                SSBTableDB2v70.appendStringWithSpace(buffer, "IN");
                SSBTableDB2v70.appendStringWithSpace(buffer, "DATABASE");
                SSBTableDB2v70.appendString(buffer, "DSNDB04");
            }
        }
    }

    private void appendEditProc(StringBuffer buffer, TableProxyDB2 tableProxy, boolean prettyPrint) {
        if (!tableProxy.getEditProc().equalsIgnoreCase("")) {
            SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 1);
            SSBTableDB2v70.appendStringWithSpace(buffer, "EDITPROC");
            SSBTableDB2v70.appendStringWithSpace(buffer, tableProxy.getEditProc());
        }
    }

    private void appendValidProc(StringBuffer buffer, TableProxyDB2 tableProxy, boolean prettyPrint) {
        if (!tableProxy.getValidProc().equalsIgnoreCase("")) {
            SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 1);
            SSBTableDB2v70.appendStringWithSpace(buffer, "VALIDPROC");
            SSBTableDB2v70.appendStringWithSpace(buffer, tableProxy.getValidProc());
        }
    }

    private void appendAudit(StringBuffer buffer, TableProxyDB2 tableProxy, boolean prettyPrint) {
        if (!tableProxy.getAudit().equalsIgnoreCase("NONE")) {
            SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 1);
            SSBTableDB2v70.appendStringWithSpace(buffer, "AUDIT");
            SSBTableDB2v70.appendStringWithSpace(buffer, tableProxy.getAudit());
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 1);
            SSBTableDB2v70.appendStringWithSpace(buffer, "AUDIT");
            SSBTableDB2v70.appendStringWithSpace(buffer, "NONE");
        }
    }

    private void appendObid(StringBuffer buffer, TableProxyDB2 tableProxy, boolean prettyPrint) {
        if (tableProxy.getObid() > 0) {
            SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 1);
            SSBTableDB2v70.appendStringWithSpace(buffer, "OBID");
            this.appendStringWithSpace(buffer, tableProxy.getObid());
        }
    }

    private void appendDataCapture(StringBuffer buffer, TableProxyDB2 tableProxy, boolean prettyPrint) {
        if (tableProxy.getDataCapture()) {
            SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 1);
            SSBTableDB2v70.appendStringWithSpace(buffer, "DATA CAPTURE");
            if (tableProxy.getDataCapture()) {
                SSBTableDB2v70.appendStringWithSpace(buffer, "CHANGES");
            }
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 1);
            SSBTableDB2v70.appendStringWithSpace(buffer, "DATA CAPTURE");
            SSBTableDB2v70.appendStringWithSpace(buffer, "NONE");
        }
    }

    private void appendWithRestrict(StringBuffer buffer, TableProxyDB2 tableProxy, boolean prettyPrint) {
        if (tableProxy.getDropRestrict()) {
            SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 1);
            SSBTableDB2v70.appendStringWithSpace(buffer, "WITH RESTRICT ON DROP");
        }
    }

    private void appendCcid(StringBuffer buffer, TableProxyDB2 tableProxy, boolean prettyPrint) {
        if (!tableProxy.getCcsid().equalsIgnoreCase("")) {
            SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 1);
            SSBTableDB2v70.appendStringWithSpace(buffer, "CCSID");
            SSBTableDB2v70.appendStringWithSpace(buffer, tableProxy.getCcsid());
        }
    }

    private void appendLabelOn(StringBuffer buffer, TableProxyDB2 tableProxy, boolean prettyPrint) {
        if (!tableProxy.getLabel().equalsIgnoreCase("")) {
            SSBTableDB2v70.appendStringWithSpace(buffer, "LABEL");
            SSBTableDB2v70.appendStringWithSpace(buffer, "ON");
            SSBTableDB2v70.appendStringWithSpace(buffer, "TABLE");
            SSBTableDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableProxy.getLongNameDDL()));
            SSBTableDB2v70.appendStringWithSpace(buffer, "IS");
            SSBTableDB2v70.appendStringWithSpace(buffer, "'" + tableProxy.getLabel() + "'");
            this.appendLineFinisher(buffer, prettyPrint);
        }
    }

    private void appendColumnCheckConstraints(StringBuffer buffer, TableProxy tableProxy, boolean prettyPrint) {
        ColumnProxy[] colProxies = tableProxy.getColumnProxies();
        for (int i = 0; i < colProxies.length; ++i) {
            String text;
            ColumnProxy columnProxy = colProxies[i];
            Column column = columnProxy.getColumn();
            if (!column.hasConstraintsDefinedForDDL() || column.getDesign().getAppView().getSettings().isGenerateInlineColumnCC() || "".equals(text = column.getConstraintsText(this.storageDesign.getFormatedName(columnProxy.getName())))) continue;
            String cname = column.getConstraintName();
            SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 0);
            SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 0);
            SSBTableDB2v70.appendStringWithSpace(buffer, "ALTER");
            SSBTableDB2v70.appendStringWithSpace(buffer, "TABLE");
            SSBTableDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableProxy.getLongNameDDL()));
            SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 1);
            SSBTableDB2v70.appendStringWithSpace(buffer, "ADD");
            if (!"".equals(cname) && cname.length() <= 18) {
                SSBTableDB2v70.appendStringWithSpace(buffer, "CONSTRAINT");
                SSBTableDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(cname));
            }
            SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 1);
            SSBTableDB2v70.appendStringWithSpace(buffer, "CHECK");
            SSBTableDB2v70.appendStringWithSpace(buffer, '(');
            SSBTableDB2v70.appendStringWithSpace(buffer, text);
            SSBTableDB2v70.appendStringWithSpace(buffer, ')');
            SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 0);
            DDLFileMaker.incrementAlterTable();
        }
    }

    private void appendTableCheckConstraints(StringBuffer buffer, TableProxy tableProxy, boolean prettyPrint) {
        Table table = (Table)tableProxy.getObject();
        if (!table.getDesign().getAppView().getSettings().isGenerateInlineColumnCC()) {
            for (TableLevelConstraint constraint : table.getCheckConstraints()) {
                String text = constraint.getRule();
                if ("".equals(text)) continue;
                String cname = constraint.getName();
                SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 0);
                SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 0);
                SSBTableDB2v70.appendStringWithSpace(buffer, "ALTER");
                SSBTableDB2v70.appendStringWithSpace(buffer, "TABLE");
                SSBTableDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableProxy.getLongNameDDL()));
                SSBTableDB2v70.appendStringWithSpace(buffer, "ADD");
                if (!"".equals(cname) && cname.length() <= 18) {
                    SSBTableDB2v70.appendStringWithSpace(buffer, "CONSTRAINT");
                    SSBTableDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(cname));
                }
                SSBTableDB2v70.appendStringWithSpace(buffer, "CHECK");
                SSBTableDB2v70.appendStringWithSpace(buffer, '(');
                SSBTableDB2v70.appendStringWithSpace(buffer, text);
                SSBTableDB2v70.appendStringWithSpace(buffer, ')');
                SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 0);
                this.appendLineFinisher(buffer, prettyPrint);
                SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 0);
                DDLFileMaker.incrementAlterTable();
            }
        }
    }

    protected void appendTableCommentOn(StringBuffer buffer, Table table, TableProxyDB2 tableProxy, boolean prettyPrint) {
        block6: {
            block5: {
                if (tableProxy == null) break block5;
                this.appendCommentOn(buffer, tableProxy, prettyPrint);
                ColumnProxy[] columnProxies = tableProxy.getColumnProxies();
                ColumnProxy col = null;
                for (int i = 0; i < columnProxies.length; ++i) {
                    String name;
                    col = columnProxies[i];
                    String comment = "";
                    if (col.getCommentInRDBMS() != null && col.isCommentInRDBMSChanged()) {
                        comment = col.getCommentInRDBMS();
                        name = col.getLongName();
                    } else {
                        comment = col.getObject().getCommentInRDBMS();
                        name = ((Column)col.getObject()).getLongName();
                    }
                    if (comment.equalsIgnoreCase("")) continue;
                    SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 0);
                    SSBTableDB2v70.appendStringWithSpace(buffer, "COMMENT ON");
                    SSBTableDB2v70.appendStringWithSpace(buffer, "COLUMN");
                    SSBTableDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(name));
                    SSBTableDB2v70.appendStringWithSpace(buffer, "IS");
                    SSBTableDB2v70.appendString(buffer, '\'');
                    SSBTableDB2v70.appendString(buffer, comment);
                    SSBTableDB2v70.appendStringWithSpace(buffer, '\'');
                    SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 0);
                    this.appendLineFinisher(buffer, prettyPrint);
                }
                break block6;
            }
            if (table == null) break block6;
            if (table.getCommentInRDBMS() != null && !"".equalsIgnoreCase(table.getCommentInRDBMS())) {
                SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 0);
                SSBTableDB2v70.appendStringWithSpace(buffer, "COMMENT ON");
                SSBTableDB2v70.appendStringWithSpace(buffer, "TABLE");
                SSBTableDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(table.getLongNameDDL()));
                SSBTableDB2v70.appendStringWithSpace(buffer, "IS");
                SSBTableDB2v70.appendString(buffer, '\'');
                SSBTableDB2v70.appendString(buffer, table.getCommentInRDBMS());
                SSBTableDB2v70.appendStringWithSpace(buffer, '\'');
                SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 0);
                this.appendLineFinisher(buffer, prettyPrint);
            }
            ContainedObject[] columns = table.getElements();
            for (int i = 0; i < columns.length; ++i) {
                Column col = (Column)columns[i];
                if (col.getCommentInRDBMS() == null || "".equalsIgnoreCase(col.getCommentInRDBMS())) continue;
                SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 0);
                SSBTableDB2v70.appendStringWithSpace(buffer, "COMMENT ON");
                SSBTableDB2v70.appendStringWithSpace(buffer, "COLUMN");
                SSBTableDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(col.getLongName()));
                SSBTableDB2v70.appendStringWithSpace(buffer, "IS");
                SSBTableDB2v70.appendString(buffer, '\'');
                SSBTableDB2v70.appendString(buffer, col.getCommentInRDBMS());
                SSBTableDB2v70.appendStringWithSpace(buffer, '\'');
                SSBTableDB2v70.appendNewLine(buffer, prettyPrint, 0);
                this.appendLineFinisher(buffer, prettyPrint);
            }
        }
    }

    private boolean hasAUXTables(TableProxyDB2 tableProxy) {
        try {
            for (AUXTableDB2 auxTable : ((AbstractStorageDesignDB2)tableProxy.getStorageDesign()).getAUXTableSet()) {
                if (!tableProxy.getName().trim().equalsIgnoreCase(auxTable.getTable().getName())) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void appendIndexesForConstraints(StringBuffer oldbuffer, Table table, TableProxy tableProxy) {
        KeyObject[] keys = table.getKeys();
        boolean genPK = table.getDesign().getDesignLevelSettings().isAutomaticPKGeneration();
        boolean genUK = table.getDesign().getDesignLevelSettings().isAutomaticUKGeneration();
        boolean genFK = table.getDesign().getDesignLevelSettings().isAutomaticFKGeneration();
        for (int i = 0; i < keys.length; ++i) {
            Index ind;
            ContainedObject[] cols;
            Index index = (Index)keys[i];
            if (!(genPK && "Primary Constraint".equals(index.getIndexState()) || genUK && "Unique Constraint".equals(index.getIndexState())) && (!index.isFK() || !genFK) || (cols = index.getElements()).length <= 0 || (ind = this.getIndexForColumns(table, index, cols, false)) != null) continue;
            this.ssbIndex.appendIndexForConstraint(oldbuffer, index, tableProxy, true);
        }
    }

    private Index getIndexForColumns(Table table, Index index, ContainedObject[] cols, boolean ascending) {
        Object[] inds = table.getIndexes().toArray();
        for (int i = 0; i < inds.length; ++i) {
            DesignObjectPlaceHolder dph = (DesignObjectPlaceHolder)inds[i];
            Index ind = (Index)dph.getDesignObject();
            ContainedObject[] icols = ind.getElements();
            if (cols.length != icols.length) continue;
            boolean brflag = false;
            for (int j = 0; j < cols.length; ++j) {
                String so;
                if (cols[j] != icols[j]) {
                    brflag = true;
                    break;
                }
                if (!ascending || "ASC".equalsIgnoreCase(so = ind.getColumnSortOrder(icols[j]).trim()) || "".equalsIgnoreCase(so)) continue;
                brflag = true;
                break;
            }
            if (brflag || ind == index) continue;
            return ind;
        }
        return null;
    }

    public SSBArcFK_CheckConstr getArcConstrHandler() {
        if (this.arcConstrHandler == null && this.storageDesign != null) {
            this.arcConstrHandler = new SSBArcFK_CheckConstr(this.storageDesign);
        }
        return this.arcConstrHandler;
    }

    @Override
    public String appendConstraints(TableProxy tableProxy) {
        StringBuffer sb = new StringBuffer();
        if (tableProxy != null && tableProxy instanceof TableProxyDB2v70) {
            Table table = (Table)tableProxy.getObject();
            if (this.storageDesign == null) {
                this.storageDesign = (StorageDesignDB2v70)tableProxy.getStorageDesign();
            }
            this.appendPKDefinition(sb, table, (TableProxyDB2)tableProxy, true);
            this.appendTableCheckConstraints(sb, tableProxy, true);
        }
        return sb.toString();
    }
}

