/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.token;

import java.util.ArrayList;
import oracle.javatools.db.token.Token;
import oracle.javatools.db.token.TokenClause;
import oracle.javatools.db.token.TokenPattern;

class TokenClauseSequence
extends TokenClause {
    ArrayList<TokenClause> m_clauses = new ArrayList();

    TokenClauseSequence() {
    }

    @Override
    void addChildClause(TokenClause clause) {
        this.m_clauses.add(clause);
    }

    @Override
    TokenClause.ClauseResult matches(TokenPattern.PatternResult patternResult, Token startToken) {
        TokenClause.ClauseResult result = new TokenClause.ClauseResult();
        boolean match = true;
        Token lastToken = null;
        Token localStartToken = startToken;
        for (TokenClause clause : this.m_clauses) {
            if (localStartToken == null) {
                match = false;
                break;
            }
            TokenClause.ClauseResult childResult = clause.matches(patternResult, localStartToken);
            if (!childResult.isMatch()) {
                match = false;
                break;
            }
            if (childResult.getEndToken() == null) continue;
            lastToken = childResult.getEndToken();
            localStartToken = lastToken.getNextCodeToken();
        }
        if (match) {
            result.setEndToken(lastToken);
            result.setStartToken(startToken);
            result.setMatch(true);
        }
        this.recordResult(patternResult, result);
        return result;
    }
}

