/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

import oracle.javatools.db.plsql.PlSqlInterrogator;
import oracle.javatools.util.ModelUtil;

public class PlSqlIdentifier {
    private String m_name;
    private String m_schemaName;
    private PlSqlType m_plsqlType;

    private PlSqlIdentifier() {
    }

    public PlSqlIdentifier(String name, String schemaName, PlSqlType plsqlType) {
        this.m_name = name;
        this.m_schemaName = schemaName;
        this.m_plsqlType = plsqlType;
    }

    public static PlSqlIdentifier getPlSqlIdentifier(String source, String schemaName, boolean force) {
        return PlSqlInterrogator.getPlSqlIdentifier(source, schemaName, force);
    }

    public String getName() {
        return this.m_name;
    }

    public String getSchemaName() {
        return this.m_schemaName;
    }

    public PlSqlType getPlsqlType() {
        return this.m_plsqlType;
    }

    public int hashCode() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.m_name).append(this.m_schemaName);
        if (this.m_plsqlType != null) {
            sb.append(this.m_plsqlType.toString());
        }
        return sb.toString().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof PlSqlIdentifier && ModelUtil.areEqual((Object)((PlSqlIdentifier)obj).m_name, (Object)this.m_name) && ModelUtil.areEqual((Object)((PlSqlIdentifier)obj).m_schemaName, (Object)this.m_schemaName) && ModelUtil.areEqual((Object)((Object)((PlSqlIdentifier)obj).m_plsqlType), (Object)((Object)this.m_plsqlType));
    }

    public static enum PlSqlType {
        PROCEDURE,
        FUNCTION,
        PACKAGE,
        PACKAGE_BODY,
        TYPE,
        TYPE_BODY,
        TRIGGER;


        public String toString() {
            return super.toString().replaceAll("_", " ");
        }
    }
}

