/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.syntax.DataObject;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.TypedExpression;
import oracle.olapi.syntax.ValidationContext;

public final class Qualifier
extends DataObject {
    private MdmPrimaryDimension m_Dimension = null;
    private TypedExpression m_Expression = null;

    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.appendIdentifier(this.getDimension().getInternalID());
        syntaxPrintingContext.append(" = ");
        syntaxPrintingContext.print(this.getExpression());
    }

    public SyntaxObject validate(ValidationContext validationContext) {
        validationContext.push(this);
        this.m_Expression = validationContext.validateExp(this.m_Expression);
        validationContext.pop();
        return this;
    }

    protected boolean checkIfDefinitionIsComplete() {
        return this.getExpression().isDefinitionComplete();
    }

    public Qualifier(MdmPrimaryDimension mdmPrimaryDimension, TypedExpression typedExpression) {
        Qualifier.validateValue(mdmPrimaryDimension);
        Qualifier.validateValue(typedExpression);
        this.m_Dimension = mdmPrimaryDimension;
        this.m_Expression = typedExpression;
        this.initialize();
    }

    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitQualifier(this, object);
    }

    public MdmPrimaryDimension getDimension() {
        return this.m_Dimension;
    }

    public TypedExpression getExpression() {
        return this.m_Expression;
    }

    public boolean isCompositeObject() {
        return true;
    }
}

