/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mtm;

import java.util.List;
import oracle.olapi.UnsupportedOperationException;
import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.mdm.MdmDimension;
import oracle.olapi.metadata.mdm.MdmMeasure;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mtm.MtmBaseCube;
import oracle.olapi.metadata.mtm.MtmCube;
import oracle.olapi.metadata.mtm.MtmMeasureMap;
import oracle.olapi.metadata.mtm.MtmObjectVisitor;
import oracle.olapi.metadata.mtm.MtmValueExpression;
import oracle.olapi.metadata.mtm.MtmXMLTags;

public class MtmPartitionedCube
extends MtmCube {
    MtmPartitionedCube(BaseMetadataProvider baseMetadataProvider) {
        super(baseMetadataProvider);
    }

    public Object acceptVisitor(MtmObjectVisitor mtmObjectVisitor, Object object) {
        return mtmObjectVisitor.visitMtmPartitionedCube(this, object);
    }

    public List getBaseCubes() {
        return this.getPropertyListValues(MtmXMLTags.BASE_CUBE_REF);
    }

    public String getCubeName() {
        return this.getPropertyStringValue(MtmXMLTags.CUBE_NAME);
    }

    public MtmBaseCube getDefaultBaseCube() {
        return (MtmBaseCube)this.getPropertyObjectValue(MtmXMLTags.DEFAULT_BASE_CUBE);
    }

    public String getDescription() {
        return this.getPropertyStringValue(MtmXMLTags.DESCRIPTION);
    }

    public void setDescription(String string) {
        this.setPropertyStringValue(MtmXMLTags.DESCRIPTION, string);
    }

    protected XMLTag getXMLTag() {
        return MtmXMLTags.PARTITIONED_CUBE_TAG;
    }

    protected XMLTag getPropertyXMLTag(String string, String string2) {
        if (MtmXMLTags.BASE_CUBE_REF.matches(string, string2)) {
            return MtmXMLTags.BASE_CUBE_REF;
        }
        if (MtmXMLTags.CUBE_NAME.matches(string, string2)) {
            return MtmXMLTags.CUBE_NAME;
        }
        if (MtmXMLTags.DESCRIPTION.matches(string, string2)) {
            return MtmXMLTags.DESCRIPTION;
        }
        if (MtmXMLTags.DEFAULT_BASE_CUBE.matches(string, string2)) {
            return MtmXMLTags.DEFAULT_BASE_CUBE;
        }
        return super.getPropertyXMLTag(string, string2);
    }

    void setCubeNAME(String string) {
        this.setPropertyStringValue(MtmXMLTags.CUBE_NAME, string);
    }

    public void setDefaultBaseCube(MtmBaseCube mtmBaseCube) {
        if (!this.isServerVersionLaterThan(new int[]{10, 2, 0, 0})) {
            throw new UnsupportedOperationException();
        }
        this.setPropertyObjectValue(MtmXMLTags.DEFAULT_BASE_CUBE, mtmBaseCube);
        mtmBaseCube.setPartitionedCube(this);
    }

    public void addBaseCube(MtmBaseCube mtmBaseCube) {
        this.addToListProperty(MtmXMLTags.BASE_CUBE_REF, mtmBaseCube);
        mtmBaseCube.setPartitionedCube(this);
    }

    public void removeBaseCube(MtmBaseCube mtmBaseCube) {
        this.removeFromListProperty(MtmXMLTags.BASE_CUBE_REF, mtmBaseCube);
    }

    public void addDimension(MdmDimension mdmDimension) {
        this.addToListProperty(MtmXMLTags.DIM_MAP_REF, mdmDimension.getSourceMap());
    }

    public void removeDimension(MdmDimension mdmDimension) {
        this.removeFromListProperty(MtmXMLTags.DIM_MAP_REF, mdmDimension.getSourceMap());
        for (MtmBaseCube mtmBaseCube : this.getBaseCubes()) {
            mtmBaseCube.removeDimension(mdmDimension);
        }
    }

    public void addMeasureMap(MtmMeasureMap mtmMeasureMap) {
        this.addToListProperty(MtmXMLTags.MEAS_MAP_REF, mtmMeasureMap);
        mtmMeasureMap.setCube(this);
    }

    public void removeMeasureMap(MtmMeasureMap mtmMeasureMap) {
        this.removeFromListProperty(MtmXMLTags.MEAS_MAP_REF, mtmMeasureMap);
        mtmMeasureMap.setCube(null);
    }

    public MdmMeasure createNumericMeasure(String string, MtmValueExpression mtmValueExpression) {
        return ((MdmMetadataProvider)this.getBaseMetadataProvider()).getMdmCustomObjectFactory().createNumericMeasure(string, this, mtmValueExpression);
    }

    public MdmMeasure createNumericMeasure(String string, String string2) {
        return ((MdmMetadataProvider)this.getBaseMetadataProvider()).getMdmCustomObjectFactory().createNumericMeasure(string, this, string2);
    }

    public MdmMeasure createBooleanMeasure(String string, MtmValueExpression mtmValueExpression) {
        return ((MdmMetadataProvider)this.getBaseMetadataProvider()).getMdmCustomObjectFactory().createBooleanMeasure(string, this, mtmValueExpression);
    }

    public MdmMeasure createBooleanMeasure(String string, String string2) {
        return ((MdmMetadataProvider)this.getBaseMetadataProvider()).getMdmCustomObjectFactory().createBooleanMeasure(string, this, string2);
    }

    public MdmMeasure createStringMeasure(String string, MtmValueExpression mtmValueExpression) {
        return ((MdmMetadataProvider)this.getBaseMetadataProvider()).getMdmCustomObjectFactory().createStringMeasure(string, this, mtmValueExpression);
    }

    public MdmMeasure createStringMeasure(String string, String string2) {
        return ((MdmMetadataProvider)this.getBaseMetadataProvider()).getMdmCustomObjectFactory().createStringMeasure(string, this, string2);
    }

    public MdmMeasure createDateMeasure(String string, MtmValueExpression mtmValueExpression) {
        return ((MdmMetadataProvider)this.getBaseMetadataProvider()).getMdmCustomObjectFactory().createDateMeasure(string, this, mtmValueExpression);
    }

    public MdmMeasure createDateMeasure(String string, String string2) {
        return ((MdmMetadataProvider)this.getBaseMetadataProvider()).getMdmCustomObjectFactory().createDateMeasure(string, this, string2);
    }

    public void removeMeasure(MdmMeasure mdmMeasure) {
        this.removeMeasureMap((MtmMeasureMap)mdmMeasure.getSourceMap());
    }
}

