/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.conversion;

import java.util.ArrayList;
import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.conversion.LegacyXMLConverter;
import oracle.olapi.metadata.conversion.LegacyXMLMeasure;
import oracle.olapi.metadata.conversion.LegacyXMLObject;
import oracle.olapi.metadata.conversion.LegacyXMLOperator;
import oracle.olapi.metadata.conversion.LegacyXMLTags;
import oracle.olapi.metadata.mdm.MdmCube;
import oracle.olapi.metadata.mdm.MdmDerivedMeasure;
import oracle.olapi.syntax.Expression;
import oracle.olapi.syntax.SQLDataType;

final class LegacyXMLDerivedMeasure
extends LegacyXMLMeasure {
    private static final XMLTag[] LOCAL_TAGS = new XMLTag[]{LegacyXMLTags.EXPRESSION_TEXT, LegacyXMLTags.BI_BEANS_DEFINITION, LegacyXMLTags.BEAN_INPUT, LegacyXMLTags.IS_VALID, LegacyXMLTags.OPERATOR};

    protected LegacyXMLDerivedMeasure(BaseMetadataProvider baseMetadataProvider) {
        super(baseMetadataProvider);
    }

    String getExpressionText() {
        return this.getPropertyStringValue(LegacyXMLTags.EXPRESSION_TEXT);
    }

    String getBIBeansDefinition() {
        return this.getPropertyStringValue(LegacyXMLTags.BI_BEANS_DEFINITION);
    }

    String getBeanInput() {
        return this.getPropertyStringValue(LegacyXMLTags.BEAN_INPUT);
    }

    boolean getIsValid() {
        return this.getPropertyBooleanValue(LegacyXMLTags.IS_VALID);
    }

    LegacyXMLOperator getOperator() {
        return (LegacyXMLOperator)this.getPropertyObjectValue(LegacyXMLTags.OPERATOR);
    }

    protected XMLTag getPropertyXMLTag(String string, String string2) {
        XMLTag xMLTag = this.findXMLTag(string, string2, LOCAL_TAGS);
        if (null == xMLTag) {
            return super.getPropertyXMLTag(string, string2);
        }
        return xMLTag;
    }

    protected XMLTag getXMLTag() {
        return LegacyXMLTags.DERIVED_MEASURE_TAG;
    }

    protected boolean validateState(LegacyXMLConverter legacyXMLConverter) {
        if (!super.validateState(legacyXMLConverter)) {
            return false;
        }
        if (null != this.getBIBeansDefinition() && this.getBIBeansDefinition().length() > 0) {
            legacyXMLConverter.reportIgnoredProperty(LegacyXMLTags.BI_BEANS_DEFINITION, this.getBIBeansDefinition(), this, false);
        }
        if (null != this.getBeanInput() && this.getBeanInput().length() > 0) {
            legacyXMLConverter.reportIgnoredProperty(LegacyXMLTags.BEAN_INPUT, this.getBeanInput(), this, false);
        }
        legacyXMLConverter.validateRequiredProperty(LegacyXMLTags.EXPRESSION_TEXT, this.getExpressionText(), this);
        if (null == this.parseExpression(legacyXMLConverter, this.getExpressionText(), true)) {
            legacyXMLConverter.reportIgnoredProperty(LegacyXMLTags.EXPRESSION_TEXT, this.getExpressionText(), this, false);
        }
        return true;
    }

    protected void convertToMdm(LegacyXMLConverter legacyXMLConverter) {
        MdmCube mdmCube = this.getCube().getMdmCube();
        MdmDerivedMeasure mdmDerivedMeasure = mdmCube.findOrCreateDerivedMeasure(this.getName());
        Expression expression = this.parseExpression(legacyXMLConverter, this.getExpressionText(), false);
        if (null != expression) {
            mdmDerivedMeasure.setMeasureExpression(expression);
        }
        this.setMdmDerivedMeasure(mdmDerivedMeasure);
        super.convertToMdm(legacyXMLConverter);
    }

    private void setMdmDerivedMeasure(MdmDerivedMeasure mdmDerivedMeasure) {
        this.setMdmMeasure(mdmDerivedMeasure);
    }

    private Expression parseExpression(LegacyXMLConverter legacyXMLConverter, String string, boolean bl) {
        Object object;
        Object object2;
        int n;
        String[] stringArray = string.split(" ");
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (n = 0; n < stringArray.length; ++n) {
            if (0 >= stringArray[n].indexOf(46) || null == (object2 = legacyXMLConverter.getMetadataReader().lookupObjectReference(stringArray[n])) || arrayList.contains(stringArray[n])) continue;
            arrayList.add(stringArray[n]);
            arrayList2.add(object2);
        }
        if (arrayList.size() > 0) {
            for (n = 0; n < arrayList.size(); ++n) {
                object2 = (String)arrayList.get(n);
                object = (LegacyXMLObject)arrayList2.get(n);
                BaseMetadataObject baseMetadataObject = ((LegacyXMLObject)object).getConvertToObject();
                if (null != baseMetadataObject) {
                    string = string.replaceAll((String)object2, baseMetadataObject.getID());
                    continue;
                }
                if (bl) continue;
                return null;
            }
        }
        n = 0;
        object2 = null;
        try {
            object2 = this.toSyntaxExpression(string);
        }
        catch (Throwable throwable) {
            n = 1;
        }
        if (n != 0) {
            object = LegacyXMLConverter.getSQLDataType(this.getDataType());
            if (null == object) {
                return null;
            }
            string = "OLAP_DML_EXPRESSION('" + string.replaceAll("'", "''") + "', " + ((SQLDataType)object).getSQLText() + ")";
            object2 = this.toSyntaxExpression(string);
        }
        return object2;
    }
}

