/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.changeset;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.util.Assert;
import oracle.ide.vcs.VCS;
import oracle.ide.vcs.VCSRegistry;
import oracle.jdeveloper.vcs.cache.Depth;
import oracle.jdeveloper.vcs.cache.StatusCacheBridge;
import oracle.jdeveloper.vcs.cache.StatusCacheEvent;
import oracle.jdeveloper.vcs.cache.StatusCacheListener;
import oracle.jdeveloper.vcs.changeset.ChangeSetAdapter;
import oracle.jdeveloper.vcs.changeset.ChangeSetException;
import oracle.jdeveloper.vcs.changeset.ChangeSetRegistry;
import oracle.jdeveloper.vcs.changeset.ChangeSetUpdate;
import oracle.jdeveloper.vcs.spi.VCSEventBus;
import oracle.jdeveloper.vcs.spi.VCSExtension;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSURLBasedCacheEvent;
import oracle.jdeveloper.vcs.spi.VCSURLBasedCacheListener;
import oracle.jdevimpl.vcs.util.FileSystemLister;
import oracle.jdevimpl.vcs.util.ProfileFileSystemLister;

public final class ChangeSetService
implements Observer {
    private final List<ServiceEvent> _queue = new LinkedList<ServiceEvent>();
    private static final Object _mutex = new Object();
    private boolean _alive = false;
    private int _count = 0;
    private Thread _thread;
    private static ChangeSetService _instance;

    public ChangeSetService() {
        _instance = this;
    }

    public static final Object getQueueMutex() {
        return _mutex;
    }

    public static final boolean isQueueBusy() {
        return _instance != null && _instance._isQueueBusy();
    }

    private final boolean _isQueueBusy() {
        return this._count > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void start() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    ChangeSetService.this.eventLoop();
                }
                catch (InterruptedException ie) {
                    Assert.printStackTrace((Throwable)ie);
                }
                ChangeSetService.this._alive = false;
            }
        };
        ChangeSetService changeSetService = this;
        synchronized (changeSetService) {
            this._thread = new Thread(r, "ChangeSetService");
            this._thread.setDaemon(true);
            this._thread.setPriority(1);
            this._alive = true;
            this._thread.start();
        }
    }

    private synchronized void enqueue(ServiceEvent se) {
        this._queue.add(se);
        ++this._count;
        this.notifyAll();
    }

    private synchronized void awaitEvents() throws InterruptedException {
        while (this.isEmpty() && this.isAlive()) {
            this.wait();
        }
    }

    private synchronized ServiceEvent dequeue() {
        ServiceEvent se = this._queue.remove(0);
        this.notifyAll();
        return se;
    }

    private synchronized boolean isEmpty() {
        return this._queue.isEmpty();
    }

    private void eventLoop() throws InterruptedException {
        while (true) {
            this.awaitEvents();
            if (!this.isAlive()) {
                return;
            }
            Thread.sleep(500L);
            this.processEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEvents() throws InterruptedException {
        while (!this.isEmpty()) {
            if (!this.isAlive()) {
                return;
            }
            ServiceEvent se = this.dequeue();
            try {
                this.processEvent(se);
            }
            catch (InterruptedException ie) {
                throw ie;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            --this._count;
        }
        Object object = _mutex;
        synchronized (object) {
            _mutex.notifyAll();
        }
    }

    protected void processEvent(ServiceEvent se) throws Exception {
        if (se.getRunnable() != null) {
            se.getRunnable().run();
            return;
        }
        VCS vcs = VCSRegistry.lookup((String)se.getSystemId());
        if (!(vcs instanceof VCSExtension)) {
            return;
        }
        ChangeSetAdapter csAdapter = ChangeSetRegistry.lookup(se.getSystemId());
        if (csAdapter == null) {
            return;
        }
        if (se.getURLs() == null && se.getStatusCacheEvent() == null) {
            throw new IllegalStateException();
        }
        if (se.getURLs() != null) {
            this.handleChanges(se.getSystemId(), se.getURLs(), Depth.EMPTY);
            return;
        }
        StatusCacheEvent sce = se.getStatusCacheEvent();
        if (sce.isInvalidate()) {
            return;
        }
        URL[] urls = new ProfileFileSystemLister(se.getSystemId()).listFiles(sce.getURLs(), FileSystemLister.ListMode.FILES_AND_DIRECTORIES, sce.getDepth(), null).toArray(new URL[0]);
        this.handleChanges(se.getSystemId(), urls, sce.getDepth());
    }

    private final boolean isAlive() {
        return this._alive;
    }

    public static final void fireChangesCommitted(String vcsId, URL[] urls, Depth depth) {
        if (_instance != null) {
            _instance._fireChangesCommitted(vcsId, urls, depth);
        }
    }

    private final void _fireChangesCommitted(final String vcsId, final URL[] urls, final Depth depth) {
        Runnable r = new Runnable(){

            @Override
            public final void run() {
                ChangeSetService.this.handleChanges(vcsId, urls, depth);
            }
        };
        if (this.isAlive()) {
            this.enqueue(new ServiceEvent(r));
        } else {
            Thread thread = new Thread(r, "ChangeSetService Commit");
            thread.setPriority(1);
            thread.start();
        }
    }

    private final void handleChanges(String vcsId, URL[] urls, Depth depth) {
        VCS vcs = VCSRegistry.lookup((String)vcsId);
        if (!(vcs instanceof VCSExtension)) {
            return;
        }
        StatusCacheBridge<VCSStatus> cache = ((VCSExtension)vcs).getStatusCacheBridge();
        if (cache == null) {
            return;
        }
        ChangeSetAdapter adapter = ChangeSetRegistry.lookup(vcsId);
        if (adapter == null) {
            return;
        }
        try {
            List<URL> urls0 = Arrays.asList(urls);
            VCSStatus[] statuses = ((VCSExtension)vcs).getStatus(urls0.toArray(new URL[urls0.size()]));
            ArrayList<URL> changedUrls = new ArrayList<URL>();
            ArrayList<URL> unchangedUrls = new ArrayList<URL>();
            for (int i = 0; i < urls0.size(); ++i) {
                if (!adapter.isChanged(statuses[i])) {
                    unchangedUrls.add(urls0.get(i));
                    continue;
                }
                changedUrls.add(urls0.get(i));
            }
            if (!changedUrls.isEmpty()) {
                VCSEventBus.send(new ChangeSetUpdate(vcsId, changedUrls.toArray(new URL[changedUrls.size()]), ChangeSetUpdate.PENDING));
            }
            if (!unchangedUrls.isEmpty()) {
                VCSEventBus.send(new ChangeSetUpdate(vcsId, unchangedUrls.toArray(new URL[unchangedUrls.size()]), ChangeSetUpdate.COMMITTED));
            }
        }
        catch (ChangeSetException cse) {
            FeedbackManager.reportException((Throwable)cse);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (!(arg instanceof VCSExtension)) {
            return;
        }
        VCSExtension vcs = (VCSExtension)arg;
        if (vcs.getStatusCache() == null && vcs.getPolicyStatusCache() == null) {
            return;
        }
        final String id = vcs.getId();
        if (vcs.getStatusCache() != null) {
            vcs.getStatusCache().addCacheListener(new VCSURLBasedCacheListener(){

                @Override
                public final void valuesCleared(VCSURLBasedCacheEvent e) {
                    if (!ChangeSetService.this.isAlive()) {
                        return;
                    }
                    if (!e.isInvalidate()) {
                        ChangeSetService.this.enqueue(new ServiceEvent(e.getURLs(), id));
                    }
                }

                @Override
                public void valueRecached(VCSURLBasedCacheEvent e) {
                    if (!ChangeSetService.this.isAlive()) {
                        return;
                    }
                    ChangeSetService.this.enqueue(new ServiceEvent(new URL[]{e.getNewURL()}, id));
                }
            });
        }
        if (vcs.getPolicyStatusCache() != null) {
            vcs.getPolicyStatusCache().addCacheListener(new StatusCacheListener(){

                @Override
                public final void statusesCleared(StatusCacheEvent e) {
                    if (!ChangeSetService.this.isAlive()) {
                        return;
                    }
                    ChangeSetService.this.enqueue(new ServiceEvent(e, id));
                }
            });
        }
        if (!this.isAlive()) {
            this.start();
        }
    }

    private class ServiceEvent {
        private final URL[] _urls;
        private final String _systemId;
        private final Runnable _r;
        private final StatusCacheEvent _sce;

        ServiceEvent(URL[] urls, String systemId) {
            this._urls = urls;
            this._systemId = systemId;
            this._r = null;
            this._sce = null;
        }

        ServiceEvent(Runnable r) {
            this._urls = null;
            this._systemId = null;
            this._r = r;
            this._sce = null;
        }

        ServiceEvent(StatusCacheEvent sce, String systemId) {
            this._urls = null;
            this._systemId = systemId;
            this._r = null;
            this._sce = sce;
        }

        final URL[] getURLs() {
            return this._urls;
        }

        final String getSystemId() {
            return this._systemId;
        }

        final Runnable getRunnable() {
            return this._r;
        }

        final StatusCacheEvent getStatusCacheEvent() {
            return this._sce;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("ServiceEvent: ");
            sb.append(this._systemId);
            sb.append(": ");
            if (this._r != null) {
                sb.append("(runnable) ");
            }
            if (this._urls != null) {
                sb.append(Arrays.asList(this._urls).toString());
            }
            return sb.toString();
        }
    }
}

