/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.dbcart.headless;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.dbcart.DbCartAddinArb;
import oracle.dbtools.dbcart.DbCartXMLUtil;
import oracle.dbtools.dbcart.config.DbCartUserConfig;
import oracle.dbtools.dbcart.headless.DbCartHeadlessResources;
import oracle.dbtools.raptor.ddl.TargetFormat;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.extract.models.ExtractObject;
import oracle.dbtools.raptor.extract.models.ExtractReconciler;
import oracle.dbtools.raptor.headless.HeadlessCore;
import oracle.dbtools.raptor.headless.InvalidCommandArgumentException;
import oracle.dbtools.raptor.headless.LogHandler;
import oracle.dbtools.raptor.utils.Connections;

public abstract class DbCartCommand {
    private Type _type;
    private String _cartXML;
    private String _configXML;
    private String _logFile;
    private String _tgtFile;
    private boolean _isHelp;
    protected ArrayList<ExtractObject> _extractObjects = new ArrayList();
    protected DbCartUserConfig _config;
    private HeadlessCore _headless;

    public DbCartCommand(Type type, HeadlessCore headlessCore) {
        this._type = type;
        this._headless = headlessCore;
    }

    abstract void getConfig() throws InvalidCommandArgumentException;

    abstract void doCommand();

    abstract String getHelpKey();

    public boolean processToolItem(String string, List<String> list) throws InvalidCommandArgumentException {
        return false;
    }

    public void handleLog() throws InvalidCommandArgumentException {
        if (this._logFile != null && this._logFile.length() > 0) {
            LogHandler logHandler = LogHandler.getInstance();
            logHandler.setLogFile(this._logFile, this._headless);
        }
    }

    public String getHelp() {
        return DbCartHeadlessResources.getString(this.getHelpKey());
    }

    public boolean isHelp() {
        return this._isHelp;
    }

    public void isHelp(boolean bl) {
        this._isHelp = bl;
    }

    public void validateParse() throws InvalidCommandArgumentException {
        if (this._cartXML == null || this._cartXML.length() == 0) {
            throw new InvalidCommandArgumentException(DbCartHeadlessResources.getString("CART_MISSING"));
        }
        if (!new File(this._cartXML).isFile()) {
            throw new InvalidCommandArgumentException(DbCartHeadlessResources.format("CART_INVALID", this._cartXML));
        }
        if (this._configXML == null || this._configXML.length() == 0) {
            throw new InvalidCommandArgumentException(DbCartHeadlessResources.getString("CONFIG_MISSING"));
        }
        if (!new File(this._configXML).isFile()) {
            throw new InvalidCommandArgumentException(DbCartHeadlessResources.format("CONFIG_INVALID", this._configXML));
        }
        if (this._logFile != null && this._logFile.length() > 0 && !this._logFile.equalsIgnoreCase("stderr")) {
            File file = new File(this._logFile);
            if (file.isFile()) {
                file.delete();
            }
            TargetFormat targetFormat = new TargetFormat(2, 1, false);
            targetFormat.setSaveAsType(0);
            targetFormat.setSaveAs(this._logFile);
            int n = targetFormat.validateSaveAs();
            if (n != 0) {
                throw new InvalidCommandArgumentException(targetFormat.getValidationMessage());
            }
        }
    }

    public void validate() throws InvalidCommandArgumentException {
    }

    public Type getType() {
        return this._type;
    }

    public void setCartXML(String string) {
        this._cartXML = string;
    }

    public String getCartXML() {
        return this._cartXML;
    }

    protected ArrayList<ExtractObject> getIncludedExtractObjects() {
        return this._extractObjects;
    }

    protected boolean isAnyDDLRows() {
        return !ExtractListModel.getList(this._extractObjects, (int[])new int[]{100}).isEmpty();
    }

    protected boolean isAnyDataRows() {
        return !ExtractListModel.getList(this._extractObjects, (int[])new int[]{101}).isEmpty();
    }

    public void setConfigXML(String string) {
        this._configXML = string;
    }

    public String getConfigXML() {
        return this._configXML;
    }

    protected void validateConfig(URL uRL, String string) throws InvalidCommandArgumentException {
        String string2 = this._config.getString("DbCartConfig");
        if (string2 == null) {
            string2 = DbCartAddinArb.getString("XML_FILE_NO_KEY");
        }
        if (!string2.equals(string)) {
            throw new InvalidCommandArgumentException(DbCartAddinArb.format("XML_FILE_ERROR_MESSAGE", uRL.getFile(), "\"" + string + "\"", string2));
        }
    }

    protected ArrayList<ExtractObject> getCart() {
        if (this._extractObjects.isEmpty()) {
            DbCartXMLUtil dbCartXMLUtil = new DbCartXMLUtil(this._extractObjects);
            dbCartXMLUtil.setImport(true);
            try {
                FileInputStream fileInputStream = new FileInputStream(this._cartXML);
                InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
                dbCartXMLUtil.parseXML(inputStreamReader, true);
                inputStreamReader.close();
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
            dbCartXMLUtil.setImport(false);
        }
        return this._extractObjects;
    }

    protected String validateCart() {
        if (this._extractObjects == null) {
            return DbCartHeadlessResources.getString("CART_NOT_SPECIFIED");
        }
        for (ExtractObject extractObject : this._extractObjects) {
            if (ExtractReconciler.reconcileExistence((ExtractObject)extractObject)) continue;
            Connections.getInstance();
            String string = DbCartHeadlessResources.format("NOT_EXISTS_OBJECT", Connections.getDisplayName((String)extractObject.getSourceConnName()), extractObject.getDBObject().getObjectType(), extractObject.getDBObject().getObjectName());
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, string);
        }
        this._extractObjects = ExtractListModel.getList((List)ExtractListModel.getList(this._extractObjects, (int[])new int[]{107}), (int[])new int[]{103});
        return null;
    }

    public void setLogFile(String string) {
        this._logFile = string;
    }

    public String getLogFile() {
        return this._logFile;
    }

    public void setTgtFile(String string) {
        this._tgtFile = string;
    }

    public String getTgtFile() {
        return this._tgtFile;
    }

    public static enum Type {
        CLOUD,
        EXPORT,
        DIFF,
        COPY;

    }
}

