/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.dbcart;

import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import oracle.dbtools.raptor.ddl.TargetFormat;
import oracle.dbtools.raptor.ddl.oracle.OracleApex;
import oracle.dbtools.raptor.extract.models.ExtractObject;
import oracle.dbtools.raptor.extract.models.ExtractScript;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.XLIFFHelper;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.dbtools.util.Logger;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DbCartXMLUtil {
    Boolean _import = false;
    private DOMParser _parser;
    boolean _cancel = false;
    protected ArrayList<ExtractObject> _model;

    public DbCartXMLUtil() {
        this._model = new ArrayList();
    }

    public DbCartXMLUtil(ArrayList<ExtractObject> arrayList) {
        this._model = arrayList;
    }

    protected ExtractObject addRow(DBObject dBObject, String string) {
        ExtractObject extractObject = new ExtractObject(dBObject, null);
        extractObject.setSourceConnName(string);
        this._model.add(extractObject);
        return extractObject;
    }

    protected ExtractObject addScriptRow(String string) {
        int n = Integer.parseInt(string);
        ExtractObject extractObject = n == 2 ? this.addScriptRow(2, 114) : this.addScriptRow(3, 115);
        this._model.add(extractObject);
        return extractObject;
    }

    public ExtractObject addScriptRow(int n, int n2) {
        try {
            TargetFormat targetFormat = new TargetFormat(1, 4);
            String string = targetFormat.getDefaultDirectory();
            File file = new File(string);
            URL uRL = file.toURI().toURL();
            ExtractObject extractObject = new ExtractObject(uRL, null);
            extractObject.setType(n);
            return extractObject;
        }
        catch (Exception exception) {
            Logger.warn(this.getClass(), (Throwable)exception);
            return null;
        }
    }

    private DOMParser getParser() {
        if (this._parser == null) {
            this._parser = new DOMParser();
        } else {
            this._parser.reset();
        }
        return this._parser;
    }

    public ArrayList<ExtractObject> parseXML(InputStreamReader inputStreamReader, boolean bl, String string) {
        DOMParser dOMParser = this.getParser();
        dOMParser.setPreserveWhitespace(false);
        try {
            dOMParser.parse((Reader)inputStreamReader);
        }
        catch (Exception exception) {
            Logger.warn(this.getClass(), (Throwable)exception);
        }
        XMLDocument xMLDocument = dOMParser.getDocument();
        this.processNode((Node)xMLDocument, bl);
        return this._model;
    }

    public ArrayList<ExtractObject> parseXML(InputStreamReader inputStreamReader, boolean bl) {
        DOMParser dOMParser = this.getParser();
        dOMParser.setPreserveWhitespace(false);
        try {
            dOMParser.parse((Reader)inputStreamReader);
            XMLDocument xMLDocument = dOMParser.getDocument();
            this.processNode((Node)xMLDocument, bl);
        }
        catch (Exception exception) {
            Logger.warn(this.getClass(), (Throwable)exception);
        }
        return this._model;
    }

    private void processNode(Node node, boolean bl) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength() && !this._cancel; ++i) {
            if (nodeList.item(i).getNodeName().equalsIgnoreCase("dbobject")) {
                this.processDbObject(nodeList.item(i), bl);
                continue;
            }
            if (nodeList.item(i).getNodeName().equalsIgnoreCase("fileobject")) {
                this.processFileObject(nodeList.item(i), bl);
                continue;
            }
            if (nodeList.item(i).getNodeName().equalsIgnoreCase("objects")) {
                this.processNode(nodeList.item(i), bl);
                continue;
            }
            if (nodeList.item(i).getNodeName().equalsIgnoreCase("connections")) {
                this.processNode(nodeList.item(i), bl);
                continue;
            }
            if (nodeList.item(i).getNodeName().equalsIgnoreCase("connection")) {
                this.processConnection(nodeList.item(i), bl);
                continue;
            }
            if (!nodeList.item(i).getNodeName().equalsIgnoreCase("cart")) continue;
            this.processNode(nodeList.item(i), bl);
        }
    }

    private void processConnection(Node node, boolean bl) {
        if (node != null) {
            String string = this.notNull(XMLHelper.getNodeValue((Node)node, (String)"displayname"));
            String string2 = this.notNull(XMLHelper.getNodeValue((Node)node, (String)"connectionname"));
            String string3 = this.notNull(XMLHelper.getNodeValue((Node)node, (String)"connectionuser"));
        }
    }

    public void processDbObject(Node node, boolean bl) {
        if (node != null) {
            String[] stringArray;
            String string = this.notNull(XMLHelper.getNodeValue((Node)node, (String)"objectconnection"));
            String string2 = this.notNull(XMLHelper.getNodeValue((Node)node, (String)"objecttype"));
            String string3 = this.notNull(XMLHelper.getNodeValue((Node)node, (String)"objectschema"));
            String string4 = this.notNull(XMLHelper.getNodeValue((Node)node, (String)"objectname"));
            String string5 = this.notNull(XMLHelper.getNodeValue((Node)node, (String)"applicationname"));
            String string6 = this.notNull(XMLHelper.getNodeValue((Node)node, (String)"workspacename"));
            boolean bl2 = this.notNullBoolean(XMLHelper.getNodeValue((Node)node, (String)"include")).equals("true");
            boolean bl3 = this.notNullBoolean(XMLHelper.getNodeValue((Node)node, (String)"meta")).equals("true");
            boolean bl4 = this.notNullBoolean(XMLHelper.getNodeValue((Node)node, (String)"data")).equals("true");
            URL uRL = DBURLFormatHelper.getURL((String)"sqldev.nav", (String)string, null, (String)string3, (String)string2);
            URL uRL2 = DBURLFormatHelper.getURL((URL)uRL, (String)string4);
            DBObject dBObject = new DBObject(uRL2);
            ExtractObject extractObject = this.addRow(dBObject, string);
            extractObject.isPreSelected(bl2);
            extractObject.isExtractMetaData(bl3);
            extractObject.isExtractData(bl4);
            extractObject.isSelectedData(bl4);
            extractObject.isExistsSource(true);
            Map map = dBObject.getDictionary();
            if (map != null && dBObject.getObjectType().equals("APEX")) {
                map.put("APPLICATION_NAME", string5);
                map.put("WORKSPACE", string6);
                stringArray = new OracleApex().getIds(dBObject, string5, string6);
                map.put("APPLICATION_ID", stringArray[0]);
                map.put("WORKSPACE_ID", stringArray[1]);
            }
            extractObject.setWhere(this.notNull(XMLHelper.getNodeValue((Node)node, (String)"filter")));
            stringArray = node.getChildNodes();
            for (int i = 0; i < stringArray.getLength() && !this._cancel; ++i) {
                if (!stringArray.item(i).getNodeName().equalsIgnoreCase("scripts")) continue;
                this.processScripts(stringArray.item(i), bl, extractObject);
            }
        }
    }

    public void processScripts(Node node, boolean bl, ExtractObject extractObject) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength() && !this._cancel; ++i) {
            if (!nodeList.item(i).getNodeName().equalsIgnoreCase("script")) continue;
            String string = this.notNull(XMLHelper.getNodeValue((Node)nodeList.item(i), (String)"execWhen"));
            String string2 = this.notNull(XMLHelper.getNodeValue((Node)nodeList.item(i), (String)"fileurl"));
            String string3 = "";
            try {
                string3 = new URL(string2).getPath();
            }
            catch (Exception exception) {
                Logger.warn(this.getClass(), (Throwable)exception);
            }
            boolean bl2 = this.notNullBoolean(XMLHelper.getNodeValue((Node)nodeList.item(i), (String)"includefile")).equals("true");
            String string4 = this.notNull(XMLHelper.getNodeValue((Node)nodeList.item(i), (String)"encoding"));
            extractObject.addScript(string3, string4, string, bl2);
        }
    }

    public void processFileObject(Node node, boolean bl) {
        if (node != null) {
            int n;
            String string = this.notNull(XMLHelper.getNodeValue((Node)node, (String)"filetype"));
            URL uRL = null;
            try {
                uRL = new URL(this.notNull(XMLHelper.getNodeValue((Node)node, (String)"fileurl")));
            }
            catch (Exception exception) {
                Logger.warn(this.getClass(), (Throwable)exception);
            }
            boolean bl2 = this.notNullBoolean(XMLHelper.getNodeValue((Node)node, (String)"includefile")).equals("true");
            ExtractObject extractObject = this.addScriptRow(string);
            extractObject.isSelectedFile(bl2);
            extractObject.isPreSelected(bl2);
            NodeList nodeList = node.getChildNodes();
            for (n = 0; n < nodeList.getLength() && !this._cancel; ++n) {
                if (!nodeList.item(n).getNodeName().equalsIgnoreCase("scripts")) continue;
                this.processScripts(nodeList.item(n), bl, extractObject);
            }
            n = Integer.parseInt(string);
            int n2 = n == 2 ? 114 : 115;
            ExtractScript extractScript = extractObject.getScript(n2);
            if (extractScript == null) {
                extractObject.addScript(uRL.getPath(), "", n2, bl2);
            }
        }
    }

    public String notNull(String string) {
        if (string == null || string.equals("null")) {
            return "";
        }
        return string;
    }

    public String notNullBoolean(String string) {
        if (string == null || string.equals("null") || string.equals("false")) {
            return "false";
        }
        return "true";
    }

    public void setImport(Boolean bl) {
        this._import = bl;
    }

    public void parseXML(InputStreamReader inputStreamReader, boolean bl, String string, XLIFFHelper xLIFFHelper) {
        this.parseXML(inputStreamReader, bl, string);
    }
}

