/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.table.load;

import java.awt.Component;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TTSQLExceptionScrubber;
import oracle.dbtools.raptor.timesten.TimesTenPassthrough;
import oracle.dbtools.raptor.timesten.dialogs.table.load.Common;
import oracle.dbtools.raptor.timesten.dialogs.table.load.IndexInfo;
import oracle.dbtools.raptor.timesten.dialogs.table.load.IndexUtil;
import oracle.dbtools.raptor.timesten.dialogs.table.load.LoadOracleTablePanel;
import oracle.dbtools.raptor.timesten.dialogs.table.load.LoadTableRow;
import oracle.dbtools.raptor.timesten.dialogs.table.load.MultipleOracleLoadable;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.javatools.dialogs.progress.ProgressPanel;
import oracle.jdeveloper.db.ConnectionException;

public class OracleTableLoader
implements MultipleOracleLoadable {
    private static Logger _logger = Logger.getLogger(LoadOracleTablePanel.class.getPackage().getName());
    private DBObject _dbObject;

    public OracleTableLoader(DBObject dBObject) {
        this._dbObject = dBObject;
    }

    @Override
    public void loadData(List<LoadTableRow> list, LoadOracleTablePanel loadOracleTablePanel) throws Exception {
        LoadProgressMonitor loadProgressMonitor = new LoadProgressMonitor(loadOracleTablePanel, Messages.getString("TimesTen.common.pleaseWait"), list);
        TimesTenPassthrough timesTenPassthrough = new TimesTenPassthrough(this._dbObject);
        MainLoaderThread mainLoaderThread = new MainLoaderThread(loadProgressMonitor, list, timesTenPassthrough, loadOracleTablePanel);
        mainLoaderThread.start();
    }

    private void createTTIndexes(Connection connection, TimesTenPassthrough timesTenPassthrough, LoadTableRow loadTableRow, String string, LoadProgressMonitor loadProgressMonitor) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        boolean bl = false;
        String string2 = loadTableRow.getOracleTable();
        if (string.equals(Messages.getString("LoadTablesFromOracle.indexCreationOption2"))) {
            bl = true;
        }
        try {
            object5 = MessageFormat.format(Messages.getString("LoadTablesFromOracle.indexCreationIdxImportMsg"), string2);
            loadProgressMonitor.updateMessage((String)object5);
            object4 = IndexUtil.getIndexesFromOracle(timesTenPassthrough, connection.getMetaData().getUserName(), string2);
            if (bl) {
                object3 = new ArrayList<IndexInfo>();
                object2 = object4.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    IndexInfo.Constraint constraint = ((IndexInfo)object).getCons();
                    if (!((IndexInfo)object).isUnique() && constraint != IndexInfo.Constraint.PRIMARY && constraint != IndexInfo.Constraint.UNIQUE) continue;
                    object3.add(object);
                }
                loadTableRow.setIndexes((List<IndexInfo>)object3);
            } else {
                loadTableRow.setIndexes((List<IndexInfo>)object4);
            }
        }
        catch (SQLException sQLException) {
            StringBuilder stringBuilder = new StringBuilder(MessageFormat.format(Messages.getString("LoadTablesFromOracle.indexCreationIdxImportError"), string2));
            stringBuilder.append("");
            stringBuilder.append(sQLException.getMessage());
            loadTableRow.setIdxImportError(stringBuilder.toString());
            loadProgressMonitor.updateMessage(loadTableRow.getIdxImportError());
            return;
        }
        object5 = loadTableRow.getIndexes();
        if (object5.isEmpty()) {
            object4 = bl ? MessageFormat.format(Messages.getString("LoadTablesFromOracle.indexCreationNoUniqueIndexes"), string2) : MessageFormat.format(Messages.getString("LoadTablesFromOracle.indexCreationNoIndexes"), string2);
            loadTableRow.setIdxImportError((String)object4);
            loadProgressMonitor.updateMessage((String)object4);
            return;
        }
        int n = 0;
        object3 = object5.iterator();
        while (object3.hasNext()) {
            object2 = (IndexInfo)object3.next();
            object = new StringBuilder(MessageFormat.format(Messages.getString("LoadTablesFromOracle.indexCreationCreatedIndexCount"), n, object5.size()));
            ((StringBuilder)object).append(" ");
            ((StringBuilder)object).append(MessageFormat.format(Messages.getString("LoadTablesFromOracle.indexCreationCreatingIdxMsg"), ((IndexInfo)object2).getTTName()));
            loadProgressMonitor.updateMessage(((StringBuilder)object).toString());
            IndexUtil.createTTIndex(connection, (IndexInfo)object2, loadTableRow.getTimesTenTable(), loadTableRow.getTimesTenUser());
            if (((IndexInfo)object2).getIndexStatus() == IndexInfo.IndexStatus.CREATED) {
                ++n;
            }
            object = new StringBuilder(MessageFormat.format(Messages.getString("LoadTablesFromOracle.indexCreationCreatedIndexCount"), n, object5.size()));
            ((StringBuilder)object).append(" ");
            ((StringBuilder)object).append(((IndexInfo)object2).getStatusMsg());
            loadProgressMonitor.updateMessage(((StringBuilder)object).toString());
        }
    }

    private boolean canCreateIndexes(String string, String string2) {
        return !string.equals(Messages.getString("LoadTablesFromOracle.indexCreationOption3")) && Common.validQuery(string2);
    }

    private class LoadFromOracleThread
    extends Thread {
        private String loadSql;
        private Statement statement;
        private LoadTableRow row;
        private LoadOracleTablePanel panel;
        private int rowNumber;
        private Connection conn;
        private SQLException exeption;

        public LoadFromOracleThread(LoadTableRow loadTableRow, String string, LoadOracleTablePanel loadOracleTablePanel, int n) {
            String string2 = String.valueOf(loadTableRow.getParallelThread());
            this.loadSql = "call ttLoadFromOracle('#tblOwner#','#tblName#', '#Query#', #numThreads#);".replace("#tblOwner#", loadTableRow.getTimesTenUser()).replace("#tblName#", loadTableRow.getTimesTenTable()).replace("#Query#", string).replace("#numThreads#", string2);
            this.row = loadTableRow;
            this.panel = loadOracleTablePanel;
            this.rowNumber = n;
        }

        @Override
        public void run() {
            try {
                this.conn = Connections.getInstance().getUniqueConnection(OracleTableLoader.this._dbObject.getConnectionName());
                Connections.getInstance().lock(this.conn);
                this.statement = this.conn.createStatement();
                if (this.isInterrupted()) {
                    return;
                }
                this.statement.execute(this.loadSql);
            }
            catch (SQLException sQLException) {
                this.exeption = sQLException;
            }
            catch (ConnectionException connectionException) {
                _logger.log(Level.SEVERE, "Can't get new connection", connectionException);
            }
            finally {
                if (this.statement != null) {
                    try {
                        this.statement.close();
                    }
                    catch (SQLException sQLException) {
                        _logger.log(Level.SEVERE, "Can't close statement", sQLException);
                    }
                }
                Connections.getInstance().unlock(this.conn);
                if (this.conn != null) {
                    try {
                        this.conn.close();
                    }
                    catch (SQLException sQLException) {
                        _logger.log(Level.SEVERE, "Can't close connection", sQLException);
                    }
                }
            }
        }

        public SQLException getExeption() {
            return this.exeption;
        }

        public void cancelThreadExecution() {
            try {
                this.statement.cancel();
            }
            catch (SQLException sQLException) {
                _logger.log(Level.SEVERE, "Can't cancel statement", sQLException);
            }
            if (this.isAlive()) {
                this.interrupt();
            }
        }
    }

    private class MainLoaderThread
    extends Thread {
        private LoadProgressMonitor waitDialog;
        private TimesTenPassthrough passthrough;
        private List<LoadTableRow> data;
        private LoadOracleTablePanel panel;
        private LoadFromOracleThread[] threads;

        public MainLoaderThread(LoadProgressMonitor loadProgressMonitor, List<LoadTableRow> list, TimesTenPassthrough timesTenPassthrough, LoadOracleTablePanel loadOracleTablePanel) {
            this.waitDialog = loadProgressMonitor;
            this.data = list;
            this.passthrough = timesTenPassthrough;
            this.panel = loadOracleTablePanel;
        }

        public LoadFromOracleThread[] getThreads() {
            return this.threads;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.waitDialog.display();
            Statement statement = null;
            Connection connection = null;
            SwingWorker swingWorker = null;
            String string = this.panel.getIndexCreationPolicy();
            try {
                connection = OracleTableLoader.this._dbObject.getConnection();
                statement = connection.createStatement();
                this.waitDialog.setStatementToStop(statement);
                Connections.getInstance().lock(connection);
                int n = 0;
                for (LoadTableRow loadTableRow : this.data) {
                    Object object;
                    loadTableRow.setStatus(1);
                    if (this.isInterrupted()) break;
                    Integer n2 = this.passthrough.executeTableCountOnOracle(loadTableRow.getSelectCountSQL());
                    this.waitDialog.setCurrentRowCount(n2);
                    loadTableRow.setRowCount(n2);
                    int n3 = loadTableRow.getParallelLoads();
                    if (n3 > 16) {
                        n3 = 16;
                    }
                    this.panel.refreshRow(n);
                    this.waitDialog.updateMessage(loadTableRow.getTimesTenTable());
                    try {
                        statement.execute(loadTableRow.getCreateTableStatement());
                        loadTableRow.setTimestenRowCount(0L);
                    }
                    catch (SQLException sQLException) {
                        if (2207 != sQLException.getErrorCode()) {
                            loadTableRow.setStatus(4);
                            loadTableRow.setError(TTSQLExceptionScrubber.getInstance().getMessage(OracleTableLoader.this._dbObject.getConnectionName(), sQLException));
                            this.panel.refreshStatusCell(n);
                            ++n;
                            continue;
                        }
                        object = statement.executeQuery(loadTableRow.getTimestenTableCountSQL());
                        while (object.next()) {
                            loadTableRow.setTimestenRowCount(object.getInt(1));
                        }
                    }
                    swingWorker = new QueryForUpdate(loadTableRow, OracleTableLoader.this._dbObject, this.waitDialog);
                    swingWorker.execute();
                    this.threads = new LoadFromOracleThread[n3];
                    for (int i = 0; i < n3; ++i) {
                        if (Common.isParallelLoadEnabled(loadTableRow.getParallelLoads())) {
                            String string2 = loadTableRow.getSelectQuery();
                            if (string2.toUpperCase().indexOf("WHERE") != -1) {
                                String string5 = " WHERE ORA_HASH(ROWID,#SEED#)=#SEEDCOUNT# AND";
                                string5 = string5.replaceAll("#SEED#", Integer.toString(n3 - 1));
                                string5 = string5.replaceAll("#SEEDCOUNT#", Integer.toString(i));
                                string2 = string2.replaceAll("where", "WHERE");
                                string2 = string2.replaceFirst("WHERE", string5);
                            } else {
                                String string8 = " WHERE ORA_HASH(ROWID,#SEED#)=#SEEDCOUNT#";
                                string8 = string8.replaceAll("#SEED#", Integer.toString(n3 - 1));
                                string8 = string8.replaceAll("#SEEDCOUNT#", Integer.toString(i));
                                string2 = string2 + string8;
                            }
                            object = new LoadFromOracleThread(loadTableRow, string2, this.panel, n);
                        } else {
                            object = new LoadFromOracleThread(loadTableRow, loadTableRow.getSelectQuery(), this.panel, n);
                        }
                        this.threads[i] = object;
                        ((Thread)object).start();
                    }
                    for (LoadFromOracleThread loadFromOracleThread : this.threads) {
                        try {
                            loadFromOracleThread.join();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    for (LoadFromOracleThread loadFromOracleThread : this.threads) {
                        if (loadFromOracleThread.getExeption() == null) continue;
                        SQLException sQLException = loadFromOracleThread.getExeption();
                        loadTableRow.setStatus(4);
                        loadTableRow.setError(TTSQLExceptionScrubber.getInstance().getMessage(OracleTableLoader.this._dbObject.getConnectionName(), sQLException));
                        this.panel.refreshRow(n);
                        if (sQLException.getErrorCode() != 802) continue;
                        throw sQLException;
                    }
                    swingWorker.cancel(true);
                    if (loadTableRow.getStatus() != 4 && OracleTableLoader.this.canCreateIndexes(string, loadTableRow.getSelectQuery())) {
                        loadTableRow.setOracleTable(Common.getOracleTableFromQuery(loadTableRow.getSelectQuery()));
                        OracleTableLoader.this.createTTIndexes(connection, this.panel.getPassthrough(), loadTableRow, string, this.waitDialog);
                    }
                    if (loadTableRow.getStatus() != 4) {
                        loadTableRow.setStatus(2);
                        this.panel.refreshStatusCell(n);
                    }
                    ++n;
                    statement.execute("commit;");
                    this.waitDialog.updateMessage(Messages.getString("LoadTablesFromOracle.updatingTableStats"));
                    statement.execute("call ttOptUpdateStats('#table#', 1, 0);".replace("#table#", loadTableRow.getTimesTenTable()));
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MainLoaderThread.this.waitDialog.close();
                    }
                });
            }
            catch (SQLException sQLException) {
                _logger.log(Level.SEVERE, "Couldn't load table from oracle", sQLException);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MainLoaderThread.this.waitDialog.close();
                    }
                });
                if (swingWorker != null && !swingWorker.isCancelled()) {
                    swingWorker.cancel(true);
                }
                MessageDialog.error(null, (Object)TTSQLExceptionScrubber.getInstance().getMessage(connection, statement.toString(), sQLException), (String)Messages.getString("TimesTen.common.error"), null);
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        _logger.log(Level.SEVERE, "Couldn't  close statement", sQLException);
                        MessageDialog.error(null, (Object)TTSQLExceptionScrubber.getInstance().getMessage(connection, statement.toString(), sQLException), (String)Messages.getString("TimesTen.common.error"), null);
                    }
                }
                if (connection != null) {
                    Connections.getInstance().unlock(connection);
                }
            }
        }
    }

    private class QueryForUpdate
    extends SwingWorker<Void, Void> {
        private LoadTableRow row;
        private int currentRowsLoaded;
        private DBObject dbObject;
        private LoadProgressMonitor monitor;

        public QueryForUpdate(LoadTableRow loadTableRow, DBObject dBObject, LoadProgressMonitor loadProgressMonitor) {
            this.row = loadTableRow;
            this.dbObject = dBObject;
            this.monitor = loadProgressMonitor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Void doInBackground() throws Exception {
            Connection connection = null;
            Statement statement = null;
            try {
                connection = Connections.getInstance().getUniqueConnection(OracleTableLoader.this._dbObject.getConnectionName());
                statement = connection.createStatement();
                Connections.getInstance().lock(connection);
                while (!this.isCancelled() && this.currentRowsLoaded < this.row.getRowCount()) {
                    ResultSet resultSet = statement.executeQuery(this.row.getTimestenTableCountSQL());
                    while (resultSet.next()) {
                        int n = resultSet.getInt(1);
                        this.monitor.updateRowsLoaded(n);
                    }
                    Thread.sleep(5000L);
                }
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "Error when excecuting query for update row count", exception);
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
                Connections.getInstance().unlock(connection);
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {
                        _logger.log(Level.SEVERE, "Can't close connection", sQLException);
                    }
                }
            }
            return null;
        }
    }

    private class LoadProgressMonitor
    extends IndeterminateProgressMonitor
    implements ChangeListener {
        private ProgressPanel progressPanel;
        private List<LoadTableRow> data;
        private String message;
        private MainLoaderThread thread;
        private Statement statement;
        private int currentTotalRowCount;

        public LoadProgressMonitor(Component component, String string, List<LoadTableRow> list) {
            super(component, string);
            this.data = list;
            this.progressPanel = this.getPanel();
            this.setCancellable(true);
            this.setCloseOnFinish(false);
            this.addCancellationListener(this);
        }

        public void setStatementToStop(Statement statement) {
            this.statement = statement;
        }

        public void updateMessage(final String string) {
            this.message = string;
            if (SwingUtilities.isEventDispatchThread()) {
                this.progressPanel.setMessage(this.message);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LoadProgressMonitor.this.progressPanel.setMessage(string);
                    }
                });
            }
        }

        public void updateRowsLoaded(final Integer n) {
            if (SwingUtilities.isEventDispatchThread()) {
                int n2 = 0;
                if (this.currentTotalRowCount > 0) {
                    n2 = n * 100 / this.currentTotalRowCount;
                }
                this.progressPanel.setMessage(MessageFormat.format(Messages.getString("LoadTablesFromOracle.insertMessage"), n, this.message, n2));
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int n2 = 0;
                        if (LoadProgressMonitor.this.currentTotalRowCount > 0) {
                            n2 = n * 100 / LoadProgressMonitor.this.currentTotalRowCount;
                        }
                        LoadProgressMonitor.this.progressPanel.setMessage(MessageFormat.format(Messages.getString("LoadTablesFromOracle.insertMessage"), n, LoadProgressMonitor.this.message, n2));
                    }
                });
            }
        }

        public void setCurrentRowCount(int n) {
            this.currentTotalRowCount = n;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (this.statement != null) {
                try {
                    this.statement.cancel();
                }
                catch (SQLException sQLException) {
                    _logger.log(Level.SEVERE, "Error while canceling statement", changeEvent);
                }
            }
            this.thread.interrupt();
            LoadFromOracleThread[] loadFromOracleThreadArray = this.thread.getThreads();
            if (loadFromOracleThreadArray != null) {
                for (LoadFromOracleThread loadFromOracleThread : loadFromOracleThreadArray) {
                    loadFromOracleThread.cancelThreadExecution();
                }
            }
            this.setCancellable(false);
        }
    }
}

