/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.table.load;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TimesTenPassthrough;
import oracle.dbtools.raptor.timesten.dialogs.table.load.IndexInfo;

public class IndexUtil {
    public static List<IndexInfo> getIndexesFromOracle(TimesTenPassthrough timesTenPassthrough, String string, String string2) throws SQLException {
        LinkedList<IndexInfo> linkedList = new LinkedList<IndexInfo>();
        String string3 = "SELECT OWNER, INDEX_NAME, INDEX_TYPE, TABLE_TYPE, UNIQUENESS FROM ALL_INDEXES WHERE TABLE_OWNER = '#towner#' AND TABLE_NAME = '#tname#' AND STATUS = 'VALID' and INDEX_TYPE IN ('NORMAL', 'FUNCTION-BASED NORMAL', 'BITMAP', 'IOT_TOP') AND TABLE_TYPE IN ('TABLE', 'VIEW') ORDER BY TABLE_OWNER, TABLE_NAME".replace("#towner#", string).replace("#tname#", string2);
        List<String> list = IndexUtil.getKeys(timesTenPassthrough, string, string2, IndexInfo.Constraint.PRIMARY);
        List<String> list2 = IndexUtil.getKeys(timesTenPassthrough, string, string2, IndexInfo.Constraint.UNIQUE);
        List<Object[]> list3 = timesTenPassthrough.executeQueryOnOracle(string3);
        for (Object[] objectArray : list3) {
            IndexInfo indexInfo = new IndexInfo((String)objectArray[1], (String)objectArray[0], (String)objectArray[2], (String)objectArray[4]);
            IndexUtil.setIndexColumns(timesTenPassthrough, indexInfo);
            if (list.contains(indexInfo.getName())) {
                indexInfo.setCons(IndexInfo.Constraint.PRIMARY);
            }
            if (list2.contains(indexInfo.getName())) {
                indexInfo.setCons(IndexInfo.Constraint.UNIQUE);
            }
            linkedList.add(indexInfo);
        }
        return linkedList;
    }

    private static void setIndexColumns(TimesTenPassthrough timesTenPassthrough, IndexInfo indexInfo) throws SQLException {
        String string = "SELECT COLUMN_NAME, COLUMN_POSITION, DESCEND FROM ALL_IND_COLUMNS WHERE INDEX_OWNER = '#iowner#' AND INDEX_NAME = '#iname#' ORDER BY COLUMN_POSITION".replace("#iowner#", indexInfo.getOwner()).replace("#iname#", indexInfo.getName());
        String string2 = "SELECT COLUMN_EXPRESSION FROM ALL_IND_EXPRESSIONS WHERE INDEX_OWNER = '#iowner#' AND INDEX_NAME = '#iname#' AND COLUMN_POSITION = #colpos#".replace("#iowner#", indexInfo.getOwner()).replace("#iname#", indexInfo.getName());
        List<Object[]> list = timesTenPassthrough.executeQueryOnOracle(string);
        for (Object[] objectArray : list) {
            BigDecimal bigDecimal = (BigDecimal)objectArray[1];
            IndexInfo indexInfo2 = indexInfo;
            indexInfo2.getClass();
            IndexInfo.ColumnInfo columnInfo = indexInfo2.new IndexInfo.ColumnInfo((String)objectArray[0], (String)objectArray[2], bigDecimal.intValue());
            String string3 = string2.replace("#colpos#", String.valueOf(columnInfo.getPosition()));
            List<Object[]> list2 = timesTenPassthrough.executeQueryOnOracle(string3);
            if (!list2.isEmpty()) {
                columnInfo.setExpression((String)list2.get(0)[0]);
            }
            indexInfo.getColumns().add(columnInfo);
        }
    }

    private static List<String> getKeys(TimesTenPassthrough timesTenPassthrough, String string, String string2, IndexInfo.Constraint constraint) throws SQLException {
        LinkedList<String> linkedList = new LinkedList<String>();
        String string3 = "";
        if (constraint == IndexInfo.Constraint.PRIMARY) {
            string3 = "SELECT CONSTRAINT_NAME, INDEX_NAME FROM ALL_CONSTRAINTS WHERE CONSTRAINT_TYPE = 'P' AND STATUS = 'ENABLED' AND VALIDATED = 'VALIDATED' AND OWNER = '#towner#' AND TABLE_NAME = '#tname#'".replace("#towner#", string).replace("#tname#", string2);
        } else if (constraint == IndexInfo.Constraint.UNIQUE) {
            string3 = "SELECT CONSTRAINT_NAME FROM ALL_CONSTRAINTS WHERE CONSTRAINT_TYPE = 'U' AND STATUS = 'ENABLED' AND VALIDATED = 'VALIDATED' AND OWNER = '#towner#' AND TABLE_NAME = '#tname#'".replace("#towner#", string).replace("#tname#", string2);
        }
        List<Object[]> list = timesTenPassthrough.executeQueryOnOracle(string3);
        for (Object[] objectArray : list) {
            linkedList.add((String)objectArray[0]);
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createTTIndex(Connection connection, IndexInfo indexInfo, String string, String string2) {
        Statement statement = null;
        String string3 = "";
        try {
            if (IndexUtil.existTTIndex(connection, indexInfo, string, string2)) {
                StringBuilder stringBuilder = new StringBuilder(MessageFormat.format(Messages.getString("LoadTablesFromOracle.indexCreationError"), indexInfo.getTTName()));
                stringBuilder.append(" ");
                stringBuilder.append(Messages.getString("LoadTablesFromOracle.indexCreationIdxAlreadyExists"));
                indexInfo.setStatusMsg(stringBuilder.toString());
                indexInfo.setIndexStatus(IndexInfo.IndexStatus.ERROR_NOT_CREATED);
                return;
            }
            statement = connection.createStatement();
            string3 = IndexUtil.getIndexCreateStatement(indexInfo, string, string2);
            statement.execute(string3);
            if (indexInfo.getCons() == IndexInfo.Constraint.UNIQUE) {
                indexInfo.setTTName(IndexUtil.getTTIndexName(connection, string2, string, indexInfo.getColumns().get(0).getName()));
            }
            indexInfo.setStatusMsg(MessageFormat.format(Messages.getString("LoadTablesFromOracle.indexCreationCreatedIdxMsg"), indexInfo.getTTName()));
            indexInfo.setIndexStatus(IndexInfo.IndexStatus.CREATED);
        }
        catch (SQLException sQLException) {
            StringBuilder stringBuilder = new StringBuilder(MessageFormat.format(Messages.getString("LoadTablesFromOracle.indexCreationError"), indexInfo.getTTName()));
            stringBuilder.append(" ");
            stringBuilder.append(sQLException.getMessage());
            indexInfo.setStatusMsg(stringBuilder.toString());
            indexInfo.setIndexStatus(IndexInfo.IndexStatus.ERROR_NOT_CREATED);
            return;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private static boolean existTTIndex(Connection connection, IndexInfo indexInfo, String string, String string2) throws SQLException {
        String string3;
        Statement statement = null;
        boolean bl = false;
        long l = -1L;
        statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string3 = "SELECT TBLID FROM SYS.TABLES WHERE TBLNAME = '#tname#' AND TBLOWNER = '#towner#'".replace("#tname#", string).replace("#towner#", string2));
        if (resultSet.next()) {
            l = resultSet.getLong(1);
            if (indexInfo.getCons() != IndexInfo.Constraint.UNIQUE) {
                string3 = "SELECT IXTYPE, ISUNIQUE, ISPRIMARY FROM SYS.INDEXES WHERE IXNAME = '#iname#' AND IXOWNER = '#iowner#' AND TBLID = #tblid#".replace("#iname#", indexInfo.getTTName()).replace("#iowner#", string2).replace("#tblid#", String.valueOf(l));
                resultSet = statement.executeQuery(string3);
                bl = resultSet.next();
            } else {
                int n;
                string3 = "SELECT COLOPTIONS FROM SYS.COLUMNS WHERE ID = #id# AND COLNAME = '#colname#'".replace("#id#", String.valueOf(l)).replace("#colname#", indexInfo.getColumns().get(0).getName());
                ResultSet resultSet2 = statement.executeQuery(string3);
                if (resultSet2.next() && (n = Integer.parseInt(resultSet2.getString(1), 16)) >= 8) {
                    bl = true;
                }
            }
        }
        if (statement != null) {
            statement.close();
        }
        return bl;
    }

    private static String getIndexCreateStatement(IndexInfo indexInfo, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (indexInfo.getCons() == IndexInfo.Constraint.NONE) {
            stringBuilder.append("CREATE ");
            if (indexInfo.getType().equalsIgnoreCase("BITMAP")) {
                stringBuilder.append("");
            } else if (indexInfo.isUnique()) {
                stringBuilder.append("UNIQUE ");
            }
            stringBuilder.append("INDEX ");
            stringBuilder.append(string2 + "." + indexInfo.getTTName());
            stringBuilder.append(" ON ");
            stringBuilder.append(string2 + "." + string);
            stringBuilder.append(" (");
            List<IndexInfo.ColumnInfo> list = indexInfo.getColumns();
            int n = list.size();
            int n2 = 0;
            for (IndexInfo.ColumnInfo columnInfo : indexInfo.getColumns()) {
                ++n2;
                if (!columnInfo.getExpression().equals("")) {
                    stringBuilder.append(columnInfo.getExpression());
                } else {
                    stringBuilder.append(columnInfo.getName());
                }
                if (list.size() <= 1 || n2 >= n) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append(")");
        } else {
            stringBuilder.append("ALTER TABLE ");
            stringBuilder.append(string2 + "." + string);
            stringBuilder.append(" ADD");
            if (indexInfo.getCons() == IndexInfo.Constraint.UNIQUE) {
                stringBuilder.append(" UNIQUE (");
                stringBuilder.append(indexInfo.getColumns().get(0).getName());
            } else if (indexInfo.getCons() == IndexInfo.Constraint.PRIMARY) {
                stringBuilder.append(" CONSTRAINT ");
                stringBuilder.append(indexInfo.getTTName());
                stringBuilder.append(" PRIMARY KEY ");
                stringBuilder.append("(");
                List<IndexInfo.ColumnInfo> list = indexInfo.getColumns();
                int n = list.size();
                int n3 = 0;
                for (IndexInfo.ColumnInfo columnInfo : indexInfo.getColumns()) {
                    ++n3;
                    if (!columnInfo.getExpression().equals("")) {
                        stringBuilder.append(columnInfo.getExpression());
                    } else {
                        stringBuilder.append(columnInfo.getName());
                    }
                    if (list.size() <= 1 || n3 >= n) continue;
                    stringBuilder.append(", ");
                }
            }
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    private static String getTTIndexName(Connection connection, String string, String string2, String string3) throws SQLException {
        int n;
        String string4;
        String string5 = "";
        Statement statement = null;
        statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string4 = "SELECT TBLID FROM SYS.TABLES WHERE TBLNAME = '#tname#' AND TBLOWNER = '#towner#'".replace("#tname#", string2).replace("#towner#", string));
        if (resultSet.next() && (resultSet = statement.executeQuery(string4 = "SELECT COLNUM FROM SYS.COLUMNS WHERE ID = #id# AND COLNAME = '#colname#'".replace("#id#", String.valueOf(n = resultSet.getInt(1))).replace("#colname#", string3))).next()) {
            int n2 = Integer.parseInt(resultSet.getString(1), 16);
            string4 = "SELECT IXNAME FROM SYS.INDEXES WHERE TBLID = #tblid# AND KEYCOLS = 0x#keycols#".replace("#tblid#", String.valueOf(n)).replace("#keycols#", String.valueOf(n2));
            resultSet = statement.executeQuery(string4);
            if (resultSet.next()) {
                string5 = resultSet.getString(1).trim();
            }
        }
        if (statement != null) {
            statement.close();
        }
        return string5;
    }
}

