/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.OracleTypeModeImpl;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.db.verifiers.Verifier;
import oracle.ide.db.verifiers.table.ColumnInfoVerifier;
import oracle.ide.db.verifiers.table.ConstraintsInfoVerifier;
import oracle.ide.db.verifiers.table.TableInfoVerifier;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.datatypes.DataTypeUsage;

public class SimpleCreateTablePanel
extends BaseInfoPanel {
    private GridBagLayout _layoutGB = new GridBagLayout();
    private SimpleTableModel _columnModel = new SimpleTableModel();
    private JTable _tblColumnList = new JTable();
    private JButton _btnAddColumn = new JButton();
    private JButton _btnRemoveColumn = new JButton();
    private DBObjectProvider _prov;
    private Table _table;
    protected TableInfoVerifier _tableVerifier = null;
    protected ColumnInfoVerifier _columnVerifier = null;
    protected ConstraintsInfoVerifier _constraintVerifier = null;
    private ArrayList _typeArray = new ArrayList(32);
    private boolean _initialized = false;
    public static final String HELP_SIMPLE_TABLE = "f1_createsimpletable_html";
    private static final int COL_NAME = 0;
    private static final int COL_TYPE = 1;
    private static final int COL_ATTR = 2;
    private static final int COL_INLINE = 3;
    private static final int COL_NNULL = 4;
    private static final int COL_ISPK = 5;
    private static final int COL_END = 6;
    private static final Long LONG_0 = new Long(0L);

    public SimpleCreateTablePanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this._layoutGB);
        ResourceUtils.resButton((AbstractButton)this._btnAddColumn, (String)UIArb.getString((int)560));
        ResourceUtils.resButton((AbstractButton)this._btnRemoveColumn, (String)UIArb.getString((int)561));
        this._btnAddColumn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = SimpleCreateTablePanel.this._tblColumnList.getSelectedRow();
                n = n < 0 ? SimpleCreateTablePanel.this._columnModel.size() : ++n;
                SimpleCreateTablePanel.this._columnModel.addDefaultRow(n);
                SimpleCreateTablePanel.this._tblColumnList.setRowSelectionInterval(n, n);
            }
        });
        this._btnRemoveColumn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = SimpleCreateTablePanel.this._tblColumnList.getSelectedRow();
                if (n >= 0) {
                    SimpleCreateTablePanel.this._columnModel.deleteRow(SimpleCreateTablePanel.this._tblColumnList.getSelectedRow());
                    if (n > 0) {
                        SimpleCreateTablePanel.this._tblColumnList.setRowSelectionInterval(n - 1, n - 1);
                    } else if (SimpleCreateTablePanel.this._columnModel.size() > 0) {
                        SimpleCreateTablePanel.this._tblColumnList.setRowSelectionInterval(0, 0);
                    }
                }
            }
        });
        this._tblColumnList.setModel(this._columnModel);
        TableColumn tableColumn = this._tblColumnList.getColumnModel().getColumn(2);
        tableColumn.setCellEditor(new DefaultCellEditor(new IntegerTextField()));
        TableColumnModel tableColumnModel = this._tblColumnList.getColumnModel();
        TableColumn tableColumn2 = tableColumnModel.getColumn(0);
        tableColumn2.setMinWidth(110);
        tableColumn2 = tableColumnModel.getColumn(1);
        tableColumn2.setMinWidth(110);
        tableColumn2.setMaxWidth(150);
        tableColumn2 = tableColumnModel.getColumn(2);
        tableColumn2.setMinWidth(50);
        tableColumn2.setMaxWidth(60);
        tableColumn2 = tableColumnModel.getColumn(3);
        tableColumn2.setMinWidth(40);
        tableColumn2.setMaxWidth(40);
        tableColumn2 = tableColumnModel.getColumn(4);
        tableColumn2.setMinWidth(60);
        tableColumn2.setMaxWidth(60);
        tableColumn2 = tableColumnModel.getColumn(5);
        tableColumn2.setMinWidth(70);
        tableColumn2.setMaxWidth(70);
        JScrollPane jScrollPane = new JScrollPane(this._tblColumnList);
        this._tblColumnList.setPreferredScrollableViewportSize(new Dimension(500, 100));
        this._tblColumnList.setSelectionMode(0);
        ColumnListCellRenderer columnListCellRenderer = new ColumnListCellRenderer();
        try {
            this._tblColumnList.setDefaultRenderer(Class.forName("java.lang.Object"), columnListCellRenderer);
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        this.add(jScrollPane, new GridBagConstraints(0, 0, 3, 3, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this._btnAddColumn, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.add(this._btnRemoveColumn, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
    }

    public void init(DBObjectProvider dBObjectProvider) {
        DataType[] dataTypeArray = dBObjectProvider.listSupportedDataTypes();
        for (int i = 0; i < dataTypeArray.length; ++i) {
            this._typeArray.add(dataTypeArray[i]);
        }
        Collections.sort(this._typeArray, new Comparator(){

            public int compare(Object object, Object object2) {
                DataType dataType = (DataType)object;
                DataType dataType2 = (DataType)object2;
                return dataType.getName().compareTo(dataType2.getName());
            }

            @Override
            public boolean equals(Object object) {
                return super.equals(object);
            }
        });
        this._initialized = true;
    }

    private void initializeVerifier(Verifier verifier) {
        if (verifier != null) {
            verifier.initializeVerifier(this._prov, null, (SchemaObject)this._table);
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        this._prov = (DBObjectProvider)traversableContext.find("oracle.javatools.db.DBObjectProvider");
        this._table = (Table)traversableContext.find("NewObject");
        assert (traversableContext.find("OriginalObject") == null) : Messages.getString("SimpleCreateTablePanel.simpleCreatePanelShoudntBeShownInEditDialog");
        this._tableVerifier = (TableInfoVerifier)traversableContext.find("SchemaObjectInfoVerifier");
        this._columnVerifier = (ColumnInfoVerifier)traversableContext.find("ColumnInfoVerifier");
        this._constraintVerifier = (ConstraintsInfoVerifier)traversableContext.find("ConstraintsInfoVerifier");
        this.initializeVerifier((Verifier)this._tableVerifier);
        this.initializeVerifier((Verifier)this._columnVerifier);
        this.initializeVerifier((Verifier)this._constraintVerifier);
        this.setup();
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        String string;
        TableCellEditor tableCellEditor = this._tblColumnList.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
        }
        int n = this._columnModel.size();
        ArrayList<Column> arrayList = new ArrayList<Column>(n);
        ArrayList<Column> arrayList2 = new ArrayList<Column>();
        for (int i = 0; i < n; ++i) {
            string = (String)this._columnModel.getValueAt(i, 0);
            DataType dataType = (DataType)this._columnModel.getValueAt(i, 1);
            String string2 = (String)this._columnModel.getValueAt(i, 2);
            String string3 = string2.replace(',', ' ');
            String[] stringArray = string3.split("[\\s]+");
            Boolean bl = (Boolean)this._columnModel.getValueAt(i, 3);
            Boolean bl2 = (Boolean)this._columnModel.getValueAt(i, 4);
            Boolean bl3 = (Boolean)this._columnModel.getValueAt(i, 5);
            String string4 = this._prov.getInternalName(string);
            Column column = (Column)this._columnModel.getValueAt(i, 6);
            if (column == null || !string4.equalsIgnoreCase(column.getName())) {
                column = new Column(string4);
                column.setID(TemporaryObjectID.createID((DBObject)column));
            }
            column.setProperty("inline", (Object)bl);
            column.setNotNull(bl2.booleanValue());
            DataTypeUsage dataTypeUsage = dataType.createDefaultUsage();
            if (dataType.hasDataTypeAttribute("size") && stringArray[0].trim().length() > 0) {
                dataTypeUsage.putAttributeValue("size", (Object)DataTypeHelper.toLong((Object)stringArray[0]));
            }
            if (dataType.hasDataTypeAttribute("precision") && stringArray[0].trim().length() > 0) {
                dataTypeUsage.putAttributeValue("precision", (Object)stringArray[0]);
            }
            if (dataType.hasDataTypeAttribute("scale") && stringArray.length > 1 && stringArray[1].trim().length() > 0) {
                dataTypeUsage.putAttributeValue("scale", (Object)stringArray[1]);
            }
            if (dataType.hasDataTypeAttribute("unit") && stringArray.length > 1) {
                dataTypeUsage.putAttributeValue("unit", (Object)stringArray[1]);
            }
            column.setDataTypeUsage(dataTypeUsage);
            if (this._columnVerifier != null) {
                this._columnVerifier.verifyColumn(null, column);
            }
            arrayList.add(column);
            if (!bl3.booleanValue()) continue;
            arrayList2.add(column);
        }
        this._table.setColumns(arrayList.toArray(new Column[arrayList.size()]));
        if (this._columnVerifier != null) {
            this._columnVerifier.verifyRelation();
        }
        if (arrayList2.size() > 0) {
            Constraint[] constraintArray;
            Constraint[] constraintArray2 = this._table.getConstraints();
            string = null;
            boolean bl = false;
            for (int i = 0; i < constraintArray2.length; ++i) {
                if (!"PKConstraint".equals(constraintArray2[i].getConstraintType())) continue;
                string = (PKConstraint)constraintArray2[i];
                bl = true;
            }
            if (string == null) {
                string = new PKConstraint("notUsed", (Relation)this._table);
                String string5 = "notUsed";
                if (this._constraintVerifier != null) {
                    try {
                        this._constraintVerifier.verifyName(string5);
                    }
                    catch (TraversalException traversalException) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, traversalException.getStackTrace()[0].toString(), traversalException);
                    }
                }
                string.setName(string5);
            }
            string.setEnabled(true);
            string.setID(TemporaryObjectID.createID((DBObject)string));
            string.setColumns(arrayList2.toArray(new Column[arrayList2.size()]));
            if (bl) {
                constraintArray = constraintArray2;
            } else {
                constraintArray = new Constraint[constraintArray2.length + 1];
                constraintArray[0] = string;
                for (int i = 1; i <= constraintArray2.length; ++i) {
                    constraintArray[i] = constraintArray2[i - 1];
                }
            }
            this._table.setConstraints(constraintArray);
        } else {
            this._table.setConstraints(null);
        }
    }

    private void setup() {
        if (!this._initialized) {
            this.init(this._prov);
        }
        this._columnModel = new SimpleTableModel();
        this._tblColumnList.setModel(this._columnModel);
        TableColumn tableColumn = this._tblColumnList.getColumnModel().getColumn(1);
        tableColumn.setCellEditor(new DefaultCellEditor(new JComboBox<Object>(this._typeArray.toArray())));
        Column[] columnArray = this._table.getColumns();
        if (columnArray.length == 0 && this._columnModel.size() == 0) {
            this._columnModel.addDefaultRow(0);
            this._tblColumnList.setRowSelectionInterval(0, 0);
        } else {
            Constraint[] constraintArray = this._table.getConstraints();
            PKConstraint pKConstraint = null;
            for (int i = 0; i < constraintArray.length; ++i) {
                if (!"PKConstraint".equals(constraintArray[i].getConstraintType())) continue;
                pKConstraint = (PKConstraint)constraintArray[i];
            }
            DataType[] dataTypeArray = this._prov.listSupportedDataTypes();
            for (int i = 0; i < columnArray.length; ++i) {
                Object object;
                String string = columnArray[i].getName();
                DataTypeUsage dataTypeUsage = columnArray[i].getDataTypeUsage();
                DataType dataType = null;
                boolean bl = false;
                boolean bl2 = (Boolean)columnArray[i].getProperty("inline");
                boolean bl3 = columnArray[i].isNotNull();
                String string2 = "";
                try {
                    dataType = DataTypeHelper.getDataType((DataTypeUsage)dataTypeUsage);
                }
                catch (DBException dBException) {
                    // empty catch block
                }
                if (dataType != null && dataTypeUsage != null) {
                    object = null;
                    if (dataType.hasDataTypeAttribute("size")) {
                        object = dataTypeUsage.getAttributeValue("size");
                    } else if (dataType.hasDataTypeAttribute("precision")) {
                        object = dataTypeUsage.getAttributeValue("precision");
                    }
                    string2 = object != null ? object.toString() : string2;
                    String string3 = " ";
                    object = null;
                    if (dataType.hasDataTypeAttribute("scale")) {
                        object = dataTypeUsage.getAttributeValue("scale");
                        string3 = ",";
                    } else if (dataType.hasDataTypeAttribute("unit")) {
                        object = dataTypeUsage.getAttributeValue("unit");
                    }
                    if (object != null) {
                        string2 = string2 + string3 + object.toString();
                    }
                }
                if (pKConstraint != null) {
                    object = pKConstraint.getColumns();
                    for (int j = 0; j < ((Column[])object).length; ++j) {
                        if (!object[j].equals((Object)columnArray[i])) continue;
                        bl = true;
                        bl3 = true;
                        break;
                    }
                }
                this._columnModel.addRow(i, string, dataType, string2, bl2, bl3, bl, columnArray[i]);
            }
        }
    }

    public static String getUniqueNameEnh(String string, DefaultListModel defaultListModel) {
        return SimpleCreateTablePanel.getUniqueName((String)string, (DefaultListModel)defaultListModel);
    }

    private class IntegerTextField
    extends JTextField {
        static final String badchars = "`~!@#$%^&*()_+-=\\|\"':;?/>.<, ";

        private IntegerTextField() {
        }

        @Override
        public void processKeyEvent(KeyEvent keyEvent) {
            char c = keyEvent.getKeyChar();
            if (Character.isLetter(c) && !keyEvent.isAltDown() || badchars.indexOf(c) > -1) {
                keyEvent.consume();
                return;
            }
            super.processKeyEvent(keyEvent);
        }
    }

    private class ColumnListCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            TableModel tableModel = jTable.getModel();
            if (!jTable.isRowSelected(n)) {
                if (!tableModel.isCellEditable(n, n2)) {
                    component.setBackground(Color.lightGray);
                } else {
                    component.setBackground(Color.white);
                }
            }
            return component;
        }
    }

    private class SimpleTableModel
    extends AbstractTableModel {
        public String[] columnNames = new String[]{UIArb.getString((int)562), UIArb.getString((int)563), Messages.getString("TimesTen.common.attribute"), Messages.getString("TimesTen.common.inline"), UIArb.getString((int)565), UIArb.getString((int)566)};
        private ArrayList _data = new ArrayList(1);
        private DefaultListModel _mdlColumns = new DefaultListModel();

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this._data.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n >= this._data.size()) {
                return null;
            }
            ArrayList arrayList = (ArrayList)this._data.get(n);
            if (n2 >= arrayList.size()) {
                return null;
            }
            return arrayList.get(n2);
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            DataTypeRegistry dataTypeRegistry = DataTypeRegistry.getInstance();
            if (n2 == 2) {
                String string = this.getValueAt(n, 1).toString().trim();
                DataType dataType = dataTypeRegistry.findDataType(string, SimpleCreateTablePanel.this._prov.getClass());
                return dataType.hasDataTypeAttribute("precision") || dataType.hasDataTypeAttribute("size");
            }
            if (n2 == 3) {
                String string = this.getValueAt(n, 1).toString().trim();
                boolean bl = string.matches(".*VARCHAR.*") || string.matches(".*VARBINARY.*");
                return bl;
            }
            if (n2 == 5) {
                String string = this.getValueAt(n, 1).toString().trim();
                boolean bl = !string.matches(".*LOB$");
                return bl;
            }
            if (n2 == 4) {
                Boolean bl = (Boolean)this.getValueAt(n, 5);
                return bl == false;
            }
            return n2 == 1 || n2 == 0;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n >= this._data.size()) {
                return;
            }
            ArrayList arrayList = (ArrayList)this._data.get(n);
            if (n2 >= arrayList.size()) {
                return;
            }
            if (n2 == 0) {
                this._mdlColumns.removeElement(arrayList.get(0));
                this._mdlColumns.addElement(object);
            }
            arrayList.set(n2, object);
            if (n2 == 1) {
                boolean bl;
                boolean bl2;
                String string = object.toString();
                if (string.equals("VARCHAR2")) {
                    arrayList.set(2, "4000");
                } else if (string.equals("NUMBER")) {
                    arrayList.set(2, "");
                } else if (string.equals("CLOB")) {
                    arrayList.set(5, new Boolean(false));
                    arrayList.set(2, "");
                    this.fireTableCellUpdated(n, 5);
                } else {
                    arrayList.set(2, "");
                }
                boolean bl3 = bl2 = string.matches(".*VARCHAR.*") || string.matches(".*VARBINARY.*");
                if (!bl2) {
                    this.setValueAt(new Boolean(false), n, 3);
                }
                if (bl = string.matches(".*LOB$")) {
                    this.setValueAt(new Boolean(false), n, 5);
                }
                this.fireTableCellUpdated(n, 2);
            } else if (n2 == 5 && ((Boolean)object).booleanValue()) {
                arrayList.set(4, new Boolean(true));
                this.fireTableCellUpdated(n, 4);
            }
            this.fireTableCellUpdated(n, n2);
        }

        public void addDefaultRow(int n) {
            ArrayList<Object> arrayList = new ArrayList<Object>(6);
            String string = SimpleCreateTablePanel.getUniqueName((String)"COLUMN", (DefaultListModel)this._mdlColumns);
            this._mdlColumns.addElement(string);
            arrayList.add(string);
            if (SimpleCreateTablePanel.this._prov instanceof OracleTypeModeImpl) {
                arrayList.add(SimpleCreateTablePanel.this._prov.getDataType("VARCHAR2"));
                arrayList.add("4000");
                arrayList.add(new Boolean(false));
            } else {
                arrayList.add(SimpleCreateTablePanel.this._prov.getDataType("CHAR"));
                arrayList.add("32");
                arrayList.add(new Boolean(false));
            }
            arrayList.add(new Boolean(false));
            arrayList.add(new Boolean(false));
            this._data.add(n, arrayList);
            this.fireTableDataChanged();
        }

        public void addRow(int n, String string, DataType dataType, String string2, Boolean bl, boolean bl2, boolean bl3, Column column) {
            ArrayList<Object> arrayList = new ArrayList<Object>(6);
            this._mdlColumns.addElement(string);
            arrayList.add(string);
            arrayList.add(dataType);
            arrayList.add(string2);
            arrayList.add(new Boolean(bl));
            arrayList.add(new Boolean(bl2));
            arrayList.add(new Boolean(bl3));
            arrayList.add(column);
            this._data.add(n, arrayList);
            this.fireTableDataChanged();
        }

        public void deleteRow(int n) {
            ArrayList arrayList = (ArrayList)this._data.get(n);
            this._mdlColumns.removeElement(arrayList.get(0));
            this._data.remove(n);
            if (this._data.size() == 0) {
                SimpleCreateTablePanel.this._table.setConstraints(null);
            }
            this.fireTableDataChanged();
        }

        public int size() {
            return this._data.size();
        }
    }
}

