/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.index;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TimesTenPlugInDatabaseImpl;
import oracle.dbtools.raptor.timesten.commands.TTInstanceInformation;
import oracle.ide.db.DBIcons;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.verifiers.table.IndexInfoVerifier;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.panels.TraversalException;
import oracle.ide.resource.ComponentArb;
import oracle.ide.util.Assert;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.WizardCallbacks;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Index;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Table;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.ViewColumn;
import oracle.javatools.db.ora.OracleIndexBuilder;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.util.Holder;

public class IndexEditorPanel
extends JPanel
implements ActionListener,
ListDataListener,
DocumentListener,
ItemListener {
    private ArrayList m_whatsHappening = new ArrayList();
    private JLabel m_lblIndexName = new JLabel();
    JLabel m_lblIndexType = new JLabel(Messages.getString("TimesTen.common.type"));
    private JLabel m_lblColExprs = new JLabel();
    private JList m_lstColExprs = new JList();
    private JButton m_btnAddColExpr = new JButton();
    private JButton m_btnRemoveColExpr = new JButton();
    private JButton m_btnUpColExpr = new JButton();
    private JButton m_btnDownColExpr = new JButton();
    private DefaultListModel m_mdlColExprs = new DefaultListModel();
    private ListSelectionListener m_mdlColExprsListSelectionListener;
    private DefaultComboBoxModel m_mdlCmbColExpr = new DefaultComboBoxModel();
    private JTextField m_fldName;
    private JLabel m_lblColExpr = new JLabel();
    private JComboBox m_cmbColExpr = new JComboBox();
    private JComboBox m_cmbCol = new JComboBox();
    private JLabel m_lblAsc = new JLabel();
    private JComboBox m_cmbAsc = new JComboBox();
    private DBObjectProvider m_prov;
    private Table m_table;
    private Index m_oldIndex;
    private Index m_index;
    private boolean m_isNewIndex;
    private IndexInfoVerifier m_verifier;
    private JRadioButton m_rdbNonUnique = new JRadioButton();
    private JRadioButton m_rdbUnique = new JRadioButton();
    private JRadioButton m_rdbBitmap = new JRadioButton();
    private JPanel m_pnlNormal;
    private GridBagConstraints m_gbcNormalDomain;
    WizardCallbacks m_callbacks;
    private Table m_originalTable;
    private static String WH_ADD_A_COLUMN_EXPRESSION = Messages.getString("IndexEditorPanel.addAColumnExpression");
    private static String WH_REMOVE_A_COLUMN_EXPRESSION = Messages.getString("IndexEditorPanel.removeAColumnExpression");
    private static String WH_MOVE_A_COLUMN_EXPRESSION_UP = Messages.getString("IndexEditorPanel.moveAColumnExpressionUP");
    private static String WH_MOVE_A_COLUMN_EXPRESSION_DOWN = Messages.getString("IndexEditorPanel.moveAColumnExpressionDown");
    private static String WH_EDIT_COLUMN_EXPRESSION = Messages.getString("IndexEditorPanel.editColumnExpression");
    private static String WH_CHANGE_COLEXPR_SELECTION = Messages.getString("IndexEditorPanel.changeColumnExpressionSelection");
    private static String WH_SET_ASC_DESC = Messages.getString("IndexEditorPanel.setTheColumnExpressionOrder");
    private static final String[] INDEXTYPES = new String[]{"INDEXTYPE"};
    private static final int NOPARALLEL = 1;
    private static final int PARALLEL_DEFAULT = 0;

    public IndexEditorPanel() {
        this(true);
    }

    public IndexEditorPanel(boolean bl) {
        ButtonGroup buttonGroup = new ButtonGroup();
        ResourceUtils.resButton((AbstractButton)this.m_rdbNonUnique, (String)Messages.getString("IndexEditorPanel.nonUnique"));
        ResourceUtils.resButton((AbstractButton)this.m_rdbUnique, (String)Messages.getString("IndexEditorPanel.unique"));
        ResourceUtils.resButton((AbstractButton)this.m_rdbBitmap, (String)Messages.getString("IndexEditorPanel.bitmap"));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.m_rdbNonUnique);
        buttonGroup2.add(this.m_rdbUnique);
        buttonGroup2.add(this.m_rdbBitmap);
        this.m_rdbNonUnique.setSelected(true);
        this.m_rdbNonUnique.addActionListener(this);
        this.m_rdbUnique.addActionListener(this);
        this.m_rdbBitmap.addActionListener(this);
        ResourceUtils.resLabel((JLabel)this.m_lblColExprs, (Component)this.m_lstColExprs, (String)Messages.getString("TimesTen.common.index"));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setVerticalScrollBarPolicy(22);
        this.m_lstColExprs.setModel(this.m_mdlColExprs);
        this.m_lstColExprs.setSelectionMode(0);
        Insets insets = new Insets(2, 2, 2, 2);
        this.m_btnUpColExpr.setMargin(insets);
        this.m_btnUpColExpr.setIcon(ComponentArb.getIcon((int)0));
        this.m_btnUpColExpr.setDisabledIcon(ComponentArb.getIcon((int)2));
        DBObjectRenderer.setToolTipText((JComponent)this.m_btnUpColExpr, (String)Messages.getString("IndexInfoPanel.moveColumnUp"));
        this.m_btnUpColExpr.addActionListener(this);
        this.m_btnDownColExpr.setMargin(insets);
        this.m_btnDownColExpr.setIcon(ComponentArb.getIcon((int)1));
        this.m_btnDownColExpr.setDisabledIcon(ComponentArb.getIcon((int)3));
        DBObjectRenderer.setToolTipText((JComponent)this.m_btnDownColExpr, (String)Messages.getString("IndexInfoPanel.moveColumnDown"));
        this.m_btnDownColExpr.addActionListener(this);
        this.m_btnAddColExpr.setMargin(insets);
        this.m_btnAddColExpr.setIcon(DBIcons.getIcon((int)36));
        DBObjectRenderer.setToolTipText((JComponent)this.m_btnAddColExpr, (String)Messages.getString("IndexInfoPanel.addColumnExmpression"));
        this.m_btnAddColExpr.addActionListener(this);
        this.m_btnRemoveColExpr.setMargin(insets);
        this.m_btnRemoveColExpr.setIcon(DBIcons.getIcon((int)23));
        DBObjectRenderer.setToolTipText((JComponent)this.m_btnRemoveColExpr, (String)Messages.getString("IndexInfoPanel.removeColumnExmpression"));
        this.m_btnRemoveColExpr.addActionListener(this);
        if (bl) {
            this.m_fldName = new JTextField();
            ResourceUtils.resLabel((JLabel)this.m_lblIndexName, (Component)this.m_fldName, (String)Messages.getString("TimesTen.common.name"));
            this.m_fldName.setColumns(30);
        }
        ResourceUtils.resLabel((JLabel)this.m_lblColExpr, (Component)this.m_cmbColExpr, (String)Messages.getString("IndexInfoPanel.columnNameOrExpression"));
        this.m_cmbColExpr.addItemListener(this);
        this.m_cmbColExpr.setModel(this.m_mdlCmbColExpr);
        this.m_cmbColExpr.setEditable(true);
        ResourceUtils.resLabel((JLabel)this.m_lblAsc, (Component)this.m_cmbAsc, (String)Messages.getString("TimesTen.common.order"));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.m_btnAddColExpr, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.m_btnRemoveColExpr, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.m_btnUpColExpr, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.m_btnDownColExpr, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
        jScrollPane.getViewport().add((Component)this.m_lstColExprs, null);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)this.m_lblColExprs, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        jPanel2.add((Component)jPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 5, 0, 0), 0, 0));
        jPanel2.add(Box.createHorizontalStrut(150), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.add((Component)this.m_lblColExpr, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        jPanel3.add((Component)this.m_cmbColExpr, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel3.add((Component)this.m_lblAsc, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 12, 5, 0), 0, 0));
        jPanel3.add((Component)this.m_cmbAsc, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 12, 0, 0), 0, 0));
        this.m_pnlNormal = new JPanel(new GridBagLayout());
        this.m_pnlNormal.add((Component)this.m_rdbNonUnique, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 15), 0, 0));
        this.m_pnlNormal.add((Component)this.m_rdbUnique, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 15), 0, 0));
        this.m_pnlNormal.add((Component)this.m_rdbBitmap, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlNormal.add((Component)jPanel2, new GridBagConstraints(0, 2, 0, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.m_pnlNormal.add((Component)jPanel3, new GridBagConstraints(0, 3, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 15, 5, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        if (bl) {
            this.add((Component)this.m_lblIndexName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
            this.add((Component)this.m_fldName, new GridBagConstraints(1, 0, 0, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 5), 0, 0));
        }
        this.add((Component)this.m_lblIndexType, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.m_gbcNormalDomain = new GridBagConstraints(0, 2, 0, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0);
        this.add((Component)this.m_pnlNormal, this.m_gbcNormalDomain);
    }

    protected void init(DBObjectProvider dBObjectProvider, Table table, IndexInfoVerifier indexInfoVerifier, WizardCallbacks wizardCallbacks, Table table2, boolean bl) {
        this.m_prov = dBObjectProvider;
        this.m_table = table;
        this.m_verifier = indexInfoVerifier;
        this.m_callbacks = wizardCallbacks;
        this.m_originalTable = table2;
        this.m_lstColExprs.getSelectionModel().removeListSelectionListener(this.m_mdlColExprsListSelectionListener);
        this.m_mdlColExprs.removeListDataListener(this);
        this.m_mdlColExprs.removeAllElements();
        this.m_index = null;
        this.m_mdlCmbColExpr.removeAllElements();
        this.m_mdlColExprsListSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                IndexEditorPanel.this.logActionStart(WH_CHANGE_COLEXPR_SELECTION, true);
                IndexEditorPanel.this.updateSelColExpr(IndexEditorPanel.this.m_lstColExprs.getSelectedValue());
                IndexEditorPanel.this.logActionEnd(WH_CHANGE_COLEXPR_SELECTION);
            }
        };
        this.m_mdlColExprs.addListDataListener(this);
        this.m_cmbAsc.addActionListener(this);
        this.m_cmbAsc.setEditable(false);
        if (0 == this.m_cmbAsc.getItemCount()) {
            this.m_cmbAsc.addItem(null);
            this.m_cmbAsc.addItem("ASC");
            this.m_cmbAsc.addItem("DESC");
        }
        this.m_lstColExprs.getSelectionModel().addListSelectionListener(this.m_mdlColExprsListSelectionListener);
        this.updateTableColumns(table);
        this.updateIndexData(null);
        this.updateColExpr(null);
        this.updateButtons();
        this.updateListContents(this.m_mdlColExprs);
        this.setFieldEnable(indexInfoVerifier, null, bl);
    }

    public void setFieldEnable(IndexInfoVerifier indexInfoVerifier, Index index, boolean bl) {
        boolean bl2;
        String string = TTInstanceInformation.getInstance().getInstanceVersion();
        boolean bl3 = bl2 = this.m_mdlColExprs.size() > 0;
        if (null != this.m_fldName && null != indexInfoVerifier) {
            this.m_lblIndexName.setEnabled(bl && indexInfoVerifier.canRenameIndex(index));
            this.m_fldName.setEnabled(bl && indexInfoVerifier.canRenameIndex(index));
        }
        this.m_rdbNonUnique.setEnabled(bl);
        this.m_rdbUnique.setEnabled(bl);
        if (string.startsWith("07.") || string.startsWith("7.")) {
            this.m_rdbBitmap.setEnabled(false);
        } else {
            this.m_rdbBitmap.setEnabled(bl);
        }
        this.m_lblColExprs.setEnabled(bl);
        this.m_btnAddColExpr.setEnabled(bl);
        this.m_btnDownColExpr.setEnabled(bl && bl2);
        this.m_btnRemoveColExpr.setEnabled(bl && bl2);
        this.m_btnUpColExpr.setEnabled(bl && bl2);
        this.m_cmbColExpr.setEditable(bl2);
        this.m_cmbColExpr.setEnabled(bl2);
        this.m_lblAsc.setEnabled(bl);
        this.m_cmbAsc.setEnabled(bl);
    }

    private void updateTableColumns(Table table) {
        this.m_cmbColExpr.removeItemListener(this);
        this.m_mdlCmbColExpr.removeAllElements();
        if (table != null) {
            for (Column column : table.getColumns()) {
                String string = column.getName();
                if (column instanceof ViewColumn && string.contains(".")) {
                    string = string.substring(string.indexOf(".") + 1);
                }
                this.m_mdlCmbColExpr.addElement(string);
            }
        }
        this.m_cmbColExpr.addItemListener(this);
    }

    public JTextField getNameField() {
        return this.m_fldName;
    }

    public void commit() throws TraversalException {
        if (null != this.m_index) {
            TraversalException traversalException = this.saveIndexAttributes();
            if (traversalException != null) {
                throw traversalException;
            }
            if (null != this.m_fldName) {
                this.m_index.setName(this.m_prov.getInternalName(this.m_fldName.getText()));
            }
            if (this.m_index.getIndexType() != Index.IndexType.DOMAIN) {
                this.m_index.setDomainIndextype(null);
                this.m_index.setDomainIndextypeOpStatus(null);
                this.m_index.setDomainIndextypeParameters(null);
            }
            if (this.m_verifier != null) {
                this.m_verifier.verifyIndex(this.m_oldIndex, this.m_index);
            }
        }
    }

    private TraversalException saveIndexAttributes() {
        if (null != this.m_index) {
            IndexObject[] indexObjectArray = null;
            this.m_index.setIndexType(Index.IndexType.NORMAL);
            if (this.m_rdbUnique.isSelected()) {
                this.m_index.setIndexType(Index.IndexType.UNIQUE);
            } else if (this.m_rdbBitmap.isSelected()) {
                this.m_index.setIndexType(Index.IndexType.BITMAP);
            }
            indexObjectArray = new IndexObject[this.m_mdlColExprs.size()];
            for (int i = 0; i < this.m_mdlColExprs.size(); ++i) {
                indexObjectArray[i] = (IndexObject)this.m_mdlColExprs.getElementAt(i);
            }
            this.m_index.setColumnExpressions(indexObjectArray);
        }
        return null;
    }

    public void setIndex(Index index) {
        this.m_index = index;
        if (null != index) {
            this.populateName(index);
            this.populateIndexType(index);
        }
    }

    public void setTable(Table table) {
        if (table != this.m_table) {
            this.m_table = table;
            this.updateTableColumns(table);
        }
    }

    public Index getIndex() {
        return this.m_index;
    }

    public void updateIndexData(Index index) {
        this.m_index = index;
        if (index == null) {
            if (null != this.m_fldName) {
                this.m_fldName.setText("");
                this.m_fldName.setEnabled(false);
            }
            this.m_oldIndex = null;
        } else {
            this.m_oldIndex = this.m_isNewIndex ? null : (Index)index.copyTo(null);
            this.populateName(index);
        }
        this.populateIndexType(this.m_index);
        this.populateUniqueness(this.m_index);
        this.populateColumnExpressions(this.m_index);
        if (null != this.m_fldName) {
            this.m_fldName.requestFocusInWindow();
        }
    }

    public void setNewIndex(boolean bl) {
        this.m_isNewIndex = bl;
        if (this.m_verifier != null) {
            this.m_verifier.setEditable(this.m_isNewIndex);
        }
    }

    private void switchToNormalIndex() {
        this.add((Component)this.m_pnlNormal, this.m_gbcNormalDomain);
        this.validate();
        this.repaint();
    }

    private void switchIndexType() {
    }

    private void switchUnique() {
        if (this.m_rdbBitmap.isSelected()) {
            this.m_cmbAsc.setSelectedIndex(0);
            this.m_cmbAsc.setEnabled(false);
        } else {
            this.m_cmbAsc.setEnabled(true);
        }
    }

    private void updateColExpr(IndexObject indexObject) {
        if (indexObject == null) {
            this.m_cmbColExpr.setSelectedItem("");
            this.m_cmbColExpr.setEnabled(false);
            this.m_cmbAsc.setSelectedItem(null);
            this.m_lblAsc.setEnabled(false);
            this.m_cmbAsc.setEnabled(false);
        } else {
            String string = indexObject.getExpression().getSQLText();
            if (string != null && string.startsWith("\"") && string.endsWith("\"")) {
                string = string.substring(1, string.length() - 1);
                this.m_cmbColExpr.setSelectedItem(string);
            } else {
                this.m_cmbColExpr.setSelectedItem(indexObject.getExpression().getSQLText());
            }
            this.m_cmbAsc.setSelectedItem(indexObject.getOrder());
            boolean bl = true;
            this.m_cmbColExpr.setEnabled(bl);
            boolean bl2 = true;
            this.m_lblAsc.setEnabled(bl2);
            this.m_cmbAsc.setEnabled(bl2);
        }
    }

    private void updateSelColExpr(Object object) {
        if (null != object) {
            this.m_lstColExprs.setSelectedValue(object, true);
            this.updateColExpr((IndexObject)object);
        }
        this.updateButtons();
    }

    public void updateButtons() {
        String string;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = this.m_lstColExprs.getSelectedIndex();
        IndexObject indexObject = n != -1 ? (IndexObject)this.m_mdlColExprs.get(n) : null;
        SQLFragment sQLFragment = null == indexObject ? null : indexObject.getExpression();
        String string2 = string = null == sQLFragment ? null : sQLFragment.getSQLText();
        if (string != null) {
            bl = true;
            IndexObject indexObject2 = n > 0 ? (IndexObject)this.m_mdlColExprs.get(n - 1) : null;
            IndexObject indexObject3 = n < this.m_mdlColExprs.getSize() - 1 ? (IndexObject)this.m_mdlColExprs.get(n + 1) : null;
            bl2 = indexObject2 != null;
            bl3 = indexObject3 != null;
        }
        this.m_btnRemoveColExpr.setEnabled(null != this.m_index && bl);
        this.m_btnAddColExpr.setEnabled(null != this.m_index);
        this.m_btnUpColExpr.setEnabled(null != this.m_index && bl2);
        this.m_btnDownColExpr.setEnabled(null != this.m_index && bl3);
    }

    public void populateName(Index index) {
        if (null != this.m_fldName) {
            if (null != index) {
                this.m_fldName.setText(this.m_prov.getExternalName(index.getName()));
            }
            boolean bl = this.m_isNewIndex || this.m_verifier == null || this.m_verifier.canRenameIndex(null);
            this.m_fldName.setEnabled(bl);
            this.m_fldName.setEditable(bl);
        }
    }

    public void populateIndexType(Index index) {
        this.switchIndexType();
    }

    public void populateUniqueness(Index index) {
        String string = TTInstanceInformation.getInstance().getInstanceVersion();
        if (null == index) {
            this.m_rdbNonUnique.setSelected(true);
            this.m_rdbNonUnique.setEnabled(false);
            this.m_rdbUnique.setEnabled(false);
            this.m_rdbBitmap.setEnabled(false);
        } else {
            this.m_rdbNonUnique.setSelected(Index.IndexType.NORMAL == index.getIndexType());
            this.m_rdbUnique.setSelected(Index.IndexType.UNIQUE == index.getIndexType());
            this.m_rdbBitmap.setSelected(Index.IndexType.BITMAP == index.getIndexType());
            this.m_rdbNonUnique.setEnabled(true);
            this.m_rdbUnique.setEnabled(true);
            if (string.startsWith("07.") || string.startsWith("7.")) {
                this.m_rdbBitmap.setEnabled(false);
            } else {
                this.m_rdbBitmap.setEnabled(true);
            }
        }
    }

    public void populateColumns(Index index) {
        this.m_cmbCol.removeAllItems();
        if (this.m_table != null) {
            IndexObject[] indexObjectArray;
            String string;
            Column[] columnArray = this.m_table.getColumns();
            for (int i = 0; i < columnArray.length; ++i) {
                string = this.m_prov.getExternalName(columnArray[i].getName(), "COLUMN");
                this.m_cmbCol.addItem(string);
            }
            if (index != null && null != (indexObjectArray = index.getColumnExpressions()) && indexObjectArray.length > 0) {
                string = indexObjectArray[0];
                SQLFragment sQLFragment = string.getExpression();
                if (sQLFragment instanceof ColumnUsage) {
                    ((ColumnUsage)sQLFragment).setProvider(this.m_prov);
                }
                this.m_cmbCol.setSelectedItem(sQLFragment.getSQLText());
            }
        }
        boolean bl = null != this.m_index && (null == this.m_verifier || this.m_verifier.canEditIndex(null));
        this.m_cmbCol.setEnabled(bl);
    }

    public void populateColumnExpressions(Index index) {
        this.m_cmbColExpr.setSelectedItem(null);
        this.m_cmbAsc.setSelectedIndex(0);
        this.m_mdlColExprs.removeAllElements();
        if (null != index) {
            IndexObject[] indexObjectArray = index.getColumnExpressions();
            for (int i = 0; i < indexObjectArray.length; ++i) {
                this.m_mdlColExprs.addElement(indexObjectArray[i]);
            }
            if (indexObjectArray.length == 0) {
                indexObjectArray = this.getDefaultExpressions(index);
            }
            if (null != indexObjectArray && indexObjectArray.length > 0) {
                this.m_lstColExprs.setSelectedIndex(0);
                this.updateColExpr(indexObjectArray[0]);
            }
        }
    }

    private IndexObject[] getDefaultExpressions(final Index index) {
        final Holder holder = new Holder((Object)new IndexObject[0]);
        Collection<String> collection = TimesTenPlugInDatabaseImpl.indexNames;
        final ProgressBar progressBar = new ProgressBar((Component)this, Messages.getString("IndexInfoPanel.indexExpressions"), null, true);
        progressBar.setRunnable(new Runnable(){

            @Override
            public void run() {
                IndexObject[] indexObjectArray = (IndexObject[])holder.get();
                IndexObject[] indexObjectArray2 = IndexEditorPanel.this.getDefaultExpressions(index, indexObjectArray);
                if (indexObjectArray2 != null) {
                    holder.set((Object)indexObjectArray2);
                }
                progressBar.setDoneStatus();
            }
        });
        progressBar.start(Messages.getString("IndexInfoPanel.calculatingDefaultColumnExpressions"), null, 1500);
        return (IndexObject[])holder.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexObject[] getDefaultExpressions(Index index, IndexObject[] indexObjectArray) {
        int n;
        if (index == null || index.getTable() == null) {
            return null;
        }
        IndexObject[] indexObjectArray2 = new IndexObject[indexObjectArray.length + 1];
        for (n = 0; n < indexObjectArray.length; ++n) {
            indexObjectArray2[n] = indexObjectArray[n];
        }
        n = 0;
        Table table = index.getTable();
        DBObjectID dBObjectID = null;
        if (indexObjectArray.length > 0) {
            dBObjectID = ((ColumnUsage)indexObjectArray[indexObjectArray.length - 1].getExpression()).getObjectID();
        }
        for (Column column : table.getColumns()) {
            if (dBObjectID == null) {
                IndexObject indexObject;
                indexObjectArray2[indexObjectArray2.length - 1] = indexObject = new IndexObject((SQLFragment)new ColumnUsage(column.getID()));
                index.setColumnExpressions(indexObjectArray2);
                try {
                    this.m_prov.validateObjectProperty((DBObject)index, "columnExpressions");
                    n = 1;
                    break;
                }
                catch (DBException dBException) {
                    boolean bl = false;
                    continue;
                }
                finally {
                    index.setColumnExpressions(null);
                }
            }
            if (!dBObjectID.equals(column.getID())) continue;
            dBObjectID = null;
        }
        if (n != 0) {
            return indexObjectArray2;
        }
        Column[] columnArray = new IndexObject[indexObjectArray.length + 1];
        for (int i = 0; i < indexObjectArray.length; ++i) {
            columnArray[i] = indexObjectArray[i];
        }
        dBObjectID = null;
        if (indexObjectArray.length > 0) {
            dBObjectID = ((ColumnUsage)indexObjectArray[indexObjectArray.length - 1].getExpression()).getObjectID();
        }
        for (Column column : table.getColumns()) {
            if (dBObjectID == null) {
                IndexObject indexObject = new IndexObject((SQLFragment)new ColumnUsage(column.getID()));
                columnArray[columnArray.length - 1] = indexObject;
                indexObjectArray2 = this.getDefaultExpressions(index, (IndexObject[])columnArray);
                if (indexObjectArray2 == null) continue;
                return indexObjectArray2;
            }
            if (!dBObjectID.equals(column.getID())) continue;
            dBObjectID = null;
        }
        return null;
    }

    private void updateListContents(Object object) {
        boolean bl = false;
        if (this.m_mdlColExprs == object) {
            bl = this.m_mdlColExprs.getSize() > 0;
            this.m_lstColExprs.setFocusable(bl);
            boolean bl2 = bl && (null == this.m_verifier || this.m_verifier.canEditIndex(null));
            this.m_cmbColExpr.setEditable(bl2);
        }
        if (this.m_callbacks != null) {
            Boolean bl3 = null == this.m_index || bl;
            this.m_callbacks.wizardEnableButtons(Boolean.TRUE, bl3, bl3);
        }
    }

    private void swap(int n, int n2) {
        Object e = this.m_mdlColExprs.getElementAt(n);
        Object e2 = this.m_mdlColExprs.getElementAt(n2);
        this.m_mdlColExprs.setElementAt(e, n2);
        this.m_mdlColExprs.setElementAt(e2, n);
    }

    private void updateIndexName() {
        this.logActionStart(WH_EDIT_COLUMN_EXPRESSION, true);
        String string = (String)this.m_cmbColExpr.getSelectedItem();
        String string2 = (String)this.m_cmbAsc.getSelectedItem();
        int n = this.m_lstColExprs.getSelectedIndex();
        if (n >= 0) {
            SQLFragment sQLFragment = OracleIndexBuilder.createExpression((String)string, (Relation)this.m_table, (DBObjectProvider)this.m_prov);
            IndexObject indexObject = new IndexObject(sQLFragment, string2);
            this.m_mdlColExprs.setElementAt(indexObject, n);
        }
        this.m_lstColExprs.repaint();
        this.logActionEnd(WH_EDIT_COLUMN_EXPRESSION);
    }

    public void logActionStart(String string, boolean bl) {
        if (!bl && 0 != this.m_whatsHappening.size()) {
            Assert.check((boolean)false, (String)("Trying to " + string + " whilst doing " + this.m_whatsHappening.get(0)));
        }
        this.m_whatsHappening.add(0, string);
    }

    public void logActionEnd(String string) {
        if (0 == this.m_whatsHappening.size()) {
            Assert.check((boolean)false, (String)MessageFormat.format(Messages.getString("IndexEditorPanel.lostTractOfApeearsToBedoingNothing"), string));
        }
        Assert.check((boolean)string.equals(this.m_whatsHappening.get(0)), (String)MessageFormat.format(Messages.getString("IndexEditorPanel.lostTrackOfAppearToBe"), string, this.m_whatsHappening.get(0)));
        this.m_whatsHappening.remove(0);
    }

    public int logSize() {
        return this.m_whatsHappening.size();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_rdbNonUnique || object == this.m_rdbUnique || object == this.m_rdbBitmap) {
            this.switchUnique();
            this.saveIndexAttributes();
            this.updateButtons();
        } else if (object == this.m_cmbAsc) {
            this.logActionStart(WH_SET_ASC_DESC, true);
            if (this.logSize() == 1) {
                this.m_cmbColExpr.requestFocusInWindow();
            }
            this.updateIndexName();
            this.logActionEnd(WH_SET_ASC_DESC);
        } else if (object == this.m_btnAddColExpr) {
            this.logActionStart(WH_ADD_A_COLUMN_EXPRESSION, false);
            this.m_lstColExprs.clearSelection();
            if (this.m_lstColExprs.getSelectedValue() == null) {
                Constraint[] constraintArray;
                Object object2 = "";
                Column[] columnArray = this.m_table.getColumns();
                if (columnArray.length > 0) {
                    object2 = columnArray[0].getName();
                    constraintArray = this.m_table.getConstraints();
                    for (int i = 0; i < constraintArray.length; ++i) {
                        if ("PKConstraint".equals(constraintArray[i].getConstraintType())) {
                            object2 = ((PKConstraint)constraintArray[i]).getColumns()[0].getName();
                            break;
                        }
                        if (!"UniqueConstraint".equals(constraintArray[i].getConstraintType())) continue;
                        object2 = ((UniqueConstraint)constraintArray[i]).getColumns()[0].getName();
                    }
                }
                constraintArray = object2;
                SQLFragment sQLFragment = OracleIndexBuilder.createExpression((String)constraintArray, (Relation)this.m_table, (DBObjectProvider)this.m_prov);
                IndexObject indexObject = new IndexObject(sQLFragment);
                this.m_mdlColExprs.addElement(indexObject);
                this.m_lstColExprs.setSelectedIndex(this.m_mdlColExprs.size() - 1);
                this.m_cmbColExpr.requestFocusInWindow();
            }
            this.saveIndexAttributes();
            this.updateButtons();
            this.logActionEnd(WH_ADD_A_COLUMN_EXPRESSION);
        } else if (object == this.m_btnRemoveColExpr) {
            this.logActionStart(WH_REMOVE_A_COLUMN_EXPRESSION, false);
            int n = this.m_lstColExprs.getSelectedIndex();
            if (n != -1) {
                int n2 = n == this.m_mdlColExprs.size() - 1 ? n - 1 : n + 1;
                this.m_lstColExprs.setSelectedIndex(n2);
                this.m_mdlColExprs.removeElementAt(n);
                if (n2 == -1) {
                    this.updateSelColExpr(null);
                    this.updateColExpr(null);
                }
            }
            this.saveIndexAttributes();
            this.updateButtons();
            this.logActionEnd(WH_REMOVE_A_COLUMN_EXPRESSION);
        } else if (object == this.m_btnUpColExpr) {
            this.logActionStart(WH_MOVE_A_COLUMN_EXPRESSION_UP, false);
            int n = this.m_lstColExprs.getSelectedIndex();
            if (n > 0) {
                this.swap(n--, n);
                this.m_lstColExprs.setSelectedIndex(n);
            }
            this.logActionEnd(WH_MOVE_A_COLUMN_EXPRESSION_UP);
        } else if (object == this.m_btnDownColExpr) {
            this.logActionStart(WH_MOVE_A_COLUMN_EXPRESSION_DOWN, false);
            int n = this.m_lstColExprs.getSelectedIndex();
            if (n < this.m_mdlColExprs.getSize() - 1) {
                this.swap(n++, n);
                this.m_lstColExprs.setSelectedIndex(n);
            }
            this.logActionEnd(WH_MOVE_A_COLUMN_EXPRESSION_DOWN);
        } else if (object == this.m_mdlColExprs) {
            this.saveIndexAttributes();
            this.updateButtons();
        }
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.updateListContents(listDataEvent.getSource());
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.updateListContents(listDataEvent.getSource());
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.updateListContents(listDataEvent.getSource());
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateIndexName();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateIndexName();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateIndexName();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.updateIndexName();
        this.logActionStart(WH_EDIT_COLUMN_EXPRESSION, true);
        String string = (String)this.m_cmbColExpr.getSelectedItem();
        String string2 = (String)this.m_cmbAsc.getSelectedItem();
        int n = this.m_lstColExprs.getSelectedIndex();
        if (string != null && string.length() > 0 && this.m_lstColExprs.getSelectedValue() == null) {
            this.m_mdlColExprs.clear();
            SQLFragment sQLFragment = OracleIndexBuilder.createExpression((String)string, (Relation)this.m_table, (DBObjectProvider)this.m_prov);
            IndexObject indexObject = new IndexObject(sQLFragment);
            this.m_mdlColExprs.addElement(indexObject);
            this.m_lstColExprs.setSelectedIndex(this.m_mdlColExprs.size() - 1);
            this.m_cmbColExpr.requestFocusInWindow();
        }
        this.m_lstColExprs.repaint();
        this.logActionEnd(WH_EDIT_COLUMN_EXPRESSION);
    }

    private static class NumberField
    extends NumberTextField {
        public NumberField() {
            this.setDataType(Integer.class);
            this.setSigned(false);
        }

        protected String convertNumberToString(Number number) {
            return number.toString();
        }

        protected boolean validateNumber(Number number) {
            return number == null || number.intValue() > 0;
        }
    }
}

