/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.loadjava;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import oracle.aurora.server.tools.loadjava.Options;
import oracle.aurora.server.tools.loadjava.ToolsError;
import oracle.aurora.util.IOCopy;

public class LogOptions
extends Options {
    private PrintWriter writer;
    private OutputStream myOpen;
    private static final String[] oneList = new String[]{"-verbose", "-debug", "-stdout", "-time", "-nowarn", "-compat817", null};
    private static final String[] twoList = new String[]{"-fileout", null};
    private static final String[] substList = new String[]{"-v", "-verbose", null};
    private static final Object[] expandList = new Object[]{null};

    public LogOptions() {
        this(null);
    }

    public LogOptions(Options defaultOpt) {
        super(oneList, twoList, substList, expandList, defaultOpt);
    }

    boolean getVerbose() {
        return this.getBoolean("-verbose");
    }

    boolean getTime() {
        return this.getBoolean("-time");
    }

    boolean getDebug() {
        return this.getBoolean("-debug");
    }

    void setOut() {
        this.setOut(null);
    }

    public void setOut(Object out) {
        if (this.writer != null) {
            this.writer.flush();
        }
        if (this.myOpen != null) {
            try {
                this.myOpen.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
            this.myOpen = null;
        }
        this.writer = null;
        OutputStream oStream = System.err;
        if (out instanceof PrintWriter) {
            this.writer = (PrintWriter)out;
        } else if (out instanceof OutputStream) {
            oStream = (OutputStream)out;
        } else if (this.getBoolean("-stdout")) {
            oStream = System.out;
        } else if (this.getString("-fileout") != null) {
            String f = this.getString("-fileout");
            try {
                oStream = new FileOutputStream(f);
                this.myOpen = oStream;
            }
            catch (FileNotFoundException ex) {
                throw new ToolsError("could not open writer file " + f);
            }
            catch (SecurityException ex) {
                String msg = "SecurityException thrown while opening file " + f + ": " + ex;
                throw new ToolsError(msg);
            }
        }
        if (this.writer == null) {
            this.writer = new PrintWriter(new IOCopy().toBuffered(oStream));
        }
    }

    PrintWriter getWriter() {
        if (this.writer == null) {
            this.setOut();
        }
        return this.writer;
    }

    void reset() {
        this.writer = null;
    }

    public void set(String opt, Object value) {
        if (opt.equals("-out")) {
            this.setOut(value);
        } else {
            super.set(opt, value);
        }
    }

    public boolean isProperty(String property) {
        return property.equals("-out") || super.isProperty(property);
    }
}

