/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.logging;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.LogRecord;
import oracle.core.ojdl.LogFormatter;
import oracle.core.ojdl.LogMessage;
import oracle.core.ojdl.logging.ODLFormatter;
import oracle.core.ojdl.logging.ODLHandler;
import oracle.core.ojdl.logging.ODLLogRecord;
import oracle.core.ojdl.logging.QuickTraceBuffer;
import oracle.core.ojdl.logging.QuickTraceHandler;
import oracle.core.ojdl.logging.QuickTraceHandlerFactory;
import oracle.core.ojdl.logging.context.LoggingContext;
import oracle.core.ojdl.logging.context.LoggingContextManager;
import oracle.dms.instrument.Noun;

class QuickTraceCacheByRefHandler
extends QuickTraceHandler {
    private static final int DISK_IO_BUFFER_SIZE = 65536;
    private QuickTraceBuffer defBuf_;
    private Hashtable<String, QuickTraceBuffer> userBufs_;

    QuickTraceCacheByRefHandler(LogFormatter formatter, long bufferSize, int fieldLength, boolean useLoggingContext, QuickTraceHandler.Mode mode, boolean enableDMSMetrics, boolean useThreadName, Noun nounRoot, boolean bufferPerUser, boolean flushOnDump) {
        super(formatter, bufferSize, fieldLength, null, useLoggingContext, mode, enableDMSMetrics, nounRoot, bufferPerUser, flushOnDump);
        this.useThreadName_ = useThreadName;
        this.userBufs_ = new Hashtable();
        this.createDefaulfBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.m_rwLock.writeLock().lock();
        try {
            this.closed_ = true;
        }
        finally {
            this.m_rwLock.writeLock().unlock();
        }
        QuickTraceHandlerFactory.removeHandler(this);
    }

    private QuickTraceBuffer createDefaulfBuffer() {
        this.defBuf_ = new QuickTraceBuffer("COMMON", this.bufferSize_, this.logRecord_overhead_, this.ref_overhead_, this.useThreadName_ || this.useRealThreadId_);
        return this.defBuf_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QuickTraceBuffer createUserBuffer(String name) {
        QuickTraceBuffer buffer = new QuickTraceBuffer(name, this.bufferSize_, this.logRecord_overhead_, this.ref_overhead_, this.useThreadName_ || this.useRealThreadId_);
        Hashtable<String, QuickTraceBuffer> hashtable = this.userBufs_;
        synchronized (hashtable) {
            this.userBufs_.put(name, buffer);
            super.createDMSSensors(name);
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QuickTraceBuffer getUserBuffer(String name, boolean createAsNeed) {
        QuickTraceBuffer buffer = null;
        Hashtable<String, QuickTraceBuffer> hashtable = this.userBufs_;
        synchronized (hashtable) {
            if (name == null || name.length() == 0 || createAsNeed && this.reserveBufferIDs_ == null) {
                return null;
            }
            if (createAsNeed) {
                boolean found = false;
                for (String id : this.reserveBufferIDs_) {
                    if (!name.equals(id)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return null;
                }
            }
            if ((buffer = this.userBufs_.get(name)) == null && createAsNeed) {
                buffer = this.createUserBuffer(name);
                this.userBufs_.put(name, buffer);
            }
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void setReserveBufferIDs(String[] ids) {
        if (ids == null || ids.length == 0) {
            return;
        }
        Hashtable<String, QuickTraceBuffer> hashtable = this.userBufs_;
        synchronized (hashtable) {
            String[] oldIds = this.reserveBufferIDs_;
            super.setReserveBufferIDs(ids);
            if (oldIds != null) {
                for (String oldId : oldIds) {
                    boolean found = false;
                    for (String id : ids) {
                        if (!oldId.equals(id)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    this.destroyDMSSensor(oldId);
                    this.userBufs_.remove(oldId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void publish(LogRecord rec, ODLHandler.RecursionCounter recursionCounter) {
        Object[] params;
        int size = 0;
        int nStr = 0;
        int nParam = 0;
        int nRecHasParam = 0;
        int numSupplKeys = 0;
        int len = 0;
        int recLevelValue = rec.getLevel().intValue();
        ODLLogRecord orec = null;
        String str = null;
        String threadName = null;
        HashMap<String, String> supplAttr = null;
        LoggingContext ctx = null;
        Map recSupplAttr = null;
        String[] recSupplAttrKeys = null;
        String[] recSupplAttrValues = null;
        QuickTraceBuffer buffer = null;
        if (this.levelValue_ == OFF || recLevelValue < this.levelValue_ || this.closed_) {
            return;
        }
        boolean isInternalCtx = false;
        isInternalCtx = this.useLoggingContext_ && recursionCounter != null ? recursionCounter.enterInternalCtx() : false;
        if (rec instanceof ODLLogRecord) {
            String messageIdStr;
            String detailedLocStr;
            String errorIdStr;
            String problemKeyStr;
            orec = (ODLLogRecord)rec;
            nStr += 5;
            String supplDetailStr = orec.getSupplDetail();
            if (supplDetailStr != null) {
                size += supplDetailStr.length();
                ++nStr;
            }
            if ((problemKeyStr = orec.getProblemKey()) != null) {
                size += problemKeyStr.length();
                ++nStr;
            }
            if ((errorIdStr = orec.getErrorInstanceId()) != null) {
                size += errorIdStr.length();
                ++nStr;
            }
            if ((detailedLocStr = orec.getDetailLocation()) != null) {
                size += detailedLocStr.length();
                ++nStr;
            }
            if ((messageIdStr = orec.getMessageId()) != null) {
                size += messageIdStr.length();
                ++nStr;
            }
            if (!isInternalCtx) {
                ctx = orec.getLoggingContext();
            }
            if ((recSupplAttr = orec.getSupplAttributes()) != null && recSupplAttr.size() > 0) {
                if (supplAttr == null) {
                    supplAttr = new HashMap();
                }
                for (Map.Entry entry : recSupplAttr.entrySet()) {
                    Object key = entry.getKey();
                    Object val = entry.getValue();
                    if (val == null) continue;
                    String keyStr = null;
                    String valStr = null;
                    valStr = !(val instanceof String) ? val.toString() : (String)val;
                    keyStr = !(key instanceof String) ? key.toString() : (String)key;
                    if (this.enableUserBuffer_ && buffer == null && keyStr != null && valStr != null && "APPS_USER_NAME".equals(keyStr)) {
                        buffer = this.getUserBuffer(valStr, true);
                    }
                    supplAttr.put(keyStr, valStr);
                    size += keyStr.length();
                    ++nStr;
                    size += valStr.length();
                    ++nStr;
                }
            }
            String[] supplAttrKeys = orec.getSupplAttributeKeys();
            String[] supplAttrValues = orec.getSupplAttributeValues();
            if (supplAttrKeys != null && supplAttrValues != null) {
                int attrLen = Math.min(supplAttrKeys.length, supplAttrValues.length);
                recSupplAttrKeys = new String[attrLen];
                recSupplAttrValues = new String[attrLen];
                numSupplKeys = attrLen;
                for (int i = 0; i < attrLen; ++i) {
                    if (supplAttrKeys[i] == null || supplAttrValues[i] == null) continue;
                    if (this.enableUserBuffer_ && buffer == null && supplAttrKeys[i] != null && supplAttrValues[i] != null && "APPS_USER_NAME".equals(supplAttrKeys[i])) {
                        buffer = this.getUserBuffer(supplAttrValues[i], true);
                    }
                    len = supplAttrValues[i].length();
                    if (this.fieldLen_ >= 0 && len > this.fieldLen_) {
                        recSupplAttrValues[i] = supplAttrValues[i].substring(0, this.fieldLen_);
                        len = this.fieldLen_;
                    } else {
                        recSupplAttrValues[i] = supplAttrValues[i];
                    }
                    size += len;
                    ++nStr;
                    len = supplAttrKeys[i].length();
                    if (this.fieldLen_ >= 0 && len > this.fieldLen_) {
                        recSupplAttrKeys[i] = supplAttrKeys[i].substring(0, this.fieldLen_);
                        len = this.fieldLen_;
                    } else {
                        recSupplAttrKeys[i] = supplAttrKeys[i];
                    }
                    size += len;
                    ++nStr;
                }
                orec.setSupplAttributeKeys(recSupplAttrKeys);
                orec.setSupplAttributeValues(recSupplAttrValues);
            }
        }
        if (ctx == null) {
            if (this.useLoggingContext_) {
                ctx = LoggingContextManager.getLoggingContext(rec.getLoggerName());
                if (orec != null) {
                    orec.setLoggingContext(ctx);
                }
            }
        } else if (!this.useLoggingContext_) {
            if (orec != null) {
                orec.setLoggingContext(null);
            }
            ctx = null;
        }
        try {
            String userId;
            if (ctx != null && this.useLoggingContext_ && !isInternalCtx) {
                Set<String> logKeys;
                String rid;
                str = ctx.getECID();
                if (str != null) {
                    size += str.length();
                    ++nStr;
                }
                if ((rid = ctx.getRID()) != null) {
                    size += rid.length();
                    ++nStr;
                }
                if (supplAttr == null) {
                    supplAttr = new HashMap();
                }
                supplAttr.put("ecid", str + "," + rid);
                String[] configSupplAttrNames = super.getSupplementalAttributes();
                if (configSupplAttrNames != null) {
                    if (supplAttr == null) {
                        supplAttr = new HashMap();
                    }
                    for (int k = 0; k < configSupplAttrNames.length; ++k) {
                        String attrName = configSupplAttrNames[k];
                        if (supplAttr.containsKey(attrName)) continue;
                        String attrValue = ctx.getAttributeValue(attrName);
                        if (attrName == null || attrValue == null) continue;
                        supplAttr.put(attrName, attrValue);
                        size += attrName.length();
                        ++nStr;
                        size += attrValue.toString().length();
                        ++nStr;
                    }
                }
                if ((logKeys = ctx.getLoggableAttributes()) != null && logKeys.size() > 0) {
                    if (supplAttr == null) {
                        supplAttr = new HashMap();
                    }
                    for (String logKey : logKeys) {
                        String val = ctx.getAttributeValue(logKey);
                        if (val == null) continue;
                        supplAttr.put(logKey, val);
                        size += logKey.length();
                        ++nStr;
                        size += val.length();
                        ++nStr;
                    }
                }
            }
            if (this.appContext_ != null && this.useLoggingContext_ && !isInternalCtx) {
                String appName;
                if (supplAttr == null) {
                    supplAttr = new HashMap<String, String>();
                }
                if ((appName = this.appContext_.getApplicationName()) != null && appName.length() > 0) {
                    supplAttr.put("APP", appName);
                }
            }
            if (this.useThreadName_) {
                threadName = Thread.currentThread().getName();
                if (threadName != null) {
                    len = threadName.length();
                    if (this.fieldLen_ >= 0 && len > this.fieldLen_) {
                        threadName = threadName.substring(0, this.fieldLen_);
                        len = this.fieldLen_;
                    }
                    size += len;
                    ++nStr;
                }
            } else if (this.useRealThreadId_) {
                threadName = Long.toString(Thread.currentThread().getId());
                len = threadName.length();
                size += len;
                ++nStr;
            }
            if (this.userContext_ != null && !isInternalCtx && (userId = this.userContext_.getUserName()) != null) {
                if (supplAttr == null) {
                    supplAttr = new HashMap();
                }
                supplAttr.put("USERID", userId);
                size += userId.length();
                ++nStr;
                if (this.enableUserBuffer_ && buffer == null) {
                    buffer = this.getUserBuffer(userId, true);
                }
            }
        }
        finally {
            if (this.useLoggingContext_ && recursionCounter != null) {
                recursionCounter.exitInternalCtx();
            }
        }
        if (recLevelValue <= this.sourceClassAndMethodLevelValue_) {
            str = rec.getSourceClassName();
            if (str != null) {
                len = str.length();
                if (this.fieldLen_ >= 0 && len > this.fieldLen_) {
                    rec.setSourceClassName(str.substring(0, this.fieldLen_));
                    len = this.fieldLen_;
                }
                size += len;
                ++nStr;
            }
            if ((str = rec.getSourceMethodName()) != null) {
                len = str.length();
                if (this.fieldLen_ >= 0 && len > this.fieldLen_) {
                    rec.setSourceMethodName(str.substring(0, this.fieldLen_));
                    len = this.fieldLen_;
                }
                size += len;
                ++nStr;
            }
        }
        if ((str = rec.getMessage()) != null) {
            len = str.length();
            if (this.fieldLen_ >= 0 && len > this.fieldLen_) {
                rec.setMessage(str.substring(0, this.fieldLen_));
                len = this.fieldLen_;
            }
            size += len;
            ++nStr;
        }
        if ((params = rec.getParameters()) != null) {
            Object[] cacheParams = new Object[params.length];
            for (int i = 0; i < params.length; ++i) {
                if (params[i] != null) {
                    String supplValue = null;
                    supplValue = params[i] instanceof String ? (String)params[i] : params[i].toString();
                    len = supplValue.length();
                    if (this.fieldLen_ >= 0 && len > this.fieldLen_) {
                        cacheParams[i] = supplValue.substring(0, this.fieldLen_);
                        len = this.fieldLen_;
                    } else {
                        cacheParams[i] = supplValue;
                    }
                    size += len;
                    ++nStr;
                }
                ++nParam;
            }
            rec.setParameters(cacheParams);
            ++nRecHasParam;
        }
        if (rec.getResourceBundleName() != null) {
            size += rec.getResourceBundleName().length();
            ++nStr;
        }
        size = size * 2 + this.string_overhead_ * nStr + this.logRecord_overhead_ + nParam * this.ref_overhead_ * 2 + nRecHasParam * this.param_overhead_ + numSupplKeys * this.param_overhead_ * 2;
        if (numSupplKeys > 0) {
            size += this.ref_overhead_ * 2 * 2;
        }
        if (rec.getResourceBundle() != null) {
            size += this.resourceBundle_overhead_;
        }
        if (supplAttr != null) {
            size += this.hashMap_overhead_s + supplAttr.size() * this.hashMap_entry_overhead_;
        }
        if (buffer == null) {
            buffer = this.defBuf_;
        }
        byte[] byArray = buffer.bufferLock_;
        synchronized (buffer.bufferLock_) {
            buffer.size_ += (long)size;
            if (buffer.recArr_.length == 0) {
                // ** MonitorExit[var21_21] (shouldn't be in output)
                return;
            }
            buffer.recArr_[buffer.currPos_] = rec;
            if (this.useThreadName_ || this.useRealThreadId_) {
                buffer.recThreadNames_[buffer.currPos_] = threadName;
            }
            buffer.recSupplAttrs_[buffer.currPos_] = supplAttr;
            buffer.recSizes_[buffer.currPos_] = size;
            if (++buffer.currPos_ == buffer.recArr_.length) {
                buffer.currPos_ = 0;
            }
            if (buffer.recArr_[buffer.currPos_] != null) {
                buffer.headPos_ = buffer.currPos_;
            }
            for (int trial = 0; buffer.size_ > buffer.maxSize_ && trial < buffer.recArr_.length; ++trial) {
                buffer.size_ -= (long)buffer.recSizes_[buffer.headPos_];
                buffer.recArr_[buffer.headPos_] = null;
                if (this.useThreadName_) {
                    buffer.recThreadNames_[buffer.headPos_] = null;
                }
                if (this.useLoggingContext_) {
                    buffer.recSupplAttrs_[buffer.headPos_] = null;
                }
                buffer.recSizes_[buffer.headPos_] = 0;
                if (++buffer.headPos_ != buffer.recArr_.length) continue;
                buffer.headPos_ = 0;
            }
            // ** MonitorExit[var21_21] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void dump(File destination) {
        super.internalDump(null, destination);
    }

    @Override
    public void dump(String name, File destination) {
        super.internalDump(name, destination);
    }

    @Override
    public void dump(FileOutputStream fos) {
        this.dump(null, fos);
    }

    @Override
    public void dump(FileOutputStream fos, boolean flushBuffer) {
        this.dump(null, fos, flushBuffer);
    }

    @Override
    public void dump(String name, FileOutputStream fos) {
        this.dump(name, fos, this.flushOnDump_);
    }

    @Override
    public void dump(File destination, boolean flushBuffer) {
        super.internalDump(null, destination, flushBuffer);
    }

    @Override
    public void dump(String name, File destination, boolean flushBuffer) {
        super.internalDump(name, destination, flushBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(String name, FileOutputStream fos, boolean flushBuffer) {
        try {
            BufferedOutputStream bos = new BufferedOutputStream(fos, 65536);
            ODLFormatter odlFmt = this.getODLFormatter();
            String enc = this.getEncoding();
            LogMessage msg = null;
            LogRecord[] dumpRecords = null;
            String[] threadNames = null;
            Map[] supplAttrMaps = null;
            int pos = 0;
            QuickTraceBuffer buffer = null;
            if (name == null) {
                buffer = this.defBuf_;
            } else if (this.enableUserBuffer_) {
                buffer = this.getUserBuffer(name, false);
            }
            if (buffer == null) {
                return;
            }
            byte[] byArray = buffer.bufferLock_;
            synchronized (buffer.bufferLock_) {
                if (flushBuffer) {
                    buffer.size_ = 0L;
                    dumpRecords = buffer.recArr_;
                    threadNames = buffer.recThreadNames_;
                    supplAttrMaps = buffer.recSupplAttrs_;
                    buffer.recArr_ = new LogRecord[dumpRecords.length];
                    Arrays.fill(buffer.recArr_, null);
                    if (this.useThreadName_ || this.useRealThreadId_) {
                        buffer.recThreadNames_ = new String[threadNames.length];
                        Arrays.fill(buffer.recThreadNames_, null);
                    }
                    buffer.recSupplAttrs_ = new Map[supplAttrMaps.length];
                    buffer.recSizes_ = new int[buffer.recArr_.length];
                    Arrays.fill(buffer.recSizes_, 0);
                    pos = buffer.headPos_;
                    buffer.currPos_ = 0;
                    buffer.headPos_ = 0;
                } else {
                    dumpRecords = new LogRecord[buffer.recArr_.length];
                    if (this.useThreadName_ || this.useRealThreadId_) {
                        threadNames = new String[buffer.recThreadNames_.length];
                    }
                    supplAttrMaps = new Map[buffer.recSupplAttrs_.length];
                    System.arraycopy(buffer.recArr_, 0, dumpRecords, 0, dumpRecords.length);
                    if (this.useThreadName_ || this.useRealThreadId_) {
                        System.arraycopy(buffer.recThreadNames_, 0, threadNames, 0, threadNames.length);
                    }
                    System.arraycopy(buffer.recSupplAttrs_, 0, supplAttrMaps, 0, supplAttrMaps.length);
                    pos = buffer.headPos_;
                }
                // ** MonitorExit[var14_14] (shouldn't be in output)
                LogRecord rec = null;
                String threadName = null;
                Map supplAttrMap = null;
                for (int i = 0; i < dumpRecords.length; ++i) {
                    Map recMap;
                    byte[] bytes;
                    rec = dumpRecords[pos];
                    if (this.useThreadName_ || this.useRealThreadId_) {
                        threadName = threadNames[pos];
                    }
                    supplAttrMap = supplAttrMaps[pos];
                    if (++pos >= dumpRecords.length) {
                        pos = 0;
                    }
                    if (rec == null) continue;
                    msg = odlFmt.toLogMessage(rec, true);
                    Map msgSupplAttrs = msg.getSupplAttrs();
                    if (supplAttrMap != null) {
                        Object userId = supplAttrMap.get("USERID");
                        if (userId != null) {
                            msg.setUserId(userId.toString());
                            supplAttrMap.remove("USERID");
                        }
                        if (msgSupplAttrs != null) {
                            msgSupplAttrs.putAll(supplAttrMap);
                        } else {
                            msg.setSupplAttrs(supplAttrMap);
                        }
                    }
                    if (msg.getTimestamp() == 0L) {
                        msg.setTimestamp(System.currentTimeMillis());
                    }
                    if ((this.useThreadName_ || this.useRealThreadId_) && threadName != null) {
                        msg.setThreadId(threadName);
                    }
                    if (!this.useLoggingContext_) {
                        msg.setExecContextId(null);
                    }
                    String data = this.formatter_.format(msg);
                    try {
                        bytes = enc == null ? data.getBytes() : data.getBytes(enc);
                    }
                    catch (Exception e) {
                        bytes = new byte[]{};
                    }
                    bos.write(bytes);
                    if (!(rec instanceof ODLLogRecord) || (recMap = ((ODLLogRecord)rec).getSupplAttributes()) == null) continue;
                    recMap.clear();
                }
                bos.flush();
            }
        }
        catch (IOException ioex) {
            this.reportError("", ioex, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void reenableThreadNames(boolean useThreadNames, boolean useRealThreadId) {
        boolean enable = useThreadNames | useRealThreadId;
        Object object = this.defBuf_.bufferLock_;
        // MONITORENTER : this.defBuf_.bufferLock_
        this.defBuf_.enableThreadNameBuffer(enable);
        // MONITOREXIT : object
        Hashtable<String, QuickTraceBuffer> hashtable = this.userBufs_;
        object = hashtable;
        // MONITORENTER : hashtable
        Iterator<QuickTraceBuffer> i$ = this.userBufs_.values().iterator();
        while (true) {
            if (!i$.hasNext()) {
                // MONITOREXIT : object
                return;
            }
            QuickTraceBuffer buffer = i$.next();
            if (buffer == null) continue;
            byte[] byArray = buffer.bufferLock_;
            // MONITORENTER : buffer.bufferLock_
            buffer.enableThreadNameBuffer(enable);
            // MONITOREXIT : byArray
        }
    }

    @Override
    long getOldestRecordTime() {
        return this.getOldestRecordTime(this.defBuf_);
    }

    @Override
    long getOldestRecordTime(String bufferName) {
        QuickTraceBuffer buffer = this.getUserBuffer(bufferName, false);
        return this.getOldestRecordTime(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getOldestRecordTime(QuickTraceBuffer buffer) {
        long time = 0L;
        if (buffer == null) {
            return 0L;
        }
        byte[] byArray = buffer.bufferLock_;
        synchronized (buffer.bufferLock_) {
            LogRecord rec = buffer.recArr_[buffer.headPos_];
            // ** MonitorExit[var5_3] (shouldn't be in output)
            if (rec != null) {
                time = rec.getMillis();
            }
            return time;
        }
    }

    @Override
    int getNumberOfRecords() {
        return this.getNumberOfRecords(this.defBuf_);
    }

    @Override
    int getNumberOfRecords(String bufferName) {
        QuickTraceBuffer buffer = this.getUserBuffer(bufferName, false);
        return this.getNumberOfRecords(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumberOfRecords(QuickTraceBuffer buffer) {
        int count = 0;
        if (buffer == null) {
            return 0;
        }
        byte[] byArray = buffer.bufferLock_;
        synchronized (buffer.bufferLock_) {
            count = buffer.headPos_ < buffer.currPos_ ? buffer.currPos_ - buffer.headPos_ : (buffer.currPos_ < buffer.headPos_ ? buffer.recArr_.length - buffer.headPos_ + buffer.currPos_ : (buffer.headPos_ == 0 ? 0 : buffer.recArr_.length));
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return count;
        }
    }

    @Override
    int getBufferUsedPercentage() {
        return this.getBufferUsedPercentage(this.defBuf_);
    }

    @Override
    int getBufferUsedPercentage(String bufferName) {
        QuickTraceBuffer buffer = this.getUserBuffer(bufferName, false);
        return this.getBufferUsedPercentage(buffer);
    }

    int getBufferUsedPercentage(QuickTraceBuffer buffer) {
        if (buffer == null) {
            return 0;
        }
        return (int)Math.round(1.0 * (double)buffer.size_ / (double)buffer.maxSize_ * 100.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getBufferNames() {
        String[] names = null;
        Hashtable<String, QuickTraceBuffer> hashtable = this.userBufs_;
        synchronized (hashtable) {
            if (this.userBufs_.size() > 0) {
                names = this.userBufs_.keySet().toArray(new String[0]);
            }
        }
        return names;
    }
}

