/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.management.tracing.impl;

import oracle.as.management.tracing.TraceInfo;
import oracle.dfw.framework.DiagnosticsFramework;
import oracle.dfw.incident.DiagnosticsDataExtractor;
import oracle.dfw.incident.Incident;
import oracle.dfw.incident.IncidentFacts;

class IncidentSupport {
    private DiagnosticsFramework m_dfw = new DiagnosticsFramework();
    private static IncidentSupport s_instance;

    private IncidentSupport() throws Exception {
    }

    public static synchronized IncidentSupport getInstance() throws Exception {
        if (s_instance == null) {
            s_instance = new IncidentSupport();
        }
        return s_instance;
    }

    public Incident createIncident(TraceInfo traceInfo) throws Exception {
        DiagnosticsDataExtractor dde = this.m_dfw.getDDE();
        IncidentFacts facts = IncidentFacts.createManualIncidentFacts((long)traceInfo.getStopTime());
        String problemKey = "TRACE_ID:" + traceInfo.getTraceId();
        facts.setProblemKey(problemKey);
        Incident incident = dde.createIncident(facts, false);
        return incident;
    }
}

