/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security.ssl;

import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.x500.X500Principal;

public class SSLStdHostVerifier
implements HostnameVerifier {
    private static final int ALTNAME_DNS = 2;
    private static final int ALTNAME_IP = 7;

    @Override
    public boolean verify(String targetHost, SSLSession sslSession) {
        X500Principal x500Principal;
        String name;
        if (targetHost == null) {
            return false;
        }
        Principal principal = null;
        Certificate[] peerCerts = null;
        try {
            principal = sslSession.getPeerPrincipal();
            peerCerts = sslSession.getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException pue) {
            return false;
        }
        if (principal != null && principal instanceof X500Principal && targetHost.equalsIgnoreCase(name = (x500Principal = (X500Principal)principal).getName("RFC1779"))) {
            return true;
        }
        if (peerCerts[0] instanceof X509Certificate) {
            X509Certificate peerCert = (X509Certificate)peerCerts[0];
            Collection<List<?>> altNames = null;
            try {
                altNames = peerCert.getSubjectAlternativeNames();
            }
            catch (CertificateParsingException cpe) {
                // empty catch block
            }
            if (altNames != null) {
                for (List<?> altName : altNames) {
                    String nameValue;
                    int nameType = (Integer)altName.get(0);
                    if (nameType != 7 && nameType != 2 || !targetHost.equals(nameValue = (String)altName.get(1))) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

