/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security.ssl;

import com.sleepycat.je.rep.net.SSLAuthenticator;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;

public class SSLControl {
    private final SSLParameters sslParameters;
    private final SSLContext sslContext;
    private final SSLAuthenticator sslAuthenticator;
    private final HostnameVerifier sslHostVerifier;

    public SSLControl(SSLParameters sslParameters, SSLContext sslContext, HostnameVerifier sslHostVerifier, SSLAuthenticator sslAuthenticator) {
        this.sslParameters = sslParameters;
        this.sslContext = sslContext;
        this.sslHostVerifier = sslHostVerifier;
        this.sslAuthenticator = sslAuthenticator;
    }

    public SSLParameters sslParameters() {
        return this.sslParameters;
    }

    public SSLContext sslContext() {
        return this.sslContext;
    }

    public SSLAuthenticator peerAuthenticator() {
        return this.sslAuthenticator;
    }

    public HostnameVerifier hostVerifier() {
        return this.sslHostVerifier;
    }

    public void applySSLParameters(SSLSocket sslSocket) {
        if (this.sslParameters != null) {
            if (this.sslParameters.getCipherSuites() != null) {
                sslSocket.setEnabledCipherSuites(this.sslParameters.getCipherSuites());
            }
            if (this.sslParameters.getProtocols() != null) {
                sslSocket.setEnabledProtocols(this.sslParameters.getProtocols());
            }
            if (this.sslParameters.getNeedClientAuth()) {
                sslSocket.setNeedClientAuth(true);
            }
        }
    }

    public int hashCode() {
        int result = 17;
        if (this.sslParameters != null) {
            result = result * 31 + this.sslParameters.hashCode();
        }
        if (this.sslContext != null) {
            result = result * 31 + this.sslContext.hashCode();
        }
        if (this.sslAuthenticator != null) {
            result = result * 31 + this.sslAuthenticator.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SSLControl other = (SSLControl)obj;
        if (this.sslParameters != other.sslParameters) {
            return false;
        }
        if (this.sslContext != other.sslContext) {
            return false;
        }
        return this.sslAuthenticator == other.sslAuthenticator;
    }
}

